// ----------------------------------------------------------------------------
// Filename:    ItemDialog.cpp
// $Date: 1998/11/16 07:28:48 $
// $Revision: 1.1 $
// ----------------------------------------------------------------------------

#include "ItemDialog.h"

#define Inherited ItemDialogData

// ----------------------------------------------------------------------------
// Function:    ItemDialog (QWidget* parent, const char* name)
// Parameters:  parent  - Handle to the parent widget
//              name    - Name of the widget
// ----------------------------------------------------------------------------
// Constructor.  Simply calls off to our base class to have it initialize all
// of the values and create all of the widgets.
// ----------------------------------------------------------------------------
ItemDialog::ItemDialog( QWidget* parent, const char* name )
	: Inherited( parent, name )
{
}

// ----------------------------------------------------------------------------
// Function:    ~ItemDialog ()
// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
ItemDialog::~ItemDialog()
{
}

// ----------------------------------------------------------------------------
// Function:    setName (const char* name)
// Parameters:  name    - Name of the item we're adding/editing.
// ----------------------------------------------------------------------------
// Sets the name of the item to 'name'.  We'll do this by cramming it into the
// text box that we've got showing it's name.
// ----------------------------------------------------------------------------
void ItemDialog::setName( const char* name )
{
    if (name != NULL)
    {
        this->txtName->setText( name );
    }
}

// ----------------------------------------------------------------------------
// Function:    setTimeSpent (int seconds)
// Parameters:  seconds - Total time spent on this item (in seconds)
// ----------------------------------------------------------------------------
// Sets the total amount of time spent on this item into our spin-buttons.
// We'll automatically do the conversion from seconds to the appropriate number
// of hours/minutes/seconds.
// ----------------------------------------------------------------------------
void ItemDialog::setTimeSpent( int seconds )
{
    spinSeconds->setValue( (seconds % 60) );
    seconds /= 60;
    spinMinutes->setValue( (seconds % 60) );
    spinHours->setValue( (seconds / 60) );
}

// ----------------------------------------------------------------------------
// Function:    name ()
// Returns:     const char*
// ----------------------------------------------------------------------------
// Gets the name of the item that we're adding/editing.
// ----------------------------------------------------------------------------
const char* ItemDialog::name()
{
    return this->txtName->text();
}

// ----------------------------------------------------------------------------
// Function:    timeSpent ()
// Returns:     int     - Total time spend on this item (in seconds).
// ----------------------------------------------------------------------------
// Gets the total amount of time spent on this item in seconds.  We'll do the
// conversion from hours/minutes/seconds as we pull the information out of our
// spin-buttons.
// ----------------------------------------------------------------------------
int ItemDialog::timeSpent()
{
    int rtnval;
    rtnval  = spinHours->value();
    rtnval *= 60;
    rtnval += spinMinutes->value();
    rtnval *= 60;
    rtnval += spinSeconds->value();
    return rtnval;
}

// ----------------------------------------------------------------------------
// Function:    enableTimeSpent (bool enabled)
// Parameters:  enabled - Are the spin-buttons enabled?
// ----------------------------------------------------------------------------
// En/disables the spin-buttons which allow for editing of the time spent on
// this item.
// ----------------------------------------------------------------------------
void ItemDialog::enableTimeSpent( bool enabled )
{
    spinHours->setEnabled( enabled );
    spinMinutes->setEnabled( enabled );
    spinSeconds->setEnabled( enabled );
}
