/***************************************************************************
                          ksnuffle.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef		KSNUFFLE_H
#define		KSNUFFLE_H 
 

#ifdef		HAVE_CONFIG_H
#include	<config.h>
#endif

#include	<assert.h>

#include	<sys/time.h>
#include	<unistd.h>

#include	<qarray.h>
#include	<qprinter.h>
#include	<qpainter.h>
#include	<qtimer.h>
#include	<qmessagebox.h>

#include	<kapp.h> 
#include	<ktmainwindow.h> 
#include	<kaccel.h>
#include	<kiconloader.h>
#include	<kmsgbox.h>
#include	<ksock.h>

typedef	QArray<char *>	SArray	;	/* Array of strings		*/

class	KNDPCap		;		/* Packet capture class		*/
class	KNDGraphic	;		/* Graphic display class	*/
class	KNDPacket	;		/* Packet display class		*/
class	KNDConfMon	;		/* Monitor configuration class	*/
class	KNDConfRep	;		/* Replay configuration class	*/
class	KNDConf		;		/* Base class for above		*/

class	KNDReplay	;		/* Class to reply recording	*/
class	KNDMonitor	;		/* Network monitor class	*/
class	KNDView		;		/* Base class for above		*/

class	KNDMulti	;		/* Multiple load graph class	*/
class	KNDSetup	;		/* Global setup class		*/

class	KNDLoadHist	;
class	KNDLoadBar	;
class	KNDPktHist	;

class	Packet		;		/* Captured packet		*/
class	PktData		;		/* Decoded packet data		*/


#define	MAXMON	(16)


class	KNDApp : public KTMainWindow 
{
	enum	Showing
	{	ShowMonitors,
		ShowMulti,
		ShowSetup
	}	;

 	Q_OBJECT

	KCombo		*monList	;	/* List of monitors	*/
	QTimer		timer		;	/* Display update timer	*/
	QArray<char *>	*iflist		;	/* Interface list	*/
	QArray<char *>	*eplist		;	/* Enet protocol list	*/
	QArray<char *>	*iplist		;	/* IP protocol list	*/
	QArray<char *>	*svlist		;	/* Service list		*/

	KNDMulti	*multi		;
	KNDSetup	*setup		;
	Showing		showing		;
	long		second		;

	KConfig		*userconf	;

	void		startNsl ()	;

public:
	KNDApp	() ; 
       ~KNDApp	() ;

	void	initMenuBar		() ;
	void	initToolBar		() ;
	void	initView		(KConfig *) ;
	void	saveOptions		(bool) ;
	void	readOptions		() ;
	void	enableCommand		(int id_) ;
	void	disableCommand		(int id_) ;
	bool	queryExit		() ;

	void	rename			(const char *, const char *) ;
	void	showClient		(int)	;

public slots	:

	void	commandCallback		(int id_) ;
	void	slotMonitorNew		() ;
	void	slotMonitorReplay	() ;
	void	slotMonitorClose	() ;
	void	slotMonitorStop		() ;
	void	slotMonitorStart	() ;
	void	slotMonitorFreeze	() ;
	void	slotMonitorResume	() ;
	void	slotMonitorPick		(int) ;
	void	slotMonitorCloseWindow	() ;
	void	slotMonitorSave		() ;
	void	slotMonitorSaveQuit	() ;
	void	slotMonitorQuit		() ;
	void	slotViewToolBar		() ;
	void	slotViewMonitors	() ;
	void	slotViewMulti		() ;
	void	slotViewSetup		() ;
	void	slotViewConfig		() ;
	void	slotViewGraphic		() ;
	void	slotViewPackets		() ;

	/* The "timerTick" method is called, nominally, once per second	*/
	/* to update displays, etc. The "upToTick" method is called	*/
	/* each time a packet is captured with the packet capture time	*/
	/* (in seconds) to ensure that we definitely keep synchronised.	*/
	/* Otherwise, a packet could appear to have been captured in	*/
	/* the future.							*/
	void	timerTick		() 	;
	long	upToTick		(long)	;

	void	sockRead (KSocket *) ;

private:
	QPopupMenu	*monitor_menu	;
	QPopupMenu	*view_menu	;
	QPopupMenu	*help_menu	;

	KNDView		*view		;
	bool		bViewToolbar	;

	KMenuBar::menuPosition menu_bar_pos ;
	KToolBar::BarPosition  tool_bar_pos ;

	QArray<KNDView *> viewlist	;

	void	showView (KNDView *)	;
	void	setView	 (QWidget *)	;
}	;   

typedef	struct	timeval	TVAL	;

/*  PktInfo								*/
/*  This class is used to record decoded packet information for use	*/
/*  by the graphic and packet display objects.				*/

class	PktInfo
{
public:
	PktInfo	*next		;	/* Next on free queue		*/
	int	pktlen		;	/* Total packet length		*/
	int	datlen		;	/* Data length in packet	*/
	int	accept		;	/* Accepted packet count	*/
	int	dropped		;	/* Dropped  packet count	*/
	int	missed		;	/* Missed packet count		*/
	TVAL	tval		;	/* Packet timestamp		*/
	int	ago		;	/* Age relative to current time	*/
	bool	inuse		;	/* Object is in use		*/
					/* Decoded display strings ..	*/
	char	time	[20]	;	/* Packet time stamp		*/
	char	proto	[20]	;	/* Protocol			*/
	char	srce	[80]	;	/* Source host and service	*/
	char	dest	[80]	;	/* Destination host and service	*/
	char	info	[32]	;	/* Miscellaneous information	*/
	char	size	[24]	;	/* Sizes as a string		*/
}	;

/*  PktData								*/
/*  This class is used to pass captured packet data from the capture	*/
/*  thread to the parent sniffer thread (via a socket).			*/

class	PktData
{
public:
	int	pktlen		;	/* Actual packet length		*/
	int	caplen		;	/* Captured data length		*/
	TVAL	tval		;	/* Packet timestamp		*/
	int	accept		;	/* Accepted packet count	*/
	int	dropped		;	/* Dropped  packet count	*/
	int	missed		;	/* Missed packet count		*/
	u_char	data[256]	;	/* Captured packet data		*/
}	;

/*  LogItem								*/
/*  So that binary log files can be upwardly compatible, header data	*/
/*  items are tagged by type.						*/

enum	LogItem
{
	ItemLast	= 0,
	ItemMagic	= 1,
	ItemIface	= 2,
	ItemProg	= 3
}	;

#define	MAGIC	"KSnuffle Magic Marker!"

extern	void	ErrExit		(char *, ...) ;
extern	void	Error	 	(const char *, const char *,
					       QMessageBox::Icon = QMessageBox::Warning) ;
extern	int	QCBFindItem	(QComboBox  &, const char *, int = -1) ;
extern	int	QLBFindItem	(QListBox   &, const char *, int = -1) ;

extern	void	PktDecode	(PktData *, PktInfo *, int) ;
extern	PktInfo	*getPktInfo	() ;
extern	void	freePktInfo	(PktInfo *) ;

extern	SArray	*FindAllIface	() ;
extern	SArray	*FindAllEProto	() ;
extern	SArray	*FindAllIProto	() ;
extern	SArray	*FindAllService	() ;

extern	char	*FindService	(int   ) ;
extern	char	*FindHost	(char *) ;

extern	long	upToTick	(long) ;

#endif // KSNUFFLE_H
