/***************************************************************************
                          knd_config.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include	"knd_config.h"


/*  KNDConf								*/
/*  KNDConf	: Constructor for configuration and control object	*/
/*  view	: KNDView *	: Parent object				*/
/*  graphic	: KNDGraphic *	: Associated graphic display object	*/
/*  packets	: KNDpacket *	: Associated packet display object	*/
/*  multi	: KNDMulti *	: Multiple graph object			*/
/*  slot	: int		: Unique slot number			*/
/*  name	: char *	: Initial monitor name			*/
/*  (returns)	: KNDConf	:					*/

KNDConf::KNDConf
	(	KNDView		*view,
		KNDGraphic	*graphic,
		KNDPacket	*packets,
		KNDMulti	*multi,
		int		slot,
		char		*name
	)
	:
	QWidget	(view),
	view	(view),
	graphic	(graphic),
	packets	(packets),
	multi	(multi),
	slot	(slot),
	g_ctrl	(this),	g_log	(this),	g_pkt	(this),	g_gra	(this),
	g_prog	(this),	
	b_set	(this),	b_res	(this),	b_clr	(this),	b_go	(this),
	b_freeze(this),	b_log	(this),
	l_name	(this),	t_name	(this),
	c_time	(this),	c_proto	(this),
	c_srce	(this), c_dest	(this),
	c_info	(this), c_size	(this),
	c_multi	(this),
	l_load1	(this),	l_bar1	(this),	l_bar2	(this),
	s_load1	(this),	s_bar1	(this),	s_bar2	(this)
{
	g_ctrl .setGeometry	  (430,   5,  70, 170) ;
	g_ctrl .setTitle	  ("Control") ;

	b_set  .setGeometry	  (435,  25,  60,  25) ;
	b_set  .setText		  ("Set"  ) ;
	connect(&b_set,    SIGNAL(clicked()), this, SLOT(clickSet   ())) ;
	QToolTip::add (&b_set, i18n ("Set and check displayed configuration")) ;

	b_res  .setGeometry	  (435,  55,  60,  25) ;
	b_res  .setText		  ("Reset") ;
	connect(&b_res,    SIGNAL(clicked()), this, SLOT(clickReset ())) ;
	QToolTip::add (&b_res, i18n ("Reset to previously set configuration")) ;

	b_clr  .setGeometry	  (435,  85,  60,  25) ;
	b_clr  .setText		  ("Clear") ;
	connect(&b_clr,    SIGNAL(clicked()), this, SLOT(clickClear ())) ;
	QToolTip::add (&b_clr, i18n ("Clear to default configuration")) ;

	b_go   .setGeometry	  (435, 115,  60,  25) ;
	b_go   .setText		  ("Go"   ) ;
	b_go   .setEnabled	  (false  ) ;
	connect(&b_go,     SIGNAL(clicked()), this, SLOT(clickGo    ())) ;
	QToolTip::add (&b_go, i18n ("Start/stop monitoring network")) ;

	b_freeze.setGeometry	  (435, 145,  60,  25) ;
	b_freeze.setText	  ("Freeze") ;
	b_freeze.setEnabled	  (false   ) ;
	connect(&b_freeze, SIGNAL(clicked()), this, SLOT(clickFreeze())) ;
	QToolTip::add (&b_freeze, i18n ("Freeze/resume graphich and packet displays")) ;

	l_name .setGeometry       ( 10,  25,  40,  25) ;
	l_name .setText	          ("Name" ) ;
	t_name .setGeometry	  ( 80,  25, 100,  25) ;
	t_name .setText		  (name	  ) ;
	v_name	= name	    	  ;
	QToolTip::add (&t_name, i18n ("Monitor name")) ;

	g_prog .setGeometry	  (  5,  85, 415, 150) ;
	g_prog .setTitle	  ("Program") ;

	g_pkt  .setGeometry	  (510, 120, 140, 115) ;
	g_pkt  .setTitle	  ("Packet monitor") ;

	c_time .setGeometry	  (515, 140,  50,  25) ;
	c_time .setText		  ("Time" ) ;
	c_time .setChecked	  (true   ) ;
	d_time 	= true	;
	QToolTip::add (&c_time, i18n ("Show time in packet display")) ;

	c_proto.setGeometry	  (585, 140,  50,  25) ;
	c_proto.setText		  ("Proto") ;
	c_proto.setChecked	  (true   ) ;
	d_proto	= true	;
	QToolTip::add (&c_proto, i18n ("Show protocol in packet display")) ;

	c_srce .setGeometry	  (515, 170,  50,  25) ;
	c_srce .setText		  ("Srce" ) ;
	c_srce .setChecked	  (true   ) ;
	d_srce	= true	;
	QToolTip::add (&c_srce, i18n ("Show source in packet display")) ;

	c_dest .setGeometry	  (585, 170,  50,  25) ;
	c_dest .setText		  ("Dest" ) ;
	c_dest .setChecked	  (true   ) ;
	d_dest	= true	;
	QToolTip::add (&c_dest, i18n ("Show destination in packet display")) ;

	c_info .setGeometry	  (515, 200,  50,  25) ;
	c_info .setText		  ("Info" ) ;
	c_info .setChecked	  (true   ) ;
	d_info = true	;
	QToolTip::add (&c_info, i18n ("Show other information in packet display")) ;

	c_size .setGeometry	  (585, 200,  50,  25) ;
	c_size .setText		  ("Size" ) ;
	c_size .setChecked	  (true   ) ;
	d_size	= true	;
	QToolTip::add (&c_size, i18n ("Show size in packet display")) ;

	g_gra  .setGeometry	  (655, 120, 130, 115) ;
	g_gra  .setTitle	  ("Graphic display") ;

	l_load1.setGeometry	  (660, 140,  60,  25) ;
	l_load1.setText		  ("Histogram") ;
	s_load1.setGeometry	  (730, 140,  50,  25) ;
	s_load1.setRange	  ( 1,   50) ;
	s_load1.setValue	  ( 1) ;
	v_load1	=  1	;
	QToolTip::add (&s_load1, i18n ("Set update interval for graphic load histogram")) ;

	l_bar1 .setGeometry	  (660, 170,  60,  25) ;
	l_bar1 .setText		  ("Bar 1") ;
	s_bar1 .setGeometry	  (730, 170,  50,  25) ;
	s_bar1 .setRange	  ( 1,  250) ;
	s_bar1 .setValue	  ( 5) ;
	v_bar1	=  5	;
	QToolTip::add (&s_bar1, i18n ("Set period for first graphic load-average display")) ;

	l_bar2 .setGeometry	  (660, 200,  60,  25) ;
	l_bar2 .setText		  ("Bar 2") ;
	s_bar2 .setGeometry	  (730, 200,  50,  25) ;
	s_bar1 .setRange	  ( 1,  250) ;
	s_bar2 .setValue	  (20) ;
	v_bar1	= 20	;
	QToolTip::add (&s_bar2, i18n ("Set period for second graphic load-average display")) ;

	b_log  .setGeometry	  (710,  25,  65,  25) ;
	g_log  .setGeometry	  (510,   5, 275, 115) ;

	g_log  .setTitle	  ("Logging") ;
	b_log  .setText		  ("Browse" ) ;
	QToolTip::add (&b_log, i18n ("Browse filesystem to select log file")) ;

	connect	(&b_log, SIGNAL(clicked()),	 this, SLOT(clickLog())   ) ;

	c_multi.setGeometry       (260,  55, 120,  25) ;
	c_multi.setText		  ("Parallel display") ;
	c_multi.setChecked	  (true) ;
	QToolTip::add (&c_multi, i18n ("Display on parallel histogram page")) ;

	d_multi = true ;
}

/*  KNDConf								*/
/*  ~KNDConf	: Destructor for configuration object			*/
/*  (returns)	: void		:					*/

KNDConf::~KNDConf ()
{
}
