/***

promisc.c	- handles the promiscuous mode flag for the Ethernet
		  interfaces
		  
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This software is open source; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License in the included COPYING file for
details.

***/
#include <qframe.h>
#include <qlistview.h>
#include <qstring.h>

#include <sys/ioctl.h>
#include <sys/socket.h>
#include <unistd.h>
#include <string.h>
#include <netinet/in.h>
#include <net/if.h>
#include <linux/if_ether.h>
#include "kifstats.h"
#include "error.h"

void initiflist(struct iflist **list);
extern void destroyiflist(struct iflist *list);
extern char *ltrim(char *buf);
extern int iface_supported(char *iface);
extern int ifinlist(struct iflist *list, char *ifname);

void srpromisc(int mode)
{
    int fd;
    struct ifreq ifr;
    struct iflist *list;
    struct iflist *ptmp;
    int istat;
    char *errmsg = "Promisc change failed for ";
    char fullmsg[40];

    initiflist(&list);
    ptmp = list;
    fd = socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL));

    if (fd < 0) {
//	errbox("Unable to open socket for flag change", ANYKEY_MSG, &response);
	destroyiflist(list);
	return;
    }
    while (ptmp != NULL) {
	if ((strncmp(ptmp->ifname, "eth", 3) == 0) ||
	    (strncmp(ptmp->ifname, "fddi", 4) == 0)) {
	    strcpy(ifr.ifr_name, ptmp->ifname);
	    istat = ioctl(fd, SIOCGIFFLAGS, &ifr);

	    if (istat < 0) {
//		errbox("Unable to obtain interface parameters",
//		       ANYKEY_MSG, &response);
		destroyiflist(list);
		close(fd);
		return;
	    }
	    if (mode)
		ifr.ifr_flags |= IFF_PROMISC;
	    else
		ifr.ifr_flags &= ~IFF_PROMISC;

	    istat = ioctl(fd, SIOCSIFFLAGS, &ifr);

	    if (istat < 0) {
		strcpy(fullmsg, errmsg);
		strcat(fullmsg, ptmp->ifname);
//		errbox(fullmsg, ANYKEY_MSG, &response);
	    }
	}
	ptmp = ptmp->next_entry;
    }

    close(fd);
    destroyiflist(list);
}




void 
initiflist(struct iflist **list)
{
    FILE *fd;
    char buf[161];
    char ifname[8];
    struct iflist *itmp = NULL;
    struct iflist *tail = NULL;
    unsigned int index = 0;

    *list = NULL;

    fd = fopen("/proc/net/dev", "r");
    if (fd == NULL) {
	return;
    }
    fgets(buf, 160, fd);	/* dummy header lines */
    fgets(buf, 160, fd);

    while (!(feof(fd))) {
	strcpy(buf, "");
	fgets(buf, 160, fd);
	if (strcmp(buf, "") != 0) {
	    strcpy(ifname, ltrim(strtok(buf, ":")));

	    if (!(iface_supported(ifname)))
		continue;

	    if (ifinlist(*list, ifname))	/* ignore entry if already in */
		continue;	/* interface list */


	    itmp = (struct iflist *)malloc(sizeof(struct iflist));
	    bzero(itmp, sizeof(struct iflist));
	    strcpy(itmp->ifname, ifname);
	    index++;
	    itmp->index = index;

	    if (*list == NULL) {
		*list = itmp;
		itmp->prev_entry = NULL;
	    } else {
		tail->next_entry = itmp;
		itmp->prev_entry = tail;
	    }

	    tail = itmp;
	    itmp->next_entry = NULL;
	}
    }
    fclose(fd);
}
