#include <kapp.h>
#include <kfiledialog.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <kstatusbar.h>
#include <kslider.h>
#include <kstdaccel.h>

#include <qmultilinedit.h>
#include <drag.h>
#include <qdialog.h>
#include <qframe.h>
#include <qfont.h>
#include <qimage.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qbuttongroup.h>

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>

#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>

#include "kiface.moc"
#include "kifstats.h"
#include "options.h"

extern char *ltrim(char *buf);
extern int ifinlist(struct iflist *list, char *ifname);
extern int iface_supported(char *iface);


selectIfaceModal::selectIfaceModal(QWidget *parent, const char *name)
  :QDialog(parent, name, TRUE)
{
  this->resize(230,200);
  textLabel = new QLabel(this, "Interface");
  textLabel->setText("Select the Interface");
  textLabel->setGeometry(50,5,200,12);

  mylistview = new QListView(this, "InterfaceView");

  mylistview->addColumn("Iface",-1);
  mylistview->setGeometry(30,30,180,100);
  mylistview->setMultiSelection(FALSE);

  //Create our OK button
  ok = new QPushButton( "Ok", this );
  ok->setGeometry( 130,150,50,30 );
  connect( ok, SIGNAL(clicked()), SLOT(accept()));

  initiflist(&list);
}

void
selectIfaceModal::accept()
{
  int done=0;
  struct iflist *itmp = NULL;

  itmp = list;

  while((itmp != NULL) & !done)
     {
       if (itmp->listviewitem->isSelected())
         {
           done=1;
           strcpy((char *)&iface, itmp->ifname);
         }
       else
         { 
           itmp = itmp->next_entry;
         }
     } 

  if (!done)
    {
     KMsgBox *mybox;
     mybox = new KMsgBox(this, "Error", "You must select an interface", 2,"ok",0,0,0);
     mybox->show();
    }
  else this->close();
}

void 
selectIfaceModal::initiflist(struct iflist **list)
{
    FILE *fd;
    char buf[161];
    char ifname[8];
    struct iflist *itmp = NULL;
    struct iflist *tail = NULL;
    unsigned int index = 0;

    *list = NULL;

    fd = fopen("/proc/net/dev", "r");
    if (fd == NULL) {
	return;
    }
    fgets(buf, 160, fd);	/* dummy header lines */
    fgets(buf, 160, fd);

    while (!(feof(fd))) {
	strcpy(buf, "");
	fgets(buf, 160, fd);
	if (strcmp(buf, "") != 0) {
	    strcpy(ifname, ltrim(strtok(buf, ":")));

	    if (!(iface_supported(ifname)))
		continue;

	    if (ifinlist(*list, ifname))	/* ignore entry if already in */
		continue;	/* interface list */


	    itmp = (struct iflist *)malloc(sizeof(struct iflist));
	    bzero(itmp, sizeof(struct iflist));
	    strcpy(itmp->ifname, ifname);
	    index++;
	    itmp->index = index;

	    if (*list == NULL) {
		*list = itmp;
		itmp->prev_entry = NULL;
	    } else {
		tail->next_entry = itmp;
		itmp->prev_entry = tail;
	    }

	    tail = itmp;
	    itmp->next_entry = NULL;
            itmp->listviewitem = new QListViewItem(mylistview, ifname);
	}
    }
    fclose(fd);
}
