/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qvalidator.h>
#include <qlayout.h>

#include "enhancement.h"

EnhancementDialog::EnhancementDialog(Preview *ps):
	QDialog(NULL,NULL,TRUE),s(ps)
{
	brSlider = new CoolSlider("Brightness",-127,127,1,0,3,
				  this,"brightness");
	cnSlider = new CoolSlider("Contrast",-127,127,1,0,3,
				  this,"contrast");
	gmSlider = new CoolSlider("Gamma",0,1000,1,100,3,
				  this,"gamma");
	//printf("histogram\n");
	his = new ImageHistogram(s,0,this,"histogram1");
	//printf("histogram done\n");
	QPushButton *ok = new QPushButton("OK",this,"ok");
	QPushButton *cancel = new QPushButton("Cancel",this,"cancel");
	connect(brSlider,SIGNAL(valueChanged(int)),
		s,SLOT(setBrightness(int)));
	connect(cnSlider,SIGNAL(valueChanged(int)),
		s,SLOT(setContrast(int)));
	connect(gmSlider,SIGNAL(valueChanged(int)),
		s,SLOT(setGamma(int)));
	connect(s,SIGNAL(changed()),his,SLOT(redraw()));
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	ok->setMinimumHeight(30);
	cancel->setMinimumHeight(30);
	setFixedWidth(QApplication::desktop()->width()/3);
	QVBoxLayout l(this);
	l.addWidget(his);
	l.addSpacing(10);
	l.addWidget(brSlider);
	l.addSpacing(8);
	l.addWidget(cnSlider);
	l.addSpacing(8);
	l.addWidget(gmSlider);
	l.addSpacing(8);
	QHBoxLayout l2;
	l.addLayout(&l2);
	l2.addStretch(1);
	l2.addWidget(ok,2);
	l2.addStretch(1);
	l2.addWidget(cancel,2);
	l2.addStretch(1);
	l.addStretch(1);
	his->setMinimumSize(200,50);
	l.activate();
	resize(childrenRect().size());
	//printf("done...\n");
}

void EnhancementDialog::exec()
{
	int brightness,contrast,gamma;
	brightness = s->getBrightness();
	contrast = s->getContrast();
	gamma = s->getGamma();
	brSlider->setValue(brightness);
        cnSlider->setValue(contrast);
	gmSlider->setValue(gamma);
	if(!QDialog::exec()) {
		s->setBrightness(brightness);
		s->setContrast(contrast);
		s->setGamma(gamma);
	}
}

#include "enhancement.moc"
