#ifndef _SMBPROT_H_
#define _SMBPROT_H_

#include "fileprot.h"
#include <qstring.h>

class SmbProtocol : public FileProtocol
{
public:
	SmbProtocol(const char *mpoint, const char *service, const char *user = 0, const char *passwd = 0, const char *ip = 0);
	virtual ~SmbProtocol();

	bool mount();
	bool umount();
	bool init();
	bool finish();
	bool shutDown();
	bool isMountable() { return true;}
	bool isMounted();
	const char* mountp() { return MountPoint.data();}
	virtual bool isAccesible();
	const char* menuEntry();
	virtual QString mntargs();

	bool isLocal() { return false;}
	const char* passwd() { return (Passwd.isEmpty() ? "" : Passwd.data());}
	const char* user() { return (User.isEmpty() ? "" : User.data());}
	bool needLogin() { return (!Mounted && (!User.isEmpty() && Passwd.isEmpty()));}
	void setLogin(const char *user, const char *pwd) { User = user; Passwd = pwd;}
	bool check();

	const char* server() { return Server.data(); }
	const char* workgroup() { return Workgroup.data(); }
	const char* share() { return Share.data(); }

protected:
	void parseService(const char *service);

protected:
	QString		Service;
	QString		MountPoint;
	QString		User;
	QString		Passwd;
	QString		IP;
	QString		Server, Workgroup, Share;

	bool		Mounted;
};

inline SmbProtocol::~SmbProtocol()
{ shutDown();}

#endif
