#include "ksiconlist.h"
#include <iostream.h>
#include <qapplication.h>
#include <qkeycode.h>

#ifndef ICON_HEIGHT
#define ICON_HEIGHT	18
#endif

KSmallIconList::KSmallIconList(QWidget *parent, const char *name, WFlags f)
	: KFileListBase(parent,name,f)
{
	setTableFlags(Tbl_hScrollBar | Tbl_smoothScrolling);
	setLineWidth(1);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
	setCellHeight(ICON_HEIGHT);
	setCellWidth(10*ICON_HEIGHT);
}

void KSmallIconList::paintCell(QPainter *p, int row, int col)
{
	int		index = col*numRows()+row;
	FileInfo	*item = index < (int)(FileList->count()) ? FileList->at(index) : 0;
	if (item) {
		bool	target = (item == TargetItem);
		int	w = cellHeight()+fontMetrics().width(item->fileName().data())+4;
		if (Selected->findRef(item) != -1 || target) {
			if (hasFocus() || target) {
				p->setBrush(QApplication::winStyleHighlightColor());
				p->drawRect(0,0,w,cellHeight());
				p->setBrush(NoBrush);
			}
			p->drawRect(0,0,w,cellHeight());
			p->setPen((hasFocus() || target ? white : colorGroup().text()));
			p->drawText(cellHeight(),0,w-cellHeight(),cellHeight(),AlignVCenter,item->fileName().data());
			p->setPen(colorGroup().text());
		}
		else p->drawText(cellHeight(),0,w-cellHeight(),cellHeight(),AlignVCenter,item->fileName().data());
		if (item->isCutted()) {
			QPixmap	pix(*(item->miniIcon()));
			QPainter	painter(&pix);
			painter.fillRect(0,0,pix.width(),pix.height(),QBrush(colorGroup().base(),Dense4Pattern));
			painter.end();
			p->drawPixmap(1,1,pix);
		}
		else p->drawPixmap(1,1,*(item->miniIcon()));
		if (item->isSymLink() && LinkArrow) {
			p->drawPixmap(1,1,*LinkArrow);
		}
		p->setPen(colorGroup().text());
	}
}

void KSmallIconList::resizeEvent(QResizeEvent *)
{
	setNumRows(QMAX(viewHeight()/cellHeight(),1));
	if (FileList) setNumCols(FileList->count()/numRows()+(FileList->count() % numRows() ? 1 : 0));
	else setNumCols(0);
	QTableView::resizeEvent(0);
}

void KSmallIconList::getTablePosition(int index, int& row, int& col)
{
	col = index / numRows();
	row = index - col*numRows();
}

bool KSmallIconList::getItemCell(int row, int col, FileInfo **item, QPoint p)
{
	bool	selected = FALSE;
	*item = 0;
	int	index = QMAX(col,0)*numRows()+row;
	if (FileList == 0 || index >= (int)(FileList->count()) || index < 0) return selected;
	*item = FileList->at(index);
	int	x;
	colXPos(col,&x);
	if (p.x()-x < cellHeight()+fontMetrics().width((*item)->fileName().data())+4)
		selected = TRUE;
	return selected;
}

QRect KSmallIconList::getItemTextRect(FileInfo *item)
{
	int	row,col;
	getTablePosition(item->index(),row,col);
	return QRect(col*cellWidth()+lineWidth()+cellHeight()-xOffset(),row*cellHeight()+lineWidth()-yOffset(),
		     cellWidth()-cellHeight(),cellHeight());
}

void KSmallIconList::updateListSize()
{
	updateColumnWidth();
	if (FileList && FileList->count() > 0)
		setNumCols(FileList->count()/numRows()+(FileList->count() % numRows() ? 1 : 0));
	else setNumCols(0);
}

void KSmallIconList::updateColumnWidth()
{
	if (!FileList) setCellWidth(10*ICON_HEIGHT);
	else {
		FileInfoListIterator	it(*FileList);
		QFontMetrics	fm(fontMetrics());
		int	w(0), w2;
		for (;it.current();++it) if ((w2=fm.width(it.current()->fileName().data())) > w) w = w2;
		w += (ICON_HEIGHT + 10);
		setCellWidth(w);
	}
}

FileInfo* KSmallIconList::getNextItem(FileInfo *current, int code)
{
	int	row(0), col(0), lastCol(0), firstCol(0);
	FileInfo	*next(current);
	int	newIndex(-1);
	if (current) getTablePosition(current->index(),row,col);
	lastCol = lastColVisible();
	firstCol = leftCell();
	switch (code) {
	   case Key_Down:
		newIndex = (current ? current->index()+1 : 0);
		break;
	   case Key_Up:
		newIndex = (current ? current->index()-1 : FileList->count()-1);
		break;
	   case Key_Right:
		newIndex = numRows()*(col+1)+row;
		break;
	   case Key_Left:
		newIndex = numRows()*(col-1)+row;
		break;
	   case Key_PageDown:
		newIndex = numRows()*(col+lastCol-firstCol)+row;
		if (newIndex >= (int)(FileList->count())) newIndex -= numRows();
		break;
	   case Key_PageUp:
		newIndex = numRows()*(col-lastCol+firstCol)+row;
		if (newIndex < 0) newIndex += numRows();
		break;
	}
	if (newIndex >= 0 && newIndex < (int)(FileList->count())) next = FileList->at(newIndex);
	return next;
}

void KSmallIconList::scroll(FileInfo *item)
{
	int	row(0), col(0), xPos(0);
	getTablePosition(item->index(),row,col);
	if (!colXPos(col,&xPos) || xPos < 0 || xPos+cellWidth() > maxViewX()) setLeftCell(col);
}

QRect KSmallIconList::getItemRect(FileInfo *item)
{
	if (!item) return QRect(0,0,-1,-1);
	int	row, col, x, y;
	getTablePosition(item->index(),row,col);
	if (rowYPos(row,&y) && colXPos(col,&x)) {
		int	w = fontMetrics().width(item->fileName().data())+cellHeight();
		return QRect(QPoint(x,y),QSize(w,cellHeight()));
	}
	else return QRect(0,0,-1,-1);
}