#include "kfiled.h"
#include <qmsgbox.h>
#include <qkeycode.h>
#include <iostream.h>

KFileEdit::KFileEdit(const QString& str, QWidget *parent, const char *name, WFlags)
	: QLineEdit(parent,name)
{
	setText(str.data());
	setFrame(TRUE);
	setEchoMode(QLineEdit::Normal);
	selectAll();
}

void KFileEdit::keyPressEvent(QKeyEvent *e)
{
	QString	s;
	switch (e->key()) {
	   case Key_Escape:
		emit cancelEdit();
		break;
	   case Key_Enter:
	   case Key_Return:
		s = QString(text());
		if (s.find('/') != -1) {
			QMessageBox::warning(this,"Error","File name format error",
					     QMessageBox::Ok | QMessageBox::Default,0);
			selectAll();
		}
		else emit terminateEdit();
		break;
	   default:
		QLineEdit::keyPressEvent(e);
		break;
	}
}
