#include "kbiconlist.h"
#include <iostream.h>
#include <qapplication.h>
#include <qkeycode.h>

KBigIconList::KBigIconList(bool showMiniImages, QWidget *parent, const char *name, WFlags f)
	: KFileListBase(parent,name,f)
{
	setTableFlags(Tbl_vScrollBar | Tbl_smoothScrolling);
	setLineWidth(1);
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
// OLE
	ShowMiniImages=showMiniImages;
	if (ShowMiniImages)
	  {
	  setCellHeight(HEIGHT_WITH_MINI_IMAGES);
	  setCellWidth(WIDTH_WITH_MINI_IMAGES);
	  }
	else
	  {
	  setCellHeight(HEIGHT_WITHOUT);
          setCellWidth(WIDTH_WITHOUT);
	  }
// OLE
	connect(this,SIGNAL(requestMiniImage(FileInfo*)),SLOT(miniImageRequested(FileInfo*)));
	installEventFilter(this);
}

// OLE
void KBigIconList::paintCell(QPainter *p, int row, int col)
{
	int		index = row*numCols()+col;
	FileInfo	*item = index < (int)(FileList->count()) ? FileList->at(index) : 0;
	
	if (item) {
		bool	target = (item == TargetItem);
	        QPixmap *icon = item->icon();

// MG
		if (ShowMiniImages) {
			switch (item->miniImageState()) {
			   case FileInfo::Normal:
				emit requestMiniImage(item);
				break;
			   case FileInfo::Loaded:
				if (!item->miniImage()->isNull()) icon = item->miniImage();
				break;
			   case FileInfo::Requested:
				break;
			}
		}
// MG

		p->setPen(colorGroup().text());
		if (Selected->findRef(item) != -1 || target) {
			if (hasFocus() || target) {
				p->setBrush(QApplication::winStyleHighlightColor());
				p->drawRect((BORDER_DIST>>1), cellHeight()-TEXT_BOX_ABOVE_BOTTOM_BORDER,
					   cellWidth()-(BORDER_DIST), TEXT_BOX_HEIGHT);
				p->setBrush(NoBrush);
			}
			p->drawRect((BORDER_DIST>>1), cellHeight()-TEXT_BOX_ABOVE_BOTTOM_BORDER,
				   cellWidth()-(BORDER_DIST), TEXT_BOX_HEIGHT);
			p->setPen((hasFocus() || target ? white : colorGroup().text()));
		}
		QFontMetrics	fm(font());
	 	int	type = 0;
		if (fm.width(item->fileName().data()) > cellWidth()-(BORDER_DIST<<1))
			type = AlignLeft | AlignVCenter;
		else type = AlignCenter;
		p->drawText(BORDER_DIST,cellHeight()-TEXT_BOX_ABOVE_BOTTOM_BORDER,
				cellWidth()-(BORDER_DIST<<1), TEXT_BOX_HEIGHT,
				type,getTruncatedString(item->fileName(),p,cellWidth()-(BORDER_DIST<<1)).data());
		p->setPen(colorGroup().text());

		int icx, icy, ich, icw;

		icx = QMAX((cellWidth()-icon->width())>>1, BORDER_DIST);
	        icy = QMAX(cellHeight()-icon->height()-ICON_ABOVE_BOTTOM_BORDER, BORDER_DIST);
                ich = QMIN(icon->height(),cellHeight()-BORDER_DIST-TEXT_BOX_ABOVE_BOTTOM_BORDER);
		icw = QMIN(icon->width(), cellWidth()-(BORDER_DIST<<1));

		QPixmap	pix(*icon);
		QPainter	painter(&pix);
		if (item->isCutted())
			painter.fillRect(0,0,pix.width(),pix.height(),QBrush(colorGroup().base(),Dense4Pattern));
		if (target || (Selected->findRef(item) != -1 && hasFocus()))
			painter.fillRect(0,0,pix.width(),pix.height(),QBrush(QApplication::winStyleHighlightColor(),Dense4Pattern));
		painter.end();
			p->drawPixmap(icx, icy, pix,0,0,icw,ich);

		if (item->isSymLink() && LinkArrow) {
		           p->drawPixmap(icx,
			               cellHeight()-(ICON_ABOVE_BOTTOM_BORDER)-(LINK_ARROW_HEIGHT),
				      *LinkArrow);
                }		
		
		p->setPen(colorGroup().text());
	}

}
// OLE

void KBigIconList::resizeEvent(QResizeEvent *)
{
	setNumCols(QMAX(viewWidth()/cellWidth(),1));
	if (FileList) setNumRows(FileList->count()/numCols()+(FileList->count() % numCols() ? 1 : 0));
	else setNumRows(0);
	QTableView::resizeEvent(0);
}

void KBigIconList::getTablePosition(int index, int& row, int& col)
{
	row = index / numCols();
	col = index - row*numCols();
}

bool KBigIconList::getItemCell(int row, int col, FileInfo **item, QPoint p)
{
	bool	selected = FALSE;
	*item = 0;
	int	index = row*numCols()+col;
	if (FileList == 0 || index >= (int)(FileList->count()) || index < 0) return selected;
	*item = FileList->at(index);
// OLE
	QPixmap *icon;

	// Icon or MiniImage ?
        icon = ((ShowMiniImages && (!(*item)->miniImage()->isNull()))
	      ?
	      (icon = (*item)->miniImage())
	      :
	      ((*item)->icon()));
	
	int     icx = QMAX(((cellWidth()-icon->width())>>1), BORDER_DIST),
	        icy = QMAX((cellHeight()-icon->height()-ICON_ABOVE_BOTTOM_BORDER), BORDER_DIST),
                ich = QMIN(icon->height(),cellHeight()-BORDER_DIST-TEXT_BOX_ABOVE_BOTTOM_BORDER),
		icw = QMIN(icon->width(), cellWidth()-(BORDER_DIST<<1));

	QRect	ic = QRect(col*cellWidth()+lineWidth()+icx-xOffset(),
			 row*cellHeight()+lineWidth()+icy-yOffset(), 	
			icw, 			
			ich),		
	        te = QRect(col*cellWidth()+lineWidth()+BORDER_DIST-xOffset(), 			
			(row+1)*cellHeight()+lineWidth()-TEXT_BOX_ABOVE_BOTTOM_BORDER-yOffset(), 		
   			cellWidth()-(BORDER_DIST<<1),
			TEXT_BOX_HEIGHT);

//	QRect	ic = QRect(col*cellWidth()+lineWidth()+24-xOffset(),row*cellHeight()+lineWidth()+12-yOffset(),32,32),
//		te =QRect(col*cellWidth()+lineWidth()+4-xOffset(),row*cellHeight()+lineWidth()+48-yOffset(),cellWidth()-4,20);
// OLE
	if (ic.contains(p) || te.contains(p))
		selected = TRUE;
	return selected;
}

void KBigIconList::updateListSize()
{
	if (FileList && FileList->count() > 0)
		setNumRows(FileList->count()/numCols()+(FileList->count() % numCols() ? 1 : 0));
	else setNumRows(0);
}

QRect KBigIconList::getItemTextRect(FileInfo *item)
{
	int	row,col;
	getTablePosition(item->index(),row,col);
// OLE
	QRect	r( col   *cellWidth()+ lineWidth()+BORDER_DIST-xOffset(),
		  (row+1)*cellHeight()+lineWidth()-TEXT_BOX_ABOVE_BOTTOM_BORDER-yOffset(),
		  cellWidth()-(BORDER_DIST<<1),
		  TEXT_BOX_HEIGHT);
//	QRect	r(col*cellWidth()+lineWidth()+4-xOffset(),row*cellHeight()+lineWidth()+48-yOffset(),
//		     cellWidth()-4,20);

// OLE
	return r;
}

FileInfo* KBigIconList::getNextItem(FileInfo *current, int code)
{
	int	row(0), col(0), lastRow(0), firstRow(0);
	FileInfo	*next(current);
	int	newIndex(-1);
	if (current) getTablePosition(current->index(),row,col);
	lastRow = lastRowVisible();
	firstRow = topCell();
	switch (code) {
	   case Key_Down:
		newIndex = numCols()*(row+1)+col;
		break;
	   case Key_Up:
		newIndex = numCols()*(row-1)+col;
		break;
	   case Key_Right:
		newIndex = (current ? current->index()+1 : 0);
		break;
	   case Key_Left:
		newIndex = (current ? current->index()-1 : FileList->count()-1);
		break;
	   case Key_PageDown:
		newIndex = numCols()*(row+lastRow-firstRow)+col;
		if (newIndex >= (int)(FileList->count())) newIndex -= numCols();
		break;
	   case Key_PageUp:
		newIndex = numCols()*(row-lastRow+firstRow)+col;
		if (newIndex < 0) newIndex += numCols();
		break;
	}
	if (newIndex >= 0 && newIndex < (int)(FileList->count())) next = FileList->at(newIndex);
	return next;
}

void KBigIconList::scroll(FileInfo *item)
{
	int	row(0), col(0), yPos(0);
	getTablePosition(item->index(),row,col);
	if (!rowYPos(row,&yPos) || yPos < 0 || yPos+cellHeight() > maxViewY()) setTopCell(row);
}

void KBigIconList::miniImageRequested(FileInfo *fi)
{
cout << "request mini-image for " << fi->fileName().data() << endl;
	Loader.loadMiniImage(fi,this,true);
}

bool KBigIconList::eventFilter(QObject *o, QEvent *e)
{
	switch (e->type()) {
	   case Event_ImageLoad:
		{
cout << "received image loaded event" << endl;
		ImageLoadEvent	*ev = (ImageLoadEvent*)e;
		if (!ev->fileInfo()->miniImage()->isNull()) updateItem(ev->fileInfo());
		return true;
		}
	   default: return false;
	}
}

void KBigIconList::setFileList(FileInfoList *list, bool keepSel)
{
	Loader.stopLoading();
	KFileListBase::setFileList(list,keepSel);
}

void KBigIconList::clearList()
{
	Loader.stopLoading();
	KFileListBase::clearList();
}

QRect KBigIconList::tip(const QPoint& pos, QString& str)
{
  int row = findRow(pos.y()), col = findCol(pos.x());
  FileInfo *item = 0;
  getItemCell(row,col,&item,pos);
  if (item)
    {
      QRect rect = getItemTextRect(item);
      str = item->fileName().data();
      if (rect.contains(pos) && fontMetrics().width(item->fileName().data()) >= rect.width()) return rect;
    }
  return QRect(0,0,-1,-1);
}

QRect KBigIconList::getItemRect(FileInfo *item)
{
	if (!item) return QRect(0,0,-1,-1);
	int	row, col, x, y;
	getTablePosition(item->index(),row,col);
	if (rowYPos(row,&y) && colXPos(col,&x))
		return QRect(QPoint(x,y),QSize(cellWidth(),cellHeight()));
	else return QRect(0,0,-1,-1);
}