#ifndef _IMAGELOADER_H_
#define _IMAGELOADER_H_

#include <qevent.h>
#include <qwidget.h>
#include <qlist.h>
#include <kurl.h>
#include <pthread.h>
#include <qimage.h>
#include "fileinfo.h"

// New event definition

#define	Event_ImageLoad		1010
class ImageLoadEvent : public QEvent
{
public:
	ImageLoadEvent(FileInfo *fi, QWidget *w, bool t = true) : QEvent(Event_ImageLoad), Info(fi), Widget(w), Threaded(t) {}
	FileInfo* fileInfo() const { return Info;}
	QWidget* widget() const { return Widget;}
	bool threaded() const { return Threaded;}
private:
	FileInfo	*Info;
	QWidget		*Widget;
	bool		Threaded;
};

#define	Event_NextImage		1011
class NextImageEvent : public QEvent
{
public:
	NextImageEvent() : QEvent(Event_NextImage) {}
};

// ImageLoader class definition

class ImageLoader : public QObject
{
friend void* __thread_start(void*);
friend void __thread_cleanup(void*);

public:
	ImageLoader(QWidget *parent = 0, const char *name = 0);
	~ImageLoader();

	void loadMiniImage(FileInfo *fi, QWidget *w, bool threaded = true);
	void stopLoading(bool clean = true);

protected:
	void startLoading();
	void loadImageInternal(ImageLoadEvent *e);
	void cantLoad(ImageLoadEvent *e);
	bool initLoading(ImageLoadEvent *e);
	void finishLoading(ImageLoadEvent *e);
	void loadWithNoThread(FileInfo *fi, QWidget *w);
	void nextImage();

	virtual bool eventFilter(QObject *o, QEvent *e);
	virtual void timerEvent(QTimerEvent *e);

	void thread_start();
	void thread_cleanup();

private:
	QList<ImageLoadEvent>	EventList;
	QList<ImageLoadEvent>	ImageLoadedList;
	pthread_t		ThreadID;
	pthread_mutex_t		Mutex;
	bool			Running;

	bool	mini_image_outdated, mini_image_file_exists, xvpics_dir_exists;
	QString	mini_image_path, xvpics_path, image_path;
	QPixmap	mini_image;
	KURL	image_url;
	bool	Loading;
	QImage	InternalImage;
	QString	InternalPath;
	ImageLoadEvent	*InternalEvent;
};

#endif
