#include "history.h"
#include "kexplorer.def"
#include <iostream.h>

HistoryCombo::HistoryCombo(QWidget *parent, const char *name)
	: QComboBox(true,parent,name)
{
	setInsertionPolicy(QComboBox::NoInsertion);
	connect(this,SIGNAL(activated(int)),SLOT(slotActivated(int)));
	Completion = new FileCompletion(this);
	QObject::connect(this,SIGNAL(completion(const char*)),Completion,SLOT(make_completion(const char*)));
	connect(Completion,SIGNAL(setText(const char*)),SLOT(setEditText(const char*)));
}

HistoryCombo::~HistoryCombo()
{
}

void HistoryCombo::refreshHistory()
{
	clear();
	insertStrList(History);
}

void HistoryCombo::keyPressEvent(QKeyEvent *e)
{
	switch (e->key()) {
	   case Key_Tab:
		emit completion(currentText());
		break;
	   case Key_Return:
	   case Key_Enter:
		emit returnPressed();
		break;
	   case Key_Escape:
		emit escapePressed();
		break;
	   default:
		QComboBox::keyPressEvent(e);
		break;
	}
}

void HistoryCombo::slotActivated(int id)
{ emit historySelected(HISTORYMENU_ID+id+1);}

void HistoryCombo::focusInEvent(QFocusEvent *e)
{
cout << "coucou" << endl;
	QComboBox::focusInEvent(e);
	grabKeyboard();
}

void HistoryCombo::focusOutEvent(QFocusEvent*)
{
	releaseKeyboard();
}
