#include "fileview.h"
#include <kurl.h>

#define LABEL_HEIGHT	18

FileViewWidget::FileViewWidget(int type, bool showMiniImages, int format, bool selectionMode, QWidget *parent, const char *name)
	: QWidget(parent,name), FileView(0), Type(type)
{
	DNDIcon = BigLink = SmallLink = (QPixmap*)0;
	FileList = 0;
	Label = 0;
	createWidget(Type,showMiniImages,format,selectionMode);
}

FileViewWidget::~FileViewWidget()
{
	if (FileView) delete FileView;
}

void FileViewWidget::createWidget(int type, bool showMiniImages, int format, bool selectionMode)
{
	if (FileView) delete FileView;
	FileView = 0;
	switch (type) {
	   case BIGICON_ID:
		FileView = new KBigIconList(showMiniImages,this);
		connect(FileView,SIGNAL(requestMiniImage(FileInfo*)),SIGNAL(requestMiniImage(FileInfo*)));
		break;
	   case LISTICON_ID:
	   case SMALLICON_ID:
		FileView = new KSmallIconList(this);
		break;
	   case DETAILICON_ID:
		FileView = new KDetailList(format,selectionMode,this);
		connect(FileView,SIGNAL(columnPressed(int)),SIGNAL(columnPressed(int)));
		connect(FileView,SIGNAL(detailPropertiesChanged()),SIGNAL(detailPropertiesChanged()));
		break;
	}
	connect(FileView,SIGNAL(openItem(FileInfo*)),SIGNAL(openItem(FileInfo*)));
	connect(FileView,SIGNAL(popup()),SIGNAL(popup()));
	connect(FileView,SIGNAL(selectionChanged()),SIGNAL(selectionChanged()));
	connect(FileView,SIGNAL(selected(KFileListBase*)),SLOT(widgetSelected(KFileListBase*)));
	connect(FileView,SIGNAL(renameItem(FileInfo*,const QString&)),SIGNAL(renameItem(FileInfo*,const QString&)));
	connect(FileView,SIGNAL(dropAccepted(QDropEvent*,FileInfo*)),SLOT(dropped(QDropEvent*,FileInfo*)));
	connect(FileView,SIGNAL(backspacePressed()),SIGNAL(backspacePressed()));
	FileView->setDNDIcon(DNDIcon);
	FileView->setLinkArrow((type == BIGICON_ID ? BigLink : SmallLink));
}

void FileViewWidget::resizeEvent(QResizeEvent *)
{
	int	h = (Label ? LABEL_HEIGHT : 0);
	if (Label) Label->setGeometry(0,0,width(),h);
	FileView->setGeometry(0,h,width(),height()-h);
}

void FileViewWidget::changeType(int newType, bool showMiniImages, int format, bool selectionMode, QStrList *CType, QStrList *Width, QString *Names)
{
	FileInfoList	selection, *oldSelection = FileView->getSelected();
	selection.setAutoDelete(FALSE);
	FileInfoListIterator	it(*oldSelection);
	for (;it.current();++it) selection.append(it.current());
	Type = newType;
	bool	tracking = FileView->hasMouseTracking();
	createWidget(newType,showMiniImages,format,selectionMode);
	enableTracking(tracking);
	if (CType && Width) setColumns(*CType,*Width,Names);
	FileView->show();
	resizeEvent(0);
	FileView->setFileList(FileList);
	FileView->setFocus();
	FileView->setSelection(selection);
}

void FileViewWidget::widgetSelected(KFileListBase*)
{ emit selected(this);}

void FileViewWidget::dropped(QDropEvent *e, FileInfo *fi)
{ emit dropAccepted(e,fi,this);}

void FileViewWidget::showLabel(bool show)
{
	if (show && !Label) {
		Label = new FileViewLabel(LabelString.data(),this);
		connect(Label,SIGNAL(clicked()),SLOT(labelClicked()));
		Label->setFrameStyle(QFrame::Panel | QFrame::Sunken);
		Label->setLineWidth(1);
		Label->setText(LabelString.data());
		if (isVisible()) Label->show();
	}
	else if (!show && Label) {
		delete Label;
		Label = 0;
	}
	resizeEvent(0);
}

void FileViewWidget::setLabelString(const char *str)
{
	LabelString = str;
	KURL::decodeURL(LabelString);
	if (Label) Label->setText(LabelString.data());
}

void FileViewWidget::activate(bool active)
{
	if (Label) Label->setBackgroundMode((active ? PaletteMidlight : PaletteBackground));
	Active = active;
	if (!active && FileView) FileView->cancelEdit();
}