#ifndef _BOOKMARK_H_
#define _BOOKMARK_H_

#include <qdialog.h>
#include <kiconloader.h>
#include <kiconloaderdialog.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcombobox.h>

class BookmarkItem;

//-------------------------------------------------------------------------------------------

class BookmarkEditDialog : public QDialog
{
public:
	BookmarkEditDialog(QWidget *parent = 0, const char *name = 0);
	~BookmarkEditDialog();

	void setupDialog(BookmarkItem *item);
	void fillItem(BookmarkItem *item);

private:
	QLineEdit	*Bookmark;
	QComboBox	*AccelKey;
	QLineEdit	*Name;
	KIconLoaderButton	*IconButton;
	KIconLoader	*Loader;
	QComboBox	*Position;
};

//-------------------------------------------------------------------------------------------

class BookmarkDialog : public QDialog
{
	Q_OBJECT;

public:
	BookmarkDialog(QWidget *parent = 0, const char *name = 0);
	~BookmarkDialog();

	void readBookmarks(QList<BookmarkItem>& bookmarks);
	void writeBookmarks(QList<BookmarkItem>& bookmarks);

protected:
	virtual void resizeEvent(QResizeEvent *e);
	void updateListView();

protected slots:
	void slotRightButtonPressed(QListViewItem *item, const QPoint& p, int col);

private:
	QListView	*List;
	KIconLoader	*Loader;
	QPushButton	*ok, *cancel;
	QList<BookmarkItem>	BookList;
};

#endif
