/**********************************************************************

	--- Qt Architect generated file ---

	File: DeviceDlg.cpp
	Last generated: Mon Feb 8 20:10:15 1999

	DO NOT EDIT!!!  This file will be automatically
	regenerated by qtarch.  All changes will be lost.

 *********************************************************************/

#include "DeviceDlg.h"

#define Inherited QDialog

#include <qpushbt.h>
#include <qframe.h>
#include <unistd.h>
#include <kapp.h>
#include <qmessagebox.h>

DeviceDlg::DeviceDlg
(
	QWidget* parent,
	const char* name,
	Device* dev
)
	:
	Inherited( parent, name, TRUE, 0 )
{
	dlgedit_LabelType = new QLabel( i18n("Type :"), this );
	dlgedit_LabelType->setGeometry( 20, 10, 80, 25 );

	dlgedit_DeviceType = new QComboBox( FALSE, this, "DeviceType" );
	dlgedit_DeviceType->setGeometry( 100, 10, 100, 25 );
	dlgedit_DeviceType->insertItem( i18n("Folder") );
	dlgedit_DeviceType->insertItem( i18n("Mountable") );
	dlgedit_DeviceType->insertItem( i18n("Ftp") );
	dlgedit_DeviceType->insertItem( i18n("Trash") );
	dlgedit_DeviceType->insertItem( i18n("SMB") );
	connect(dlgedit_DeviceType,SIGNAL(activated(int)),SLOT(typeChanged(int)));

	dlgedit_LabelName = new QLabel( i18n("Name :"), this );
	dlgedit_LabelName->setGeometry( 20, 45, 80, 25 );

	dlgedit_DeviceName = new QLineEdit( this );
	dlgedit_DeviceName->setGeometry( 100, 45, 100, 25 );
	dlgedit_DeviceName->setFrame( TRUE );

	dlgedit_LabelPath = new QLabel( i18n("Path :"), this );
	dlgedit_LabelPath->setGeometry( 20, 80, 80, 25 );

	dlgedit_DevicePath = new QLineEdit( this );
	dlgedit_DevicePath->setGeometry( 100, 80, 100, 25 );
	dlgedit_DevicePath->setFrame( TRUE );

	dlgedit_LabelHost = new QLabel( i18n("Host :"), this );
	dlgedit_LabelHost->setGeometry( 240, 10, 80, 25 );

	dlgedit_DeviceHost = new QLineEdit( this );
	dlgedit_DeviceHost->setGeometry( 340, 10, 100, 25 );
	dlgedit_DeviceHost->setFrame( TRUE );
	dlgedit_DeviceHost->setEnabled(FALSE);

	dlgedit_LabelLogin = new QLabel( i18n("Login :"), this );
	dlgedit_LabelLogin->setGeometry( 240, 45, 90, 25 );

	dlgedit_DeviceLogin = new QLineEdit( this );
	dlgedit_DeviceLogin->setGeometry( 340, 45, 100, 25 );
	dlgedit_DeviceLogin->setFrame( TRUE );
	dlgedit_DeviceLogin->setEnabled(FALSE);

	dlgedit_LabelPasswd = new QLabel( i18n("Password :"), this );
	dlgedit_LabelPasswd->setGeometry( 240, 80, 90, 25 );

	dlgedit_DevicePasswd = new QLineEdit( this );
	dlgedit_DevicePasswd->setGeometry( 340, 80, 100, 25 );
	dlgedit_DevicePasswd->setFrame( TRUE );
	dlgedit_DevicePasswd->setEnabled(FALSE);

	dlgedit_LabelPort = new QLabel( i18n("Port :"), this );
	dlgedit_LabelPort->setGeometry( 240, 115, 80, 25 );

	dlgedit_DevicePort = new QLineEdit( this );
	dlgedit_DevicePort->setGeometry( 340, 115, 100, 25 );
	dlgedit_DevicePort->setFrame( TRUE );
	dlgedit_DevicePort->setEnabled(FALSE);

	QFrame* dlgedit_Frame_1;
	dlgedit_Frame_1 = new QFrame( this, "Frame_1" );
	dlgedit_Frame_1->setGeometry( 220, 10, 10, 170 );
	dlgedit_Frame_1->setFrameStyle( 53 );

	dlgedit_DeviceKeep = new QCheckBox( i18n("Restore on opening"), this );
	dlgedit_DeviceKeep->setGeometry( 20, 150, 160, 30 );

	dlgedit_CheckAnonymous = new QCheckBox( i18n("Anonymous login"), this );
	dlgedit_CheckAnonymous->setGeometry( 240, 150, 160, 30 );
	dlgedit_CheckAnonymous->setEnabled(FALSE);
	connect(dlgedit_CheckAnonymous,SIGNAL(clicked()),SLOT(anonymousClicked()));

	QPushButton* dlgedit_ButtonOk;
	dlgedit_ButtonOk = new QPushButton( i18n("OK"), this );
	dlgedit_ButtonOk->setGeometry( 60, 190, 90, 30 );
	dlgedit_ButtonOk->setDefault(true);
	connect( dlgedit_ButtonOk, SIGNAL(clicked()), SLOT(okButtonClicked()) );

	QPushButton* dlgedit_ButtonCancel;
	dlgedit_ButtonCancel = new QPushButton( i18n("Cancel"), this );
	dlgedit_ButtonCancel->setGeometry( 280, 190, 90, 30 );
	connect( dlgedit_ButtonCancel, SIGNAL(clicked()), SLOT(reject()) );

	dlgedit_LabelIcon = new QLabel( i18n("Icon :"), this );
	dlgedit_LabelIcon->setGeometry( 20, 115, 80, 25 );

	dlgedit_DeviceIcon = new KIconLoaderButton(this);
	dlgedit_DeviceIcon->setGeometry( 100, 115, 25, 25 );
	dlgedit_DeviceIcon->setIcon("folder.xpm");

	resize( 460,230 );
	setMinimumSize( 460, 230 );
	setMaximumSize( 460, 230 );
	setCaption(i18n("Device properties"));

	if (dev) setupDevice(dev);
}


DeviceDlg::~DeviceDlg()
{
}

void DeviceDlg::typeChanged(int index)
{
	switch (index) {
	   case 0:	// Folder device
		dlgedit_DeviceHost->setEnabled(FALSE);
		dlgedit_DeviceLogin->setEnabled(FALSE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
		dlgedit_DevicePort->setEnabled(FALSE);
		dlgedit_CheckAnonymous->setEnabled(FALSE);
		dlgedit_LabelPath->setText(i18n("Path :"));
		dlgedit_DeviceIcon->setEnabled(TRUE);
		dlgedit_DeviceName->setEnabled(TRUE);
		dlgedit_DevicePath->setEnabled(TRUE);
		break;
	   case 1:	// Mount device
		dlgedit_LabelPath->setText(i18n("Mount point :"));
		dlgedit_LabelHost->setText(i18n("Device :"));
		dlgedit_LabelLogin->setText(i18n("FS Type :"));
		if (getuid() == 0) {
			dlgedit_DevicePath->setEnabled(TRUE);
			dlgedit_DeviceLogin->setEnabled(TRUE);
		}
		else {
			dlgedit_DevicePath->setEnabled(FALSE);
			dlgedit_DeviceLogin->setEnabled(FALSE);
		}
		dlgedit_DeviceHost->setEnabled(TRUE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
		dlgedit_DevicePort->setEnabled(FALSE);
		dlgedit_CheckAnonymous->setEnabled(FALSE);
		dlgedit_DeviceIcon->setEnabled(TRUE);
		dlgedit_DeviceName->setEnabled(TRUE);
		break;
	   case 2:	// Ftp device
		dlgedit_LabelPath->setText(i18n("Path :"));
		dlgedit_LabelHost->setText(i18n("Host :"));
		dlgedit_LabelLogin->setText(i18n("Login :"));
		dlgedit_LabelPort->setText(i18n("Port :"));
		dlgedit_DeviceHost->setEnabled(TRUE);
		dlgedit_DeviceLogin->setEnabled(FALSE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
		dlgedit_DevicePort->setEnabled(TRUE);
		dlgedit_CheckAnonymous->setChecked(TRUE);
		dlgedit_CheckAnonymous->setEnabled(TRUE);
		dlgedit_DeviceIcon->setEnabled(TRUE);
		dlgedit_DevicePath->setEnabled(TRUE);
		dlgedit_DeviceName->setEnabled(TRUE);
		break;
	   case 3:	// Trash device
		dlgedit_DeviceHost->setEnabled(FALSE);
		dlgedit_DeviceLogin->setEnabled(FALSE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
		dlgedit_DevicePort->setEnabled(FALSE);
		dlgedit_CheckAnonymous->setEnabled(FALSE);
		dlgedit_LabelPath->setText(i18n("Path :"));
		dlgedit_DeviceIcon->setEnabled(FALSE);
		dlgedit_DeviceName->setEnabled(FALSE);
		dlgedit_DevicePath->setEnabled(TRUE);
		break;
	   case 4:	// Smb device
		dlgedit_LabelHost->setText(i18n("SMB Service :"));
		dlgedit_LabelPath->setText(i18n("Mount point :"));
		dlgedit_LabelLogin->setText(i18n("Login :"));
		dlgedit_LabelPort->setText(i18n("IP :"));
		dlgedit_DeviceHost->setEnabled(TRUE);
		dlgedit_DeviceLogin->setEnabled(FALSE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
		dlgedit_DevicePort->setEnabled(TRUE);
		dlgedit_CheckAnonymous->setChecked(TRUE);
		dlgedit_CheckAnonymous->setEnabled(TRUE);
		dlgedit_DeviceIcon->setEnabled(TRUE);
		dlgedit_DeviceName->setEnabled(TRUE);
		dlgedit_DevicePath->setEnabled(TRUE);
		break;
	}
}

void DeviceDlg::anonymousClicked()
{
	if (dlgedit_CheckAnonymous->isChecked()) {
		dlgedit_DeviceLogin->setEnabled(FALSE);
		dlgedit_DevicePasswd->setEnabled(FALSE);
	}
	else {
		dlgedit_DeviceLogin->setEnabled(TRUE);
		dlgedit_DevicePasswd->setEnabled(TRUE);
	}
}

void DeviceDlg::setupDevice(Device *dev)
{
	dlgedit_DeviceType->setCurrentItem(dev->type());
	typeChanged(dev->type());
	dlgedit_DeviceName->setText(dev->name().data());
	dlgedit_DevicePath->setText(dev->string(0).data());
	dlgedit_DeviceHost->setText(dev->string(1).data());
	dlgedit_DeviceLogin->setText(dev->string(2).data());
	dlgedit_DevicePasswd->setText(dev->string(3).data());
	dlgedit_DevicePort->setText(dev->string(4).data());
	dlgedit_DeviceKeep->setChecked(dev->keep());
	if (dev->type() == Protocol::Ftp || dev->type() == Protocol::Smb) {
		dlgedit_CheckAnonymous->setChecked(dev->string(2).isEmpty());
		anonymousClicked();
	}
	else dlgedit_CheckAnonymous->setChecked(false);
	dlgedit_DeviceType->setEnabled(false);	// Can't change device type on the fly
	dlgedit_DeviceIcon->setIcon(dev->icon().data());
}

void DeviceDlg::okButtonClicked()
{
	QString	entry;
	if (QString(dlgedit_DeviceName->text()).isEmpty()) entry = i18n("Device name");
	else
		switch (dlgedit_DeviceType->currentItem()) {
		   case 0:
			if (strcmp(dlgedit_DevicePath->text(),"") == 0) entry = i18n("Device path");
			break;
		   case 1:
			if (strcmp(dlgedit_DeviceHost->text(),"") == 0) entry = i18n("Block device");
			break;
		   case 2:
			if (strcmp(dlgedit_DeviceHost->text(),"") == 0) entry = i18n("Host name");
			else if (!dlgedit_CheckAnonymous->isChecked() && strcmp(dlgedit_DeviceLogin->text(),"") == 0)
				entry = i18n("Login");
			break;
		   case 3:
			if (strcmp(dlgedit_DevicePath->text(),"") == 0) entry = i18n("Device path");
			break;
		   case 4:
			if (strcmp(dlgedit_DeviceHost->text(),"") == 0) entry = i18n("Service");
			else if (strcmp(dlgedit_DevicePath->text(),"") == 0) entry = i18n("Mount point");
			else if (!dlgedit_CheckAnonymous->isChecked() && strcmp(dlgedit_DeviceLogin->text(),"") == 0)
				entry = i18n("Login");
			break;
		}
	if (entry.isEmpty()) accept();
	else {
		QString	msg;
		msg.sprintf(i18n("Bad configuration, missing entry : %s"),entry.data());
		QMessageBox::critical(this,i18n("Error"),msg.data(),QMessageBox::Ok | QMessageBox::Default,0);
	}
}
