#include "DeviceDelDlg.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kapp.h>

DeviceDelDlg::DeviceDelDlg(QWidget *parent, const char *name)
	: QDialog(parent,name,TRUE)
{
	setCaption(i18n("Remove device"));
	resize(450,150);
	setMaximumSize(450,150);
	setMinimumSize(450,150);

	ListView = new QListView(this);
	ListView->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Name"));
	ListView->setColumnWidth(0,130);
	ListView->addColumn(i18n("Type"));
	ListView->setColumnWidth(1,50);
	ListView->addColumn(i18n("Address"));
	ListView->setColumnWidth(2,250);
	ListView->setGeometry(10,40,350,100);
	ListView->setAllColumnsShowFocus(TRUE);
	ListView->setSorting(-1);

	QLabel	*label = new QLabel(i18n("Existing devices :"),this);
	label->setGeometry(10,10,200,25);

	QPushButton	*Ok = new QPushButton(i18n("OK"),this);
	Ok->setGeometry(370,20,70,25);
	connect(Ok,SIGNAL(clicked()),SLOT(accept()));

	QPushButton	*Cancel = new QPushButton(i18n("Cancel"),this);
	Cancel->setGeometry(370,55,70,25);
	connect(Cancel,SIGNAL(clicked()),SLOT(reject()));
}

DeviceDelDlg::~DeviceDelDlg()
{
}

void DeviceDelDlg::insertDevice(const char *name, int type, const char *addr, QPixmap *icon)
{
	QString		typeStr;
	switch (type) {
	   case 0: typeStr = i18n("Folder"); break;
	   case 1: typeStr = i18n("Mountable"); break;
	   case 2: typeStr = i18n("Ftp"); break;
	   case 3: typeStr = i18n("Trash"); break;
	   case 8: typeStr = i18n("SMB"); break;
	}
	QListViewItem	*item = new QListViewItem(ListView,name,typeStr.data(),addr);
	item->setPixmap(0,*icon);
}
