/***************************************************************************
                          binaryc.cpp  -  description
                             -------------------
    begin                : Tue Dec 28 1999
    copyright            : (C) 1999 by Philipp Ghring
    email                : p.guehring@poboxes.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "binaryc.h"
#include <ctype.h>
#include <kapp.h>

BinaryC::BinaryC(const char *Directory="",const char *Filename="",unsigned char Wert=0)
{
  QString Name(Directory);
  Handle=NULL;N=0;Muster=Wert;
  Dateiname=Filename;
  Name+=Filename;
  printf("BinFile: %s\n",(const char *)Name);
  Handle=fopen(Name,"r");
  if (Handle!=NULL)
  {
    fseek(Handle,0,SEEK_END);
    N=ftell(Handle);
  }
  else
    printf("Could not open file!\n");
}


BinaryC::~BinaryC()
{


}

long BinaryC::search(const char *v)
{
  long l=0, r=N, x,xr,xl;
  char ch;
  const char *a;
  if (v==NULL) return -1; //Nothing found
  while(r>=1 && ((l+3)<r))
  {
    x=(l+r)/2;xr=x;
    fseek(Handle,x,SEEK_SET);
    ch=fgetc(Handle)^Muster;
    while(ch!='\n' && x>0)
    {
      x--;
      fseek(Handle,x,SEEK_SET);
      ch=fgetc(Handle)^Muster;
    }
    xl=x;
    if(x)
    {
      ch=fgetc(Handle)^Muster;
    }
    for(a=v;a!=NULL && tolower(*a)==tolower(ch) && !feof(Handle);a++)
    {
      ch=fgetc(Handle)^Muster;
    }
    if(!*a && ch=='\t') return ftell(Handle);
    if(tolower(*a)<tolower(ch)) r=xl-1;
    if(tolower(*a)>tolower(ch)) l=xr+1;
  }
  return -1;
}


int BinaryC::html(KHTMLView *html,const char *p_word)
{
  QString line;
  long Pos;
  char ch;
  if(p_word==NULL) return 0;
  Pos = search( p_word );
  printf("BinQuery(%s): %s %ld\n",Dateiname,p_word,Pos);
  if (Pos>-1)
  {
    line.sprintf( i18n("%s translation of %s: ") ,Dateiname, p_word );

    ch=fgetc(Handle)^Muster;
    while(ch!='\n' && !feof(Handle))
    {
      line+=ch;
      ch=fgetc(Handle)^Muster;
    }
    line+="<P>\n";
    html->write(line);
    return 1;
  }
  return 0;
}
