/***************************************************************************
                          printsettings.cpp  -  description                              
                             -------------------                                         
    begin                : Mon May 17 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qstrlist.h>
#include <kapp.h>
#include <kconfig.h>
#include "printsettings.h"

PrintSettings::PrintSettings()
{

	// read config file!
	slotReadConfigFile();

	// set paperList
	paperList.clear();
	paperList.append("a3");
	paperList.append("a4");
	paperList.append("a5");
	paperList.append("b5");
	paperList.append("letter");
	paperList.append("legal");
	paperList.append("tabloid");
	paperList.append("statement");
	paperList.append("executive");
	paperList.append("folio");
	paperList.append("quarto");
	paperList.append("10x14");
	
	postscriptValid = false;
	transformValid = false;
}

PrintSettings::~PrintSettings()
{
	// config file is only saved when user presses
	// Settings -> Save
	slotSaveConfigFile();
}

void PrintSettings::slotInit()
{
	// send it
	emit paperListChanged(paperList);
	setPrinterList(printerList);
	emit paperChanged(paperNo);
	emit printerChanged(printerNo);
	
	postscriptValid = false;
	transformValid = false;
}

void PrintSettings::slotSetPagesPerSheet(PrintSettings::PagesPerSheet p)
{
	pagesPerSheet = p;
	transformValid = false;
}

void PrintSettings::slotSetReverseOrder(bool o)
{
	reverseOrder = o;
	transformValid = false;
}

void PrintSettings::slotSetBook(bool b)
{
	book = b;
	transformValid = false;
}

void PrintSettings::slotSetSignature(int s)
{
	signature = s;
	transformValid = false;
}

void PrintSettings::slotSetFromPage(int p)
{
	rangeFrom = p;
	transformValid = false;
}

void PrintSettings::slotSetToPage(int p)
{
	rangeTo = p;
	transformValid = false;
}

void PrintSettings::slotSetPageSelect(PrintSettings::PageSelect p)
{
	pageSelect = p;
	transformValid = false;
}

PrinterEntry *PrintSettings::getPrinterEntry()
{
	// write the new values to the selected printer
	// the printerNo is the index of the printer in the list
	PrinterEntry *entry;
	QListIterator<PrinterEntry> iterator(printerList);
	iterator.toFirst();
	entry = iterator += printerNo;
	return entry;
}

QString PrintSettings::getPaper()
{
	QStrListIterator iterator(paperList);
	iterator.toFirst();
	QString paper = iterator += paperNo;
	return paper.copy();
}

int PrintSettings::getPagesPerSheetDecimal()
{
	int nup = 0;
	switch(pagesPerSheet)
	{
		case PrintSettings::one: nup = 1; break;
		case PrintSettings::two: nup = 2; break;
		case PrintSettings::four: nup = 4; break;
		default: nup = 1;
	}
	return nup;
}

bool PrintSettings::setWorkFile(QString f)
{
	workFile = f.copy();
	emit workFileChanged(workFile);
	postscriptValid = false;
	transformValid = false;
	return true;
}

void PrintSettings::setPrinterList(PrinterList l)
{
	QStrList strlist;
		
	printerList = l;
	
	// build a QStrList of the PrinterNames and send it
	// maybe somebody wants to have them
	strlist.clear();
	QListIterator<PrinterEntry> iterator(printerList);
	for (iterator.toFirst(); iterator.current(); ++iterator)
	{
		strlist.append(iterator.current()->description);
	}
	emit printerListChanged(strlist);
}

PrinterList PrintSettings::getPrinterList()
{
	return printerList;
}


QStrList PrintSettings::getPrinterStrList()
{
	QStrList strlist;
		
	// build a QStrList of the PrinterNames and send it
	// maybe somebody wants to have them
	strlist.clear();
	QListIterator<PrinterEntry> iterator(printerList);
	for (iterator.toFirst(); iterator.current(); ++iterator)
	{
		strlist.append(iterator.current()->description);
	}
	return strlist;
}

QStrList PrintSettings::getPaperStrList()
{
	return paperList;
}

void PrintSettings::slotReadConfigFile()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  QStrList 			printerName;
  QStrList 			transformCommand;
  QStrList 			previewCommand;
  QStrList 			printCommand;
  PrinterEntry	*entry;

  printerName.clear();
	transformCommand.clear();
	previewCommand.clear();
	printCommand.clear();
	
  KConfig *config = kapp->getConfig();

  config->setGroup("PRINTER");
  paperNo 	= config->readNumEntry("DefaultPaper", 0);
  printerNo = config->readNumEntry("DefaultPrinter", 0);
  config->readListEntry("PrinterName",printerName);
  config->readListEntry("TransformCommand",transformCommand);
  config->readListEntry("PreviewCommand",previewCommand);
  config->readListEntry("PrintCommand",printCommand);

	// fill printerList with read entries
	
	printerList.clear();
	
	QStrListIterator iterName	(printerName);	
	QStrListIterator iterTrans(transformCommand);	
	QStrListIterator iterPreview(previewCommand);	
	QStrListIterator iterPrint(printCommand);
	
	iterName.toFirst();
	iterTrans.toFirst();
	iterPreview.toFirst();
	iterPrint.toFirst();
	
	while ((iterName.current()) && (iterTrans.current())
				&& (iterPreview.current()) && (iterPrint.current()))
	{
		entry = new PrinterEntry;
		CHECK_PTR(entry);
		
		entry->description.setStr(iterName.current());
		entry->transformCommand.setStr(iterTrans.current());
		entry->previewCommand.setStr(iterPreview.current());
		entry->printCommand.setStr(iterPrint.current());
		
		
		printerList.append(entry);
		
		++iterName;
		++iterTrans;
		++iterPreview;
		++iterPrint;
	}
}

void PrintSettings::slotSaveConfigFile()
{
  KConfig *config = kapp->getConfig();
	
  QStrList printerName;
  QStrList transformCommand;
  QStrList previewCommand;
  QStrList printCommand;

  printerName.clear();
	transformCommand.clear();
	previewCommand.clear();
	printCommand.clear();

  config->setGroup("PRINTER");
  config->writeEntry("DefaultPaper",paperNo);
  config->writeEntry("DefaultPrinter",printerNo);

	QListIterator<PrinterEntry> iterator(printerList);
	for (iterator.toFirst(); iterator.current(); ++iterator)
	{
		printerName.append(iterator.current()->description);
		transformCommand.append(iterator.current()->transformCommand);
		previewCommand.append(iterator.current()->previewCommand);
		printCommand.append(iterator.current()->printCommand);
	}
  config->writeEntry("PrinterName",printerName);
  config->writeEntry("TransformCommand",transformCommand);
  config->writeEntry("PreviewCommand",previewCommand);
  config->writeEntry("PrintCommand",printCommand);
}










