/**********************************************************************

	--- Qt Architect generated file ---

	File: PrinterSettingsDialog.cpp
	Last generated: Wed May 19 10:10:05 1999

 *********************************************************************/

#include <qmessagebox.h>
#include <qlist.h>
#include <kapp.h>
#include "PrinterSettingsDialog.h"
#include "printsettings.h"

#define Inherited PrinterSettingsDialogData

PrinterSettingsDialog::PrinterSettingsDialog(const PrinterList &pl,
		QWidget* parent,const char* name) : Inherited( parent, name )
{
	setCaption( "Printer Settings" );
	newPrinter = false;
	_printerList = pl;
	
	// set PrinterBox
	currentPrinter->clear();
	QListIterator<PrinterEntry> iterator(_printerList);
	for (iterator.toFirst(); iterator.current(); ++iterator)
		currentPrinter->insertItem(iterator.current()->description);
		
	iterator.toFirst();
	if (iterator.current())
	{
		printerName->setText(iterator.current()->description);
		transformCommand->setText(iterator.current()->transformCommand);
		printCommand->setText(iterator.current()->printCommand);
	}
}


PrinterSettingsDialog::~PrinterSettingsDialog()
{
}

/** build a PrinterList from the internally stored values
		and return it */
PrinterList PrinterSettingsDialog::getPrinterList()
{
	return _printerList;
}

void PrinterSettingsDialog::slotClearFields()
{
	printerName->clear();
	transformCommand->clear();
	printCommand->clear();
}

void PrinterSettingsDialog::slotAddPrinter()
{
	// append the made changes to the PrinterList
	if ((!printerName->text()) || (!transformCommand->text()) ||
			(!printCommand->text()))
	{
		QMessageBox::information(0,i18n("Accept Printer"),
			i18n("There are empty fields!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
	}
	// create new PrinterEntry and append to PrinterList
	PrinterEntry *entry = new PrinterEntry;
	entry->printerNo = _printerList.count() + 1;
	entry->description = printerName->text();
	entry->transformCommand = transformCommand->text();
	entry->printCommand = printCommand->text();
	_printerList.append(entry);
	// set printer name in pull down list
	currentPrinter->insertItem(printerName->text());
	currentPrinter->setCurrentItem(currentPrinter->count()-1);
}

void PrinterSettingsDialog::slotAcceptPrinter()
{
	// if list is empty go to AddPrinter
	if (currentPrinter->count() == 0)
	{
		slotAddPrinter();
		return;
	}
	
	int idx = 0;
	if ((!printerName->text()) || (!transformCommand->text()) ||
			(!printCommand->text()))
	{
		QMessageBox::information(0,i18n("Accept Printer"),
			i18n("There are empty fields!"),
			QMessageBox::Ok | QMessageBox::Default);
		return;
	}
	// overwrite existing entry
	idx = currentPrinter->currentItem();
	currentPrinter->changeItem(printerName->text(),idx);

	// write the new values to the selected printer
	PrinterEntry *entry;
	QListIterator<PrinterEntry> iterator(_printerList);
	iterator.toFirst();
	entry = iterator += idx;
	entry->description = printerName->text();
	entry->transformCommand = transformCommand->text();
	entry->printCommand = printCommand->text();
}

void PrinterSettingsDialog::slotNewPrinterSelected(int idx)
{
	// write the values of the selected printer in the
	// entry fields
	PrinterEntry *entry;
	QListIterator<PrinterEntry> iterator(_printerList);
	iterator.toFirst();
	entry = iterator += idx;
	printerName->setText(entry->description);
	transformCommand->setText(entry->transformCommand);
	printCommand->setText(entry->printCommand);
}




