/*
 * pgp.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __KPGPKEYS_H__
#define __KPGPKEYS_H__

#include <iostream.h>

#include <qframe.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qradiobt.h> 
#include <qpixmap.h>
#include <qgrpbox.h> 
#include <qpainter.h>
#include <qbttngrp.h>
#include <qlcdnum.h>

#include <qpushbt.h>
#include <qlined.h>
#include <qlayout.h>
#include <qdict.h>

#include <ktreelist.h>
#include <kiconloader.h>
#include <kconfig.h>




#define KEYID_FORMAT "%2.2X%2.2X%2.2X%2.2X"
#define FP_FORMAT    "%2.2X%2.2X%2.2X%2.2X %2.2X%2.2X%2.2X%2.2X"


class KPGPMPI
{
  public:
    
    KPGPMPI();
  
    virtual ~KPGPMPI();
    
    virtual KPGPMPI& operator<<(QDataStream &ds);
  
    virtual QString keyID();
    
    virtual UINT32  store(UINT8 *dest);
    virtual UINT32  bitLen();
    virtual UINT32  byteLen();
    
  protected:
  
    UINT16 bit_len;
    UINT16 byte_len;
    UINT8  *num;
};

// PGP trust packets   
class KPGPTrust 
{
  public:
    
    KPGPTrust(QDataStream &ds);
    virtual ~KPGPTrust();
    
    UINT8         trustByte();
    
    bool          ok;
    
  protected:
    
    UINT8 trust;
};


class KPGPSignature : public KTreeListItem
{
  public:
    
    // Constructor
    KPGPSignature(QDataStream &ds);
  
    // Dectructor
    virtual ~KPGPSignature();
    
    bool           ok;
    
  protected:
    
    void           setValues();
    
    UINT8          version;
    UINT8          length;
    UINT8          sigType;
    UINT32         timestamp;
    UINT8          keyId[8];
    QString        keyIdStr;
    UINT8          concAlgo;
    UINT8          hashAlgo;
    UINT16         testBytes;
    KPGPMPI        digest;
    
    KPGPTrust      *trust;
};


/*
   class KPGPUserId
*/
class KPGPUserID : public KTreeListItem
{
  public:
    
    // Constructor
    KPGPUserID(QDataStream &ds);
  
    // Destructor
    virtual ~KPGPUserID();
    
    bool                  ok;
    
  protected:
    
    void                  setValues();
  
    UINT8                 len;  
    UINT8                 *string;
    KPGPTrust             *trust;
    QList<KPGPSignature>  sigList;
};



class KPGPKey : public KTreeListItem
{
  public:
    
    KPGPKey(QDataStream &ds);
    virtual ~KPGPKey();
    
    // returns fingerprint of key; NOT IMPLEMENTED
    QString        fingerPrint();
    QString        bitlen();
    QString        created();
    QString        keyID();
    QString        userID();
    
    // returns TRUE if key if private
    bool           priv();
    bool           getDefault();
    void           setDefault(bool def);
    
    bool           ok;
    
  protected:
    
    void           setValues();
  
    // --------------------- DATA MEMBER ------------------------
  
    UINT32             timestamp;
    UINT8              version;
    UINT16             validity;
    UINT8              algo;
    UINT8              keyId[8];
    bool               def_key;
    
    KPGPMPI            n;
    KPGPMPI            e;
    
    KPGPTrust          *trust;
    QList<KPGPUserID>  userIdList;
};


#endif

