//=====================================================================
//
//  Package Viewer - A little aid to System Administrators
//  Copyright (C) 1998/1999 Eng.Ele.Paulo Castro
//
//  *** Legal stuff
//  The main goal is to be compliant with KDE and QT current standards.
//  This software is mainly distributed under the terms of the GNU-GPL.
//  Some prior versions were distributed under the terms of the Troll Tech QPL.
//  Both licenses apply when appropriate to save author and all owners rights and
//  copyrights. In case of doubt the most conservative and/or restrictive license apply.
//  The reason to such "dual" license is to respect Troll and KDE current standards.
//
//  This code is released to public access under the terms and conditions 
//  of the license(s) above. Permission to use, to copy and to modify the
//  code is granted to anyone exclusive for non-commercial use.
//
//  This code must not be redistributed if modified, contact the author 
//  first. This especially apply if the objective is commercial.
// 
//  This program is distributed in the hope that it will be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
//  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
//  for more details. You should have received a copy of the GNU General Public
//  License along with this program; if not, write to the Free Software
//  Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  See also the Troll QPL for specific information concerning Troll QT.
//
//  THIS IS CONSIDERED BETA CODE - ALTHOUGH TESTED - USE AT OWN RISK.
//
//  *** About
//  Author  : Eng.Ele.Paulo Castro
//  E-Mail  : hook@netrio.com.br
//  Home    : http://www.momentus.com.br/users/hook/kpackviewer.html
//
//  *** Readme:
//  This is under work, please report any bugs you may find.
//  Suggestions, opinions additions or contributions are always welcome too.
//  Be shure to check the home page (under bugs) to see current status.
//
//  Some effort was made to make a `readable' code - as possible.
//  Also, to make it as simple (single source with simple makefile) as
//  possible. This way anyone can `fit' code (along time) to suite the
//  needs even adjusting the makefile or producing specific ones with Automake.
//  Code is a bit bigger since beggining, compilation may be slow...
//  I am avoiding to split the code due to maintenance reasons...
//  May be unavoidable due to complexity at some point anymore.
//
//  This is intended to be a package viewer. Written to satisfy my own needs.
//  This package DO NOT have any intention to compete or replace any other package,
//  what would be a non sense effort. It's main goal is to add a humble contribution
//  to the best community effort ever seen in the author's opinion.
//  It serves as an additional tool for every one that feel it as useful.
//  Enjoy the reading and - I hope with no problems - the use...
//
//  NEdit: Tab=4 Window=31x94 FixedFont
//=====================================================================

//--<Debug Level>------------------------------------------------------

#define	KPACK_VER	"0.70"

//--<Macros>-----------------------------------------------------------

// Some handy alias...
#define BEEP				KPVApp->beep();
#define Working				KPVApp->processEvents();
#define WORKING				KApplication::getKApplication()->processEvents();

#define CenterCoord(CORD)	(int)(((CORD)>>1)+1)
#define PackCount			packages->childCount()
#define FirstPack			packages->firstChild()
#define CurrPackLabel		packages->currPackLabel()

// "Double Deletion" `nop' safe guard...
#define DESTROY(ptr)		if ( ptr ) { delete ptr; ptr = 0; }

#define ILoad(idx,icx)		idx.load(data_path + icx)
#define FixIco(A,B,C,D,E)	Fixed(A, B, C); if (ILoad(D, E)) setIcon(D);
#define Fixed(Wsz,Hsz,tit)	resize( Wsz, Hsz ); setMinimumSize( Wsz, Hsz ); setMaximumSize( Wsz, Hsz ); setCaption(tit);

#define ProgDlgDone			ProgDlg->setProgress(ProgDlg->totalSteps()); ProgDlg->reset(); Working;
#define ProgInit(a_msg,tot)	ProgDlg->setLabelText(a_msg); ProgDlg->setTotalSteps(tot); ProgDlg->setProgress(0); ProgDlg->show(); Working;

#define TIP_ID(a_str)		if		(a_str == SLA_PAK) amsg = ID_SLA_STA;\
							else if	(a_str == DEB_DIR) amsg = ID_DEB_STA;\
							else amsg = "Packs in: " + a_str; TTip(amsg);

#define TTip(a_str)			lp->setText(a_str);\
							if (a_str != DLG_DIV41 && a_str != LBL_DIV1) { amsg += "\nTotal items logged: "; amsg += PckCnt(); }\
							QToolTip::add(lp, amsg);

#define BGETS(a_fle,a_str)	fgets(buf, BUFLEN, a_fle); a_str = buf;
#define FGETS(b_fle,b_str)	BGETS(b_fle,b_str); b_str = b_str.stripWhiteSpace();
#define IFGETS(c_fle,c_str)	FGETS(c_fle,c_str); if (!feof(c_fle))
#define IBGETS(d_fle,d_str)	BGETS(d_fle,d_str); if (!feof(d_fle))

#define DEFLOG				" > " + user_path + FLE_LOG
#define DEFLST				" > " + user_path + FLE_LST

#define RegularPack			(GoodPack || pack_type == tdeb)
#define IsNasty(a_pak)		( isNasty && pack_type == a_pak)
#define NotNasty(a_pak)		(!isNasty && pack_type == a_pak)
#define ValidPack(a_pak)	(a_pak != tnone && a_pak != tslack && a_pak != tvdeb && a_pak != tvrpm)

#define GoodPack		   (NotNasty(tzip) || \
							NotNasty(tgz)  || \
							NotNasty(tz)   || \
							NotNasty(tbz2) || \
							pack_type == tlzh)
			
#define NoPanic				PrintMsg(MSG_DIV1); return;
#define OPS(a_cte, a_msg)	amsg = a_cte; amsg += a_msg; WARN(amsg);
#define WARN(a_warn) 		DumpMsg(a_warn); Warn(a_warn, true); NoPanic;
#define PANIC(a_str)		ClearPack(); packages->clear(); TTip(LBL_DIV1); WARN(a_str);

#define ExecTrap(a_str)	   (a_str.find(" fail "            , 0, false) > -1 || \
							a_str.find(" failed "          , 0, false) > -1 || \
							a_str.find("invalid "          , 0, false) > -1 || \
							a_str.find(" error "           , 0, false) > -1 || \
							a_str.find("cannot find"       , 0, false) > -1 || \
							a_str.find("no such"           , 0, false) > -1 || \
							a_str.find(" unknown "         , 0, false) > -1 || \
							a_str.find(" doesn't exist"    , 0, false) > -1 || \
							a_str.find("unexpected end"    , 0, false) > -1 || \
							a_str.find("not in gzip format", 0, false) > -1)

#define LSPACED(a_str)		a_str = "    "  + a_str + " "
#define SPACED(a_str)		a_str = "     " + a_str + "     "
#define RSPACED(a_str)		a_str = "   "   + a_str + "         "

#define GOODStr(a_str)		!a_str.isNull() && !a_str.isEmpty() && a_str != "\n"
#define WEIRDStr(a_str)		 a_str.isNull() ||  a_str.isEmpty() || a_str == " "
#define ValidStr(a_str)		!a_str.isNull() && !a_str.isEmpty() && a_str.find("\n") == -1

#define SQuoteStr(a_str)	QuotStr(a_str,"`")
#define DQuoteStr(a_str)	QuotStr(a_str,"\"")

#define UnQuoteStr(a_str)	if (a_str.left(1)  == "\"" || a_str.left(1) == "`" ) \
							{	a_str = a_str.mid(1, a_str.length()); }			 \
							if (a_str.right(1) == "\"" || a_str.right(1) == "`") \
							{	a_str = a_str.mid(0, a_str.length()-1); }

#define QuotStr(a_str,a_qt)	if (notGrpView(a_str))										  \
							{	a_str = a_str.stripWhiteSpace();						  \
								if (!a_str.isEmpty())									  \
								{	if (a_str.find(" ") > -1)							  \
									{	if (a_str.left(1)  != a_qt) a_str = a_qt + a_str; \
										if (a_str.right(1) != a_qt) a_str += a_qt;		  \
							}}}

#define IsSubDir(adir,asub)	(adir.find(asub) > -1)
#define IsDirectory(a_str)	(a_str.right(1) == "/")
#define ForceDir(a_str)		if (a_str.right(1) != "/") a_str += "/";

#define FNAME(a_str)		if (a_str.findRev("/") > -1)								 \
							{	a_str = a_str.mid(a_str.findRev("/")+1, a_str.length()); \
								a_str = a_str.stripWhiteSpace(); }

#define FNODOT(a_str)		if (a_str.findRev(".") > -1)					\
							{	a_str = a_str.mid(0, a_str.findRev("."));	\
								a_str = a_str.stripWhiteSpace(); }


#define isINF(a_lne, a_pck)	(a_lne.left(a_pck.length()+1) == a_pck + ":")
#define isCntrlLne(a_lne)	(a_lne.find("FILE LIST:") > -1 || a_lne == "./")

#define CheckSlash(a_str)	if (a_str != "/" )								\
							{	if (a_str.left(1) == "/")					\
								{	a_str = a_str.mid(1, a_str.length());	\
							}}												\
							if (a_str != "./" )								\
							{	if (a_str.left(2) == "./")					\
								{	a_str = a_str.mid(2, a_str.length());	\
							}}

#define StripFlags(a_str)	if (a_str.left(4) == "RPM:" || 					\
								a_str.left(4) == "DEB:" || 					\
								a_str.left(4) == "SLA:") 					\
							{	a_str = a_str.mid(4, a_str.length()); } 	\
							else 											\
							{	if (a_str.left(7) == "RPMGRP:" || 			\
									a_str.left(7) == "DEBGRP:" || 			\
									a_str.left(7) == "SLAGRP:") 			\
								{ a_str = a_str.mid(7, a_str.length()); }	\
							} a_str = a_str.stripWhiteSpace();


// Some IDentity definitions...
#define ID_RPM_STA			"RPM installed packs"
#define ID_DEB_STA			"Debian installed packs"
#define ID_SLA_STA			"Slack installed packs"

#define ID_RPM_GRP			"RPM Groups Structure"
#define ID_DEB_GRP			"Debian Groups Structure"
#define ID_SLA_GRP			"Slack Groups Structure"

#define isRPMStatus(a_str)	a_str.find(ID_RPM_STA)  > -1
#define isDEBStatus(a_str)	a_str.find(ID_DEB_STA)  > -1
#define isSLAStatus(a_str)	a_str.find(ID_SLA_STA)  > -1
#define notRPMStatus(a_str)	a_str.find(ID_RPM_STA) == -1
#define notDEBStatus(a_str)	a_str.find(ID_DEB_STA) == -1
#define notSLAStatus(a_str)	a_str.find(ID_SLA_STA) == -1

#define isDEBGrp(a_str)		a_str.find(ID_DEB_GRP)  > -1
#define isRPMGrp(a_str)		a_str.find(ID_RPM_GRP)  > -1
#define isSLAGrp(a_str)		a_str.find(ID_SLA_GRP)  > -1	
#define notDEBGrp(a_str)	a_str.find(ID_DEB_GRP) == -1
#define notRPMGrp(a_str)	a_str.find(ID_RPM_GRP) == -1
#define notSLAGrp(a_str)	a_str.find(ID_SLA_GRP) == -1

#define isRPMdb 			(pack_type == trpm   &&  bf_RPMdb)
#define isDEBdb				(pack_type == tvdeb  &&  bf_DEBdb)
#define isSLAdb 			(pack_type == tslack &&  bf_SLAdb)
#define isRPMxt				(pack_type == trpm   && !bf_RPMdb)
#define isDEBxt				(pack_type == tdeb   && !bf_DEBdb)
#define isSLAxt				(pack_type == tslack && !bf_SLAdb)

#define wSLAInfo			(pack_type == tslack && notSLAGrp(requested_pack))
#define wDEBInfo			(pack_type == tvdeb  && notDEBGrp(requested_pack))
#define wRPMInfo			(pack_type == tvrpm  && notRPMGrp(requested_pack))
#define wHTMInfo			(wSLAInfo || wDEBInfo)

#define isSLAFolder(a_pat)	(a_pat == SLA_PAK || \
							 a_pat == user_path + VRT_SLA)
							 
#define isDEBFolder(a_pat)	(a_pat == user_path + VRT_TMP || \
							 a_pat == user_path + VRT_DEB)

#define isRPMFolder(a_pat)	(a_pat == user_path + VRT_RPM)

#define InRpmFolder			(pack_type == tvrpm  && (isRPMFolder(path_to_packs)))
#define InDebFolder			(pack_type == tvdeb  && (isDEBFolder(path_to_packs)))
#define InSlaFolder			(pack_type == tslack && (isSLAFolder(path_to_packs)))
#define InFolder			(InRpmFolder || InDebFolder || InSlaFolder)

#define isGroupable			(pack_type == trpm   || \
							 pack_type == tdeb   || \
							 pack_type == tslack || \
							 pack_type == tvrpm  || \
							 pack_type == tvdeb)

#define isGrpView(a_str)	(isRPMGrp(a_str) || \
							 isDEBGrp(a_str) || \
							 isSLAGrp(a_str) )
							 
#define notGrpView(a_str)	(notRPMGrp(a_str) && \
							 notDEBGrp(a_str) && \
							 notSLAGrp(a_str) )
							 
#define isDEBTopic(a_str)	((a_str.left(14) == "VIRTUAL DEBIAN" ) || \
							 (a_str.left( 8) == "Package:"		 ) || \
							 (a_str.left( 8) == "Version:"		 ) || \
							 (a_str.left(13) == "Architecture:"	 ) || \
							 (a_str.left( 8) == "Depends:"		 ) || \
							 (a_str.left(11) == "Recommends:"	 ) || \
							 (a_str.left( 9) == "Suggests:"		 ) || \
							 (a_str.left( 8) == "Section:"		 ) || \
							 (a_str.left( 9) == "Priority:"		 ) || \
							 (a_str.left(10) == "Essencial:"	 ) || \
							 (a_str.left(12) == "Pre-Depends:"	 ) || \
							 (a_str.left( 9) == "Provides:"		 ) || \
							 (a_str.left( 7) == "Source:"		 ) || \
							 (a_str.left( 5) == "Size:"			 ) || \
							 (a_str.left(10) == "Conflicts:"	 ) || \
							 (a_str.left(15) == "Installed-Size:") || \
							 (a_str.left(11) == "Maintainer:"	 ))
							 
#define isRPMTopic(a_str)	((a_str.left(11) == "VIRTUAL RPM"    ) || \
							 (a_str.left(13) == "Name        :"	 ) || \
							 (a_str.left(13) == "Version     :"	 ) || \
							 (a_str.left(13) == "Release     :"	 ) || \
							 (a_str.left(13) == "Install date:"	 ) || \
							 (a_str.left(13) == "Group       :"	 ) || \
							 (a_str.left(13) == "Size        :"	 ) || \
							 (a_str.left(13) == "Packager    :"	 ) || \
							 (a_str.left(13) == "Summary     :"	 ))
							 
// Some HTML macros...
#define H_BOLD(a_str)		"<B>"					  + a_str + "</B>"
#define H_BLUE(a_str)		"<FONT COLOR=BLUE>"		  + a_str + "</FONT>"
#define H_RED(a_str)		"<FONT COLOR=RED>"		  + a_str + "</FONT>"
#define H_BRED(a_str)		"<FONT COLOR=RED><B>"	  + a_str + "</B></FONT>"
#define H_BBLU(a_str)		"<FONT COLOR=BLUE><B>"	  + a_str + "</B></FONT>"
#define H_OBLU(a_str)		"<FONT COLOR=#000099><B>" + a_str + "</B></FONT>"
#define H_GREEN(a_str)		"<FONT COLOR=#009900><B>" + a_str + "</B></FONT>"
#define H_MAG(a_str)		"<FONT COLOR=#CC66CC><B>" + a_str + "</B></FONT>"
#define H_PRE(a_str)		"<PRE><TT>"				  + a_str + "</TT></PRE>"

//--<Uses>-------------------------------------------------------------

// C libraries
#include <stdio.h>
#include <dirent.h>
#include <iostream.h>

// Qt libraries
#include <qapp.h>
#include <qdialog.h>
#include <qmainwindow.h>
#include <qlayout.h>
#include <qcursor.h>
#include <qwidget.h>
#include <qmessagebox.h>
#include <qclipboard.h>

#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qprogressbar.h>
#include <qprogressdialog.h>

#include <qlabel.h>
#include <qlistview.h>
#include <qmultilinedit.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qframe.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qscrollbar.h>
#include <qtableview.h>

#include <qlist.h>
#include <qevent.h>
#include <qdir.h>
#include <qfile.h>
#include <qregexp.h>
#include <qdatetime.h>
#include <qstrlist.h>
#include <qsize.h>
#include <qtimer.h>

// KDE libraries
#include <kapp.h>
#include <kprocess.h>
#include <ktabbar.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <htmlview.h>
#include <klocale.h>
#include <drag.h>
#include <kcombo.h>
#include "ktreeview.h"

//--<Const>------------------------------------------------------------

// Sanity Limits...
#define TRIGGER	 750					// Time to trigger post process events
#define	BUFLEN	1024					// fgets general purpose line buffer
#define MEMLEN	 256					// same to read meminfo
#define PACKSZ	 200					// Threshold to avoid suspicious bad packs
#define PACKCN	 300					// Threshold to enable pack load counting
#define HTMLMAX	 700					// Threshold to avoid HUGE HTML Tables
#define GRPMIN    15					// Threshold to avoid prog.meter overload
#define PAKMIN    40					// same to packs...

// Memory Checking...
#define MEM_FLE		"/proc/meminfo"

// File List Names (relative to user_path)
#define FLE_DIR		"/KPackView.dirs"	// File to store directory analisys
#define FLE_LOG		"/KPackView.log"	// File to store command execution `log'
#define FLE_PAK		"/KPackView.pack"	// File to store final -readable- pack list
#define FLE_SLK		"/KPackView.slak"	// File to store slackware subtree scan
#define FLE_DSC		"/KPackView.descs"	// File to store all slak descriptions
#define FLE_RPM		"/KPackView.rpms"	// File to store rpm installed packs
#define FLE_LST		"/KPackView.sort"	// File to store unsorted list
#define FLE_DEB		"/KPackView.debn"	// File to store debian subtree scan

// Default Stuff
#define VRT_TMP		"/Virtual_Packs/"	// Temporary Directory for Virtual stuff
#define VRT_SLA		"/Virtual_Slack/"	// Directory to Store Slack Virtual stuff
#define VRT_DEB		"/Virtual_Debian/"	// Directory to Store Debian Virtual stuff
#define VRT_RPM		"/Virtual_RPM/"		// Directory to Store RPM Virtual stuff
#define PAK_ALN		"/Alien"			// Directory to Store Alien Converted stuff

// Location of the usual stuff
#define SLA_SCP		"/var/adm/scripts/"
#define SLA_PAK		"/var/adm/packages/"
#define OLD_PAK		"/var/adm/removed_packages/"
#define OLD_SCP		"/var/adm/removed_scripts/"

#define DEB_DIR		"/var/lib/dpkg/"
#define DEB_LST		"/var/lib/dpkg/info/"
#define DEB_STA		"/var/lib/dpkg/status"
#define DEB_PAK		"/var/lib/dpkg/available"

#define RPM_PAK		"/var/lib/rpm/packages.rpm"
#define RPM_RPM		"/usr/src/redhat/RPMS/i386"

// After all, KPV is a simple translator/front-end  :)
#define PAK_LIST		"ls -R1 "
#define PAK_SORT		"sort -o"

#define PAK_ALN_G		"alien -g"
#define PAK_ALN_T		"alien -t"
#define PAK_ALN_R		"alien -r"
#define PAK_ALN_D		"alien -d"
#define PAK_ALN_HLP		"alien -h"

#define PAK_ARJ_LST		"unarj l "
#define PAK_ARJ_INF		"unarj t "
#define PAK_ARJ_XTR		"unarj x "
#define PAK_ARJ_HLP		"unarj"

#define PAK_LHA_LST		"lha -l "
#define PAK_LHA_XTR		"lha -xv "
#define PAK_LHA_HLP		"lha"

#define PAK_RAR_LST		"rar v -c- "
#define PAK_RAR_XTR		"rar x -o- "
#define PAK_RAR_HLP		"rar"

#define PAK_ZIP_LST		"unzip -Z1 "
#define PAK_ZIP_INF		"unzip -Zl "
#define PAK_ZIP_XTR		"unzip -n "
#define PAK_ZIP_HLP		"unzip"

#define PAK_GZP_LST		"gzip -lvc "
#define PAK_GZP_XTR		"gunzip -dv "
#define PAK_GZP_HLP		"gzip -h"

#define PAK_BZ2_LST		"bz2cat "
#define PAK_BZ2_XTR		"bzip2 -vdc "
#define PAK_BZ2_HLP		"bzip2 -h"

#define PAK_TGZ_LST		"gzip -dc "
#define PAK_TGZ_XTR		"tar xvfz "
#define PAK_TGZ_INF		"gzip -l "
#define PAK_TGZ_HLP		PAK_TAR_HLP

#define PAK_TAR_LST		" | tar tvv "
#define PAK_TAR_XTR		" | tar xv "
#define PAK_TAR_HLP		"tar --help"

#define PAK_DEB_LST		"dpkg-deb -c "
#define PAK_DEB_INF		"dpkg --info "
#define PAK_DEB_XTR		"dpkg-deb -X "
#define PAK_DEB_INS		"dpkg --install "
#define PAK_DEB_HLP		"dpkg --help"
#define PAK_DEB_RMV		"dpkg -r "

#define PAK_RPM_I		"rpm -i"
#define PAK_RPM_U		"rpm -U"
#define PAK_RPM_QL		"rpm -ql "
#define PAK_RPM_QPL		"rpm -qpl "
#define PAK_RPM_QPI		"rpm -qpi "
#define PAK_RPM_QPLI	"rpm -qpli "
#define PAK_RPM_QF		"rpm -q --qf "
#define PAK_RPM_QPF		"rpm -qp --qf "
#define PAK_RPM_QA		"rpm -qa > "
#define PAK_RPM_HLP		"rpm --help"
#define PAK_RPM_RMV		"rpm -e "

#define WIZ_SCP		"#!/bin/sh"			// Script Wizard script type defaults to...

// String Table SubDivided in Msg Categories
// Misc related
#define WELCOME		"\
*************************************************************\n\
*  KPackViewer                                              *\n\
*                                                           *\n\
*  WARNING: This is BETA code - Please report bugs          *\n\
*                                                           *\n\
*  This software is based upon the terms of the GNU-GPL     *\n\
*************************************************************\n\
\n"

#define	TITLE   	klocale->translate("Package Viewer")
#define	VIEWTIT   	klocale->translate("Output Viewer")
#define MSG_EXIT	klocale->translate("Shutting down...")

// HTML related
#define HTML_HEADER	"\
<HTML><HEAD>\
<META HTTP-EQUIV=Content-Type CONTENT=text/html; charset=iso-8859-1>\
<TITLE>KPV Information Pane</TITLE></HEAD>\
<BODY TEXT=#000000 BGCOLOR=#FFFFFF LINK=#0000FF VLINK=#FF0000 ALINK=#000088>"

#define HTML_FOOTER	"\
<CENTER><HR WIDTH=100%></CENTER>\
<CENTER><FONT SIZE=-1>&copy; Eng.Ele. Paulo Castro</FONT></CENTER>\
<CENTER><FONT SIZE=-2><A HREF=mailto: hook@netrio.com.br>hook@netrio.com.br</A></FONT></CENTER>\
</BODY></HTML>"

#define GRUP_HEADER	"\
<CENTER><H3>Packages Group Info</H3></CENTER><P>\
<CENTER><HR WIDTH=100%></CENTER>\
<CENTER><TABLE BORDER COLS=3 WIDTH=95% NOSAVE>\
<TR BGCOLOR=#000066 NOSAVE>\
<TD WIDTH=15% NOSAVE><FONT COLOR=#FFFFFF><B><CENTER>Package</CENTER></B></FONT></TD>\
<TD WIDTH=25% NOSAVE><FONT COLOR=#FFFFFF><B><CENTER> Group </CENTER></B></FONT></TD>\
<TD WIDTH=60% NOSAVE><FONT COLOR=#FFFFFF><B><CENTER>Description</CENTER></B></FONT></TD></TR>"

#define INFO_HEADER	"\
<CENTER><H3>Package Info</H3></CENTER><P>\
<CENTER><HR WIDTH=100%></CENTER><P>\
<CENTER><TABLE BORDER COLS=2 WIDTH=95% NOSAVE>\
<TR BGCOLOR=#000066 NOSAVE>\
<TD WIDTH=25% NOSAVE><FONT COLOR=#FFFFFF><B><CENTER>Info</CENTER></B></FONT></TD>\
<TD WIDTH=75% NOSAVE><FONT COLOR=#FFFFFF><B><CENTER>Value</CENTER></B></FONT></TD></TR>"

#define HTML_BLANK HTML_HEADER "\
<CENTER><H3>Package Info</H3></CENTER><P>\
<CENTER><HR WIDTH=100%></CENTER><P>\
<CENTER><H4>Nothing to report!</H4></CENTER><P>\
" HTML_FOOTER

#define HTML_ABOUT	HTML_HEADER "\
<CENTER><H1>KPackViewer v." KPACK_VER "\
</H1></CENTER><P><CENTER><H3><FONT COLOR=RED><B>About</B></FONT></H3></CENTER><P>\
<HR WIDTH=100%><P><FONT SIZE=+1>&copy; 1998/1999 Eng.Ele. Paulo Castro<BR>\
<B><FONT SIZE=-1>Looking for a serious position in Canada, US, UK or Australia.</FONT></B><BR>\
<P>E-Mail: <A HREF=mailto: hook@netrio.com.br>hook@netrio.com.br</A><BR>KPV Home: <A HREF=http:/\
/www.momentus.com.br/users/hook/kpackviewer.html>http:/\
/www.momentus.com.br/users/hook/kpackviewer.html</A><BR>\
<P>This program is free software; you can redistribute it and/or modify it \
under the terms of the GNU-GPL. See also the <A HREF=http:/\
/www.troll.no/copyright.html>Troll Tech Q Public License (QPL)</A>.<BR>\
<P>Keep in mind that this is a on going work, you may find some minor bugs that \
I am still working. Please report bugs! This feedback made me reach as far as \
here, thanks in advance for your tolerance...<BR>\
<P>I hope you think this program is useful.<BR>\
Be shure to visit the HomePage for the latest improvements.<P><P></FONT>\
" HTML_FOOTER

#define HTML_NOSCR	klocale->translate("<B>No Slack Script Information</B><P>")
#define HTML_NOREP	klocale->translate("<CENTER><H4>Nothing to report!</H4></CENTER><P>")
#define HTML_SCRIP	"<P><CENTER><HR WIDTH=100%></CENTER><P><H3>Slack Script</H3><P>"

// Menu related
#define M_SLACK	 	klocale->translate("Browse Slackware Packages")
#define M_RPM  	 	klocale->translate("Browse RPM Packages")
#define M_DEB  	 	klocale->translate("Browse Debian Packages")
#define M_ZIP  	 	klocale->translate("Browse Zip Packages")
#define M_TGZ  	 	klocale->translate("Browse TarGZip Packages")
#define M_TBZ  	 	klocale->translate("Browse TarBZip2 Packages")
#define M_LHA  	 	klocale->translate("Browse LHA Packages")
#define M_GZP  	 	klocale->translate("Browse GZIP Packages")
#define M_ARJ  	 	klocale->translate("Browse ARJ Packages")
#define M_RAR  	 	klocale->translate("Browse RAR Packages")
#define M_ALL  	 	klocale->translate("Browse ALL valid packs")
#define M_MNTSLK 	klocale->translate("Mount a Slackware Distribution CDROM")
#define M_MNTDEB 	klocale->translate("Mount a Debian Distribution CDROM")
#define M_MNTRPM 	klocale->translate("Mount a RPM Distribution CDROM")
#define M_LOOK	 	klocale->translate("View the last Shell output issued")
#define M_ALIEN  	klocale->translate("Convert Package using Alien...")
#define M_QUIT		klocale->translate("Exit application")
#define M_FRESH		klocale->translate("Refresh current folder")
#define M_GUIWIN	klocale->translate("Change GUI to Windows Style")
#define M_GUIMOT	klocale->translate("Change GUI Motif Style")
#define M_GUISYS	klocale->translate("Use System Default GUI Style")
#define M_ABOUT		klocale->translate("About the author")
#define M_HELP		klocale->translate("Help Index")
#define M_NKPV		klocale->translate("New KPV Clone Window...")
#define M_MCHK		klocale->translate("Toggle Memory Checking...")
#define M_AFIC		klocale->translate("Alternate Folder Icons...")
#define M_INHTML	klocale->translate("Toggle HTML Formatting in Information Pane...")
#define M_NIC3		klocale->translate("Toggle TreeView AutoCollapse feature...")

// Tips related
#define O_MOUNT		klocale->translate("Mount a Slackware Distribution CDROM\n\nAs if it was installed...\nAllows easy package browsing even for non Slackware users because anyone can see all distribution packages\nThe packs are mounted in your home directory, under KPV dir in Virtual_Slack..")
#define O_DEBDB		klocale->translate("Mount a Debian Distribution CDROM\n\nAs if it was installed...\nAllows easy package browsing even for non Debian users because anyone can see all distribution packages\nThe packs are mounted in your home directory, under KPV dir in Virtual_Debian...\nNote that Debian owns many packs.\nYou can easily reach more than 10Mb.")
#define O_RPMDB		klocale->translate("Mount a RPM Distribution CDROM\n\nAs if it was installed...\nAllows easy package browsing even for non RPM users because anyone can see all distribution packages\nThe packs are mounted in your home directory, under KPV dir in Virtual_RPM..")
#define O_SLACK		klocale->translate("Open Slackware Packages\n\nATTENTION: Be carefull when selecting what you will try to open because slackpacks don't have fixed extension.\n\nPrefer to look only in: /var/adm/packages/ or in the virtual Slackware mounted directory...")
#define O_RPM		klocale->translate("Open RPM Packages\nChoose a package into a folder and\nall RPMs in the folder will be logged in the listbox...")
#define O_DEB		klocale->translate("Open Debian Packages\nChoose a package into a folder and\nall DEB packs in the folder will be logged in the listbox...")
#define O_ZIP		klocale->translate("Open Zip Packages\nChoose a zip pack into a folder and\nall ZIPs in the folder will be logged in the listbox...")
#define O_TGZ		klocale->translate("Open Tar.GZip Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_TBZ		klocale->translate("Open Tar.BZip2 Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_LHA		klocale->translate("Open LHA Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_GZP		klocale->translate("Open GZIP Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_ARJ		klocale->translate("Open ARJ Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_RAR		klocale->translate("Open RAR Packages\nChoose a package into a folder and\nall packs in the folder will be logged in the listbox...")
#define O_ALL		klocale->translate("Open All Valid Packages\nChoose a folder and all valid packs\nwill be logged in the listbox...")
#define O_NKPV		klocale->translate("Open a KPV Clone Window\nAttempt to open a new window\nin KPV current folder.")
#define	O_TREE		klocale->translate("Here you have a visual representation\nof the package listing in a hierachical view...")
#define	O_LIST		klocale->translate("Here you have the file list\nreported by the package..")
#define	O_PACK		klocale->translate("Here you have all packages found\non selected directory under selected pattern...")
#define O_INFO		klocale->translate("Here you have selected package\nreported information by query.")
#define O_HTML		klocale->translate("Here you have an HTML view\nThis view is just an option to\nenhance your visual power with KPV...")

// Popup menu related
#define MNU_POP1	klocale->translate("&Extract to...")
#define MNU_POP2	klocale->translate("&Convert pack...")
#define MNU_POP3	klocale->translate("Show &RPM Groups...")
#define MNU_POP4	klocale->translate("Show &DEB Groups...")
#define MNU_POP5	klocale->translate("Remove item &from list")
#define MNU_POP6	klocale->translate("&Copy")
#define MNU_POP7	klocale->translate("&Select All")
#define MNU_POP8	klocale->translate("&Deselect")
#define MNU_POP9	klocale->translate("Copy &All to Clipboard")
#define MNU_POP10	klocale->translate("Show &Slack Groups...")
#define MNU_POP11	klocale->translate("Search...")
#define MNU_POP18	klocale->translate("Where is it ?...")
#define MNU_POP12	klocale->translate("Copy All to Clipboard Tab Delimited...")
#define MNU_POP13	klocale->translate("Copy All to Clipboard Semi-Colon Delimited...")
#define MNU_POP14	klocale->translate("Copy Selected to Clipboard")
#define MNU_POP15	klocale->translate("Copy Selected to Clipboard Tab Delimited...")
#define MNU_POP16	klocale->translate("Copy Selected to Clipboard Semi-Colon Delimited...")
#define MNU_POP17	klocale->translate("Re&load pack")
#define MNU_POP19	klocale->translate("Script &Wizard")
#define MNU_POP21	klocale->translate("Remove Pack...")

// Menu Bar related - Last is: 31
#define MNU_BAR1	klocale->translate("Open &Slackware packages")
#define MNU_BAR2	klocale->translate("Open &RPM packages")
#define MNU_BAR3	klocale->translate("Open &Debian packages")
#define MNU_BAR4	klocale->translate("Open &Zip packages")
#define MNU_BAR5	klocale->translate("Open &TarGZip packages")
#define MNU_BAR6	klocale->translate("Open Tar&BZip2 packages")
#define MNU_BAR7	klocale->translate("Open &Lha packages")
#define MNU_BAR8	klocale->translate("Open &GZip packages")
#define MNU_BAR28	klocale->translate("Open Ar&j packages")
#define MNU_BAR30	klocale->translate("Open RAR packages")
#define MNU_BAR9	klocale->translate("Open &all valid packages")
#define MNU_BAR10	klocale->translate("Mount Slac&kware CDROM")
#define MNU_BAR11	klocale->translate("Mount RPM CDROM")
#define MNU_BAR12	klocale->translate("Mount D&EB CDROM")
#define MNU_BAR13	klocale->translate("&View Last Output...")
#define MNU_BAR14	klocale->translate("Re&fresh Pack Folder...")
#define MNU_BAR15	klocale->translate("&Quit")
#define MNU_BAR16	klocale->translate("&Windows Style")
#define MNU_BAR17	klocale->translate("&Motif Style")
#define MNU_BAR18	klocale->translate("&About")
#define MNU_BAR19	klocale->translate("&Index")
#define MNU_BAR20	klocale->translate("&File")
#define MNU_BAR21	klocale->translate("&Options")
#define MNU_BAR22	klocale->translate("&Help")
#define MNU_BAR23	klocale->translate("&New KPV Window...")
#define MNU_BAR24	klocale->translate("Memory &checking")
#define MNU_BAR25	klocale->translate("Alternate F&older Icon")
#define MNU_BAR26	klocale->translate("S&ystem Default")
#define MNU_BAR27	klocale->translate("&HTML View")
#define MNU_BAR29	klocale->translate("Nice Tree")

// Tab related
#define TAB_BAR1	klocale->translate("Package Structure")
#define TAB_BAR2	klocale->translate("Package Contents")
#define TAB_BAR3	klocale->translate("Package Information")

// MsgDiv related - Last is: 34
#define MSG_DIV1	klocale->translate("Ready")
#define MSG_DIV7	klocale->translate("Ready - Elapsed: ")
#define MSG_DIV3	klocale->translate("Sorting packages... ")
#define MSG_DIV27	klocale->translate("Searching for: ")
#define MSG_DIV28	klocale->translate("Found at position: ")
#define MSG_DIV5	klocale->translate("Please wait... ")
#define MSG_DIV8 	klocale->translate("Scanning Package: ")
#define MSG_DIV6	klocale->translate("Querying Package: ")
#define MSG_DIV15	klocale->translate("Extracting package... ")
#define MSG_DIV21	klocale->translate("Loading Packages... ")
#define MSG_DIV9 	klocale->translate("Scanning Groups... ")
#define MSG_DIV11	klocale->translate("Processing Package list... ")
#define MSG_DIV22	klocale->translate("Building Group Structure... ")

#define MSG_DIV14	klocale->translate("Select install options... ")
#define MSG_DIV2	klocale->translate("Select folder and package... ")
#define MSG_DIV17	klocale->translate("Select extract to directory... ")
#define MSG_DIV13	klocale->translate("Select Alien converting options... ")
#define MSG_DIV23	klocale->translate("Select Slackware ROOT folder... ")

#define MSG_DIV25	klocale->translate("Mounting Virtual Packs in: ")
#define MSG_DIV24	klocale->translate("Getting Slackware Descriptions... ")
#define MSG_DIV26	klocale->translate("This will take a while... Mounting ")

#define MSG_DIV29	klocale->translate("Disposing previous package...done. Stand by...")
#define MSG_DIV30	klocale->translate("Stand by, opening new KPV window...")
#define MSG_DIV31	klocale->translate("Disposing KPV window...")
#define MSG_DIV32	klocale->translate("Querying RPM database status...")

#define MSG_DIV33	klocale->translate("Select Debian Packs Root folder...")
#define MSG_DIV34	klocale->translate("Select RPM Packs folder...")

// Warn related - Last is: 35
#define MSG_WARN16	klocale->translate("Your Slackware Virtual Folder is not empty.\nRemove or rename it before building a new one.")
#define MSG_WARN19	klocale->translate("Sorry, can not identify package: `")
#define MSG_WARN24	klocale->translate("File does not seems to be a Slackware Package.")
#define MSG_WARN30	klocale->translate("File does not seems to be a Virtual Package.")

#define MSG_WARN15	klocale->translate("No RPM packages found.")
#define MSG_WARN5	klocale->translate("Not a valid pack for conversion.")
#define MSG_WARN31	klocale->translate("Error while executing: ")
#define MSG_WARN33	klocale->translate("Error while querying package: ")

#define MSG_WARN1	klocale->translate("Please, refer to associated pack instead...")
#define MSG_WARN6	klocale->translate("Please, re-select a valid item first...")
#define MSG_WARN22	klocale->translate("Please select a valid Folder.")
#define MSG_WARN23	klocale->translate("Please verify... Can not log directory: ")

#define MSG_WARN20	klocale->translate("Can not load: ")
#define MSG_WARN7	klocale->translate("Can not find: ")
#define MSG_WARN29	klocale->translate("Can not change to: ")
#define MSG_WARN21	klocale->translate("Can not find RPM package file: ")
#define MSG_WARN27	klocale->translate("Can not find Debian directories...")
#define MSG_WARN10	klocale->translate("Can not find Debian Status File: /var/lib/dpkg/status !")
#define MSG_WARN18	klocale->translate("Can not find required directories on ")
#define MSG_WARN9	klocale->translate("Can not check available memory.\nProgram will terminate now.")
#define MSG_WARN4	klocale->translate("Can not create user $HOME Directory to Alien, using root...")
#define MSG_WARN11	klocale->translate("Can not create Debian Packs Folder.")
#define MSG_WARN12	klocale->translate("Can not create Debian Packs Group List.")
#define MSG_WARN13	klocale->translate("Can not create DEB package list to: ")
#define MSG_WARN14	klocale->translate("Can not create Group File in: ")
#define MSG_WARN17	klocale->translate("Can not create Virtual Slackware Folder.")
#define MSG_WARN32	klocale->translate("Can not create Virtual Debian Folder.")

#define MSG_WARN3	klocale->translate("OPS! Can not proceed.\nFile Read error to: ")
#define MSG_WARN2	klocale->translate("OPS! Can not proceed.\nFile Write error to: ")
#define MSG_WARN8	klocale->translate("OPS! Not enough memory to complete operation.")
#define MSG_WARN25	klocale->translate("OPS! Package listing file contains bad data.\n\nProbably cause is failure to generate pack list.\nCheck file integrity and permissions.\n")

#define MSG_WARN34	klocale->translate("Error reading Virtual Pack: ")
#define MSG_WARN35	klocale->translate("Pack does not seem to be a valid Virtual Pack: ")

// Dialog related
#define DLG_DIV1	klocale->translate("Slackware Initial Folder")
#define DLG_DIV2	klocale->translate("Extract Debian pack")
#define DLG_DIV3	klocale->translate("ExtractTo... ")
#define DLG_DIV4	klocale->translate("Install-NoForce ")
#define DLG_DIV5	klocale->translate("Install-ForceDepends ")
#define DLG_DIV6	klocale->translate("Install-ForceConflicts ")
#define DLG_DIV7	klocale->translate(" Options ")
#define DLG_DIV8	klocale->translate(" Ok ")
#define DLG_DIV9	klocale->translate(" Cancel ")
#define DLG_DIV10	klocale->translate("Auto Load Directory")
#define DLG_DIV11	klocale->translate("Free Browsing")
#define DLG_DIV12	klocale->translate("Convert package with Alien")

// Order after some chaos :-P ....
#define DLG_DIV13	klocale->translate("Extracting package: ")
#define DLG_DIV14	klocale->translate("Extracting ")
#define DLG_DIV15	klocale->translate(" selected items")
#define DLG_DIV16	klocale->translate("Copied ")
#define DLG_DIV17	klocale->translate(" items to Clipboard.")
#define DLG_DIV20	klocale->translate("Abort")
#define DLG_DIV21	klocale->translate("Progress")
#define DLG_DIV22	klocale->translate("\nDone.\n")
#define DLG_DIV23	klocale->translate("Converting package ")
#define DLG_DIV24	klocale->translate("\nTo: ")
#define DLG_DIV25	klocale->translate("Fatal Error")
#define DLG_DIV27	klocale->translate(" Dismiss ")
#define DLG_DIV28	klocale->translate("Match Whole")
#define DLG_DIV29	klocale->translate("Match Case")
#define DLG_DIV30	klocale->translate("Search for:")
#define DLG_DIV31	klocale->translate("Search")
#define DLG_DIV32	klocale->translate("Wildcard Mode")
#define DLG_DIV33	klocale->translate("Invalid Expression!")
#define DLG_DIV34	klocale->translate("Selected ")
#define DLG_DIV35	klocale->translate(" items.")
#define DLG_DIV36	klocale->translate("Nothing to copy to Clipboard!")
#define DLG_DIV37	klocale->translate("Disposing previous package...")
#define DLG_DIV38	klocale->translate("ARJ list is empty...")
#define DLG_DIV39	klocale->translate("ARJ list count do not match.")
#define DLG_DIV40	klocale->translate("Building Script...")
#define DLG_DIV41	klocale->translate("Stand by...")
#define DLG_DIV42	klocale->translate("RAR list is empty...")
#define DLG_DIV43	klocale->translate("RAR list count do not match.")
#define DLG_DIV44	klocale->translate("\nOPS! ERROR while executing process...\n\nProcess Output is:\n\n")
#define DLG_DIV45	klocale->translate("Choose Initial Folder")

// Label related
#define LBL_DIV1	klocale->translate("Waiting")
#define LBL_DIV2	klocale->translate("Package")
#define LBL_DIV3	klocale->translate("Group")
#define LBL_DIV4	klocale->translate("Description")
#define LBL_DIV5	klocale->translate("Attribs")
#define LBL_DIV6	klocale->translate("Time Stamp")
#define LBL_DIV7	klocale->translate("Size")
#define LBL_DIV8	klocale->translate("File")
#define LBL_DIV9	klocale->translate("Script Type:")
#define LBL_DIV10	klocale->translate("If IsDirectory:")
#define LBL_DIV11	klocale->translate("If IsArchive:")
#define LBL_DIV12	klocale->translate("Put After each:")
#define LBL_DIV13	klocale->translate("Put Before each:")
#define LBL_DIV14	klocale->translate("Sample:")
#define LBL_DIV15	klocale->translate("Copy To Clipboard")
#define LBL_DIV16	klocale->translate("%t% = TAB\n%i% = RepeatItem()\n%p% = ParentDir()\n%f% = FileName()\n%o% = OmitItem()")
#define LBL_DIV17	klocale->translate("None")
#define LBL_DIV18	klocale->translate("Erase")
#define LBL_DIV19	klocale->translate("MoveTo:")
#define LBL_DIV20	klocale->translate("Move using symlinks to avoid brokens")
#define LBL_DIV21	klocale->translate("Automatic PreBuilt Scripts")

// Confirmations
#define MSG_CONF1	klocale->translate("The Virtual Folder is not empty.\nWould you like to append/overwrite virtual packs to it ?")
#define MSG_CONF2	klocale->translate("Please confirm Virtual Packs Mounting from:\n\n")

//--<Var-Forwarded>----------------------------------------------------

bool		isBusy;
QString		data_path;

//--<Type>-------------------------------------------------------------

//--<Generic types>-----------------------------

typedef KTreeViewItem TKTreeItem;
typedef enum tag_TOption { Option_1, Option_2, Option_3, Option_4 } TOption;
typedef enum tag_TPack { tall, tslack, tdeb, trpm, tzip, tgz, tbz2, tlzh, tz, tarj, trar, tvdeb, tvrpm, tnone } TPack;

//--<General purpose objects>-------------------

class TDoubleClick_RB : public QRadioButton
{
	Q_OBJECT

	public:
		TDoubleClick_RB(QWidget *parent = NULL, const char *name = NULL)
		:QRadioButton(parent,name) {} ;

		~TDoubleClick_RB() {} ;
		
	signals:
		void SIG_DoubleClicked(void);
		
	protected:
		void mouseDoubleClickEvent( QMouseEvent *e )
		{ 	QRadioButton::mouseDoubleClickEvent(e);
			emit SIG_DoubleClicked();
		};
};

class THistCombo : public KCombo
{
	Q_OBJECT

	public:
		THistCombo(KConfig *cfg, QString cfgSect, int maxit = 10, QWidget *parent = NULL, const char *name = NULL)
		:KCombo(true, parent, name)
		{
			setCompletion(true); setInsertionPolicy(QComboBox::AtTop);
			conf = cfg; confSect = cfgSect; maxitm = maxit; LoadHistory();
			connect( this, SIGNAL( activated(const char*)   ), this, SLOT( AddToHistory(const char*)) );
		};

		virtual ~THistCombo() {  SaveHistory(); };
		
	public slots:
		void Remember(void) { AddToHistory(currentText()); };

		void AddToHistory(const char* anitem)
		{	if (NotInHistory(anitem)) insertItem(anitem,0); else PutAtTop(anitem);
			setCurrentItem(0); setFocus();
		};

	protected:
		int maxitm; KConfig *conf; QString confSect;

		void LoadHistory()
		{	QString aux(""); conf->setGroup( confSect );
			for(int i = 0; i < maxitm; i++)
			{	aux = conf->readEntry(aux.setNum(i), "");
				if ( GOODStr(aux) ) { if (NotInHistory(aux)) insertItem(aux); }
			}
		};
		
		void SaveHistory()
		{	QString aux(""), pkey(""); conf->setGroup( confSect );
			for(int i = 0; i < count() && i < maxitm; i++)
			{	aux = text(i);
				if ( GOODStr(aux) ) conf->writeEntry(pkey.setNum(i), aux);
			} conf->sync();
		};

		bool NotInHistory(QString anitem)
		{	if ( WEIRDStr(anitem) ) return false; if (count() == 0) return true;
			for(int i = 0; i < count(); i++) { if (anitem == text(i)) return false; }
			return true;
		};
		
		void PutAtTop(QString anitem)
		{	for(int i = 0; i < count(); i++) { if (anitem == text(i)) removeItem(i); }
			insertItem(anitem, 0);
		};
};

class TKMultiEd : public QMultiLineEdit
{
	Q_OBJECT
	
	public:
		TKMultiEd(QWidget *parent = 0, const char *name = 0)
		:QMultiLineEdit(parent,name)
		{
			setReadOnly(true); popmnu = new QPopupMenu(); QPixmap mnuico;
			ILoad(mnuico, "/copy.xpm" ); popmnu->insertItem(mnuico, MNU_POP6 , this, SLOT(copyText())  );
			ILoad(mnuico, "/fnt.xpm"  ); popmnu->insertItem(mnuico, MNU_POP7 , this, SLOT(selectAll()) );
			ILoad(mnuico, "/desel.xpm"); popmnu->insertItem(mnuico, MNU_POP8 , this, SLOT(deselect())  );
		};
		
		~TKMultiEd() { DESTROY(popmnu); };
		
	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{	if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
			else QMultiLineEdit::mousePressEvent(e);
		};

	private:
		QPopupMenu  *popmnu;
};

//--<General purpose Dialogs>-------------------

class TKPVStatus : public QDialog
{
	Q_OBJECT

	public:
		TKPVStatus(QString, QWidget *parent = NULL, const char *name = NULL);
		~TKPVStatus() { DESTROY(Label_1); };

	public slots:
		void WaitMsg(QString, bool adj = true);
		
	private:
		QLabel	*Label_1;
		void Adjust(void);
};

class TInfoWindow : public QDialog 
{
	Q_OBJECT

	public:
		TInfoWindow(QString, QString, bool in_HTML = false, bool isModal = true, QWidget *parent = 0, const char *name = 0);
		~TInfoWindow()
		{	if ( atxt ) SaveConfig();
			DESTROY(OK_Button); DESTROY(atxt); DESTROY(ahtml); DESTROY(WLayout);
		};

	public slots:
		void SetText(QString aTxt) { atxt->setText(aTxt); };
		void AddText(QString aTxt) { atxt->append(aTxt);  };
		
	private:
		QVBoxLayout		*WLayout;
		QPushButton 	*OK_Button;
		KHTMLView		*ahtml;
		TKMultiEd		*atxt;
		
		void Restore(void);
		void SaveConfig(void);
};

//--<KPV config/options Dialogs>----------------

class TKPVNewWin : public QDialog
{
	Q_OBJECT

	public:
		TKPVNewWin(QString ctx = "", QWidget *parent = NULL, const char *name = NULL);

		~TKPVNewWin()
		{	DESTROY(RadioButton_1);	DESTROY(RadioButton_2);	DESTROY(RadioButton_3);
			DESTROY(RadioButton_4);	DESTROY(RadioButton_5);	DESTROY(RadioButton_6);
			DESTROY(RadioButton_7);	DESTROY(RadioButton_8);	DESTROY(PushButton_1) ;
			DESTROY(PushButton_2) ;	DESTROY(ButtonGroup_1); DESTROY(CheckBox_1);
			DESTROY(Label_1);
		};
		
		int GetOptions(void)
		{	int retval = 0;
			if (RadioButton_1->isChecked()) retval = 1;
			if (RadioButton_2->isChecked()) retval = 2;
			if (RadioButton_3->isChecked()) retval = 3;
			if (RadioButton_4->isChecked()) retval = 4;
			if (RadioButton_5->isChecked()) retval = 5;
			if (RadioButton_6->isChecked()) retval = 6;
			if (RadioButton_7->isChecked()) retval = 7;
			if (RadioButton_8->isChecked()) retval = 8;
			if (   CheckBox_1->isChecked()) retval += 10; return retval;
		};
		
	public slots:
		void toggleIMG(int);
		
	private:
		QLabel			*Label_1;
		QCheckBox		*CheckBox_1;
		QButtonGroup  	*ButtonGroup_1;
		QPushButton 	*PushButton_1 , *PushButton_2;
		TDoubleClick_RB	*RadioButton_1, *RadioButton_2, *RadioButton_3, *RadioButton_4,
						*RadioButton_5, *RadioButton_6, *RadioButton_7, *RadioButton_8;
};
		
class TKPVGetInput : public QDialog
{
	Q_OBJECT

	public:
		TKPVGetInput(bool wher = false, QWidget *parent = NULL, const char *name = NULL);

		const char* GetPattern(void) { return Combo_1->currentText(); }
		int GetMode(void) { if (isRegExp) return (int)GetOptions(); else return (int)GetOptions() + 10; };
		
		~TKPVGetInput() 
		{	DESTROY(Label_1);
			DESTROY(RadioButton_1);	DESTROY(RadioButton_2);	DESTROY(ButtonGroup_1);
			DESTROY(CheckBox_1);	DESTROY(CheckBox_2);	DESTROY(Combo_1);
			DESTROY(PushButton_1);	DESTROY(PushButton_2);	DESTROY(GroupBox_1);			
		};
		
	signals:
		void Warn(QString, bool);
	
	public slots:
		void IsPattern(void) { isRegExp = false; CheckBox_1->setText( DLG_DIV28 ); };
		void IsRegExp(void)  { isRegExp = true;  CheckBox_1->setText( DLG_DIV32 ); };
		
		void CheckInput(void)
		{	QString astr(""); astr = Combo_1->currentText();
			if (isRegExp)
			{	QRegExp test_input(astr, CheckBox_2->isChecked(), CheckBox_1->isChecked());
				if (test_input.isValid()) accept(); else Warn(DLG_DIV33, true); 
			} else { if ( GOODStr(astr) ) accept(); else Warn(DLG_DIV33, true); }
		};
		
	private:
		bool			isRegExp;
		QCheckBox		*CheckBox_1, *CheckBox_2;
		QRadioButton	*RadioButton_1, *RadioButton_2;
		QGroupBox		*GroupBox_1;
		QButtonGroup	*ButtonGroup_1;
		QPushButton 	*PushButton_1, *PushButton_2;
		QLabel			*Label_1;
		THistCombo		*Combo_1;

		TOption GetOptions(void)
		{	if ( CheckBox_1->isChecked() && !CheckBox_2->isChecked()) return Option_1;
			if (!CheckBox_1->isChecked() &&  CheckBox_2->isChecked()) return Option_2;
			if ( CheckBox_1->isChecked() &&  CheckBox_2->isChecked()) return Option_3;
			if (!CheckBox_1->isChecked() && !CheckBox_2->isChecked()) return Option_4;
			return Option_4;
		};
};

class TKPVScriptWiz : public QDialog
{
	Q_OBJECT

	public:
		TKPVScriptWiz(QStrList&, QWidget *parent = NULL, const char *name = NULL);

		~TKPVScriptWiz() 
		{	DESTROY(Label_1);		DESTROY(Label_2);		DESTROY(Label_3);
			DESTROY(Label_4);		DESTROY(Label_5);		DESTROY(Label_6);
			DESTROY(Label_7);		DESTROY(Label_8);		DESTROY(Label_9);
			DESTROY(LineEdit_1);	DESTROY(LineEdit_2);	DESTROY(LineEdit_3);
			DESTROY(LineEdit_4);	DESTROY(LineEdit_5);	DESTROY(LineEdit_6);
			DESTROY(PushButton_1);	DESTROY(PushButton_2);	DESTROY(PushButton_3);
			DESTROY(RadioButton_1); DESTROY(RadioButton_2); DESTROY(RadioButton_3);
			DESTROY(CheckBox_1); 	DESTROY(ButtonGroup_1); DESTROY(MultiLineEdit_1);
			DESTROY(Frame_2);		DESTROY(Frame_1);
		};

		TOption GetOptions(void)
		{	TOption retval = Option_1;
			if (RadioButton_1->isChecked()) retval = Option_1;
			if (RadioButton_2->isChecked()) retval = Option_2;
			if (RadioButton_3->isChecked()) { (CheckBox_1->isChecked()) ? retval = Option_3 : retval = Option_4; }
			return retval;
		};

	signals:
		void Beep(void);
		void SetLedOn(void);
		void SetLedOff(void);
		void WaitDone(void);
		void ShowWait(QString);
		void PrintMsg(QString);
		void Warn(QString, bool);
		void Confirm(QString, bool&, bool);
		
	public slots:
		void EmitBeep(void)						{ emit Beep();			 };
		void EmitSetLedOn(void)					{ emit SetLedOn();		 };
		void EmitSetLedOff(void)				{ emit SetLedOff();		 };
		void EmitDone(void)						{ emit WaitDone();		 };
		void EmitWait(QString msg)				{ emit ShowWait(msg);	 };
		void EmitMsg(QString msg)				{ emit PrintMsg(msg);	 };
		void EmitWarn(QString msg, bool bep)	{ emit Warn(msg, bep);	 };
		
		void EmitConfirm(QString msg, bool &ret, bool bep)	{ emit Confirm(msg, ret, bep);};
		
		void ScriptChg(const char*)
		{	QString aux(LineEdit_1->text()); aux += "\n\n";
			aux += LineEdit_2->text(); aux += "usr/sample/directory/"; aux += LineEdit_4->text(); aux += "\n\n";
			aux += LineEdit_3->text(); aux += "usr/sample/directory/archive"; aux += LineEdit_5->text(); aux += "\n";
			MultiLineEdit_1->setText(aux);
		};

		void DoScript(void)
		{	switch (GetOptions())
			{	case Option_1: DoCustomScript();	break;
				case Option_2: DoEraseScript();		break;
				case Option_3: DoMoveScript(true);	break;
				default: DoMoveScript(false);
			}
		};

		void MoveToWhere(void)
		{   QString sel_dir(LineEdit_6->text());
			sel_dir = KDirDialog::getDirectory(sel_dir, this);
			if (!sel_dir.isEmpty()) { RadioButton_3->setChecked(true); LineEdit_6->setText(sel_dir); }
		};

	private:
		QStrList		*the_lst;
		QCheckBox		*CheckBox_1;
		QButtonGroup	*ButtonGroup_1;
		QFrame			*Frame_1, *Frame_2;
		QPushButton 	*PushButton_1, *PushButton_2, *PushButton_3;
		QRadioButton	*RadioButton_1, *RadioButton_2, *RadioButton_3;
		QLabel			*Label_1, *Label_2, *Label_3, *Label_4, *Label_5, *Label_6, *Label_7, *Label_8, *Label_9;
		QLineEdit		*LineEdit_1, *LineEdit_2, *LineEdit_3, *LineEdit_4, *LineEdit_5, *LineEdit_6;
		QMultiLineEdit	*MultiLineEdit_1;

		QString Parse(QString aitm, QString astr)
		{	if (astr.isNull() || astr.isEmpty() || astr.find("%o%") > -1) return "";
			if (astr.find("%i%") > -1) { astr = astr.replace( QRegExp("%i%"), aitm            ); }
			if (astr.find("%p%") > -1) { astr = astr.replace( QRegExp("%p%"), GetParent(aitm) ); }
			if (astr.find("%f%") > -1) { astr = astr.replace( QRegExp("%f%"), GetFName(aitm)  ); }
			if (astr.find("%t%") > -1) { astr = astr.replace( QRegExp("%t%"), "\t"            ); }
			return astr;
		};
		
		QString OmitChk(QString astr, bool isDir)
		{	if (astr.isNull() || astr.isEmpty()) return ""; QString aux(""), aret("");
			if ( isDir ) { aux = LineEdit_2->text(); aret = LineEdit_4->text(); }
			else { aux = LineEdit_3->text(); aret = LineEdit_5->text(); }
			(aux.find("%o%") > -1 || aret.find("%o%") > -1) ? aret = "" : aret = astr;
			return aret;
		};

		QString GetParent(QString astr)
		{	if (astr.isNull() || astr.isEmpty()) return "";
			if (astr == "./" || astr == "/") return "";
			if (IsDirectory(astr)) astr = astr.mid(0, astr.length()-1);
			if (astr.findRev("/") == -1) return "/";
			astr = astr.mid(0, astr.findRev("/"));
			return astr.stripWhiteSpace();
		};

		QString GetFName(QString astr)
		{	if (astr.isNull() || astr.isEmpty()) return "";
			if (astr == "./" || astr == "/") return "";
			if (astr.find("/") == -1) return astr;
			if (IsDirectory(astr)) astr = astr.mid(0, astr.length()-1);
			if (astr.find("/") == -1) return astr.stripWhiteSpace();
			astr = astr.mid(astr.findRev("/")+1, astr.length());
			return astr.stripWhiteSpace();
		};

		void DoCustomScript(void)
		{	PrintMsg(DLG_DIV40); SetLedOn(); int counter = 0;
			QString acum(LineEdit_1->text()), aux(the_lst->first()), abuf(""); acum += "\n\n";
			while ( !aux.isNull() )
			{	if ( IsDirectory(aux) ) { if (aux != "./") abuf = Parse(aux, LineEdit_2->text()) + OmitChk(aux, true) + Parse(aux, LineEdit_4->text()); }
				else { abuf = Parse(aux, LineEdit_3->text()) + OmitChk(aux, false) + Parse(aux, LineEdit_5->text()); }
				if (GOODStr(abuf)) { acum += abuf + "\n"; counter++; } aux = the_lst->next();
			} QClipboard *coptoclip = QApplication::clipboard(); coptoclip->setText(acum);
			SetLedOff(); acum = DLG_DIV40 + acum.setNum(counter) + DLG_DIV17; PrintMsg(acum); Beep();
		};

		void DoEraseScript(void)
		{	PrintMsg(DLG_DIV40); SetLedOn(); int counter = 0;
			QString acum(LineEdit_1->text()), aux(the_lst->first()), abuf(""); acum += "\n\n";
			while ( !aux.isNull() )
			{	if ( IsDirectory(aux) ) { abuf = ""; } else { abuf =  "rm -f /" + aux; }
				if (GOODStr(abuf)) { acum += abuf + "\n"; counter++; } aux = the_lst->next();
			} QClipboard *coptoclip = QApplication::clipboard(); coptoclip->setText(acum);
			SetLedOff(); acum = DLG_DIV40 + acum.setNum(counter) + DLG_DIV17; PrintMsg(acum); Beep();
		};

		void DoMoveScript(bool dolinks)
		{	PrintMsg(DLG_DIV40); SetLedOn(); int counter = 0;
			QString acum(LineEdit_1->text()), aux(the_lst->first()), abuf(""); acum += "\n\n";
			QString BaseDir(LineEdit_6->text()); if (BaseDir.isEmpty()) { Warn("Please enter a valid target to move to...", true); return; } ForceDir(BaseDir);
			while ( !aux.isNull() )
			{	if ( IsDirectory(aux) ) { if (aux != "./") abuf = "mkdir " + BaseDir + aux; }
				else { abuf =  "mv /" + aux + "\t" + BaseDir + aux; }
				if (GOODStr(abuf)) { acum += abuf + "\n"; counter++; } aux = the_lst->next();
			}
			if (dolinks)
			{	aux = the_lst->first(); abuf = ""; acum += "\n\n";
				while ( !aux.isNull() )
				{	if ( IsDirectory(aux) ) { abuf = ""; }
					else { abuf =  "ln -sv " + BaseDir + aux + "\t/" + aux; } 
					if (GOODStr(abuf)) { acum += abuf + "\n"; counter++; } aux = the_lst->next();
			}} QClipboard *coptoclip = QApplication::clipboard(); coptoclip->setText(acum);
			SetLedOff(); acum = DLG_DIV40 + acum.setNum(counter) + DLG_DIV17; PrintMsg(acum); Beep();
		};
};

//--<Debian Specific Dialogs>-------------------

class TKPVExtractDeb : public QDialog
{
	Q_OBJECT

	public:
		TKPVExtractDeb(QWidget *parent = NULL, const char *name = NULL);
		TOption GetOptions(void)
		{	if (RadioButton_1->isChecked()) return Option_1;
			if (RadioButton_2->isChecked()) return Option_2;
			if (RadioButton_3->isChecked()) return Option_3;
			if (RadioButton_4->isChecked()) return Option_4;
			return Option_1;
		};
		
		~TKPVExtractDeb()
		{	DESTROY(OK_Button);		DESTROY(Cancel_Button);	DESTROY(Label_1);
			DESTROY(RadioButton_1);	DESTROY(RadioButton_2);
			DESTROY(RadioButton_3);	DESTROY(RadioButton_4);	DESTROY(GroupBox_1);
		};
		
	private:
		QButtonGroup	*GroupBox_1;
		QLabel 			*Label_1;
		QPushButton 	*OK_Button, *Cancel_Button;
		TDoubleClick_RB	*RadioButton_1, *RadioButton_2, *RadioButton_3, *RadioButton_4;
};

//--<MultiPack Dialogs>-------------------------

class TKPVChoPakMod : public QDialog
{
	Q_OBJECT

	public:
		TOption GetOptions(void)
		{	if (RadioButton_1->isChecked()) return Option_1;
			if (RadioButton_2->isChecked()) return Option_2;
			if (RadioButton_3->isChecked()) return Option_3;
			return Option_1;
		};
		
		bool AutoLoadDir(void) { return (CheckBox_1->isChecked() && !RadioButton_3->isChecked()); }

		TKPVChoPakMod(TPack pck = tslack, bool virt_slak = false, QWidget *parent = NULL, const char *name = NULL);

		~TKPVChoPakMod()
		{	DESTROY(Label_1);		DESTROY(CheckBox_1);
			DESTROY(RadioButton_1);	DESTROY(RadioButton_2);	DESTROY(RadioButton_3);
			DESTROY(OK_Button);		DESTROY(Cancel_Button);	DESTROY(GroupBox_1);
		};
		
	public slots:
		void toggleIMG(int);

	private:
		TPack			tpck;
		QLabel 			*Label_1;
		QButtonGroup	*GroupBox_1;
		QCheckBox		*CheckBox_1;
		QPushButton		*OK_Button,  *Cancel_Button;
		TDoubleClick_RB *RadioButton_1, *RadioButton_2, *RadioButton_3;
};

class TKPVRemovePAK : public QDialog
{
	Q_OBJECT

	public:
		TKPVRemovePAK(bool is_RPM = true, QWidget *parent = NULL, const char *name = NULL);
		QString GetOptions(void)
		{	QString aux(""); 
			if (isRPM)
			{	aux = PAK_RPM_RMV;
				if (CheckBox_1->isChecked()) aux += " -vv ";
				if (CheckBox_2->isChecked()) aux += " --test ";
				if (CheckBox_3->isChecked()) aux += " --noscripts ";
				if (CheckBox_4->isChecked()) aux += " --nodeps ";
			}
			else
			{	aux = PAK_DEB_RMV;
				if (CheckBox_1->isChecked()) aux += " -vv ";
				if (CheckBox_2->isChecked()) aux += " --no-act ";
				if (CheckBox_3->isChecked()) aux += " --noforce ";
				if (CheckBox_4->isChecked()) aux += "  ";
			}
			return aux;
		};
		
		~TKPVRemovePAK()
		{	DESTROY(OK_Button);		DESTROY(Cancel_Button);	DESTROY(Label_1);
			DESTROY(CheckBox_1);	DESTROY(CheckBox_2);	DESTROY(CheckBox_3);
			DESTROY(CheckBox_4);	DESTROY(GroupBox_1);
		};
		
	private:
		bool isRPM;
		QGroupBox		*GroupBox_1;
		QLabel 			*Label_1;
		QPushButton 	*OK_Button, *Cancel_Button;
		QCheckBox		*CheckBox_1, *CheckBox_2, *CheckBox_3, *CheckBox_4;
};

class TKPVExtract : public QDialog
{
	Q_OBJECT

	public:
		TKPVExtract(QString, bool wAlien = false, QStrList *the_list = NULL, int wSel = 0, QWidget *parent = NULL, const char *name = NULL);
		const char *GetPath(void) { return Combo_1->currentText(); }
		QString GetOptions(void)
		{	QString aux("");
			if (isAlien)
			{	if (RadioButton_4->isChecked()) aux = PAK_ALN_G;
				if (RadioButton_3->isChecked()) aux = PAK_ALN_T;
				if (RadioButton_2->isChecked()) aux = PAK_ALN_R;
				if (RadioButton_1->isChecked()) aux = PAK_ALN_D;
			}
			else
			{	CheckBox_2->isChecked() ? aux = PAK_RPM_U : aux = PAK_RPM_I;
				if (CheckBox_1->isChecked()) aux += "vh";
				if (CheckBox_3->isChecked()) aux += " --force";
				if (CheckBox_4->isChecked()) aux += " --nodeps";
			} 
			aux += " "; return aux;
		};
		
		~TKPVExtract()
		{	DESTROY(OK_Button);		DESTROY(Cancel_Button);	DESTROY(Browse_Button);
			DESTROY(Combo_1);		DESTROY(Combo_2);		DESTROY(Label_1);
			DESTROY(Label_3);		DESTROY(CheckBox_1);	DESTROY(CheckBox_2);
			DESTROY(CheckBox_3);	DESTROY(CheckBox_4);	DESTROY(RadioButton_1);
			DESTROY(RadioButton_2);	DESTROY(RadioButton_3);	DESTROY(RadioButton_4);
			DESTROY(RadioButton_5);	DESTROY(RadioButton_6);	DESTROY(GroupBox_2);
			DESTROY(GroupBox_1);
		};
		
	public slots:
		void ChooseDir(void)
		{   QString sel_dir(Combo_1->currentText());
			sel_dir = KDirDialog::getDirectory(sel_dir, this);
			if (!sel_dir.isEmpty()) { Combo_1->AddToHistory(sel_dir); }
		};
		
		void SelectAll(void)
		{	QString amsg(""); amsg = DLG_DIV13 + pak;
			Label_1->setText( amsg ); RadioButton_5->setChecked(true); Combo_2->setEnabled(false);
		};

		void SelectSom(void)
		{	QString amsg(""); amsg = DLG_DIV14 + amsg.setNum(hasSel) + DLG_DIV15;
			Label_1->setText( amsg ); RadioButton_6->setChecked(true); Combo_2->setEnabled(true);
		};
		
	private:
		QButtonGroup	*GroupBox_1;
		QGroupBox		*GroupBox_2;
		QLabel 			*Label_1, *Label_3;
		QRadioButton	*RadioButton_5, *RadioButton_6;
		QPushButton 	*Browse_Button, *OK_Button, *Cancel_Button;
		QCheckBox		*CheckBox_1, *CheckBox_2, *CheckBox_3, *CheckBox_4;
		KCombo			*Combo_2;
		TDoubleClick_RB	*RadioButton_1, *RadioButton_2, *RadioButton_3, *RadioButton_4;
		THistCombo		*Combo_1;
		
		QString pak, ext; bool isAlien; int hasSel;
		void BuildRPM(void);
		void BuildDeb(void);
		void BuildAlien(void);
		void BuildGeneric(QString, QStrList*);
};

//--<Main KPV Objects>--------------------------

class TKTreeView : public KTreeView
{
	Q_OBJECT
	
	public:
		TKTreeView(QWidget *parent = 0, const char *name = 0) 
		:KTreeView(parent,name)
		{
			setSmoothScrolling(true);
			popmnu = new QPopupMenu(); QPixmap mnuico;
			ILoad(mnuico, "/xtrak.xpm"		); popmnu->insertItem(mnuico, MNU_POP1 , parent, SLOT(ExtractTo())		);
			ILoad(mnuico, "/cvrt.xpm"		); popmnu->insertItem(mnuico, MNU_POP2 , parent, SLOT(ConvertPack())	);
			ILoad(mnuico, "/lupa.xpm"		); popmnu->insertItem(mnuico, MNU_POP11,   this, SLOT(Search())			);
			popmnu->insertSeparator();
			ILoad(mnuico, "/rpmlogo.xpm"	); popmnu->insertItem(mnuico, MNU_POP3 , parent, SLOT(ShowRPMGroups())	);
			ILoad(mnuico, "/debian_logo.xpm"); popmnu->insertItem(mnuico, MNU_POP4 , parent, SLOT(ShowDEBGroups())	);
			ILoad(mnuico, "/slack.xpm"		); popmnu->insertItem(mnuico, MNU_POP10, parent, SLOT(ShowSLAGroups())	);
			
			drophere = new KDNDDropZone(this, DndText);
 			connect(drophere, SIGNAL(dropAction(KDNDDropZone*)), parent, SLOT(Dropped(KDNDDropZone*)));

			connect(this, SIGNAL(  PrintMsg(QString)   ), parent, SLOT(  PrintMsg(QString)   ));
			connect(this, SIGNAL( Warn(QString, bool)  ), parent, SLOT( Warn(QString, bool)  ));
			connect(this, SIGNAL( ShowWait(QString)    ), parent, SLOT( ShowWait(QString)    ));
			connect(this, SIGNAL(    WaitDone()        ), parent, SLOT(     WaitDone()       ));
			connect(this, SIGNAL(       Beep()         ), parent, SLOT(       Beep()         ));
			connect(this, SIGNAL(     SetLedOn()       ), parent, SLOT(      SetLedOn()      ));
			connect(this, SIGNAL(     SetLedOff()      ), parent, SLOT(      SetLedOff()     ));

			connect(this, SIGNAL(Confirm(QString, bool&, bool)), parent, SLOT(Confirm(QString, bool&, bool)));
		};
		
		~TKTreeView() {	DESTROY(popmnu); DESTROY(drophere);	};

		bool Zerd(void) { return (count() == 0); };
		QString CurrLbl(void) { QString aux(""); if (currentItem() >= 0) { TKTreeItem *curritm = getCurrentItem(); if (curritm) aux = curritm->getText(); } if (WEIRDStr(aux)) aux = ""; return aux; };
		
	signals:
		void Beep(void);
		void SetLedOn(void);
		void SetLedOff(void);
		void WaitDone(void);
		void ShowWait(QString);
		void PrintMsg(QString);
		void Warn(QString, bool);
		void Confirm(QString, bool&, bool);
		void SIG_DoubleClicked(void);
		
	public slots:
		void EmitBeep(void)						{ emit Beep();			 };
		void EmitSetLedOn(void)					{ emit SetLedOn();		 };
		void EmitSetLedOff(void)				{ emit SetLedOff();		 };
		void EmitDone(void)						{ emit WaitDone();		 };
		void EmitWait(QString msg)				{ emit ShowWait(msg);	 };
		void EmitMsg(QString msg)				{ emit PrintMsg(msg);	 };
		void EmitWarn(QString msg, bool bep)	{ emit Warn(msg, bep);	 };

		void EmitConfirm(QString msg, bool &ret, bool bep)	{ emit Confirm(msg, ret, bep);};
		
		void Search(QString criteria, int Mode) { SetSelection(criteria, Mode); };

		void Search(void)
		{	setFocus(); TKPVGetInput *dlg = new TKPVGetInput(false, this); int retval = dlg->exec();
			if (retval == QDialog::Accepted) { SetSelection(dlg->GetPattern(), dlg->GetMode()); }
			DESTROY(dlg);
		};
		
		void NiceTree(void)
		{	setFocus(); WORKING;
			SetLedOn(); blockSignals(false); WORKING;
			DoNiceTree(false); DoNiceTree(true);
			SetLedOff(); PrintMsg(""); setFocus();
		};

		void FullTree(void) { DoNiceTree(false); };

	protected:
		void mousePressEvent( QMouseEvent *e ) 
		{	if (count() == 0 || isBusy) return;
			else if ( e->button() == RightButton ) popmnu->popup(QCursor::pos());
			else KTreeView::mousePressEvent(e);
		};

		void mouseDoubleClickEvent( QMouseEvent *e ) 
		{ 	KTreeView::mouseDoubleClickEvent(e);
			if (count() == 0 || isBusy) return;
			emit SIG_DoubleClicked();
		};

		void keyPressEvent( QKeyEvent *e )
		{	KTreeView::keyPressEvent(e);
			if (currentItem() == -1 || isBusy) return;
			TKTreeItem *curritm = getCurrentItem();
			QScrollBar *vsb = (QScrollBar*)verticalScrollBar();
			switch ( e->key() )
			{	case Key_Home: 
					setCurrentItem(0);
					vsb->setValue(vsb->minValue());
					break;
				case Key_End : 
					setCurrentItem(visibleCount()-1);
					if (testTableFlags(Tbl_vScrollBar)) vsb->setValue(vsb->maxValue());
					break;
				case Key_Left: 
					if (!curritm->hasParent()) return;
					if (!curritm->hasChild()) curritm = curritm->getParent();
					else { if (!curritm->isExpanded()) curritm = curritm->getParent(); }
					setCurrentItem(current);
					collapseItem(current, false);
					break;
				case Key_Right:
					if (!curritm->hasChild()) return;
					expandItem(current, false);
					setCurrentItem(current+1);
					break;
				case Key_Insert:
					PrintMsg(DLG_DIV41);
					SetLedOn(); blockSignals(false);
					WORKING; DoNiceTree(false);
					SetLedOff(); PrintMsg(MSG_DIV1); setFocus();
					break;
				case Key_Delete:
					PrintMsg(DLG_DIV41);
					SetLedOn(); blockSignals(false);
					WORKING; DoNiceTree(true);
					SetLedOff(); PrintMsg(MSG_DIV1); setFocus();
					break;
			}
		};

		virtual void SetSelection(QString criteria, int Mode)
		{	if (Zerd()) return;
			QString amsg(""); amsg = MSG_DIV27 + criteria + " -> ";
			TKTreeItem *curritm; setAutoUpdate(false);
			int fromitm = currentItem()+1, toitm = count()-1, idxlok = fromitm-1;
			bool bf_found = false, bf_fromroot = (currentItem() == 0);
			SetLedOn(); blockSignals(false);
ocagn:		do
			{	idxlok++; setCurrentItem(idxlok);
				curritm = getCurrentItem();	if ( curritm )
				{	if (!curritm->isExpanded()) expandItem(idxlok, false);
					PrintMsg(amsg + curritm->getText());
					bf_found = MatchCriteria( criteria, Mode, curritm->getText() ); }
			} while ( curritm && !bf_found && idxlok < toitm );
			if (!bf_found)
			{	if (bf_fromroot) { SetLedOff(); setCurrentItem(0); Warn(MSG_WARN7 + criteria, true); }
				else { bf_fromroot = true; toitm = fromitm; idxlok = -1; goto ocagn; }
			} else { SetLedOff(); Beep(); PrintMsg(MSG_DIV28 + amsg.setNum(idxlok)); }
			scrollVisible(getCurrentItem(), false); setAutoUpdate(true); repaint();
		};

	private:
		QPopupMenu  	*popmnu;
		KDNDDropZone	*drophere;
		
		bool MatchCriteria(QString criteria, int Mode, QString strCompared)
		{	if (Mode > 3)
			{	bool bf_Whole = (Mode == 10 || Mode == 12), bf_Case = (Mode == 11 || Mode == 12);
				if (bf_Whole) return ( strCompared == criteria );
				return ( strCompared.find(criteria, 0, bf_Case) > -1 );
			}
			QRegExp criter(criteria, (Mode == 1 || Mode == 2), (Mode == 0 || Mode == 2));
			return (criter.match(strCompared) > -1);			
		};

		void DoNiceTree(bool colaps)
		{	if (Zerd()) return;	if (currentItem() == -1) return;
			QScrollBar *vsb = (QScrollBar*)verticalScrollBar();
			setCurrentItem(0); vsb->setValue(vsb->minValue()); WORKING;
			setAutoUpdate(false); (colaps) ? setExpandLevel(1) : setExpandLevel(10);
			setCurrentItem(0); vsb->setValue(vsb->minValue()); WORKING;
			setAutoUpdate(true); repaint(); WORKING;
		};
};

class TKListView : public QListView
{
	Q_OBJECT
	
	public:
		TKListView(QWidget *parent = 0, const char *name = 0) 
		:QListView(parent, name)
		{
			setMultiSelection(true); setAllColumnsShowFocus(true);

			popmnu = new QPopupMenu();		
			
			drophere = new KDNDDropZone(this, DndText);
 			connect(drophere, SIGNAL(dropAction(KDNDDropZone*)), parent, SLOT(Dropped(KDNDDropZone*)));

			connect(this, SIGNAL(  PrintMsg(QString)   ), parent, SLOT(  PrintMsg(QString)   ));
			connect(this, SIGNAL( Warn(QString, bool)  ), parent, SLOT( Warn(QString, bool)  ));
			connect(this, SIGNAL( ShowWait(QString)    ), parent, SLOT( ShowWait(QString)    ));
			connect(this, SIGNAL(    WaitDone()        ), parent, SLOT(     WaitDone()       ));
			connect(this, SIGNAL(       Beep()         ), parent, SLOT(       Beep()         ));
			connect(this, SIGNAL(     SetLedOn()       ), parent, SLOT(      SetLedOn()      ));
			connect(this, SIGNAL(     SetLedOff()      ), parent, SLOT(      SetLedOff()     ));
			connect(this, SIGNAL(Confirm(QString, bool&, bool)), parent, SLOT(Confirm(QString, bool&, bool)));
		};
		
		~TKListView() {	DESTROY(popmnu); DESTROY(drophere); };

		bool Zerd(void) { return (firstChild() == 0); };
		void Activate(void) { setUpdatesEnabled(true); repaint(); };
		
		void GetSelection(QStrList *alist)
		{	alist->setAutoDelete(true); alist->clear(); if (Zerd()) return;
			QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (isSelected(curritm)) alist->inSort(GetASelection(curritm));
				curritm = curritm->itemBelow();
			}
		};	

		virtual void Reset(int colDef = 50) { setFocus(); UnSelect(); clear(); setColumnWidth(0, colDef); setUpdatesEnabled(false); };

		virtual int GetNumSelection(void)
		{	if (Zerd()) return 0; int counter = 0; QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (isSelected(curritm)) counter++;
				curritm = curritm->itemBelow();
			} return counter;
		};
		
		virtual void Insert(QPixmap &apix, QString s1)
		{	if (s1.find("FILE LIST:", 0, false) > -1) return;
			QListViewItem *qitm = new QListViewItem(this, s1.stripWhiteSpace());
			qitm->setPixmap(0, apix);
		};
		
	signals:
		void Beep(void);
		void SetLedOn(void);
		void SetLedOff(void);
		void WaitDone(void);
		void ShowWait(QString);
		void PrintMsg(QString);
		void Warn(QString, bool);
		void Confirm(QString, bool&, bool);
		
	public slots:
		void EmitBeep(void)						{ emit Beep();			 };
		void EmitSetLedOn(void)					{ emit SetLedOn();		 };
		void EmitSetLedOff(void)				{ emit SetLedOff();		 };
		void EmitDone(void)						{ emit WaitDone();		 };
		void EmitWait(QString msg)				{ emit ShowWait(msg);	 };
		void EmitMsg(QString msg)				{ emit PrintMsg(msg);	 };
		void EmitWarn(QString msg, bool bep)	{ emit Warn(msg, bep);	 };
		void EmitConfirm(QString msg, bool &ret, bool bep)	{ emit Confirm(msg, ret, bep);};
		
		void UnSelect(void)
		{	if (Zerd()) return; QListViewItem *curritm = firstChild();
			while( curritm ) { setSelected(curritm, false); curritm = curritm->itemBelow(); }
		};

		void Search(void) { Search(false); };
		
		void Search(QString criteria, int Mode) { SetSelection(criteria, Mode); };
		
		void Search(bool wher = false)
		{	setFocus(); TKPVGetInput *dlg= new TKPVGetInput(wher, this); int retval = dlg->exec();
			if (retval == QDialog::Accepted) { SetSelection(dlg->GetPattern(), dlg->GetMode()); }
			DESTROY(dlg);
		};
		
		void ComputeChanges(void)
		{ 	if (Zerd()) return;	int counter = 0; QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (isSelected(curritm)) counter++;
				curritm = curritm->itemBelow();
			} QString msg(""); msg = DLG_DIV34 + msg.setNum(counter) + DLG_DIV35;
			PrintMsg(msg);
		};

	protected:
		QPopupMenu *popmnu;

		void mousePressEvent( QMouseEvent *e ) 
		{	if (Zerd() || isBusy) return;
			else if ( e->button() == RightButton) popmnu->popup(QCursor::pos());
			else QListView::mousePressEvent(e);
		};

		void resizeEvent( QResizeEvent *e )
		{	QListView::resizeEvent( e );
			QSize asz = e->size();
			setColumnWidth(0, asz.width());
		};

		void CopToClip(bool isAll = true, const char *asep = "")
		{	if (Zerd()) return; setCurrentItem(firstChild()); int counter = 0;
			QString acum(""); QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (isAll || isSelected(curritm))
				{	counter++; acum += GetASelection(curritm, asep) + "\n";
				} curritm = curritm->itemBelow();
			}
			if (counter > 0) 
			{	QClipboard *coptoclip = QApplication::clipboard(); coptoclip->setText(acum);
				acum = DLG_DIV16 + acum.setNum(counter) + DLG_DIV17; PrintMsg(acum); Beep();
			} else Warn(DLG_DIV36, true);
		};

		void DoSelection(QString criteria, int Mode, int byCol = 0)
		{	if (Zerd()) return; int counter = 0; QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (!MatchCriteria(criteria, Mode, curritm->text(byCol))) setSelected(curritm, false);
				else { counter++; setSelected(curritm, true); if (counter == 1) ensureItemVisible(curritm); }
				curritm = curritm->itemBelow();
			}
			QString msg(""); msg = DLG_DIV34 + msg.setNum(counter) + DLG_DIV35;
			if (counter == 0) Warn(msg, true); else { Beep(); PrintMsg(msg); }
		};

		bool MatchCriteria(QString criteria, int Mode, QString strCompared)
		{	if (Mode > 3)
			{	bool bf_Whole = (Mode == 10 || Mode == 12), bf_Case = (Mode == 11 || Mode == 12);
				if (bf_Whole) return ( criteria == strCompared.stripWhiteSpace());
				return ( strCompared.find(criteria, 0, bf_Case) > -1 );
			}
			QRegExp criter(criteria, (Mode == 1 || Mode == 2), (Mode == 0 || Mode == 2));
			return (criter.match(strCompared) > -1);
		};
		
		virtual void SetSelection(QString criteria, int Mode)
		{
			DoSelection(criteria, Mode);
		};

		virtual QString GetASelection(QListViewItem *aitm, const char *asep = "")
		{	QString aux("");
			if (!Zerd() && aitm != 0) aux = aitm->text(0); return aux + asep;
		};

	private:
		KDNDDropZone *drophere;
};

class TKListBox : public TKListView
{
	Q_OBJECT
	
	public:
		TKListBox(QWidget *parent = 0, const char *name = 0)
		:TKListView(parent, name)
		{
			addColumn("Pack List"); setColumnAlignment(0, AlignLeft); setColumnWidthMode(0, QListView::Maximum);
			setSorting(0, true); whereis = false;
			
			setMultiSelection(false); DEFMenu();

			connect(this, SIGNAL( currentChanged(QListViewItem*) ), parent, SLOT(  ShowPack() ));
			connect(this, SIGNAL(  doubleClicked(QListViewItem*) ), parent, SLOT( ExtractTo() ));
			connect(this, SIGNAL(     SearchFor(QString, int))    , parent, SLOT(      SearchFor(QString, int))    );
			connect(this, SIGNAL( GetPackList(QString, QStrList&)), parent, SLOT( GetPackList(QString, QStrList&)) );
		};
		
		void Select(QString aitm) { SetSelection(aitm, 13); };
		
		QString currPackLabel(void)	{ return GetASelection(currentItem()); };

		virtual int GetNumSelection(void) { if (Zerd()) return 0; return 1; };
		
		QString GetNext(QString aitm)
		{	QListViewItem *i_dx = GetItemIndex(aitm); i_dx = i_dx->nextSibling();
			if ( i_dx ) return i_dx->text(0); else return "";
		};
		
		void SelectItem(QString aitm) { SelectItem(GetItemIndex(aitm)); };
		void SelectItem(QListViewItem *idx) { setFocus(); if ( !idx ) return; setCurrentItem(idx); setSelected(idx, true); ensureItemVisible(idx); }
		
		void setDEFMenu(void) { popmnu->clear(); DEFMenu(); }

		void setMenu(bool bf_DB)
		{	setDEFMenu(); popmnu->insertSeparator(); QPixmap mnuico;
			if (bf_DB) { ILoad(mnuico, "/skull.xpm"	); popmnu->insertItem(mnuico, MNU_POP21, parentWidget(), SLOT(RemovePAK())); }
			// else { ILoad(mnuico, "/check.xpm" ); popmnu->insertItem(mnuico, MNU_POP24, parentWidget(), SLOT(TagInstalled())); }
		};
		
	signals:
		void SearchFor(QString, int);
		void GetPackList(QString, QStrList&);

	public slots:
		void WhereIs(void)			{ whereis = true; Search(whereis); whereis = false; };
		void EnsureVisible(void)	{ if (!Zerd() && currentItem()) ensureItemVisible(currentItem()); };

	protected:		
		virtual void SetSelection(QString criteria, int Mode)
		{	if (Zerd()) return; QListViewItem *curritm, *toitm, *fromitm, *idxlok;
			curritm = currentItem(); if ( curritm == NULL ) curritm = firstChild();
			toitm = curritm; fromitm = curritm->itemBelow(); // fromitm = curritm;
			if ( fromitm == NULL ) fromitm = firstChild(); idxlok = fromitm;
			bool bf_found = false, bf_fromroot = (currentItem() == firstChild());
			SetLedOn(); blockSignals(false);
oncag:		do
			{	if ( idxlok )
				{	if (whereis) bf_found = WhereIsIt(criteria, Mode, idxlok->text(0));
					else bf_found = MatchCriteria(criteria, Mode, idxlok->text(0));
					if (!bf_found) idxlok = idxlok->itemBelow(); } 
			} while ( idxlok && !bf_found && idxlok != toitm );
			if (!bf_found)
			{	if (bf_fromroot) { Warn(MSG_WARN7 + criteria, true); }
				else { bf_fromroot = true; idxlok = firstChild(); goto oncag; }
			}
			else { SetLedOff(); SelectItem(idxlok); if (whereis) SearchFor(criteria, Mode); }
		};

	private:
		bool whereis;
		
		bool WhereIsIt(QString criteria, int Mode, QString pck2chk)
		{	QStrList pack_list; emit GetPackList(pck2chk, pack_list);
			if (pack_list.isEmpty()) return false; QString idxlok(""); idxlok = pack_list.first();
			do
			{	if (!idxlok.isNull() && !idxlok.isEmpty()) { if (MatchCriteria(criteria, Mode, idxlok)) return true; }
				idxlok = pack_list.next();
			} while ( !idxlok.isNull() );
			return false;
		};	

		QListViewItem* GetItemIndex(QString anitem)
		{	if (Zerd()) return NULL;
			QListViewItem *aitm = firstChild(); QString lstitm("");
			if (anitem.findRev("/") > -1) { anitem = anitem.mid(anitem.findRev("/")+1, anitem.length()); anitem = anitem.stripWhiteSpace(); }
			while( aitm )
			{	lstitm = aitm->text(0); lstitm = lstitm.stripWhiteSpace();
				if (anitem == lstitm) return aitm;
				aitm = aitm->nextSibling();
			} return firstChild();
		};
		
		void DEFMenu(void)
		{	QPixmap mnuico;
			ILoad(mnuico, "/xtrak.xpm"		); popmnu->insertItem(mnuico, MNU_POP1 , parentWidget(), SLOT(ExtractTo()			));
			ILoad(mnuico, "/cvrt.xpm"		); popmnu->insertItem(mnuico, MNU_POP2 , parentWidget(), SLOT(ConvertPack()			));
			ILoad(mnuico, "/lupa.xpm"		); popmnu->insertItem(mnuico, MNU_POP11,   		this,    SLOT(Search()				));
			ILoad(mnuico, "/where.xpm"		); popmnu->insertItem(mnuico, MNU_POP18,   		this,    SLOT(WhereIs()				));
			popmnu->insertSeparator();
			ILoad(mnuico, "/rpmlogo.xpm"	); popmnu->insertItem(mnuico, MNU_POP3 , parentWidget(), SLOT(ShowRPMGroups()		));
			ILoad(mnuico, "/debian_logo.xpm"); popmnu->insertItem(mnuico, MNU_POP4 , parentWidget(), SLOT(ShowDEBGroups()		));
			ILoad(mnuico, "/slack.xpm"		); popmnu->insertItem(mnuico, MNU_POP10, parentWidget(), SLOT(ShowSLAGroups()		));
		};
};
	
class TKSimList : public TKListView
{
	Q_OBJECT
	
	public:
		TKSimList(QWidget *parent = 0, const char *name = 0)
		:TKListView(parent, name)
		{
			addColumn("FILE LIST:"); setColumnAlignment(0, AlignLeft); setColumnWidthMode(0, QListView::Maximum);
			setSorting(0, true);

			QPixmap mnuico;
			ILoad(mnuico, "/xtrak.xpm"		); popmnu->insertItem(mnuico, MNU_POP1 , parent, SLOT(ExtractTo()		));
			ILoad(mnuico, "/cvrt.xpm"		); popmnu->insertItem(mnuico, MNU_POP2 , parent, SLOT(ConvertPack()	));
			ILoad(mnuico, "/lupa.xpm"		); popmnu->insertItem(mnuico, MNU_POP11,   this, SLOT(Search()			));
			popmnu->insertSeparator();
			ILoad(mnuico, "/rpmlogo.xpm"	); popmnu->insertItem(mnuico, MNU_POP3 , parent, SLOT(ShowRPMGroups()	));
			ILoad(mnuico, "/debian_logo.xpm"); popmnu->insertItem(mnuico, MNU_POP4 , parent, SLOT(ShowDEBGroups()	));
			ILoad(mnuico, "/slack.xpm"		); popmnu->insertItem(mnuico, MNU_POP10, parent, SLOT(ShowSLAGroups()	));
			popmnu->insertSeparator();		
			ILoad(mnuico, "/bulb.xpm"		); popmnu->insertItem(mnuico, MNU_POP19,   this, SLOT(ScriptWiz()		));
			ILoad(mnuico, "/desel.xpm"		); popmnu->insertItem(mnuico, MNU_POP8 ,   this, SLOT(UnSelect()		));
			ILoad(mnuico, "/copy.xpm"		); popmnu->insertItem(mnuico, MNU_POP9 ,   this, SLOT(CopAllToClip()	));
			ILoad(mnuico, "/some.xpm"		); popmnu->insertItem(mnuico, MNU_POP14,   this, SLOT(CopSelToClip()	));

 			connect(this, SIGNAL(selectionChanged()), this, SLOT(ComputeChanges()));
		};

	public slots:
		void CopAllToClip(void) { CopToClip( true, ""); };
		void CopSelToClip(void) { CopToClip(false, ""); };

		void ScriptWiz(void)		
		{	if (Zerd()) return; setFocus(); QStrList flelst; flelst.setAutoDelete(true);
			int counter = 0; bool isAll = ( GetNumSelection() == 0 );
			setCurrentItem(firstChild()); QListViewItem *curritm = firstChild();
			while( curritm )
			{	if (isAll || isSelected(curritm))
				{	counter++; flelst.append( GetASelection(curritm, "") );
				} curritm = curritm->itemBelow();
			}
			if (counter > 0)
			{	TKPVScriptWiz *dlg = new TKPVScriptWiz(flelst, parentWidget());
				dlg->exec(); DESTROY(dlg);
				flelst.clear(); PrintMsg(MSG_DIV1);
			}
		};
};
	
class TKGrpView : public TKListView
{
	Q_OBJECT
	
	public:
		TKGrpView(QWidget *parent = 0, const char *name = 0)
		:TKListView(parent, name)
		{
			addColumn(LBL_DIV2); setColumnAlignment(0, AlignLeft); setColumnWidthMode(0, QListView::Maximum);
			addColumn(LBL_DIV3); setColumnAlignment(1, AlignLeft); setColumnWidthMode(1, QListView::Maximum);
			addColumn(LBL_DIV4); setColumnAlignment(2, AlignLeft); setColumnWidthMode(2, QListView::Maximum);
			setSorting(0, true);

			QPixmap mnuico;
			ILoad(mnuico, "/desel.xpm"	); popmnu->insertItem(mnuico, MNU_POP8 , this, SLOT(UnSelect()			));
			ILoad(mnuico, "/copy.xpm"	); popmnu->insertItem(mnuico, MNU_POP12, this, SLOT(AllAsTabToClip()	));
			ILoad(mnuico, "/copy.xpm"	); popmnu->insertItem(mnuico, MNU_POP13, this, SLOT(AllAsColonToClip()	));
			ILoad(mnuico, "/some.xpm"	); popmnu->insertItem(mnuico, MNU_POP15, this, SLOT(SelAsTabToClip()	));
			ILoad(mnuico, "/some.xpm"	); popmnu->insertItem(mnuico, MNU_POP16, this, SLOT(SelAsColonToClip()	));

			connect(this, SIGNAL(selectionChanged()), this, SLOT(ComputeChanges()));
		};
		
		virtual void Insert(QPixmap &apix, QString s1, QString s2, QString s3)
		{	if (s1.find("FILE LIST:", 0, false) > -1) return;
			QListViewItem *qitm = new QListViewItem(this, s1, s2, s3);
			qitm->setPixmap(0, apix);
		};
		
		virtual void Reset(int colDef = 50)
		{	setFocus(); UnSelect(); clear();
			setColumnWidth(0, 50); setColumnWidth(1, 50); setColumnWidth(2, colDef);
		 	setUpdatesEnabled(false);
		};
	
	public slots:	
		void AllAsTabToClip(void)   { CopToClip( true, "\t"); };
		void AllAsColonToClip(void) { CopToClip( true,  ";"); };
		void SelAsTabToClip(void)   { CopToClip(false, "\t"); };
		void SelAsColonToClip(void) { CopToClip(false,  ";"); };

	protected:
		void resizeEvent( QResizeEvent *e )
		{	QListView::resizeEvent( e );
			QSize asz = e->size();
			setColumnWidth(2, asz.width());
		};

		virtual QString GetASelection(QListViewItem *aitm, const char *asep = "")
		{	QString aux("");
			if (!Zerd() && aitm != 0)
			{	aux  = aitm->text(0); aux += asep;
			 	aux += aitm->text(1); aux += asep;
				aux += aitm->text(2);
			} return aux;
		};
};
	
class TKFleView : public TKListView
{
	Q_OBJECT
	
	public:
		TKFleView(QWidget *parent = 0, const char *name = 0)
		:TKListView(parent, name)
		{
			addColumn(LBL_DIV5); setColumnAlignment(0, AlignRight);	setColumnWidthMode(0, QListView::Maximum);
			addColumn(LBL_DIV6); setColumnAlignment(1, AlignRight);	setColumnWidthMode(1, QListView::Maximum);
			addColumn(LBL_DIV7); setColumnAlignment(2, AlignRight);	setColumnWidthMode(2, QListView::Maximum);
			addColumn(LBL_DIV8); setColumnAlignment(3, AlignLeft);	setColumnWidthMode(3, QListView::Maximum);
			setSorting(3,true);

			QPixmap mnuico;
			ILoad(mnuico, "/xtrak.xpm"		); popmnu->insertItem(mnuico, MNU_POP1 , parent, SLOT(ExtractTo()			));
			ILoad(mnuico, "/cvrt.xpm"		); popmnu->insertItem(mnuico, MNU_POP2 , parent, SLOT(ConvertPack()			));
			ILoad(mnuico, "/lupa.xpm"		); popmnu->insertItem(mnuico, MNU_POP11,   this, SLOT(Search()				));
			popmnu->insertSeparator();
			ILoad(mnuico, "/rpmlogo.xpm"	); popmnu->insertItem(mnuico, MNU_POP3 , parent, SLOT(ShowRPMGroups()		));
			ILoad(mnuico, "/debian_logo.xpm"); popmnu->insertItem(mnuico, MNU_POP4 , parent, SLOT(ShowDEBGroups()		));
			ILoad(mnuico, "/slack.xpm"		); popmnu->insertItem(mnuico, MNU_POP10, parent, SLOT(ShowSLAGroups()		));
			popmnu->insertSeparator();		
			ILoad(mnuico, "/desel.xpm"		); popmnu->insertItem(mnuico, MNU_POP8 ,   this, SLOT(UnSelect()			));
			ILoad(mnuico, "/copy.xpm"		); popmnu->insertItem(mnuico, MNU_POP12,   this, SLOT(AllAsTabToClip()		));
			ILoad(mnuico, "/copy.xpm"		); popmnu->insertItem(mnuico, MNU_POP13,   this, SLOT(AllAsColonToClip()	));
			ILoad(mnuico, "/some.xpm"		); popmnu->insertItem(mnuico, MNU_POP15,   this, SLOT(SelAsTabToClip()		));
			ILoad(mnuico, "/some.xpm"		); popmnu->insertItem(mnuico, MNU_POP16,   this, SLOT(SelAsColonToClip()	));

			connect(this, SIGNAL(selectionChanged()), this, SLOT(ComputeChanges()));
		};
		
		virtual void Insert(QPixmap &apix, QString s1, QString s2, QString s3, QString s4)
		{	if (s1.find("FILE LIST:", 0, false) > -1) return;
			QListViewItem *qitm = new QListViewItem(this, s1, s2, s3, s4);
			qitm->setPixmap(3, apix);
		};
		
		virtual void Reset(int colDef = 100)
		{	setFocus(); UnSelect(); clear();
			setColumnWidth(0, 70); setColumnWidth(1, 50);
			setColumnWidth(2, 30); setColumnWidth(3, colDef);
		 	setUpdatesEnabled(false);
		};
	
	public slots:	
		void AllAsTabToClip(void)   { CopToClip( true, "\t"); };
		void AllAsColonToClip(void) { CopToClip( true,  ";"); };
		void SelAsTabToClip(void)   { CopToClip(false, "\t"); };
		void SelAsColonToClip(void) { CopToClip(false,  ";"); };

	protected:
		void resizeEvent( QResizeEvent *e )
		{	QListView::resizeEvent( e );
			QSize asz = e->size();
			setColumnWidth(3, asz.width());
		};

		virtual QString GetASelection(QListViewItem *aitm, const char *asep = "")
		{	QString aux("");
			if (!Zerd() && aitm != 0)
			{	aux  = aitm->text(0); aux += asep;
			 	aux += aitm->text(1); aux += asep;
				aux += aitm->text(2); aux += asep;
				aux += aitm->text(3);
			} return aux;
		};

		virtual void SetSelection(QString criteria, int Mode)
		{
			DoSelection(criteria, Mode, 3);
		};
};

class TKPackViewer : public QMainWindow
{
	Q_OBJECT
	
	public:
		static QList<TKPackViewer> windowList;
		TKPackViewer(QString, bool nictre = true, bool inhtml = false, int alt_dir = 2040, int app_style = -1, QWidget *parent = 0, const char *name = 0);
		~TKPackViewer()
		{
			DESTROY(Shell_Viewer);	DESTROY(ProgDlg);	DESTROY(timer);
			DESTROY(lt); 			DESTROY(ls); 		DESTROY(lp); DESTROY(li);
			DESTROY(progbar);		DESTROY(packtree);	DESTROY(packages);
			DESTROY(results);		DESTROY(info);		DESTROY(finfo);
			DESTROY(packview);		DESTROY(grpview);	DESTROY(openSlack);
			DESTROY(openRpm);		DESTROY(openDeb);	DESTROY(openZip);
			DESTROY(openTgz);		DESTROY(openTbz);	DESTROY(openLha);
			DESTROY(openGzp);		DESTROY(openArj);	DESTROY(openRar);
			DESTROY(modeAll);		DESTROY(mountRpm);	DESTROY(mountDeb);
			DESTROY(mountSlack);	DESTROY(lookOut);	DESTROY(Fresh);
			DESTROY(newKpv);		DESTROY(quitapp);	DESTROY(packtools);

			// This may cause exit SEGFAULT in some systems :-( Still don't know why...
			DESTROY(tabbar);		// If it happens, comment it....
			// Hope this helps ;-)

			DESTROY(mnufol);		DESTROY(mnufle);	DESTROY(mnuopt);
			DESTROY(mnuhlp);		DESTROY(packmenu);	DESTROY(lboxes);
			DESTROY(topLayout);
			windowList.removeRef( this );
		};
		
	signals:
		void Ready(void);
		void Logged(void);
		
	public slots:
		// KPV Object
		void Help(void);
		void Quit(void);
		void About(void);
		void MenuMsg(int);
		void NewKPV(void);
		void PrintInfo(void);
		void SetDefStyle(void)	{ SetKPVStyle(-1);					};
		void SetWinStyle(void)	{ SetKPVStyle((int)WindowsStyle);	};
		void SetMtfStyle(void)	{ SetKPVStyle((int)MotifStyle  );	};

		// Error Checking/Feedback/ProgMeter
		void Beep(void);
		void SetLedOn(void);
		void SetLedOff(void);
		void WaitDone(void);
		void ShowWait(QString);
		void DumpMsg(QString);
		void PrintMsg(QString);
		void Warn(QString, bool bep = false);
		void Confirm(QString aqst, bool &ret, bool bep = false);
		void Fatal(QString);

		// Frame object
		void TabSelected(int);
		void ViewOutput(void);
		void ToggleHTML(void);
		void ToggleNice3(void);
		void ToggleMemChk(void);
		void ChangeFolderIcon(int);
		void ReadyAck(void) { DESTROY(oneshot); PrintMsg(MSG_DIV1); }

		void OneShot(void)
		{	oneshot = new QTimer( this );
			if (shotwhat == "SLA") connect( oneshot, SIGNAL(timeout()), this, SLOT( ShowSLAGroups() ));
			if (shotwhat == "RPM") connect( oneshot, SIGNAL(timeout()), this, SLOT( ShowRPMGroups() ));
			if (shotwhat == "DEB") connect( oneshot, SIGNAL(timeout()), this, SLOT( ShowDEBGroups() ));
			oneshot->start( TRIGGER, TRUE );
		};
		
		void EnsureVisible(void)
		{	QTimer::singleShot(3*(TRIGGER>>2), packages, SLOT( EnsureVisible()) );
			if (nice3) { PrintMsg(DLG_DIV41); QTimer::singleShot(TRIGGER, packtree, SLOT(NiceTree())); }
		};
		
		// Pack object
		void ShowPack(void);
		void ExtractTo(void);
		void RemovePAK(void);		
		void ReloadPack(void);
		void ConvertPack(void);
		void RefreshPacks(void);
		void SearchFor(QString, int);
		void GetPackList(QString, QStrList&);

		void MountDEB(void);
		void MountRPM(void);
		void MountSLA(void);
		void ShowDEBGroups(void)	{ ShowGroups(tvdeb ); };
		void ShowRPMGroups(void) 	{ ShowGroups(trpm  ); };
		void ShowSLAGroups(void)	{ ShowGroups(tslack); };

		void GetSLAPack(void)		{ ChoosePack(tslack); };
		void GetDEBPack(void) 		{ ChoosePack(tdeb  ); };
		void GetRPMPack(void) 		{ ChoosePack(trpm  ); };
		void GetZIPPack(void) 		{ ChoosePack(tzip  ); };
		void GetTGZPack(void) 		{ ChoosePack(tgz   ); };
		void GetTBZPack(void) 		{ ChoosePack(tbz2  ); };
		void GetLHAPack(void) 		{ ChoosePack(tlzh  ); };
		void GetGZPPack(void) 		{ ChoosePack(tz    ); };
		void GetARJPack(void) 		{ ChoosePack(tarj  ); };
		void GetRARPack(void) 		{ ChoosePack(trar  ); };
		void GetALLPack(void) 		{ ChoosePack(tall  ); };

		// Process handling
		void ExternEnd(KProcess*);
		void ExternOutput(KProcess*, char*, int);		

		void ProcessOutput(KProcess*, char*, int);
		void DoneProc(KProcess *proc) { DESTROY(proc); };

		void Dropped(KDNDDropZone *whatisthis) { GetParameter(whatisthis->getData()); };

	protected:
		void closeEvent(QCloseEvent*);
		
	private:
		QLabel			*lt, *ls, *lp, *li;
		QBoxLayout  	*topLayout;		
		QGridLayout 	*lboxes;
		QToolBar		*packtools;
		QMenuBar    	*packmenu;
		QProgressBar	*progbar;
		QPopupMenu  	*mnufle, *mnuopt, *mnuhlp, *mnufol;
	 	QTab 			*stab, *ltab, *itab;
		KTabBar			*tabbar;
		KHTMLView		*finfo;
		TKMultiEd		*info;
		TKTreeView		*packtree;
		TKListBox		*packages;
		TKSimList		*results;
		TKGrpView		*grpview;
		TKFleView		*packview;
		TInfoWindow		*Shell_Viewer;

		QToolButton *openSlack, *openRpm , *openDeb , *openZip, *openTgz, 
					*openTbz  , *openLha , *openGzp , *openArj, *openRar,
					*modeAll  , *mountRpm, *mountDeb, *mountSlack,
					*lookOut  , *Fresh   , *quitapp , *newKpv;
		
		// File handling
		char buf[BUFLEN];					 // Buffer to fgets()
		FILE *f, *nf;						 // Deals with intermediate packs
		FILE* FOPEN(QString,QString);		 // File open common entry point
		bool  FTEST(FILE*&,QString,QString); // Same but returns success
		int   FileLines(QString);
		void  FileReset(QString);
		bool  FileExists(QString);		
		bool  EatFleLn(FILE*, int howmuch = 1);
		QString GoodPath(QString apath) { DQuoteStr(apath); return apath; }
		
		// KPV Object
		bool nice3;
		void SetKPVStyle(int);
		void SetKPVConfig(void);
		void OpenNewKPV(QString);
		QString GetKPVContext(void);

		// Param handling
		void DoParam(QString);
		void DoSLAParam(QString);
		void DoRPMParam(QString);
		void DoDEBParam(QString);
		void GetParameter(QString);
		void DoGetParameter(QString, bool);

		// Frame object
		bool inHTML; int ALT_DIR, APP_STYLE;
		void BuildObjects(void);
		void BuildLayout(void);
		void BuildMenu(void);
		void BuildToolBar(void);
		bool InitFrame(void);
		void SetFrameUpdate(bool);
		void SetFrameBlocked(bool);
		void BlockFrame(bool blkit, QString msg = MSG_DIV1);

		// Error Checking/Feedback
		QString shell_out, memdum, MemFree, SwapFree, MemTot, SwapTot;
		char membuf[MEMLEN]; bool exec_ok, bf_dummy;
		bool MemAvail(void);
		bool TrivialErr(void);
		
		// Process handling
		QString xtrak_opt;
		void ProcessExec(QString);
		void ExternExec(QString, bool block = false);
		void SetConvertPath(void);
		void DoExtractTo(QString);
		void DoExtractDeb(QString);
		void DoExtractPack(QString);		
		void ExtractVirtualPak(void);
		
		// Pack object
		bool pack_mode_all; TPack pack_type, prev_type;
		QString	path_to_packs, requested_pack, readable_pack;
		void ClearPack(void);		
		void ChoosePack(TPack);
		bool DoChoosePack(TPack);
		bool ExecChoosePack(TPack, QString, QString);
		void SetPathTo(QString);
		void SetModeTo(TPack,bool);		
		void LogDir(QString);
		void SetPack(void);
		void DoShowPack(void);
		void ReadPack(void);
		TPack GetPackType(QString);
		QString GetPackExt(QString);
		QString GetValidExts(TPack);

		// Item object
		int  idx;							// Tree index controller
		QString curr, prev, cbuf;			// Tree item buffers
		void AddItemToTree(void);
		void DoAddItem(void);
		void FormatItem(QString);
		void EnsureItem(QString&);
		void ScanItemParent(void);
		void GetItemParent(QString&);
		void GetItemFullPath(int, QString&);

		// Pack interface
		int parentpos;
		QStrList dirlog;
		QString lastparent, amsg, whatidid;
		bool isNasty, frmt;
		bool NastyPack(void);
		void Pack_Parse(void);		
		void GetPackInfo(void);
		int  PackSize(QString);
		bool PackLineOK(QString&);
		void PreparePackFile(void);
		void Process_Pack_Entry(QString);
		void PatchNastyPack(int etnm = 0);
		QString GetPackOrigin(QString, QString);		
		void SortPackList(QString afle = FLE_LST);
		void FormatPackInfo(QString afle = FLE_LOG);
		
		// Group handling
		void ShowGroups(TPack);
		void GetGroupInfo(TPack,QString);
		bool InGroupView(void) { return isGrpView(requested_pack); };
		
		// Query status functions
		bool ListBegins(void);
		bool InRoot(QString&);
		int  GetDirIdx(QString);
		bool ParentInBuf(QString);
		bool InItemFolder(QString);
		bool StringAccepted(QString&, bool);
		bool DirExists(QString apat, bool makit = false)
		{	QDir adir(apat);
			if (makit) { if (!adir.exists()) { if (!adir.mkdir(apat)) return false; }}
			return (adir.exists() && adir.setCurrent(apat));
		}
				
		// Slak Specific
		bool bf_SLAdb; // void LogSLA(void) { LogDir(SLA_PAK); };
		bool IsSlack(QString);
		void FormatSLAInfo(void);
		void DoFormatSLAInfo(void);
		void AppendSLAData(void);
			QString GetSlackAlias(QString);
			void GetSlackGroupInfo(QString);
		
		// Debian Specific
		bool bf_DEBdb; void LogDEB(void);
		bool IsDebian(QString);
		void FormatDEBInfo(void);
		void DoFormatDEBInfo(QString, bool);
		void AppendDEBData(QString);
		
		// RPM Specific
		bool bf_RPMdb; void LogRPM(void);
			bool ExistRPMs(void);
			void GetRPMInfo(QString,QString, int acolor = -2);
			void GetRPMGroupInfo(QString);
			void DoRPMGrpInfo(void);
			void SplitRPMGroupInfo(QString,QString&,QString&,QString&,QString&);
			bool UpdateRPMPackList(void);

		// Virtual Slack Specific
		bool bf_virtslak; QString vrt_sla_org;
		bool IsVSlack(QString);
		void MountSLAPacks(void);
		bool ValidSLAFolder(QString&, bool verify = false);
			void GenAllDescs(void);
			void GetVSlackDesc(QString);
			void GetVSlackSize(QString, QString);
			void GetVSlackScript(QString);
			void GetVSlackList(QString);
			void CheckSlakContents(void);

		// Virtual Debian Specific
		bool bf_virtdeb; QString vrt_deb_org;
		bool IsVDEB(QString);
		void MountDEBPacks(void);
		bool ValidDEBFolder(QString&, bool verify = false);
			void VrtDEB2PAK(QString);
			void GetDebGroupInfo(QString);
		
		// Virtual RPM Specific
		bool bf_virtrpm; QString vrt_rpm_org;
		bool IsVRPM(QString);
		void MountRPMPacks(void);
		bool ValidRPMFolder(QString&, bool verify = false);
			void VrtRPM2PAK(QString);
			void GetVRPMGroupInfo(QString);
		
		// ARJ/LHA/RAR... Specific
		void GetRARInfo(void);
		void GetARJInfo(void);
		QString GetLHAInfo(QString, int);
		void GetARJList(QString, QStrList&);
		void GetARJTree(QString, QStrList&);
		void DoGetRARInfo(QString, QStrList&, QStrList&);
						
		// Information View
		QString htmlinfo; bool bf_vsinit;
		void SetView(int);
		int  GetView(void);
		void SetInfoView(void);
		void ResetView(bool force = false);
		int  GetSpacePos(int,QString, bool inRev = false);
		QString PckCnt(void) { QString naux(""); naux = naux.setNum(PackCount); return naux; };
		bool DirMarked(QString);
		QString WithBL(QString&);
		QString GetInfoLen(QString);
		QString GetInfoAtr(QString);
		QString GetInfoStp(QString);
		QString GetInfoItm(QString);
		void SetHTMLView(QString aview)
		{	finfo->begin("", 1, 1);
				finfo->write(aview);
				finfo->parse();
			finfo->end();
		};
		
		// Meter stuff
		int flelns, count;
		TKPVStatus *WaitDlg;
		QProgressDialog *ProgDlg;
		void BuildMeter(void);
		void StartMeter(void);
		bool UpdateMeter(void);
		void StopMeter(void);
		void StartProgBar(int);
		void UpdateProgBar(int);
		void StopProgBar(void);

		// Timer stuff
		QTime *timer; QTimer *oneshot; QString shotwhat;
		void PrintElapsed(void);

		// Icon stuff
		QPixmap hom, fol, doc, zip, hpp, cpp, shl, lib, pel, man, pyt, grf,
				lsm, htm, pdf, snd, awk, inf, tex, txt, mak, exl, fnt, tcl,
				dif, eye, pod, css, jav, pyo, pyc, dbf, sgm, lyx, vid, rtf,
				exe, ini,  m4, deb, rpm, elc, bak, pot, gen, dat, unk, prj,
				pgp, dof, mki, inc, rul, mon,  tk, def, alt, bz2, gzp, rar,
				cad, bas, frm, hlp, aut, dte, act, bin, pmd, pal, liba, am,
				lnk, lsp, gmp, scm, inn,  xs, cgi, sty, ldf, ptt, news, palet, chk,
				alt_blu, alt_cya, alt_yel, alt_red, alt_gre, alt_mag, alt_bf,
				alt_cf , alt_of , alt_rf , alt_gf , alt_mf;

		// Toolbar icons
		QPixmap openSLACK, openRPM, openDEB, openZIP, openTGZ, openTBZ, openRAR,
				openLHA  , openGZP, openARJ, quitAPP, modeALL, lookOUT, mntSLACK,
				mntRPM, KPV, fresh, alien, mntdeb, ledred, ledgreen, NKPV;

		QPixmap fico;
		void LoadIcons(void);
		void SetFolderIcon(int, bool relod = true);
		void LoadIcon(QPixmap&, QString);
		QPixmap GetItemPixmap(QString, int force = 0);
};

//--<Var>--------------------------------------------------------------

KApplication	*KPVApp;
TKPackViewer	*KPackViewer;
int				WinW, WinH, WinX, WinY;
QString 		cfgbuf, user_path;
bool			CHK_MEM;
QStrList		RPMPackList, DEBPackList;

QList<TKPackViewer> TKPackViewer::windowList;

//--<Extern>-----------------------------------------------------------

#include "KPackViewer.moc"

//=====================================================================
//	IMPLEMENTATION
//=====================================================================

//==<Main Function>====================================================

int main(int argc, char **argv)
{
	cerr << WELCOME; KPVApp = new KApplication(argc, argv);

	// Set references before initialize Objects...
	data_path = KPVApp->kde_datadir().data(); data_path += "/KPackViewer";

	// Verify and attempts to create a user specific directory to KPV...
	user_path = KPVApp->localkdedir() + "/share/apps"; user_path += "/KPackViewer";
	QDir test_user_path(user_path); if (!test_user_path.exists()) if (!test_user_path.mkdir(user_path)) user_path = data_path;
	
	// Read configuration
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Window" );
	WinX = conf->readNumEntry( "WinXPos"  ,   1 );
	WinY = conf->readNumEntry( "WinYPos"  ,   1 );
	WinW = conf->readNumEntry( "WinWidth" , 600 );
	WinH = conf->readNumEntry( "WinHeight", 400 );
	conf->setGroup( "Options" );
	CHK_MEM  = conf->readBoolEntry( "CheckMem", false );
	switch (conf->readNumEntry("Style", -1 ))
	{	case (int)WindowsStyle:	KPVApp->setStyle(WindowsStyle);	break;
		case (int)MotifStyle: 	KPVApp->setStyle(MotifStyle);	break;
		default: break;
	}

	// Accepts the first passed parameter as a file or a directory...
	QString param(""); if (argc > 1) param = argv[1];
	KPackViewer = new TKPackViewer(	param,
									conf->readBoolEntry( "NiceTree",  true ),
									conf->readBoolEntry(   "inHTML",  true ),
									conf->readNumEntry(    "AltDir",  2040 ),
									conf->readNumEntry(     "Style",    -1 ),
									0, TITLE);
	
	KPackViewer->windowList.setAutoDelete( false );
	if (!KPVApp->isRestored()) KPackViewer->setGeometry(WinX, WinY, WinW, WinH);
	return KPVApp->exec();
}


//==<Class TKPackViewer>================================================

TKPackViewer::TKPackViewer(QString aparam, bool nictre, bool inhtml, int alt_dir, int app_style, QWidget *parent, const char *name)
:QMainWindow(parent, name)
{
	WaitDlg = 0; Shell_Viewer = 0; dirlog.setAutoDelete(true);
	timer = new QTime(); timer->start(); oneshot = 0; shotwhat = "";
	nice3 = nictre; inHTML = inhtml; ALT_DIR = alt_dir; APP_STYLE = app_style;
	RPMPackList.clear(); DEBPackList.clear();
	
	pack_type = tnone; prev_type = tnone;
	bf_RPMdb = false; bf_SLAdb = false; bf_DEBdb = true;
	isNasty = false; pack_mode_all = false; bf_virtslak = false; bf_virtdeb = false; bf_virtrpm = false;

	path_to_packs = ""; requested_pack = ""; readable_pack = "";
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Virtual_Path" );
	vrt_sla_org = conf->readEntry("SLAK_PATH", ""); vrt_deb_org = conf->readEntry("DEB_PATH" , ""); vrt_rpm_org = conf->readEntry("RPM_PATH", "");
	
	LoadIcons(); setIcon(NKPV);
	BuildObjects(); BuildToolBar(); BuildMenu(); BuildLayout(); BuildMeter();

	if (aparam != "") GetParameter(aparam); 
	setGeometry(WinX, WinY, WinW, WinH); windowList.append( this ); show();
	if (aparam == "") PrintMsg(MSG_DIV1);
}
//---------------------------------------------------------------------
void TKPackViewer::BuildObjects()
{
	lt = new QLabel(this); ls = new QLabel(this); li = new QLabel(this);
			
	lt->setText(" ");
	lt->setMinimumSize( lt->sizeHint() );
	lt->setAlignment(AlignRight);
	lt->setMaximumHeight( 2 * lt->sizeHint().height() );
	lt->setPixmap( ledgreen );

	// Make a divider line to adjust better the layout
	li->setLineWidth(2);
	li->setMinimumSize(li->sizeHint());
	li->setFrameStyle(QFrame::HLine | QFrame::Raised);
	li->setMaximumHeight(7);

	ls->setText(" ");
	ls->setMinimumSize( ls->sizeHint() );
	ls->setMaximumHeight( ls->sizeHint().height() );
	
	lp = new QLabel(this); 
	lp->setText( LBL_DIV1 );
	lp->setAlignment(AlignCenter);
	lp->setLineWidth(2);
	lp->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	lp->setMinimumSize( lp->sizeHint() );
	lp->setMinimumWidth(  2 * lp->sizeHint().width()  );
	lp->setMaximumHeight( 1 * lp->sizeHint().height() );
	lp->setMaximumWidth(  4 * lp->sizeHint().width()  );
	
	progbar = new QProgressBar(this); progbar->hide(); progbar->reset();
	progbar->setMinimumSize( lp->sizeHint() );
	progbar->setMinimumWidth(  2 * lp->sizeHint().width()  );
	progbar->setMaximumHeight( 1 * lp->sizeHint().height() );
	progbar->setMaximumWidth(  4 * lp->sizeHint().width()  );
	
	// Main widgets...
	packages = new TKListBox( this, "packages"); QWhatsThis::add(packages, O_PACK, false);
	packtree = new TKTreeView(this, "packtree"); QWhatsThis::add(packtree, O_TREE, false);
	results  = new TKSimList( this,  "results"); QWhatsThis::add(results , O_LIST, false);
	packview = new TKFleView( this, "packview"); QWhatsThis::add(packview, O_INFO, false);
	grpview  = new TKGrpView( this,  "grpview"); QWhatsThis::add(grpview , O_HTML, false);
	info     = new TKMultiEd( this,     "info"); QWhatsThis::add(info    , O_INFO, false);
	finfo	 = new KHTMLView( this, "htmlview"); QWhatsThis::add(finfo   , O_INFO, false);

 	tabbar = new KTabBar(this, "tabbar"); stab = new QTab; ltab = new QTab; itab = new QTab;
	stab->label = TAB_BAR1; stab->enabled = true;
	ltab->label = TAB_BAR2; ltab->enabled = true;
	itab->label = TAB_BAR3; itab->enabled = true;
	tabbar->addTab(stab); tabbar->addTab(ltab); tabbar->addTab(itab);
	tabbar->setMinimumWidth( tabbar->sizeHint().width() );

	connect(   tabbar, SIGNAL(    selected(int)    ), this, SLOT( TabSelected(int) ));
	connect( packtree, SIGNAL( SIG_DoubleClicked() ), this, SLOT(   ExtractTo()    ));
	connect(     this, SIGNAL(       Ready()       ), this, SLOT( EnsureVisible()  ));
}
//---------------------------------------------------------------------
void TKPackViewer::BuildToolBar()
{
    // Toolbar stuff...
	packtools  = new QToolBar( this, "Package Operations" );	
	openSlack  = new QToolButton(openSLACK, M_SLACK , 0, this, SLOT(GetSLAPack()	), packtools, M_SLACK );
	openDeb    = new QToolButton(openDEB  , M_DEB   , 0, this, SLOT(GetDEBPack()	), packtools, M_DEB   );
	openRpm    = new QToolButton(openRPM  , M_RPM   , 0, this, SLOT(GetRPMPack()	), packtools, M_RPM   );
	packtools->addSeparator();
	openZip    = new QToolButton(openZIP  , M_ZIP   , 0, this, SLOT(GetZIPPack()	), packtools, M_ZIP	);
	openTgz    = new QToolButton(openTGZ  , M_TGZ   , 0, this, SLOT(GetTGZPack()	), packtools, M_TGZ	);
	openTbz    = new QToolButton(openTBZ  , M_TBZ   , 0, this, SLOT(GetTBZPack()	), packtools, M_TBZ	);
	openLha    = new QToolButton(openLHA  , M_LHA   , 0, this, SLOT(GetLHAPack()	), packtools, M_LHA	);
	openGzp    = new QToolButton(openGZP  , M_GZP   , 0, this, SLOT(GetGZPPack()	), packtools, M_GZP	);
	openArj    = new QToolButton(openARJ  , M_ARJ   , 0, this, SLOT(GetARJPack()	), packtools, M_ARJ	);
	openRar    = new QToolButton(openRAR  , M_RAR   , 0, this, SLOT(GetRARPack()	), packtools, M_RAR	);
	modeAll    = new QToolButton(modeALL  , M_ALL   , 0, this, SLOT(GetALLPack()	), packtools, M_ALL	);
	packtools->addSeparator();
	mountSlack = new QToolButton(mntSLACK , M_MNTSLK, 0, this, SLOT(MountSLA()		), packtools, M_MNTSLK );
	mountDeb   = new QToolButton(mntdeb   , M_MNTDEB, 0, this, SLOT(MountDEB()		), packtools, M_MNTDEB );
	mountRpm   = new QToolButton(mntRPM   , M_MNTRPM, 0, this, SLOT(MountRPM() 		), packtools, M_MNTRPM );
	lookOut    = new QToolButton(lookOUT  , M_LOOK  , 0, this, SLOT(ViewOutput()	), packtools, M_LOOK   );
	Fresh      = new QToolButton(fresh    ,"Refresh", 0, this, SLOT(RefreshPacks()	), packtools, "Refresh");
	newKpv     = new QToolButton(NKPV     , M_NKPV  , 0, this, SLOT(NewKPV()		), packtools, M_NKPV   );
	quitapp    = new QToolButton(quitAPP  ,"Quit"   , 0, this, SLOT(Quit()			), packtools, "Quit"   );
	(void)QWhatsThis::whatsThisButton(packtools);	

	// Whatsthis stuff...
	QWhatsThis::add(openSlack , O_SLACK, false);
	QWhatsThis::add(openRpm   , O_RPM  , false);
	QWhatsThis::add(openDeb   , O_DEB  , false);
	QWhatsThis::add(openZip   , O_ZIP  , false);		
	QWhatsThis::add(openTgz   , O_TGZ  , false);		
	QWhatsThis::add(openTbz   , O_TBZ  , false);
	QWhatsThis::add(openLha   , O_LHA  , false);
	QWhatsThis::add(openGzp   , O_GZP  , false);
	QWhatsThis::add(openArj   , O_ARJ  , false);
	QWhatsThis::add(openRar   , O_RAR  , false);
	QWhatsThis::add(modeAll   , O_ALL  , false);
	QWhatsThis::add(mountSlack, O_MOUNT, false);
	QWhatsThis::add(mountRpm  , O_RPMDB, false);
	QWhatsThis::add(mountDeb  , O_DEBDB, false);
	QWhatsThis::add(lookOut   , M_LOOK , false);
	QWhatsThis::add(Fresh     , M_FRESH, false);
	QWhatsThis::add(newKpv    , O_NKPV , false);
	QWhatsThis::add(quitapp   , M_QUIT , false);
}
//---------------------------------------------------------------------
void TKPackViewer::BuildMenu()
{
	// Creates menu...
    packmenu = new QMenuBar(this);
	connect(packmenu, SIGNAL( highlighted(int) ), this, SLOT( MenuMsg(int) ));
	
	// File...
	mnufle = new QPopupMenu;
	mnufle->insertItem(NKPV      , MNU_BAR23, this, SLOT(NewKPV()		), CTRL + Key_N , 116);
	mnufle->insertSeparator();	
	mnufle->insertItem(openSLACK , MNU_BAR1 , this, SLOT(GetSLAPack()	), CTRL + Key_S , 101);
	mnufle->insertItem(openDEB   , MNU_BAR3 , this, SLOT(GetDEBPack()	), CTRL + Key_D , 103);	
	mnufle->insertItem(openRPM   , MNU_BAR2 , this, SLOT(GetRPMPack()	), CTRL + Key_R , 102);
	mnufle->insertSeparator();
	mnufle->insertItem(openZIP   , MNU_BAR4 , this, SLOT(GetZIPPack()	), CTRL + Key_Z , 104);
	mnufle->insertItem(openTGZ   , MNU_BAR5 , this, SLOT(GetTGZPack()	), CTRL + Key_T , 105);
	mnufle->insertItem(openTBZ   , MNU_BAR6 , this, SLOT(GetTBZPack()	), CTRL + Key_B , 106);
	mnufle->insertItem(openLHA   , MNU_BAR7 , this, SLOT(GetLHAPack()	), CTRL + Key_L , 107);
	mnufle->insertItem(openGZP   , MNU_BAR8 , this, SLOT(GetGZPPack()	), CTRL + Key_G , 108);
	mnufle->insertItem(openARJ   , MNU_BAR28, this, SLOT(GetARJPack()	), CTRL + Key_J , 117);
	mnufle->insertItem(openRAR   , MNU_BAR30, this, SLOT(GetRARPack()	), CTRL + Key_H , 118);
	mnufle->insertItem(modeALL   , MNU_BAR9 , this, SLOT(GetALLPack()	), CTRL + Key_A , 109);
	mnufle->insertSeparator();
	mnufle->insertItem(mntSLACK  , MNU_BAR10, this, SLOT(MountSLA()		), CTRL + Key_K , 112);
	mnufle->insertItem(mntdeb    , MNU_BAR12, this, SLOT(MountDEB()		), CTRL + Key_E , 115);
	mnufle->insertItem(mntRPM    , MNU_BAR11, this, SLOT(MountRPM()		), CTRL + Key_I , 113);
	mnufle->insertItem(lookOUT   , MNU_BAR13, this, SLOT(ViewOutput()	), CTRL + Key_V , 110);
	mnufle->insertItem(fresh     , MNU_BAR14, this, SLOT(RefreshPacks()	), CTRL + Key_F , 114);
	mnufle->insertSeparator();
	mnufle->insertItem(quitAPP   , MNU_BAR15, this, SLOT(Quit()			), CTRL + Key_Q , 111);

	// Folder Icons...
	mnufol = new QPopupMenu;
	mnufol->setCheckable(true);
	mnufol->insertItem( fol    , "Flat       ", 2040);
	mnufol->insertItem( alt_bf , "Flat Blue  ", 2048);
	mnufol->insertItem( alt_rf , "Flat Red   ", 2049);
	mnufol->insertItem( alt_gf , "Flat Green ", 2050);
	mnufol->insertItem( alt_of , "Flat Orange", 2051);
	mnufol->insertItem( alt_mf , "Flat Magent", 2052);
	mnufol->insertItem( alt_cf , "Flat Cyan  ", 2053);
	mnufol->insertSeparator();
	mnufol->insertItem( alt    , "3D         ", 2041);
	mnufol->insertItem( alt_blu, "3D Blue    ", 2042);
	mnufol->insertItem( alt_red, "3D Red     ", 2043);
	mnufol->insertItem( alt_gre, "3D Green   ", 2044);
	mnufol->insertItem( alt_yel, "3D Yellow  ", 2045);
	mnufol->insertItem( alt_mag, "3D Magent  ", 2046);
	mnufol->insertItem( alt_cya, "3D Cyan    ", 2047);
	SetFolderIcon(ALT_DIR, false);
	connect( mnufol, SIGNAL( activated(int) ), this, SLOT( ChangeFolderIcon(int) ));
	
	// Options...
	mnuopt = new QPopupMenu; mnuopt->setCheckable(true);
	mnuopt->insertItem( MNU_BAR25 , mnufol , 204);
	mnuopt->insertItem( MNU_BAR29, this, SLOT(ToggleNice3()) , CTRL + Key_3, 207);
	mnuopt->setItemChecked(207, nice3);
	mnuopt->insertItem( MNU_BAR27, this, SLOT(ToggleHTML())  , CTRL + Key_H, 206);
	mnuopt->setItemChecked(206, inHTML);
	mnuopt->insertItem( MNU_BAR24, this, SLOT(ToggleMemChk()), CTRL + Key_C, 203);
	mnuopt->setItemChecked(203, CHK_MEM);
	mnuopt->insertSeparator();
	mnuopt->insertItem( MNU_BAR16, this, SLOT(SetWinStyle()) , CTRL + Key_W, 201);
	mnuopt->insertItem( MNU_BAR17, this, SLOT(SetMtfStyle()) , CTRL + Key_M, 202);
	mnuopt->insertItem( MNU_BAR26, this, SLOT(SetDefStyle()) , CTRL + Key_Y, 205);
	switch (APP_STYLE)
	{	case (int)WindowsStyle:	mnuopt->setItemChecked(201, true);	break;
		case (int)MotifStyle: 	mnuopt->setItemChecked(202, true);	break;
		default: 				mnuopt->setItemChecked(205, true);
	}
	mnuopt->insertSeparator();
	mnuopt->insertItem("Information...", this, SLOT(PrintInfo()), CTRL + Key_1, 209);

    // Help...
	mnuhlp = new QPopupMenu;
	mnuhlp->insertItem( MNU_BAR19,  this, SLOT(Help() ), 0, 302);
	mnuhlp->insertSeparator();
	mnuhlp->insertItem( MNU_BAR18,  this, SLOT(About()), 0, 301);

	packmenu->insertItem( MNU_BAR20, mnufle);
	packmenu->insertItem( MNU_BAR21, mnuopt);
	packmenu->insertItem( MNU_BAR22, mnuhlp);
}
//---------------------------------------------------------------------
void TKPackViewer::BuildLayout()
{
	topLayout = new QVBoxLayout( this, 4 );
	lboxes = new QGridLayout( 5, 2 );
	topLayout->setMenuBar( packmenu );
	topLayout->addLayout( lboxes );
	lboxes->addMultiCellWidget(     lt, 0, 0, 0, 1 );
	lboxes->addMultiCellWidget( tabbar, 1, 1, 0, 0 );
	lboxes->addWidget(  progbar, 1, 1 );
	lboxes->addWidget(       lp, 1, 1 );
	lboxes->addWidget( packtree, 2, 0 );
	lboxes->addWidget(  results, 2, 0 );
	lboxes->addWidget(     info, 2, 0 );
	lboxes->addWidget(    finfo, 2, 0 );
	lboxes->addWidget( packview, 2, 0 );
	lboxes->addWidget(  grpview, 2, 0 );
	lboxes->addWidget( packages, 2, 1 );
	lboxes->addMultiCellWidget(     li, 3, 3, 0, 1 );
	lboxes->addMultiCellWidget(     ls, 4, 4, 0, 1 );
	ResetView(true); SetView(0); 
	cerr << "Initializing HTML widget..."; SetHTMLView(HTML_BLANK); cerr << " done.\n";
	topLayout->activate();
}
//---------------------------------------------------------------------
void TKPackViewer::BuildMeter()
{
    ProgDlg = new QProgressDialog("", DLG_DIV20, 100, this, DLG_DIV21, true);
	ProgDlg->setCaption(MSG_DIV5);
	ProgDlg->setLabelText("");
	ProgDlg->setIcon(NKPV);
	ProgDlg->setProgress(0);
	ProgDlg->reset();
}
//---------------------------------------------------------------------
void TKPackViewer::StartMeter()
{
	count = 0; amsg = MSG_DIV8 + requested_pack; PrintMsg(amsg);
	if (flelns > PAKMIN) { (KPVApp->style() == MotifStyle) ? SPACED(amsg) : RSPACED(amsg);	ProgInit(amsg, flelns); }
	SetLedOn();
}
//---------------------------------------------------------------------
bool TKPackViewer::UpdateMeter()
{
	if (flelns <= PAKMIN) return true;
	
	count++; ProgDlg->setProgress(count);
	if (count == 1 || count == (int)(flelns >> 2) ||  count == (int)(flelns >> 1) || count == (int)((3*flelns) >> 2))
	{	packtree->setAutoUpdate(true);
		packtree->repaint(); Working;
		packtree->setAutoUpdate(false);
	}
	return ( !ProgDlg->wasCancelled() );
}
//---------------------------------------------------------------------
void TKPackViewer::StopMeter()
{
	SetLedOff(); if (flelns > PAKMIN) { ProgDlgDone; }
	packtree->repaint(); Working; count = flelns;
}
//---------------------------------------------------------------------
void TKPackViewer::StartProgBar(int totstps)
{
	lp->hide(); progbar->reset(); progbar->setTotalSteps(totstps); progbar->show();
}
//---------------------------------------------------------------------
void TKPackViewer::UpdateProgBar(int pval)
{
	progbar->setProgress(pval); Working;
}
//---------------------------------------------------------------------
void TKPackViewer::StopProgBar()
{
	progbar->hide(); lp->show();
}
//---------------------------------------------------------------------
void TKPackViewer::ShowWait(QString msg)
{
	if ( WaitDlg ) WaitDlg->WaitMsg(amsg);
	else
	{	WaitDlg = new TKPVStatus(msg);
		WaitDlg->show(); Working; WaitDlg->update(); Working; SetLedOn();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::WaitDone()
{
	SetLedOff(); if ( WaitDlg ) { WaitDlg->hide(); Working; DESTROY(WaitDlg); }
}
//---------------------------------------------------------------------
void TKPackViewer::SetLedOn()
{
	if (isBusy) return; isBusy = true; lt->setPixmap( ledred ); SetFrameBlocked(true);
}
//---------------------------------------------------------------------
void TKPackViewer::SetLedOff()
{
	if (!isBusy) return; isBusy = false; lt->setPixmap(ledgreen); SetFrameBlocked(false);
}
//---------------------------------------------------------------------
void TKPackViewer::BlockFrame(bool blkit, QString msg)
{
	if (blkit) { if ( isBusy ) return; PrintMsg(msg); packages->Reset(lp->width()); SetLedOn(); }
	else { if ( !isBusy ) return; SetLedOff(); packages->Activate(); PrintMsg(msg); }
}
//---------------------------------------------------------------------
void TKPackViewer::SetFrameBlocked(bool blockit)
{
	packages->blockSignals(blockit);
	tabbar->blockSignals(blockit);
	packtree->blockSignals(blockit);
	results->blockSignals(blockit);
	info->blockSignals(blockit);
	packview->blockSignals(blockit);
	finfo->blockSignals(blockit);
	grpview->blockSignals(blockit);
	SetFrameUpdate(!blockit);
	Working;
}
//---------------------------------------------------------------------
void TKPackViewer::SetFrameUpdate(bool enbl)
{
	packtree->setEnabled(enbl);
	packages->setEnabled(enbl);
	tabbar->setEnabled(enbl);
	
	packtree->setAutoUpdate(enbl);
	packages->setUpdatesEnabled(enbl);
	results->setUpdatesEnabled(enbl);
	packview->setUpdatesEnabled(enbl);
	grpview->setUpdatesEnabled(enbl);

	if (enbl) { packages->repaint(); packtree->repaint(); results->repaint(); packview->repaint(); grpview->repaint(); }
}
//---------------------------------------------------------------------
void TKPackViewer::ProcessExec(QString AQry)
{
	exec_ok = true; KShellProcess *proc = new KShellProcess(); (*proc) << AQry;
	connect(proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(ProcessOutput(KProcess*, char*, int)));
	connect(proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(ProcessOutput(KProcess*, char*, int)));
	connect(proc, SIGNAL(processExited(KProcess*)), this, SLOT(DoneProc(KProcess*)));
	proc->start(KProcess::Block, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::ProcessOutput(KProcess*, char *buffer, int buflen)
{
	Working; shell_out = buffer; shell_out = shell_out.mid(0, buflen);
	if (ExecTrap(shell_out))
	{	exec_ok = false; cerr << shell_out << "\n"; shell_out = DLG_DIV44 + shell_out;
		ClearPack(); ViewOutput();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::ViewOutput()
{
	WaitDone(); DESTROY(Shell_Viewer);
	Shell_Viewer= new TInfoWindow(VIEWTIT, shell_out);
	Shell_Viewer->exec(); DESTROY(Shell_Viewer)
}
//---------------------------------------------------------------------
void TKPackViewer::SortPackList(QString afle)
{
	ProcessExec(PAK_SORT + user_path + FLE_LOG + "  " + user_path + afle);
	if (!exec_ok) DumpMsg(MSG_WARN31 + afle);
}
//---------------------------------------------------------------------
void TKPackViewer::NewKPV()
{
	QString aux(GetKPVContext());
	TKPVNewWin *dlg = new TKPVNewWin(aux, this); int retval = dlg->exec();
	int opt = dlg->GetOptions(); DESTROY(dlg); if (retval == QDialog::Rejected) return;
	switch (opt)
	{	case  1: case 11: OpenNewKPV(""); break;
		case  2: OpenNewKPV("SLA:" SLA_PAK); break;
		case 12: OpenNewKPV("SLAGRP:" SLA_PAK); break;
		case  3: OpenNewKPV("SLA:" + user_path + VRT_SLA); break;
		case 13: OpenNewKPV("SLAGRP:" + user_path + VRT_SLA); break;
		case  4: OpenNewKPV("DEB:" DEB_PAK); break;
		case 14: OpenNewKPV("DEBGRP:" DEB_PAK); break;
		case  5: OpenNewKPV("DEB:" + user_path + VRT_DEB); break;
		case 15: OpenNewKPV("DEBGRP:" + user_path + VRT_DEB); break;
		case  6: OpenNewKPV("RPM:"); break;
		case 16: OpenNewKPV("RPMGRP:"); break;
		case  7: OpenNewKPV("RPM:" + user_path + VRT_RPM); break;
		case 17: OpenNewKPV("RPMGRP:" + user_path + VRT_RPM); break;
		case  8: case 18: OpenNewKPV(aux); break;
		default: break;
	}
};
//---------------------------------------------------------------------
void TKPackViewer::OpenNewKPV(QString context)
{
	if ( WEIRDStr(context) ) context = ""; PrintMsg(MSG_DIV30);
	TKPackViewer *newKPV = new TKPackViewer(context, nice3, inHTML, ALT_DIR, APP_STYLE, 0, TITLE);
	connect(newKPV , SIGNAL( Logged() ), this, SLOT( ReadyAck() ));
	oneshot = new QTimer( this );
	connect(oneshot, SIGNAL( timeout()), this, SLOT( ReadyAck() ));
	oneshot->start( TRIGGER , TRUE );
}
//---------------------------------------------------------------------
QString TKPackViewer::GetKPVContext()
{	
	QString def_con(""); if (packages->Zerd()) return def_con; QString lpt(lp->text());
	def_con = packtree->CurrLbl(); if (WEIRDStr(def_con) || def_con == "/") def_con = path_to_packs;
	def_con = def_con.stripWhiteSpace(); if (WEIRDStr(def_con)) def_con = "";

	if (InGroupView())
	{	if (IsDirectory(def_con))
		{	if		(isRPMGrp(requested_pack)) { if (notRPMStatus(lpt)) def_con = "RPMGRP:" + path_to_packs; else def_con = "RPMGRP:"; }
			else if	(isDEBGrp(requested_pack)) { def_con = "DEBGRP:" + path_to_packs; }
			else if	(isSLAGrp(requested_pack)) { def_con = "SLAGRP:" + path_to_packs; }
			def_con += CurrPackLabel;
		}
		else if (isRPMdb)
		{	if (def_con.isEmpty() && isRPMStatus(lpt)) def_con = "RPMGRP:" + CurrPackLabel;
			else def_con = "RPM:" + def_con;
		}
		else def_con = path_to_packs + def_con;
	}
	else
	{	if (notRPMStatus(lpt))
		{	if ( WEIRDStr(path_to_packs) ) return "";
			else def_con = path_to_packs + CurrPackLabel;
		} else { def_con = "RPM:"; def_con += CurrPackLabel; }
	}
	return def_con;
}
//---------------------------------------------------------------------
void TKPackViewer::GetParameter(QString aparam)
{
	cerr << "PARAM: " << aparam << "\n";
	if		(aparam.left(4) == "DEB:" || aparam.left(7) == "DEBGRP:") DoDEBParam(aparam);
	else if	(aparam.left(4) == "RPM:" || aparam.left(7) == "RPMGRP:") DoRPMParam(aparam);
	else if	(aparam.left(4) == "SLA:" || aparam.left(7) == "SLAGRP:") DoSLAParam(aparam);
	else { if (aparam.left(5) == "file:") aparam = aparam.mid(5, aparam.length()); DoParam(aparam); }
}
//---------------------------------------------------------------------
void TKPackViewer::DoParam(QString aparam)
{
	QString aux(""); aux = aparam.copy(); StripFlags(aux);
	QDir d = QDir::root(); bool isDIR = d.cd(aux);
	if (!isDIR) 
	{	GetItemParent(aux);
		if (d.cd(aux)) 
		{ 	if (aux == "/") { OPS(MSG_WARN20, aparam); }
			if (!d.setCurrent(aux)) { OPS(MSG_WARN29, aux); }
			path_to_packs = aux; aux = aparam.copy(); FNAME(aux); 
			QFile afile(aux); if(!afile.exists()) { OPS(MSG_WARN20, aparam); }
			isDIR = false;
		} else { OPS(MSG_WARN20, aparam); }
	} else { ForceDir(aparam); path_to_packs = aux; }
	DoGetParameter(aparam, isDIR);
}
//---------------------------------------------------------------------
void TKPackViewer::DoSLAParam(QString aparam)
{
	QString aux(""); aux = aparam.copy(); StripFlags(aux); aux = aux.stripWhiteSpace();
	bf_dummy = ValidSLAFolder(aux, true); SetModeTo(tslack, aparam.find(SLA_PAK)>-1);
	SetPathTo(aux); bool nictre = nice3; if (nictre) nice3 = false;
	if (aparam.left(7) == "SLAGRP:") { shotwhat = "SLA"; connect( this, SIGNAL( Ready() ), this, SLOT( OneShot() )); }
	SetPack(); nice3 = nictre;
}
//---------------------------------------------------------------------
void TKPackViewer::DoDEBParam(QString aparam)
{
	QString aux(""); aux = aparam.copy(); StripFlags(aux); aux = aux.stripWhiteSpace();
	bf_dummy = ValidDEBFolder(aux, true); SetModeTo(tvdeb, aparam.find(DEB_DIR)>-1||aparam.find(user_path + VRT_TMP)>-1);
	SetPathTo(aux); bool nictre = nice3; if (nictre) nice3 = false;
	if (aparam.left(7) == "DEBGRP:") { shotwhat = "DEB"; connect( this, SIGNAL( Ready() ), this, SLOT( OneShot() )); }
	SetPack(); nice3 = nictre;
}
//---------------------------------------------------------------------
void TKPackViewer::DoRPMParam(QString aparam)
{
	QString aux(""); aux = aparam.copy(); StripFlags(aux); aux = aux.stripWhiteSpace();
	bf_dummy = (aparam.find(user_path + VRT_RPM)>-1); if (bf_dummy) { FNODOT(aux); } requested_pack = aux; 
	if (bf_dummy) { bf_dummy = ValidRPMFolder(aux, true); SetModeTo(tvrpm, false); } else { SetModeTo(trpm, aux.find("/") == -1 ); }
	SetPathTo(aux); bool nictre = nice3; if (nictre) nice3 = false;
	if (aparam.left(7) == "RPMGRP:") { shotwhat = "RPM"; connect( this, SIGNAL( Ready() ), this, SLOT( OneShot() )); }
	if (aux.find("/") == -1) LogRPM(); else { FNAME(requested_pack); SetPathTo(aux); SetPack(); }
	nice3 = nictre;
}
//---------------------------------------------------------------------
void TKPackViewer::DoGetParameter(QString aparam, bool isDIR)
{
	TPack packis; requested_pack = aparam;
	(isDIR) ? packis = tall : packis = GetPackType(requested_pack);
	switch (packis)
	{	case tslack: if (!IsSlack(requested_pack) ) { OPS(MSG_WARN19, requested_pack); }
					 SetModeTo(tslack, path_to_packs == SLA_PAK);
					 break;
		case tvdeb : if (!IsDebian(requested_pack)) { OPS(MSG_WARN19, requested_pack); }
					 SetModeTo(tvdeb, path_to_packs == user_path + VRT_TMP);
					 break;
		case tvrpm : if (!IsVRPM(requested_pack)  ) { OPS(MSG_WARN19, requested_pack); }
					 SetModeTo(tvrpm, path_to_packs == user_path + VRT_RPM);
					 break;
		default: SetModeTo(tall, false);
	}
	if (isDIR) { amsg = MSG_DIV6 + requested_pack + "..."; ShowWait(amsg); Working; }
	SetPathTo(aparam); Working; if (isDIR) { WaitDone(); Working; } SetPack(); Working;
}
//---------------------------------------------------------------------
bool TKPackViewer::DoChoosePack(TPack apack_type)
{	
	QString org("");
	if (apack_type == tslack || apack_type == tdeb || apack_type == trpm)
	{	bool a_mod = false; switch (apack_type) { case tslack: a_mod = bf_virtslak; break; case tdeb : a_mod = !bf_DEBdb; break; case trpm : a_mod = !bf_RPMdb; break; default: break; }
		TKPVChoPakMod *chomod = new TKPVChoPakMod(apack_type, a_mod);
		int retval = chomod->exec(); TOption option = chomod->GetOptions(); bool autoload = chomod->AutoLoadDir();
		DESTROY(chomod); if (retval == QDialog::Rejected) { PrintMsg(MSG_DIV1); return false; }
		switch (apack_type)
		{	case tslack:
				switch (option)
				{	case Option_1: SetModeTo(tslack, true ); org = SLA_PAK; break;
					case Option_2: SetModeTo(tslack, false); org = user_path + VRT_SLA; break;
					default: return ExecChoosePack(apack_type, org, "*");
				} break;
			case tdeb:
				switch (option)
				{	case Option_1: SetModeTo(tvdeb, true ); org = DEB_PAK; break;
					case Option_2: SetModeTo(tvdeb, false); org = user_path + VRT_DEB; break;
					default: return ExecChoosePack(apack_type,org, "*.deb");
				} break;
			case trpm:
				switch (option)
				{	case Option_1: LogRPM(); return false;
					case Option_2: SetModeTo(tvrpm, false); org = user_path + VRT_RPM; break;
					default: return ExecChoosePack(apack_type,org, "*.rpm");
				} break;
			default: return false;
		}
		if (autoload)
		{	requested_pack = org; if (pack_type == tslack) ForceDir(requested_pack);
			packtree->setFocus(); packages->UnSelect(); return true;
		}
	}
	return ExecChoosePack(apack_type, org, GetValidExts(apack_type));
}
//---------------------------------------------------------------------
bool TKPackViewer::ExecChoosePack(TPack apack_type, QString org, QString flepat)
{
	PrintMsg(MSG_DIV2); requested_pack = KFileDialog::getOpenFileName(org, flepat, this);
	if (requested_pack.isEmpty()) { PrintMsg(MSG_DIV1); return false; }
	SetModeTo(apack_type, false); return true;
}
//---------------------------------------------------------------------
void TKPackViewer::ChoosePack(TPack apack_type)
{
	if (DoChoosePack(apack_type)) { SetPathTo(requested_pack); SetPack(); }
}
//---------------------------------------------------------------------
void TKPackViewer::SetModeTo(TPack apack_type, bool dbflag)
{
	(pack_mode_all) ? prev_type = tall : prev_type = pack_type;
	pack_type = apack_type;	pack_mode_all = (apack_type == tall);
	bf_SLAdb = (apack_type == tslack && dbflag);
	bf_RPMdb = (apack_type == trpm   && dbflag);
	bf_DEBdb = (apack_type == tvdeb  && dbflag);
	switch(pack_type)
	{	case trpm  : packages->setMenu(bf_RPMdb); break;
		case tvdeb : packages->setMenu(bf_DEBdb); break;
		default:     packages->setDEFMenu();
	} 
}
//---------------------------------------------------------------------
void TKPackViewer::SetPathTo(QString apath)
{
	readable_pack = apath; if (!IsDirectory(apath)) GetItemParent(apath);
	if (path_to_packs != apath || prev_type != pack_type || packages->Zerd())
	{	if (!DirExists(apath)) { WARN(MSG_WARN23 + apath); }
		else if (apath == DEB_DIR) { path_to_packs = user_path + VRT_TMP; LogDEB(); }
		else { path_to_packs = apath; LogDir(apath); } TIP_ID(apath);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::LogDir(QString adir)
{
	DIR *dir; dir = opendir(adir); if (dir == NULL) { WARN(MSG_WARN23 + adir); } 
	struct dirent *dirent; TPack ptype = tnone; QPixmap apix = gzp; QFile fsz; int count = 0;
	packages->clear(); TTip(DLG_DIV41); QDir::setCurrent(adir); BlockFrame(true, MSG_DIV21);
	do 
	{	dirent = readdir(dir);
		if (dirent != NULL && strcmp(dirent->d_name,".") != 0 && strcmp(dirent->d_name,"..") != 0)
		{	adir = dirent->d_name; fsz.setName(adir); if (fsz.size() > PACKSZ)
			{	ptype = GetPackType(adir); apix = GetItemPixmap(adir, -1); count++;
				if (pack_mode_all) { if (ValidPack(ptype)) packages->Insert(apix, adir); }
				else
				{	if (ptype == pack_type)
					{	switch (ptype)
						{	case tslack: packages->Insert(mntSLACK, adir); break;
							case tvdeb : packages->Insert( mntdeb , adir); break;
							case tvrpm : packages->Insert( mntRPM , adir); break;
							default:     packages->Insert(  apix  , adir);
				}}} if (count > PACKCN) PrintMsg(MSG_DIV21 + amsg.setNum(count));
			}
		} Working;
	} while (dirent != NULL); BlockFrame(false); closedir(dir); emit Logged();
}
//---------------------------------------------------------------------
TPack TKPackViewer::GetPackType(QString astr)
{
	// "in Trust" (fast) procedure...
	if (isRPMFolder(path_to_packs)) return tvrpm;
	if (isDEBFolder(path_to_packs)) return tvdeb;
	if (isSLAFolder(path_to_packs)) return tslack;

	QString ext(""); ext = GetPackExt(astr);
	if (ext == "deb"					)	return tdeb;
	if (ext == "zip"					)	return tzip;
	if (ext == "arj"					)	return tarj;
	if (ext == "rar"					)	return trar;
	if (ext == "tar.bz2"				)	return tbz2;
	if (ext == "rpm" || bf_RPMdb		)  	return trpm;
	if (ext == "lzh" || ext == "lha"	)	return tlzh;
	if (ext == "gz"  || ext == "z"		)	return tz;	
	if (ext == "i386"|| ext == "noarch" )	return tvrpm;
	if (ext == "tgz" || ext == "tar.gz" || ext == "tar.z")	return tgz;

	if (ext == "")
	{	// Secure (slow) procedure... but these dumb routines read TEXT FILES!
		if (astr.find("/") == -1) astr = path_to_packs + astr;
		if ( IsVRPM(astr)  ) return tvrpm;
		if ( IsVDEB(astr)  ) return tvdeb;
		if ( IsSlack(astr) ) return tslack;
	}
	
	return tnone;
}
//---------------------------------------------------------------------
QString TKPackViewer::GetPackExt(QString astr)
{
	QString ext(""); ext = astr.copy(); ext = ext.lower();
	switch (ext.contains("."))
	{	case 0:  return ""; // We have no extension to check...
		case 1:  return ext.mid(ext.findRev(".")+1, ext.length());
		default: // We have more than one dot...
		ext = ext.mid(ext.findRev(".")+1, ext.length());
		// Cases that need special care: .tar.gz/.tar.bz2/.tar.z
		if (ext == "gz" || ext == "bz2" || ext == "z")
		{	QString aux("");
			aux = astr.mid(0, astr.findRev(".")-1); aux = aux.lower();
			int tarpoint = aux.findRev(".");	// Position of second point in Rev
			if (tarpoint <=0) return ext;
			aux = astr.mid(tarpoint+1, astr.length()); aux = aux.lower();
			if (aux == "tar.gz" || aux == "tar.bz2" || aux == "tar.z") return aux;
		}
	} return ext;
}
//---------------------------------------------------------------------
QString TKPackViewer::GetValidExts(TPack apack_type)
{
	if (pack_mode_all || apack_type == tall) return "*.deb *.rpm *.zip *.tar.bz2 *.tgz *.Z *.gz *.lzh *.lha *.arj *.rar";
	
	switch (apack_type)
	{	case tdeb : return "*.deb";
		case trpm : return "*.rpm";
		case tzip : return "*.zip";
		case tarj : return "*.arj";
		case trar : return "*.rar";
		case tgz  : return "*.tgz *.tar.gz *.tar.Z";
		case tbz2 : return "*.tar.bz2";
		case tlzh : return "*.lzh *.lha";
		case tz   : return "*.Z *.gz";
		case tvrpm: return "*.i386 *.noarch";
		default  : return "*";		
	}
}
//---------------------------------------------------------------------
void TKPackViewer::RefreshPacks()
{
	if 		(isBusy) return;
	else if (isRPMdb) LogRPM();
	else if (path_to_packs == DEB_DIR) LogDEB();
	else { LogDir(path_to_packs); TIP_ID(path_to_packs); }
	SetPack();
}
//---------------------------------------------------------------------
void TKPackViewer::SetPack()
{
	StripFlags(requested_pack); if ( WEIRDStr(requested_pack) ) requested_pack = "!NONE";
	packages->SelectItem(requested_pack);
}
//---------------------------------------------------------------------
void TKPackViewer::ReloadPack() { if (!isBusy && !packages->Zerd()) ShowPack(); }
//---------------------------------------------------------------------
void TKPackViewer::ShowPack()
{
	PrintMsg(MSG_DIV5); requested_pack = path_to_packs + CurrPackLabel;
	requested_pack = requested_pack.stripWhiteSpace(); readable_pack  = requested_pack;
	ClearPack(); DoShowPack();
}
//---------------------------------------------------------------------
void TKPackViewer::ClearPack(void)
{	results->UnSelect(); 		PrintMsg(DLG_DIV37);
	results->clear();			Working;
	SetHTMLView(HTML_BLANK);	Working;
	info->clear(); 				Working;
	packview->clear(); 			Working;
	grpview->clear(); 			Working;
	packtree->clear(); 			PrintMsg(MSG_DIV29);
}
//---------------------------------------------------------------------
void TKPackViewer::DoShowPack()
{
	if (!bf_RPMdb) pack_type = GetPackType(CurrPackLabel);
	if (pack_type == tnone) { OPS(MSG_WARN19, requested_pack); }
	amsg = "KPV - " + requested_pack; setCaption(amsg);
	if (pack_type == tslack || pack_type == tvdeb) { info->clear(); SetInfoView(); }
	info->setAutoUpdate(false); DQuoteStr(requested_pack); timer->restart();
	if (pack_type != tslack)
	{	switch (pack_type) 
		{	case tvdeb:
				if (bf_DEBdb) { readable_pack = requested_pack; }
				else { SetLedOn(); VrtDEB2PAK(requested_pack); readable_pack = user_path + FLE_PAK; }
				break;
			case tvrpm:
				SetLedOn(); VrtRPM2PAK(requested_pack);
				SetInfoView(); if (NastyPack()) Pack_Parse(); PreparePackFile();
				readable_pack = user_path + FLE_PAK;
				break;
			default:
				ShowWait(MSG_DIV6 + requested_pack); SetLedOn();
				GetPackInfo(); if (!exec_ok) { NoPanic; }
				SetInfoView(); if (NastyPack()) Pack_Parse(); PreparePackFile();
				readable_pack = user_path + FLE_PAK;
		}
		
	} ReadPack(); info->setAutoUpdate(true); info->repaint();
}
//---------------------------------------------------------------------
void TKPackViewer::VrtDEB2PAK(QString apack)
{
	QString aux(""), lne(""); bool bf_lstlne = false;
 
	f = FOPEN(apack, "r"); nf = FOPEN(user_path + FLE_PAK, "w");
	do 
	{	IFGETS(f, aux) 
		{	if (GOODStr(aux))
			{	if (aux.length() > 48) // Check List Line...
				{	lne = aux.mid(48, aux.length()); lne = lne.stripWhiteSpace();
					if (lne == "./") { fputs("FILE LIST:\n", nf); bf_lstlne = true; }
				}
				if (!bf_lstlne) fputs(aux + "\n", nf);
				else { if (aux.length() > 48) fputs(aux.mid(48, aux.length()) + "\n", nf); }
			}
		} Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::VrtRPM2PAK(QString apack)
{
	QString aux(""), itm1(""), itm2(""); bool bf_flelst = false; int dd1 = -1, dd2 = -1, dd3 = -1;
	htmlinfo = HTML_HEADER; htmlinfo += INFO_HEADER;
	f = FOPEN(apack, "r"); nf = FOPEN(user_path + FLE_LOG, "w");
	do 
	{	IFGETS(f, aux) 
		{	if (GOODStr(aux))
			{	if ( isCntrlLne(aux) ) { bf_flelst = true; htmlinfo += "</TABLE></CENTER>"; htmlinfo += HTML_FOOTER; SetHTMLView(htmlinfo); }
				if ( bf_flelst ) { if ( isCntrlLne(aux) ) { } else fputs(aux + "\n", nf); }
				else
				{	info->insertLine( aux ); 
					if ( isRPMTopic(aux) )
					{	dd1 = aux.find(":");
						if (dd1 > -1)
						{	aux = aux.replace("<", " &lt "); aux = aux.replace(">", " &gt ");
							dd2 = aux.find(":", dd1+1); (dd2 > -1) ? dd3 = dd2 -12 : dd3 = aux.length();
							itm1 = aux.mid(dd1+1, dd3-dd1); (dd2 > -1) ? itm2 = aux.mid(dd2+1, aux.length()) : itm1 = aux.mid(dd1+1, aux.length());
							if 		(aux.left(7) == "VIRTUAL" ) { htmlinfo += "<TR><TD><B>Virtual RPM:</B></TD><TD>"	; htmlinfo += H_BOLD(itm1);  htmlinfo += "</TD></TR>"; }
							else if (aux.left(4) == "Name"	  ) { htmlinfo += "<TR><TD><B>Name:</B></TD><TD>"			; htmlinfo += H_OBLU(itm1);	 htmlinfo += "</TD></TR>"; htmlinfo += "<TR><TD><B>Relocations:</B></TD><TD>"	; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(7) == "Version" ) { htmlinfo += "<TR><TD><B>Version:</B></TD><TD>"		; htmlinfo += H_MAG(itm1);	 htmlinfo += "</TD></TR>"; htmlinfo += "<TR><TD><B>Vendor:</B></TD><TD>"		; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(7) == "Release" ) { htmlinfo += "<TR><TD><B>Release:</B></TD><TD>"		; htmlinfo += H_OBLU(itm1);	 htmlinfo += "</TD></TR>"; htmlinfo += "<TR><TD><B>Build Date:</B></TD><TD>"	; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(7) == "Install" ) { htmlinfo += "<TR><TD><B>Install date:</B></TD><TD>"	; htmlinfo += H_OBLU(itm1);	 htmlinfo += "</TD></TR>"; htmlinfo += "<TR><TD><B>Build host:</B></TD><TD>"	; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(5) == "Group"   ) { htmlinfo += "<TR><TD><B>Group:</B></TD><TD>"			; htmlinfo += H_GREEN(itm1); htmlinfo += "</TD></TR>"; htmlinfo += "<TR><TD><B>Source RPM:</B></TD><TD>"	; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(4) == "Size"    ) { htmlinfo += "<TR><TD><B>Size:</B></TD><TD>"			; htmlinfo += itm1                    +  "</TD></TR>"; htmlinfo += "<TR><TD><B>License:</B></TD><TD>"		; htmlinfo += itm2 + "</TD></TR>"; }
							else if	(aux.left(8) == "Packager") { htmlinfo += "<TR><TD><B>Packager:</B></TD><TD>"		; htmlinfo += aux.mid(dd1+1, aux.length()) +  "</TD></TR>"; }
							else if	(aux.left(7) == "Summary" ) { htmlinfo += "<TR><TD><B>Summary:</B></TD><TD>"		; htmlinfo += H_RED(itm1);	 htmlinfo += "</TD></TR>"; }
							else { };
						}						
					} else { if (aux.left(11) == "Description") { BGETS(f, aux); htmlinfo += "<TR><TD><B>Description:</B></TD><TD>" + aux; } else htmlinfo += aux + "<BR>"; }
		}}} Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetPackInfo()
{
	QString AQry("");

	switch(pack_type)
	{	case trpm:
			frmt = true;
			htmlinfo = HTML_HEADER; htmlinfo += INFO_HEADER; info->clear();
			GetRPMInfo("NAME"         , " \"%{NAME}-%{VERSION}-%{RELEASE}\n\" ", 0);
			GetRPMInfo("RELEASE"      , " \"%{RELEASE}\n\" "         );
			GetRPMInfo("GROUP"        , " \"%{GROUP}\n\" "           ,  2);
			GetRPMInfo("DISTRIBUTION" , " \"%{DISTRIBUTION}\n\" "    );
			GetRPMInfo("VENDOR"       , " \"%{VENDOR}\n\" "          );
			GetRPMInfo("SUMMARY"      , " \"%{SUMMARY}\n\" "         ,  1);
			GetRPMInfo("SIZE"         , " \"%{SIZE} bytes\n\" "      );
			GetRPMInfo("COPYRIGHT"    , " \"%{COPYRIGHT}\n\" "       );	
			GetRPMInfo("OS"           , " \"%{OS}\n\" "              );
			GetRPMInfo("BUILDHOST"    , " \"%{BUILDHOST}\n\" "       );
			GetRPMInfo("SOURCERPM"    , " \"%{SOURCERPM}\n\" "       );
			GetRPMInfo("PACKAGER"     , " \"%{PACKAGER}\n\" "        );
			GetRPMInfo("URL"          , " \"%{URL}\n\" "             );
			GetRPMInfo("BUILDTIME"    , " \"%{BUILDTIME:date}\n\" "  );
			GetRPMInfo("SERIAL"       , " \"%{SERIAL}\n\" "          );
			GetRPMInfo("RPMVERSION"   , " \"%{RPMVERSION}\n\" "      );
			frmt = false;
			GetRPMInfo("PREINSTALL"   , " \"%{RPMTAG_PREIN}\n\" "    , -1);
			GetRPMInfo("POSTINSTALL"  , " \"%{RPMTAG_POSTIN}\n\" "   , -1);
			GetRPMInfo("PREUNINST"    , " \"%{RPMTAG_PREUN}\n\" "    , -1);
			GetRPMInfo("POSTUNINST"   , " \"%{RPMTAG_POSTUN}\n\" "   , -1);
			GetRPMInfo("VERIFY"       , " \"%{VERIFYSCRIPT}\n\" "    , -1);
			GetRPMInfo("PROVIDES"     , " \"[%{PROVIDES}\n]\n\" "    ,  1);
			GetRPMInfo("REQUIRES"     , " \"[%{REQUIRENAME} %{REQUIREFLAGS:depflags} %{REQUIREVERSION}\n]\n\" ", 2);
			GetRPMInfo("DESCRIPTION"  , " \"%{DESCRIPTION}\n\" "     );
			GetRPMInfo("CHANGELOG"    , " \"[* %{CHANGELOGTIME:date} %{CHANGELOGNAME}\n%{CHANGELOGTEXT}\n\n]\n\" ");
			htmlinfo += "</TABLE></CENTER>"; htmlinfo += HTML_FOOTER; SetHTMLView(htmlinfo);
			(isRPMdb) ? AQry = PAK_RPM_QL : AQry = PAK_RPM_QPL;
			AQry += requested_pack + DEFLOG; ProcessExec(AQry);
			if (!exec_ok) DumpMsg(MSG_WARN33 + AQry);
			break;
		
		case tdeb:
			AQry = PAK_DEB_INF + requested_pack + DEFLOG; ProcessExec(AQry);
			if (!exec_ok) { DumpMsg(MSG_WARN33 + AQry); return; }
			FormatDEBInfo();
			AQry = PAK_DEB_LST + requested_pack + DEFLOG; ProcessExec(AQry);
			if (!exec_ok) { DumpMsg(MSG_WARN33 + AQry); return; }
			break;
			
		case tarj: GetARJInfo(); FormatPackInfo(FLE_LST); break;
		case trar: GetRARInfo(); FormatPackInfo(FLE_LST); break;

		default:
			switch(pack_type)
			{	case tzip: AQry = PAK_ZIP_INF + requested_pack; break;
				case tlzh: AQry = PAK_LHA_LST + requested_pack; break;
				case tz  : AQry = PAK_GZP_LST + requested_pack; break;
				case tgz : AQry = PAK_TGZ_LST + requested_pack + PAK_TAR_LST; break;
				case tbz2: AQry = PAK_BZ2_LST + requested_pack + PAK_TAR_LST; break;
				default: break;
			}
			AQry += DEFLOG; ProcessExec(AQry);
			if (!exec_ok) { DumpMsg(MSG_WARN33 + AQry); return; }
			FormatPackInfo();
	}
}
//---------------------------------------------------------------------
void TKPackViewer::GetPackList(QString apack, QStrList &lstbuf)
{
	QString pck(""), AQry(""), rfle(""); TPack apt = GetPackType(apack); bool doproc = true;
	
	pck = GoodPath(path_to_packs + apack); rfle = user_path + FLE_LST; AQry = " > " + rfle;
	lstbuf.clear(); PrintMsg(MSG_DIV8 + pck);

	if		(   isRPMdb  ) { AQry = PAK_RPM_QL  + pck + AQry; }
	else if (apt == trpm ) { AQry = PAK_RPM_QPL + pck + AQry; }
	else if (apt == tdeb ) { AQry = PAK_DEB_LST + pck + AQry; }
	else if (apt == tzip ) { AQry = PAK_ZIP_LST + pck + AQry; }
	else if (apt == tlzh ) { AQry = PAK_LHA_LST + pck + AQry; }
	else if (apt == tz   ) { AQry = PAK_GZP_LST + pck + AQry; }
	else if (apt == tgz  ) { AQry = PAK_TGZ_LST + pck + PAK_TAR_LST + AQry; }
	else if (apt == tbz2 ) { AQry = PAK_BZ2_LST + pck + PAK_TAR_LST + AQry; }
	else if (apt == tarj ) { GetARJTree(pck, lstbuf); SetLedOff();  return; }
	else if (apt == trar ) { QStrList dmylst; DoGetRARInfo(pck, lstbuf, dmylst); SetLedOff(); return; }
	else if (apt == tvdeb) { if (!bf_DEBdb) { VrtDEB2PAK(apack); rfle = user_path + FLE_PAK; } else rfle = user_path + VRT_TMP + apack; doproc = false; }
	else { doproc = false; rfle = pck; }

	if (doproc)	{ ProcessExec(AQry); if (!exec_ok) { DumpMsg(MSG_WARN33 + AQry); SetLedOff(); return; }}
	
	FILE *lstf = FOPEN(rfle, "r"); bool lstbeg = false;
	do
	{	IFGETS(lstf, pck)
		{	if (GOODStr(pck))
			{	if (apt == trpm) lstbuf.append(pck);
				else if (isCntrlLne(pck)) lstbeg = true;
				else { if (lstbeg) lstbuf.append(pck); }
		}} Working;
	} while (!feof(lstf)); fclose(lstf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetRPMInfo(QString Param, QString AQry, int acolor)
{
	(isRPMdb) ? AQry = PAK_RPM_QF + AQry : AQry = PAK_RPM_QPF + AQry;
	AQry = AQry + requested_pack + DEFLOG; ProcessExec(AQry);
	if (!exec_ok) { DumpMsg(MSG_WARN33 + AQry); return; }
	
	QString dummy(""), acum(""); amsg = Param + ": ";
	if (!frmt) { info->insertLine("    "); info->insertLine("--- " + amsg); }
	
 	f = FOPEN(user_path + FLE_LOG, "r");
	do
	{	IBGETS(f, dummy)
		{	if (frmt)
			{	acum = dummy;
				if (StringAccepted(dummy, true)) info->insertLine(amsg + dummy);
			}
			else
			{	(acolor == -1) ? acum += dummy : acum += dummy + "<BR>";
				dummy = dummy.replace( QRegExp("\n+$"), "" );
				info->insertLine("   " + dummy);
			}
		} Working;
	} while (!feof(f)); fclose(f);

	if (acolor > -2)
	{	if (acum.find("(none)") == -1)
		{	switch (acolor)
			{	case -1: acum = H_PRE(acum)  ; break;
				case  0: acum = H_BOLD(acum) ; break;
				case  1: acum = H_BLUE(acum) ; break;
				case  2: acum = H_RED(acum)  ; break;
				case  3: acum = H_GREEN(acum); break;
				default: break;
	}}}
	htmlinfo += "<TR><TD><B>" + WithBL(amsg) + "</B></TD><TD>" + acum + "</TD></TR>";
}
//---------------------------------------------------------------------
void TKPackViewer::GetARJInfo()
{
	QStrList inflst, nmelst;
	GetARJList(requested_pack, inflst);
	GetARJTree(requested_pack, nmelst);

	if (inflst.isEmpty() || nmelst.isEmpty()) { WARN(DLG_DIV38) };
	if (inflst.count()   != nmelst.count()  ) { WARN(DLG_DIV39) };

	f = FOPEN(user_path + FLE_LST, "w"); nf = FOPEN(user_path + FLE_LOG, "w"); 
	QString aux(""), aux2(""), aux3(""); aux = inflst.first(); aux2 = nmelst.first();
	do
	{	aux3 = aux2 + "\n"; fputs(aux3, nf);
		aux3 = aux + "   " + aux3; fputs(aux3, f);
		aux = inflst.next(); aux2 = nmelst.next(); Working;
	} while ( !aux.isNull()  && !aux2.isNull() ); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetARJList(QString apack, QStrList &alist)
{
	QString aux(""); aux = PAK_ARJ_LST + apack + DEFLST;
	alist.clear(); ProcessExec(aux);
	if (!exec_ok) { DumpMsg(MSG_WARN33 + aux); return; }

	f  = FOPEN(user_path + FLE_LST, "r"); EatFleLn(f, 6);
	do 
	{	IFGETS(f, aux)
		{	if (PackLineOK(aux))
			{	int ppt = aux.findRev("+");
				if (ppt > -1)
				{	QString asz("");
					if (ppt > 70) { aux = aux.mid(13, aux.length()); aux = aux.stripWhiteSpace(); }
					ppt = aux.find("-");
					if (ppt > -1)
					{	ppt -= 9; asz = aux.mid(0, ppt+1); aux = aux.mid(ppt, aux.length());
						aux = aux.replace( QRegExp("\\s+") , "\t");
						aux = aux.replace( QRegExp("\t") , " ");
						aux = aux.stripWhiteSpace();
						asz = asz.replace( QRegExp("\\s+") , "\t");
						asz = asz.replace( QRegExp("\t") , " ");
						asz = asz.stripWhiteSpace();
						asz = asz.rightJustify(23, ' ');
						aux = asz + " " + aux; alist.append(aux);
					}
				}
			}
		} Working;
	} while (!feof(f)); fclose(f);
}
//---------------------------------------------------------------------
void TKPackViewer::GetARJTree(QString apack, QStrList &alist)
{
	QString aux(""); aux = PAK_ARJ_INF + apack + DEFLST;
	alist.clear(); ProcessExec(aux);
	if (!exec_ok) { DumpMsg(MSG_WARN33 + aux); return; }

	f  = FOPEN(user_path + FLE_LST, "r"); EatFleLn(f, 4);
	do 
	{	IFGETS(f, aux)
		{	if (PackLineOK(aux))
			{	int ppt = aux.find( QRegExp( "\\(.*\\)") );
				if (ppt > -1) aux = aux.mid(0, ppt-1);
				else aux = aux.mid(37, aux.length());
				aux = aux.mid(7, aux.length());
				aux = aux.replace( QRegExp("\t") , "   ");
				aux = aux.stripWhiteSpace();
				if (GOODStr(aux)) alist.append(aux);
			}
		} Working;
	} while (!feof(f)); fclose(f);
}
//---------------------------------------------------------------------
void TKPackViewer::GetRARInfo()
{
	QStrList inflst, nmelst; DoGetRARInfo(requested_pack, nmelst, inflst);

	if (inflst.isEmpty() || nmelst.isEmpty()) { WARN(DLG_DIV42) };
	if (inflst.count()   != nmelst.count()  ) { WARN(DLG_DIV43) };

	f = FOPEN(user_path + FLE_LST, "w"); nf = FOPEN(user_path + FLE_LOG, "w"); 
	QString aux(""), aux2(""), aux3(""); aux = inflst.first(); aux2 = nmelst.first();
	do
	{	if (aux.mid(41, 1) == "d") ForceDir(aux2);
		aux3 = aux2 + "\n"; fputs(aux3, nf);
		aux3 = aux + "   " + aux3; fputs(aux3, f);
		aux = inflst.next(); aux2 = nmelst.next(); Working;
	} while ( !aux.isNull()  && !aux2.isNull() ); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::DoGetRARInfo(QString apack, QStrList &nmelst, QStrList &inflst)
{
	QString aux(""); aux = PAK_RAR_LST + apack + DEFLST;
	nmelst.clear(); inflst.clear(); ProcessExec(aux);
	if (!exec_ok) { DumpMsg(MSG_WARN33 + aux); return; }

	f  = FOPEN(user_path + FLE_LST, "r"); EatFleLn(f, 9);
	do 
	{	IFGETS(f, aux) { if (PackLineOK(aux)) { if (GOODStr(aux)) nmelst.append(aux); }}
		IBGETS(f, aux) { if (PackLineOK(aux)) { if (GOODStr(aux)) { aux = aux.mid(11, aux.length()); inflst.append(aux); }}}
		Working;
	} while (!feof(f)); fclose(f);
}
//---------------------------------------------------------------------
void TKPackViewer::FormatDEBInfo()
{
	htmlinfo = HTML_HEADER; htmlinfo += INFO_HEADER; info->clear();
 	f = FOPEN(user_path + FLE_LOG, "r"); QString aux("");
	do { IFGETS(f, aux) { DoFormatDEBInfo(aux, false); } Working; }
	while (!feof(f)); fclose(f);
	htmlinfo += "</TD></TR></TABLE><P>"; htmlinfo += HTML_FOOTER; SetHTMLView(htmlinfo);
}
//---------------------------------------------------------------------
void TKPackViewer::DoFormatDEBInfo(QString debuf, bool inLST)
{
	QString itm(""), val(""); int ddpt; info->insertLine( debuf );

	if ( isDEBTopic(debuf) )
	{	ddpt = debuf.find(":");
		if (ddpt > -1)
		{	itm = debuf.mid(0, ddpt); val = debuf.mid(ddpt+1, debuf.length());
			val = val.replace("<", "&lt"); val = val.replace(">", "&gt");
			if (itm.find("VIRTUAL DEBIAN PACKAGE", 0, false) > -1) htmlinfo += "<TR><TD><B>Virtual Debian:</B></TD><TD>";
			else htmlinfo += "<TR><TD><B>" + itm + ":</B></TD><TD>";
			if (itm.find("VIRTUAL DEBIAN PACKAGE", 0, false) > -1)
			{ htmlinfo += H_GREEN(val.mid(0, val.find("/"))); htmlinfo += H_BOLD(val.mid(val.find("/"), val.length())); }
			else if (itm.find("Package"   , 0, false) > -1) htmlinfo += H_OBLU(val);
			else if	(itm.find("Conflicts" , 0, false) > -1) htmlinfo += H_MAG(val);
			else if	(itm.find("Suggests"  , 0, false) > -1) htmlinfo += H_OBLU(val);
			else if	(itm.find("Recommends", 0, false) > -1) htmlinfo += H_OBLU(val);
			else if	(itm.find("Section"   , 0, false) > -1) htmlinfo += H_GREEN(val);
			else if	(itm.find("Depends"   , 0, false) > -1) htmlinfo += H_RED(val);
			else htmlinfo += val; htmlinfo += "</TD></TR>";
		} else { if (inLST) htmlinfo += curr + "<BR>"; }
	}
	else
	{	if (debuf.left(12) == "Description:")
		{	htmlinfo += "<TR><TD><B>Summary:</B></TD><TD><FONT COLOR=BLUE>" + debuf.mid(12, debuf.length()) + "</FONT></TD></TR>";
			BGETS(f, debuf); htmlinfo += "<TR><TD><B>Description:</B></TD><TD>" + debuf;
		} else htmlinfo += debuf + "<BR>";
	}
}
//---------------------------------------------------------------------
void TKPackViewer::FormatPackInfo(QString afle)
{
	QString dummy(""), len(""), atr(""), stp(""), itm(""); QPixmap apix = fico;

	info->clear(); packview->Reset((int)tabbar->width() >> 1); Working;
	f = FOPEN(user_path + afle, "r");
	do
	{	IBGETS(f, dummy)
		{	if (GOODStr(dummy))
			{	info->insertLine(dummy);
				if (PackLineOK(dummy))
				{	atr = GetInfoAtr(dummy); stp = GetInfoStp(dummy);
					len = GetInfoLen(dummy); itm = GetInfoItm(dummy);
					LSPACED(atr); LSPACED(stp); LSPACED(len); FormatItem(itm);
					apix = GetItemPixmap(cbuf); packview->Insert(apix, atr, stp, len, itm);
				}
			}
		} Working;
	} while (!feof(f)); fclose(f); packview->Activate();
}
//---------------------------------------------------------------------
void TKPackViewer::FormatSLAInfo()
{
	if (curr == "/") return;

	info->insertLine(curr); 
	if (bf_virtslak && !bf_vsinit)
	{	if (curr.left(11) == "---<Script>") 
		{	htmlinfo += "</TD></TR></TABLE>" HTML_SCRIP "<PRE><TT>\n";
			bf_vsinit = true;
		} else DoFormatSLAInfo();
	}
	else if (bf_virtslak && bf_vsinit) { htmlinfo += curr + "\n"; }
	else DoFormatSLAInfo();
}
//---------------------------------------------------------------------
void TKPackViewer::DoFormatSLAInfo()
{
	int ddpt = curr.find(":"); if (ddpt == -1) return; QString itm(""), val(""); 
	itm = curr.mid(0, ddpt); val = curr.mid(ddpt+1, curr.length());

	if (itm.find("PACKAGE NAME") >-1 || itm.find("VIRTUAL SLACK PACKAGE") >-1 || itm.find("PACKAGE SIZE") >-1 || itm.find("PACKAGE LOCATION") >-1)
	{
		if (itm.find("PACKAGE NAME") >-1 || itm.find("VIRTUAL SLACK PACKAGE") >-1) val = H_BOLD(val);
		if (itm.find("PACKAGE LOCATION") >-1) val += "&nbsp&nbsp(<FONT COLOR=RED><B>" + GetSlackAlias(val) + "</B></FONT>)";
		htmlinfo += "<TR><TD><B>" + WithBL(itm) + ":</B></TD><TD>" + val + "</TD></TR>"; 
	}
	else if (itm.find("PACKAGE DESCRIPTION") >-1)
	{
		htmlinfo += "<TR><TD><B>Summary:</B></TD>"; QString aux(""); FGETS(f, aux); info->insertLine(aux);
		aux = aux.mid(aux.find(":")+1, aux.length()); aux = aux.stripWhiteSpace();
		htmlinfo += "<TD><FONT COLOR=BLUE>" + aux + "</FONT></TD></TR>";		
		htmlinfo += "<TR><TD><B>" + WithBL(itm) + ":</B></TD><TD>";
	}
	else if (itm == CurrPackLabel) { htmlinfo += val; }
	else htmlinfo += "</TD></TR>";
}
//---------------------------------------------------------------------
QString TKPackViewer::WithBL(QString &astr)
{
	QString cpt(""); if (astr.find("packager", 0, false) == -1) astr = astr.replace( QRegExp("PACKAGE"), "" ); astr = astr.stripWhiteSpace();
	if (astr.find("  ", 0, false)>-1) astr = astr.replace( QRegExp("  ") , " " ); astr = astr.stripWhiteSpace();
	cpt = astr.mid(0, 1); astr = astr.lower(); astr = astr.replace(0, 1, cpt.upper()); int ppt = astr.find(" ", 0);
	if (ppt > 0) { cpt = astr.mid(ppt+1, 1); astr = astr.replace(ppt+1, 1, cpt.upper()); }
	if (astr.find("rpmv", 0, false)>-1) astr = astr.replace( QRegExp("rpmv") , "RPM V" ); return astr;
}
//---------------------------------------------------------------------
bool TKPackViewer::EatFleLn(FILE *afle, int howmuch)
{
	int fcnt = 0; QString dummy("");
	do
	{ IFGETS(afle, dummy) { fcnt++; } Working;
	} while (!feof(afle) && fcnt < howmuch); return (fcnt == howmuch);
}
//---------------------------------------------------------------------
int TKPackViewer::GetSpacePos(int which, QString astr, bool inRev)
{
	if (astr.contains(" ") == 0 || which < 1) return astr.length();
	
	int i = 1, retval = 0;  QString aux(""); aux = astr.copy();
	for(; i <= which; i++)
	{	if (inRev) { retval = aux.findRev(" "); aux = aux.mid(0, retval); }
		else { retval += aux.find(" "); aux = aux.mid(retval+1, aux.length()); }
	}
	if (!inRev) retval += (i-1); return retval;
}
//---------------------------------------------------------------------
QString TKPackViewer::GetLHAInfo(QString astr, int typ)
{
	int lhapt1 = astr.find("/"); if (lhapt1 == -1) lhapt1 = 13;
	int lhapt2 = astr.find("%"); if (lhapt2 == -1) lhapt2 = 31;
	int lhapt3 = astr.find(":"); if (lhapt3 == -1) lhapt3 = 42;
	do { lhapt1++; }
	while (astr.mid(lhapt1, 1) != " " && lhapt1 < (int)astr.length());
	if (lhapt1 >= (int)astr.length()) if (lhapt1 == -1) lhapt1 = 13;
	do { lhapt2++; }
	while (astr.mid(lhapt2, 1) != " " && lhapt2 < (int)astr.length());
	if (lhapt2 >= (int)astr.length()) if (lhapt2 == -1) lhapt2 = 31;
	do { lhapt3++; }
	while (astr.mid(lhapt3, 1) != " " && lhapt3 < (int)astr.length());
	if (lhapt3 >= (int)astr.length()) if (lhapt3 == -1) lhapt3 = 42;
	switch(typ)
	{	case 1: astr = astr.mid(0, lhapt1); break;
		case 2: astr = astr.mid(lhapt1, lhapt2-lhapt1+1); break;
		case 3: astr = astr.mid(lhapt2, lhapt3-lhapt2+1); break;
		case 4: astr = astr.mid(lhapt3, astr.length()  ); break;
		default: break;
	} return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoAtr(QString astr)
{
	switch (pack_type)
	{	case tzip: astr = astr.mid( 0, 20); break;
		case tarj: astr = astr.mid(47, 14); break;
		case trar: astr = astr.mid(40, 29); break;
		case tlzh: astr = GetLHAInfo(astr, 1); break;
		case tdeb:
		case tbz2:
		case tgz : astr = astr.mid(0, GetSpacePos(2, astr)); break;
		case tz  : (astr.left(11) == "method  crc") ? astr = "" : astr = astr.mid(0, 15); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoLen(QString astr)
{
	switch (pack_type)
	{	case tzip: astr = astr.mid(19, 27); astr = astr.stripWhiteSpace(); astr = astr.replace( QRegExp("\\s+") , " - "); break;
		case tarj: astr = astr.mid( 0, 30); astr = astr.stripWhiteSpace(); astr = astr.replace( QRegExp(" ")    , " - "); break;
		case trar: astr = astr.mid( 0, 25); astr = astr.stripWhiteSpace(); astr = astr.replace( QRegExp("\\s+") , " - "); break;
		case tlzh: astr = GetLHAInfo(astr, 2); break;
		case tdeb:
		case tbz2:
		case tgz : astr = astr.mid(GetSpacePos(2, astr), astr.find("-", GetSpacePos(2, astr))-5-GetSpacePos(2, astr)); break;
		case tz  : (astr.left(11) == "method  crc") ? astr = "" : astr = astr.mid(27, 28); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoStp(QString astr)
{
	switch (pack_type)
	{	case tzip: astr = astr.mid(45, 17); break;
		case tarj: astr = astr.mid(29, 19); break;
		case trar: astr = astr.mid(25, 16); break;
		case tlzh: astr = GetLHAInfo(astr, 3); break;
		case tdeb:
		case tbz2:
		case tgz : astr = astr.mid(astr.find("-", GetSpacePos(2, astr))-5, 17); break;
		case tz  : (astr.left(11) == "method  crc") ? astr = "" : astr = astr.mid(15, 13); break;
		default  : astr = "";
	}
	return astr.stripWhiteSpace();
}
//---------------------------------------------------------------------
QString TKPackViewer::GetInfoItm(QString astr)
{
	if (!PackLineOK(astr)) return "";
	switch (pack_type)
	{	case tzip: astr = astr.mid(61, astr.length()); break;
		case tarj: astr = astr.mid(61, astr.length()); break;
		case trar: astr = astr.mid(69, astr.length()); break;
		case tlzh: astr = GetLHAInfo(astr, 4); break;
		case tdeb:
		case tbz2:
		case tgz : astr = astr.mid(astr.findRev(":", 49)+3, astr.length()); break;
		case tz  : (astr.left(11) == "method  crc") ? astr = "" : astr = astr.mid(55, astr.length()); break;
		default  : astr = "";
	}
	astr = astr.stripWhiteSpace(); CheckSlash(astr); return astr;
}
//---------------------------------------------------------------------
bool TKPackViewer::PackLineOK(QString &astr)
{
	if ( WEIRDStr(astr) ) return false; bf_dummy = false;
	switch (pack_type)
	{	case tlzh:
			bf_dummy = (	astr.left(7) != "-------"
					 && astr.find("Total ") == -1
					 && astr.find("PERMSSN  UID GID") == -1); 		break;
		case tzip:
			bf_dummy = (	astr.left(9) != "Archive: "
					 && astr.find("bytes uncompressed,") == -1);	break;
		case tz  :
			bf_dummy = (	astr.left(11)  != "method  crc"
					 && astr.right(17) != "uncompressed_name");		break;
		case tarj:
			bf_dummy = (	astr.mid(5, 8) != " file(s)"
					 && astr.mid(6, 8) != " files  "
					 && astr.left(7)   != "-------"
					 && astr.right(11) != "AttrBTPMGVX"
					 && astr.find("UNARJ ") == -1
					 && astr.find("Archive created:") == -1
					 && astr.find("Processing archive:") == -1);	break;
		case trar:
			if (astr.right(1) == "\n") astr = astr.mid(0, astr.length()-1);
			bf_dummy = (astr.find(" Eugene Roshal ") == -1
					&& astr.find("Type RAR -? for help") == -1
					&& astr.find("Pathname/Comment") == -1
					&& astr.left(7)   != "-------"
					&& astr.left(8)   != "Archive "
					&& astr.right(14) != "CRC   Meth Ver"
					&& astr.right(1)  !=  "%");						break;
		
		case tdeb:
		case tgz :
		case tbz2:
		default  : bf_dummy = true; break; 
	}
	if (bf_dummy) CheckSlash(astr);
	return bf_dummy;
}
//---------------------------------------------------------------------
bool TKPackViewer::NastyPack()
{
	switch (pack_type)
	{	case tvrpm:
		case trpm:
		case trar:
		case tarj: isNasty = true;    break;
		case tbz2:
		case tgz : PatchNastyPack();  break;
		case tzip: PatchNastyPack(1); break;
		case tz  : PatchNastyPack(1); break;
		default  : isNasty = false;
	}
	return isNasty;
}
//---------------------------------------------------------------------
bool TKPackViewer::DirMarked(QString astr)
{
	bool isMarked = false;
	switch (pack_type)
	{	case tlzh: isMarked = ( astr.find("******") > -1 ); break;
		case tbz2:
		case tzip:
		case trar:
		case tgz : isMarked = ( astr.left(1) == "d" ); break;
		default  : break;
	}
	return isMarked;
}
//---------------------------------------------------------------------
void TKPackViewer::PatchNastyPack(int etnm)
{
	FILE *afle = FOPEN(user_path + FLE_LOG, "r");
	if (etnm) { if (!EatFleLn(afle, etnm)) { fclose(afle); return; } }

	QString abuf(""), itm(""), atr("");
	IFGETS(afle, abuf)
	{	if ( PackLineOK(abuf) )
		{	atr = GetInfoAtr(abuf); itm = GetInfoItm(abuf);
			isNasty = ( itm != "./" && !IsDirectory(itm) && !DirMarked(abuf) );
			if (isNasty)
			{	if ( DirMarked(abuf) ) ForceDir(itm);
				FILE *wnsf = FOPEN(user_path + FLE_LST, "w"); fputs(itm + "\n", wnsf);
				do
				{	IFGETS(afle, abuf)
					{	if (PackLineOK(abuf))
						{	atr = GetInfoAtr(abuf); itm = GetInfoItm(abuf);
							if (atr.left(1) == "d") ForceDir(itm);
							fputs(itm + "\n", wnsf);
						}
					} Working;
				} while (!feof(afle)); fclose(wnsf);
	}}} fclose(afle);
}
//---------------------------------------------------------------------
void TKPackViewer::ReadPack()
{
	if (!InitFrame()) return;
	
	if (wHTMInfo) { htmlinfo = HTML_HEADER; htmlinfo += INFO_HEADER; }
	WaitDone(); f = FOPEN(readable_pack, "r"); StartMeter();
	do 
	{	IBGETS(f, curr)
		{	if (StringAccepted(curr, bf_virtslak))
			{	if (ListBegins()) 
				{	AddItemToTree();
					if (!UpdateMeter() || !MemAvail()) goto breakit;
				} prev = curr;
			}
		} Working;
	} while (!feof(f));
breakit: fclose(f); StopMeter();

	if (wHTMInfo) { htmlinfo += HTML_FOOTER; SetHTMLView(htmlinfo); }
	results->setColumnWidth(0, tabbar->width()); PrintElapsed();
}
//---------------------------------------------------------------------
bool TKPackViewer::StringAccepted(QString &astr, bool ftest)
{
	if (ftest)
	{ 	// Strip only not "formatted" lines...
		if (astr.left(1) != " " && astr.left(1) != "\t") 
		{ 	astr = astr.stripWhiteSpace();
			return (ValidStr(astr));
		}
		if (astr.right(1) == "\n") astr = astr.mid(0, astr.length()-1);
		return true;
	}
	else { astr = astr.stripWhiteSpace(); return (ValidStr(astr)); }
}
//---------------------------------------------------------------------
void TKPackViewer::PrintElapsed()
{
	QTime *tf = new QTime(); *tf = tf->addMSecs(timer->elapsed());
	amsg = MSG_DIV7; amsg += tf->toString(); amsg += " (hh:mm:ss)";
	PrintMsg(amsg); delete tf; emit Ready(); packtree->setFocus();
}
//---------------------------------------------------------------------
bool TKPackViewer::ListBegins()
{
	// List already began...
	if (idx >= 0) return true;
	
	Working; bool is_FILE_LIST_LINE = (curr.find("FILE LIST:", 0, false) > -1);
	
	// Check for SlackContents...
	if (is_FILE_LIST_LINE) { if (pack_type == tgz) CheckSlakContents(); results->Insert(gen, curr); }
	
	// Check VDEB Info...
	if (pack_type == tvdeb) { (!is_FILE_LIST_LINE && curr != "./") ? DoFormatDEBInfo(curr, true) : htmlinfo += "</TD></TR></TABLE><P>"; }
	
	// Detects begin of FILE LIST...
	if (curr.left(2) == "./") { results->Insert(hom, curr); idx++; curr = "/"; }

	if (wSLAInfo)
	{	if 		(!is_FILE_LIST_LINE) FormatSLAInfo();
		else if (!   bf_virtslak   ) AppendSLAData();
		else
		{	QString aux(CurrPackLabel);
			if (isINF(prev, aux))
			{
				htmlinfo += "</TD></TR></TABLE>" HTML_SCRIP; htmlinfo += HTML_NOSCR;
			}
			else if (prev.find("PACKAGE LOCATION:") > -1)
			{
				htmlinfo += "</TABLE>" HTML_SCRIP; htmlinfo += HTML_NOSCR;
			}
			else htmlinfo += "\n</TT></PRE><P>";
		}
	}
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::AppendSLAData()
{
	htmlinfo += "</TABLE></CENTER><P>";
	if (!DirExists(SLA_SCP)) return; QFile slack_script(CurrPackLabel);
	htmlinfo += HTML_SCRIP;

	if (slack_script.open( IO_ReadOnly ))
	{	QTextStream tx( &slack_script ); QString aux("");
		info->insertLine("   ");
		info->insertLine("---<Script>--------------------------");
		info->insertLine("   ");
		htmlinfo +=  "<PRE><TT>";
		while (!tx.eof()) { aux = tx.readLine(); htmlinfo += aux + "\n"; info->insertLine( aux ); }
		htmlinfo += "</TT></PRE><P>";
		slack_script.close();
	}
	else { htmlinfo += HTML_NOSCR; }
	bf_dummy = DirExists(SLA_PAK);
}
//---------------------------------------------------------------------
void TKPackViewer::CheckSlakContents()
{
	QString dummy(""), astr(""), acnt("");
	astr = path_to_packs; astr = astr.mid(0, astr.length()-1); FNAME(astr);
	astr = GoodPath(path_to_packs + "disk" + astr);

	FILE *skf; if (!FTEST(skf, astr, "r")) return; int cnt = 0;
	astr = CurrPackLabel; astr = astr.mid(0, astr.findRev(".")) + ":";
	do
	{	IFGETS(skf, dummy)
		{	if (dummy.left(astr.length()) == astr)
			{	cnt++; acnt.setNum(cnt); if (acnt.length() < 2) acnt = "0" + acnt;
				dummy = "-" + acnt + "- " + dummy; results->Insert(unk, dummy);
			}
		} Working;
	} while (!feof(skf)); fclose(skf);
}
//---------------------------------------------------------------------
void TKPackViewer::AddItemToTree()
{
	cbuf = curr;
	if (IsDirectory(curr))
	{	if (IsSubDir(curr, prev)) DoAddItem(); else { ScanItemParent(); DoAddItem(); }
		idx = packtree->count()-1;
	} else { if (!InItemFolder(curr)) ScanItemParent(); DoAddItem(); }
}
//---------------------------------------------------------------------
void TKPackViewer::ScanItemParent()
{
	QString ditem(""), dparent(""); bool bfpop = true;
	
	dparent = curr; GetItemParent(dparent); GetItemFullPath(idx, ditem);
	if (!ParentInBuf(dparent)) 
	{	do
		{	if (InRoot(ditem) || InRoot(dparent)) { idx = 0; bfpop = false; }
			else 
			{	if (IsSubDir(curr, ditem.mid(1, ditem.length())))
				{	bfpop = false;
					if (!IsDirectory(ditem)) { idx--; GetItemFullPath(idx, ditem); }
				}
				else 
				{	idx--; GetItemFullPath(idx, ditem);
					if (ditem == dparent) bfpop = false;
				}
			} Working;
		} while (bfpop);
	}
}
//---------------------------------------------------------------------
bool TKPackViewer::ParentInBuf(QString aparent)
{
	if (dirlog.find(aparent) == -1) return false;

	if (aparent != lastparent)
	{	parentpos = GetDirIdx(aparent);
		if (parentpos ==  -1) return false;
		lastparent = aparent;
	}
	idx = parentpos; return true;
}
//---------------------------------------------------------------------
int TKPackViewer::GetDirIdx(QString ADir)
{
	QString aux("");
	for(int i = 0; i < (int)packtree->count(); i++)
	{	GetItemFullPath(i, aux);
		if (aux == ADir) return i;
		Working;
	} return -1;
}
//---------------------------------------------------------------------
void TKPackViewer::DoAddItem()
{
	QString abuf(""); FormatItem(curr);
	if (IsDirectory(cbuf))
	{	results->Insert(fico, curr); 
		packtree->appendChildItem(cbuf, fico, idx);
		GetItemFullPath(idx, abuf); dirlog.append(abuf + cbuf);
	}
	else
	{	QPixmap apix = GetItemPixmap(cbuf);
		results->Insert(apix, curr);
		packtree->appendChildItem(cbuf, apix, idx);
	}
	packtree->expandItem(idx, false);
}
//---------------------------------------------------------------------
void TKPackViewer::Pack_Parse()
{
	QString strcurr("FILE LIST:\n./\n"), strwrt(""); char oldbuf[BUFLEN];

	whatidid = "#";
	(IsNasty(tgz) || IsNasty(tbz2) || IsNasty(tz) || IsNasty(tzip)) ? f = FOPEN(user_path + FLE_LST, "r") : f = FOPEN(user_path + FLE_LOG, "r");
 	nf = FOPEN(user_path + FLE_DIR, "w"); fputs(strcurr,nf);
	do 
	{	IFGETS(f, strcurr)
		{	if (ValidStr(strcurr))
			{	if (strcurr.left(1) != "/") strcurr = "/" + strcurr;
				strcurr = strcurr.mid(1, strcurr.findRev("/"));
				Process_Pack_Entry(strcurr);
				if (strcmp(buf, oldbuf) != 0)
				{	strwrt = buf; if (strwrt.left(1) == "/") strwrt = strwrt.mid(1, strwrt.length());
					strwrt = strwrt.stripWhiteSpace() + "\n"; fputs(strwrt, nf);
				} strcpy(oldbuf, buf);
			}
		} Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::Process_Pack_Entry(QString strcurr)
{
	QString straux(""), strhold(""), strbuf(""); int j, atpos, numpar = strcurr.contains("/");

	straux = strcurr;
	for (int i = 1; i <= numpar; i++)
	{	straux = straux.mid(0, straux.find("/")+1);
		strbuf = strhold + straux;
		atpos  = whatidid.find("#" + strbuf);
		if (atpos == -1) { fputs(strbuf + "\n", nf); whatidid += (strbuf + "#"); }
		strhold += straux; straux = strcurr;
		for (j = 1; j <= i; j++) straux = straux.mid(straux.find("/")+1, straux.length());
		Working;
	}
}
//---------------------------------------------------------------------
void TKPackViewer::PreparePackFile()
{
	QString strcurr(""), strprev("");
 
 	(isNasty || isSLAdb) ? f = FOPEN(user_path + FLE_DIR, "r") : f = FOPEN(user_path + FLE_LOG, "r");
  	nf= FOPEN(user_path + FLE_PAK, "w");
	
	if (pack_type == tlzh) EatFleLn(f, 2);
	if (pack_type == tdeb) fputs("FILE LIST:\n", nf);
	if (GoodPack) fputs("FILE LIST:\n./\n", nf);
	do 
	{	FGETS(f, strcurr)  // Attention here.. IFGETS fails due to PREV algorithm...
		{	EnsureItem(strcurr);
			if (PackLineOK(strcurr))
			{	if (pack_type == trpm) { if (strcurr != strprev + "/") fputs(strprev + "\n", nf); }
				else { if (strcurr != strprev) fputs(strcurr + "\n", nf); }
			} strprev = strcurr;
		} Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::EnsureItem(QString &aitm)
{	QString aux("");
	if (RegularPack)
	{	if (NotNasty(tgz))
		{	aux = GetInfoAtr(aitm); aitm = GetInfoItm(aitm);
			if (aitm == "./") aitm = "";
			else { if (aux.left(1) == "d") ForceDir(aitm); }
		} else aitm = GetInfoItm(aitm);
	} else aitm = aitm.stripWhiteSpace();
}
//---------------------------------------------------------------------
bool TKPackViewer::IsSlack(QString pck)
{
	FILE *stf = FOPEN(pck, "r"); QString dummy(""); bf_dummy = false;
	IFGETS(stf, dummy)
	{	if ( dummy.find("VIRTUAL SLACK PACKAGE:", 0, false) > -1 ||
			 dummy.find("PACKAGE NAME:"         , 0, false) > -1 ||
			 dummy.find("FILE LIST:"            , 0, false) > -1 ||
			 dummy.find("./"                    , 0, false) > -1) bf_dummy = true; 
	} fclose(stf); return bf_dummy;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsDebian(QString pck)
{
	FILE *stf = FOPEN(pck, "r"); QString dummy(""); bf_dummy = false; Working;
	IFGETS(stf, dummy)
	{	if (dummy.find("VIRTUAL DEBIAN PACKAGE:", 0, false) > -1 ||
			dummy.left(8) == "Package:") bf_dummy = true;
	} fclose(stf); return bf_dummy;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsVRPM(QString pck)
{
	FILE *stf = FOPEN(pck, "r"); QString dummy(""); bf_dummy = false; Working;
	IFGETS(stf, dummy)
	{	bf_dummy = (dummy.find("VIRTUAL RPM PACKAGE:", 0, false) > -1);
	} fclose(stf); return bf_dummy;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsVSlack(QString pck)
{
	FILE *stf = FOPEN(pck, "r"); QString dummy(""); bf_dummy = false;
	IFGETS(stf, dummy)
	{	if ( dummy.find("VIRTUAL SLACK PACKAGE:", 0, false) > -1) bf_dummy = true; 
	} fclose(stf); return bf_dummy;
}
//---------------------------------------------------------------------
bool TKPackViewer::IsVDEB(QString pck)
{
	FILE *stf = FOPEN(pck, "r"); QString dummy(""); bf_dummy = false; Working;
	IFGETS(stf, dummy)
	{	if (dummy.find("VIRTUAL DEBIAN PACKAGE:", 0, false) > -1) bf_dummy = true;
	} fclose(stf); return bf_dummy;
}
//---------------------------------------------------------------------
int TKPackViewer::PackSize(QString fname)
{
	f = FOPEN(fname, "r"); QString dummy(""); int numlnspack = 0;
 	do 
	{	IFGETS(f, dummy)
		{	if (dummy.find("./", 0, false) > -1)  numlnspack++;
			if (numlnspack > 0 && GOODStr(dummy)) numlnspack++;
		} Working;
	} while (!feof(f)); fclose(f); numlnspack -= 3;	return numlnspack;
}
//---------------------------------------------------------------------
void TKPackViewer::GetItemParent(QString &astr)
{
	if (InRoot(astr)) return;
	// Chop dir specificator...
	if (IsDirectory(astr)) astr = astr.mid(0, astr.length()-1);
	// Scan last path string component...
	if (astr.find("/") == -1) astr = "/";
	else astr = astr.mid(0, astr.findRev("/"));
	// Ensure valid path...
	if (!IsDirectory(astr)) astr += "/"; if (astr.left(1) != "/") astr = "/" + astr;
}
//---------------------------------------------------------------------
bool TKPackViewer::InitFrame()
{
	// Initialize Widgets...
	// results->clear(); packtree->clear();
	(ALT_DIR > 2040) ? packtree->insertItem("/", fico) : packtree->insertItem("/", hom);

	// Initialize vars...
	idx  =  -1;
	curr = "";
	prev = "/";
	parentpos = 0;
	lastparent = "";
	dirlog.clear();

	// Verify valid data...
	bf_vsinit = false; bf_virtslak = false; bf_virtdeb = false; bf_virtrpm = false;
	if (pack_type == tslack && notSLAGrp(requested_pack))
	{
		if (!IsSlack(requested_pack)) { Warn(MSG_WARN24); return false; }
		bf_virtslak = IsVSlack(requested_pack);
	}

	if (pack_type == tvrpm && notRPMGrp(requested_pack))
	{
		bf_virtrpm = IsVRPM(requested_pack);
		if (!bf_virtrpm) { Warn(MSG_WARN30); return false; }
	}

	if (pack_type == tvdeb && notDEBGrp(requested_pack))
	{
		(bf_DEBdb) ? bf_virtdeb = IsDebian(requested_pack) : bf_virtdeb = IsVDEB(requested_pack);
		if (!bf_virtdeb) { Warn(MSG_WARN30); return false; }
	}

	flelns = PackSize(readable_pack);
	if (flelns >= 1) return true; Warn(MSG_WARN25); return false;
}
//---------------------------------------------------------------------
void TKPackViewer::GetItemFullPath(int itmidx, QString &abuf)
{
	abuf = ""; KPath paux; packtree->itemPath(itmidx, paux);
	do
	{ abuf = *paux.pop() + abuf; }
	while (!paux.isEmpty());
}
//---------------------------------------------------------------------
void TKPackViewer::FormatItem(QString itm)
{
	bool bfdir = IsDirectory(itm); if (bfdir) itm = itm.mid(0, itm.length()-1);
	if (itm.find("/") == -1) cbuf = itm;
	else
	{	int ppt = itm.find("->"); // " link to "
		if (ppt > -1)
		{	if (itm.findRev("/", ppt) > -1) itm = itm.mid(itm.findRev("/", ppt)+1, itm.length());
			itm = itm.stripWhiteSpace();
		} else { FNAME(itm); }
		cbuf = itm; if (cbuf.left(1) == "/") cbuf = cbuf.mid(1, cbuf.length());
	}
	if (bfdir) cbuf += "/";
}
//---------------------------------------------------------------------
bool TKPackViewer::InRoot(QString &astr)
{
	if ( astr.isNull() || astr.isEmpty() || astr == "/" || astr.find("/") == -1 ) { astr = "/"; return true; }
	return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::InItemFolder(QString itm)
{
	QString ditem(""), dparent(""); dparent = itm;
	GetItemParent(dparent);	GetItemFullPath(idx, ditem);
	return (ditem == dparent);
}
//---------------------------------------------------------------------
void TKPackViewer::LoadIcon(QPixmap &anicon, QString icon_file)
{
	if (!anicon.load(data_path + "/" + icon_file))
	{
		cerr << "ERROR loading:" << data_path + "/" + icon_file << "\n";
		cerr << "Did you run the make install procedure ?\n\n"; 
	}
}
//---------------------------------------------------------------------
void TKPackViewer::LoadIcons()
{
	LoadIcon(KPV  ,"KPackViewer.xpm");	LoadIcon(NKPV    ,"kpv_mini.xpm");
    LoadIcon(openSLACK,"slack.xpm"	);	LoadIcon(openRPM  ,"rpmlogo.xpm");
	LoadIcon(openDEB,"debian_logo.xpm");LoadIcon(openZIP  ,"zipack.xpm"	);
	LoadIcon(mntdeb   ,"mntdeb.xpm" );	LoadIcon(openTGZ  ,"targzip.xpm");	
    LoadIcon(openLHA  ,"lhapack.xpm");	LoadIcon(openGZP  ,"gzipack.xpm");
	LoadIcon(openARJ  ,"arjpack.xpm");	LoadIcon(quitAPP  ,"quitapp.xpm");
	LoadIcon(modeALL  ,"modeall.xpm");	LoadIcon(lookOUT  ,"look.xpm"   );
	LoadIcon(mntSLACK ,"mntslk.xpm" );	LoadIcon(mntRPM   ,"mntrpm.xpm" );
	LoadIcon(fresh    ,"fresh.xpm"  );	LoadIcon(alien    ,"alien.xpm"  );
	LoadIcon(openTBZ  ,"tarbzip.xpm");	LoadIcon(ledred,"status_red.xpm");
	LoadIcon(openRAR  ,"rarpack.xpm");	LoadIcon(ledgreen,"status_green.xpm");
	
	LoadIcon(hom, "home.xpm"); 	LoadIcon(fol, "dir.xpm");
	LoadIcon(gen, "gen.xpm");	LoadIcon(zip, "zip.xpm");
	LoadIcon(bz2, "bz2.xpm");	LoadIcon(gzp, "gzp.xpm");
	LoadIcon(hpp, "hpp.xpm");	LoadIcon(cpp, "cpp.xpm");
	LoadIcon(shl, "shl.xpm");	LoadIcon(lib, "lib.xpm");
	LoadIcon(pel, "pel.xpm");	LoadIcon(man, "man.xpm");
	LoadIcon(pyt, "pyt.xpm");	LoadIcon(grf, "grf.xpm");
	LoadIcon(pdf, "pdf.xpm");	LoadIcon(htm, "htm.xpm");
	LoadIcon(snd, "snd.xpm");	LoadIcon(awk, "awk.xpm");
	LoadIcon(inf, "inf.xpm");	LoadIcon(tex, "tex.xpm");
	LoadIcon(txt, "txt.xpm");	LoadIcon(mak, "mak.xpm");
	LoadIcon(exl, "exl.xpm");	LoadIcon(fnt, "fnt.xpm");
	LoadIcon(tcl, "tcl.xpm");	LoadIcon(dif, "dif.xpm");
	LoadIcon(eye, "eye.xpm");	LoadIcon(lsm,"slack.xpm");
	LoadIcon(pod, "pod.xpm");	LoadIcon(css, "css.xpm");
	LoadIcon(jav, "jav.xpm");	LoadIcon(pyo, "pyo.xpm");
	LoadIcon(pyc, "pyc.xpm");	LoadIcon(dbf, "dbf.xpm");
	LoadIcon(sgm, "sgm.xpm");	LoadIcon(lyx, "lyx.xpm");
	LoadIcon(vid, "vid.xpm");	LoadIcon(rtf, "rtf.xpm");
	LoadIcon(exe, "exe.xpm");	LoadIcon(ini, "ini.xpm");
	LoadIcon(m4 , "m4.xpm" );	LoadIcon(rpm, "rpm.xpm");
	LoadIcon(elc,"emacs.xpm");	LoadIcon(pgp,"pgp.xpm");
	LoadIcon(bak,"trash.xpm");	LoadIcon(alt,"folder.xpm");
	LoadIcon(dat, "dat.xpm");	LoadIcon(doc, "doc.xpm");
	LoadIcon(pot,"keyb.xpm");	LoadIcon(unk,"quest.xpm");
	LoadIcon(prj,"proj.xpm");	LoadIcon(inc,"inc.xpm");
	LoadIcon(mki,"makin.xpm");	LoadIcon(rul,"rul.xpm");
	LoadIcon( tk,"tk.xpm");		LoadIcon(def,"def.xpm");
	LoadIcon(rar, "rar.xpm");	LoadIcon(cad, "cad.xpm");
	LoadIcon(bas, "bas.xpm");	LoadIcon(frm, "frm.xpm");
	LoadIcon(hlp, "hlp.xpm");	LoadIcon(liba,"liba.xpm");
	LoadIcon(news,"news.xpm");	LoadIcon(aut,"aut.xpm");
	LoadIcon(dte,"dte.xpm");	LoadIcon(act,"act.xpm");
	LoadIcon(bin,"bin.xpm");	LoadIcon(pmd, "pmod.xpm");
	LoadIcon(pal, "pal.xpm");	LoadIcon(dof,"debpack_off.xpm");
	LoadIcon( am, "am.xpm");	LoadIcon(mon,"mon2.xpm");
	LoadIcon(lnk, "lnk.xpm");	LoadIcon(lsp, "lsp.xpm");
	LoadIcon(gmp, "gimp.xpm");	LoadIcon(scm, "scm.xpm");
	LoadIcon(inn, "inn.xpm");	LoadIcon(palet,"palet.xpm");
	LoadIcon( xs, "xs.xpm");	LoadIcon( cgi, "cgi.xpm");
	LoadIcon(sty,"sty.xpm");	LoadIcon(ldf,"ldf.xpm");
	LoadIcon(chk,"check.xpm");	LoadIcon(ptt,"t.xpm");
	LoadIcon(deb,"debian_logo.xpm");

	LoadIcon(alt_bf,"bfoldc.xpm");	LoadIcon(alt_cf,"cfoldc.xpm");
	LoadIcon(alt_gf,"gfoldc.xpm");	LoadIcon(alt_rf,"rfoldc.xpm");
	LoadIcon(alt_of,"ofoldc.xpm");	LoadIcon(alt_mf,"mfoldc.xpm");

	LoadIcon(alt_blu,"folder_blue.xpm"  ); LoadIcon(alt_cya,"folder_cyan.xpm"  );
	LoadIcon(alt_gre,"folder_green.xpm" ); LoadIcon(alt_red,"folder_red.xpm"   );
	LoadIcon(alt_yel,"folder_yellow.xpm"); LoadIcon(alt_mag,"folder_magent.xpm");
}
//---------------------------------------------------------------------
QPixmap TKPackViewer::GetItemPixmap(QString itm, int force)
{
	if (force == 0)
	{	if (isSLAGrp(requested_pack)) return mntSLACK;
		if (isDEBGrp(requested_pack) || isDEBStatus(requested_pack)) return mntdeb;
		if (isRPMGrp(requested_pack)) { if (isRPMFolder(path_to_packs)) return mntRPM; else return rpm; }
	}
	
	if (itm.find("->") > -1 ) return lnk;
	if (itm.left(2)  == "./") return hom;
	if (itm.right(1) == "/" ) return fico;
	if (itm.left(1)  == "." ) return unk;
	
	int ppt = itm.findRev("."); QString ext("");
	if (ppt > -1) { ext = itm.mid(ppt, itm.length()); ext = ext.lower(); }
	
	// Zip associated files
	if (ext == ".rpm") return rpm;
	if (ext == ".bz2") return bz2;	
	if (ext == ".zip") return zip;
	if (ext == ".deb") return deb;
	if (ext == ".gz"  && force == -1) return gzp;
	if (ext == ".tgz" || ext == ".z"   || ext == ".Z") return gzp;
	if (ext == ".arj" || ext == ".rar" || ext == ".lha" || ext == ".lzh") return rar;

	if (ext.right(3) != ".gz" && ext.right(4) != ".bat" &&
		ext.right(3) != ".sh" && ext.right(4) != ".btm" && 
		ext.right(4) != ".sys" )
	{
		QString aux(itm.lower());
		if (aux.find("readme" , 0, false) > -1) return eye;
		if (aux.left(3) == "faq" || aux.left(3) == "bug") return lookOUT;
		if (aux.left(7) == "copying" || aux.left(9) == "copyright" || aux.left(6) == "licens") return exl;
		if (aux.left(6) == "config"  || aux.left(8) == "makefile" ) { if (ext == ".in") return mki; else return mak; }
		if (aux.find(".", 0, false) == -1) // No extension...
		{
			if (aux.left(3) == "-sh"	) return shl;	
			if (aux.left(6) == "author"	) return aut;
			if (itm.find("makefile", 0, false) > -1) return mak;
			if (aux == "todo" || aux == "install" || aux == "setup") return exl;
			if (aux.left(6) == "change" || aux.left(7) == "version" || aux.left(4) == "news") return news;
			return gen;
		}
	}
	
// These in general don't have numbers to confuse...
	
	// Some sort of trash files
	if (ext.right(1) == "~" || ext == ".bak" || ext == ".tmp") return bak;

	// PGP related files
	if (ext == ".skr" || ext == ".pkr" || ext == ".asc" || ext == ".sig") return pgp;

	// Language associated files
	if (ext == ".m4"					)	return m4 ;
	if (ext == ".am"					)	return am ;
	if (ext == ".in"					)	return inn;
	if (ext == ".h"						)	return hpp;	
	if (ext == ".lsp"					)	return lsp;
	if (ext == ".py"					)	return pyt;
	if (ext == ".pyo"					)	return pyo;
	if (ext == ".pyc"					)	return pyc;
	if (ext == ".tcl"					)	return tcl;
	if (ext == ".tk" 					)	return tk ;
	if (ext == ".bas"					)	return bas;
	if (ext == ".frm"					)	return frm;
	if (ext == ".al"					)	return pal;
	if (ext == ".t"						)	return ptt;
	if (ext == ".xs"					)	return  xs;
	if (ext == ".pm"					)	return pmd;
	if (ext == ".cgi"					)	return cgi;
	if (ext == ".scm"					)	return scm;
	if (ext == ".awk"  || ext == ".sed" )	return awk;
	if (ext == ".pl"   || ext == ".perl")	return pel;
	if (ext == ".spec" || ext == ".mak" )	return mak;
	if (ext == ".bat"  || ext == ".btm"	)	return shl;
	if (ext.find(QRegExp(".*sh", false, true)) > -1) return shl;
	if (ext == ".prj" || ext == ".dlg"  || ext == ".obj") return prj;
	if (ext == ".c"   || ext == ".cpp"  || ext == ".cc"  || ext == ".asm" || ext == ".pas"  ) return cpp;
	if (ext == ".jav" || ext == ".java" || ext == ".js"  || ext == ".jar" || ext == ".class" || ext == ".jscript") return jav;
	
	if (ext.find(".dif"  , 0, false) > -1) return dif;
	if (ext.find(".patch", 0, false) > -1) return dif;

	// Document associated files
	if (ext == ".lsm"					)	return lsm;
	if (ext == ".pod"					)	return pod;
	if (ext == ".css"					)	return css;
	if (ext == ".sgml"					)	return sgm;
	if (ext == ".lyx"					)	return lyx;
	if (ext == ".ldf"					)	return ldf;
	if (ext == ".sty"					)	return sty;
	if (ext == ".rtf"					)	return rtf;
	if (ext == ".hlp"					)	return hlp;
	if (ext == ".man"					)	return man;
	if (ext == ".elc" || ext == ".el"	)	return elc;
	if (ext == ".tex" || ext == ".texi"	)	return tex;	
	if (ext == ".htm" || ext == ".html"	)	return htm;
	if (ext == ".txt" || ext == ".lst" || ext == ".log") return txt;	

	if (ext == ".act") return act;
	if (ext == ".sdc" || ext == ".wks") return dat;
	if (ext == ".dat" || ext == ".grf")	return dte;
	if (ext.find(QRegExp(".xl?", false, true)) > -1) return dat;
	if (ext == ".doc" || ext == ".dot" || ext == ".sdw") return doc;

	if (ext == ".dbf" || ext == ".mdb" || ext == ".sql" ||
		ext == ".dbm" || ext == ".gdbm") return dbf;
	
	// Binary/Misc associated files
	if (ext == ".dll" || ext == ".sys" || ext == ".rtl" ) return lib;
	if (ext == ".bin" || ext == ".com" || ext == ".exe"	) return exe;
	
	// Some sort of terminal definition file...
	if (ext == ".termcap" || ext == ".terminfo") return mon;

	// INI/CFG/LOG/Rules and all this_kind of stuff
	if (ext == ".reg" || ext == ".rules" || ext == ".tmpl")	return rul;
	if (ext == ".grp" || ext == ".dir"   || ext == ".def" || ext == ".defs") return def;
	
	if (ext == ".cf"  || ext == ".pif" || ext == ".init" || ext == ".cfg" ||
		ext == ".ini" || ext == ".lnk" || ext == ".inf"  ||	ext == ".ad"  ||
		ext == ".conf" || ext == ".kdelnk" || ext == ".desktop")
		return ini;

	// Some sort of locale associated file...
	if (itm.right(6) == "LOCALE") return pot;
	if (ext == ".gmo" || ext == ".mo" ||ext == ".po" || ext == ".pot") return pot;
	if (itm.find("locale", 0, false) > -1 && ext != ".gz" && ext != ".so" && ext != ".o" && ext != ".a") return pot;

	// Media associated files
	if (   ext == ".pal") return palet;
	if (   ext == ".gbr" || ext == ".pat") return gmp;
	if (   ext == ".wav" || ext == ".au"  || ext == ".mid" || ext == ".ra")	
		return snd;
	if (   ext == ".avi" || ext == ".mpg" || ext == ".mov" || ext == ".fli"
		|| ext == ".flc" || ext == ".cel" || ext == ".cmv")	
		return vid;
	if (   ext == ".gif" || ext == ".jpg" || ext == ".xpm" || ext == ".ico" 
		|| ext == ".xbm" || ext == ".bmp" || ext == ".pbm" || ext == ".pix" 
		|| ext == ".pcx" || ext == ".png" || ext == ".tif" || ext == ".ppm"
		|| ext == ".wmf" || ext == ".tiff" || ext == ".jpeg")
		return grf;
	if (   ext == ".fig" || ext == ".pov" || ext == ".cdr" || ext == ".vrml"
		|| ext == ".3ds" || ext == ".scn" || ext == ".lft" || ext == ".shp"
		|| ext == ".dwg" || ext == ".flm" || ext == ".sld" || ext == ".xlg")
		return cad;

	// Now we can have multiple numbers and  multiple dots...
	// And we dont have ALL the files to read MAGIC NUMBERS...
	// Very context dependent - god help the creator of the names...
	// Order matters when building better RegExps...
	// Note that almost all RegExps are in Wildcard mode...

	ext = itm.mid(itm.find("."), itm.length());

	// Inf related
	if (ext == ".info.gz" || ext == ".info") return inf;
	if (ext.find(QRegExp(".info-[0-9]*"   , false, true)) > -1) return inf;
	if (ext.find(QRegExp(".info*[0-9].gz" , false, true)) > -1) return inf;
	
	// Man related
	if (ext == ".n" || ext == ".n.gz") return man;
	if (ext.find(".tar.") == -1 && (ext.find(".so.", 0, false) == -1 || ext.right(3) == ".gz"))
	{	if (ext.find(QRegExp("*dif*gz"   , false, true)) > -1) return dif;
		if (ext.find(QRegExp("*.[0-9]"   , false, true)) > -1) return man;
		if (ext.find(QRegExp("*.[0-9]x"  , false, true)) > -1) return man;
		if (ext.find(QRegExp("*[0-9]*gz" , false, true)) > -1) return man;
		if (ext.find(QRegExp("*[0-9]*man", false, true)) > -1) return man;
	}
	if (itm.mid(itm.findRev("."), itm.length()) == ".gz" ) return gzp;
	
	// PostScript related
	if (ext == ".pdf" || ext == ".eps" || ext == ".ps" || ext == ".dvi") return pdf;
	if (ext.find(QRegExp(".[0-9].ps", false, true)) > -1) return pdf;
	if (ext.find(QRegExp(".ps*"     , false, true)) > -1) return pdf;
	
	// Font related
	if (ext.find(QRegExp(".pcf*",false,true)) > -1) return fnt;
	if (ext == ".ttf" || ext == ".pfm" || ext == ".pfb" || ext == ".pfa" || 
		ext == ".afm" || ext == ".gsf" || ext == ".spd" || ext == ".phont") return fnt;
	
	// Shared Lib related
	if (ext == ".so") return lib;
	if (ext == ".o" || ext == ".a" || ext == ".la"|| ext == ".sa") return liba;
	if (ext.find(QRegExp(".[0-9]*[0-9].a" , false, true)) > -1) return liba;
	if (ext.find(QRegExp(".so.[0-9]*[0-9]", false, true)) > -1) return lib;
	if (ext.find(QRegExp(".*[0-9].so"     , false, true)) > -1) return lib;
	if (ext.find(QRegExp(".so*"           , false, true)) > -1) return lib;

	return gen;
}
//---------------------------------------------------------------------
void TKPackViewer::SetKPVStyle(int astyle)
{
	mnuopt->setItemChecked(201, false);
	mnuopt->setItemChecked(202, false);
	mnuopt->setItemChecked(205, false);
	APP_STYLE = astyle; if (astyle == -1) { mnuopt->setItemChecked(205,true); return; }
	
	GUIStyle the_style = (GUIStyle)astyle;
	bool isMotif = (the_style == MotifStyle);
	isMotif ? mnuopt->setItemChecked(202,true) : mnuopt->setItemChecked(201,true);

	KApplication::setStyle(the_style);
	OpenNewKPV( GetKPVContext() ); Working; close();
}
//---------------------------------------------------------------------
void TKPackViewer::About()
{
	QString wintxt(""); wintxt = HTML_ABOUT; DESTROY(Shell_Viewer);
	Shell_Viewer = new TInfoWindow("About KPackViewer", wintxt, true);
	Shell_Viewer->exec(); DESTROY(Shell_Viewer);
}
//---------------------------------------------------------------------
void TKPackViewer::Help() 
{
	KPVApp->invokeHTMLHelp( "", "" );
}
//---------------------------------------------------------------------
void TKPackViewer::DumpMsg(QString msg) 
{
	if (msg == "") msg = amsg; cerr << msg << "\n"; 
}
//---------------------------------------------------------------------
void TKPackViewer::PrintMsg(QString msg) 
{
	if (msg == "") msg = amsg;
	statusBar()->message(msg); statusBar()->update(); Working;
}
//---------------------------------------------------------------------
void TKPackViewer::PrintInfo() 
{	
	QString KPVEng(""); KPVEng = "\nCurrent KPV Engine Status:\n";
	KPVEng += "  - Path To Packs : " + path_to_packs  + "\n";
	KPVEng += "  - Requested Pack: " + requested_pack + "\n";
	KPVEng += "  - Readable Pack : " + readable_pack  + "\n";
	
	switch (pack_type)
	{	case tslack: KPVEng += "  - Pack Type (curr/prev): Slack";		break;
		case tvdeb : KPVEng += "  - Pack Type (curr/prev): VDebian";	break;
		case tvrpm : KPVEng += "  - Pack Type (curr/prev): VRPM";		break;
		case tdeb  : KPVEng += "  - Pack Type (curr/prev): Debian";		break;
		case trpm  : KPVEng += "  - Pack Type (curr/prev): RPM";		break;
		case tzip  : KPVEng += "  - Pack Type (curr/prev): ZIP";		break;
		case tarj  : KPVEng += "  - Pack Type (curr/prev): ARJ";		break;
		case trar  : KPVEng += "  - Pack Type (curr/prev): RAR";		break;
		case tgz   : KPVEng += "  - Pack Type (curr/prev): TGZ";		break;
		case tbz2  : KPVEng += "  - Pack Type (curr/prev): TBZ2";		break;
		case tlzh  : KPVEng += "  - Pack Type (curr/prev): LHA";		break;
		case tz    : KPVEng += "  - Pack Type (curr/prev): TZ";			break;
		default    : KPVEng += "  - Pack Type (curr/prev): NONE";
	}
	
	switch (prev_type)
	{	case tslack: KPVEng += "/Slack  \n"; break;
		case tvdeb : KPVEng += "/VDebian\n"; break;
		case tvrpm : KPVEng += "/VRPM   \n"; break;
		case tdeb  : KPVEng += "/Debian \n"; break;
		case trpm  : KPVEng += "/RPM    \n"; break;
		case tzip  : KPVEng += "/ZIP    \n"; break;
		case tarj  : KPVEng += "/ARJ    \n"; break;
		case trar  : KPVEng += "/RAR    \n"; break;
		case tgz   : KPVEng += "/TGZ    \n"; break;
		case tbz2  : KPVEng += "/TBZ2   \n"; break;
		case tlzh  : KPVEng += "/LHA    \n"; break;
		case tz    : KPVEng += "/TZ     \n"; break;
		default    : KPVEng += "/NONE   \n";
	}
	
	KPVEng += "  - MODE_ALL : "        + amsg.setNum(pack_mode_all) + "\n";
	KPVEng += "  - IS_NASTY : "        + amsg.setNum(isNasty)       + "\n";
	KPVEng += "  - DB(D/R/S): "        + amsg.setNum(bf_DEBdb) + " - " + amsg.setNum(bf_RPMdb) + " - " + amsg.setNum(bf_SLAdb) + "\n";
	KPVEng += "  - Virtual RPM FLAG: " + amsg.setNum(bf_virtrpm )   + "\n";
	KPVEng += "  - Virtual RPM Path: " + user_path + VRT_RPM        + "\n";
	KPVEng += "  - Virtual RPM Org : " + vrt_rpm_org                + "\n";
	KPVEng += "  - Virtual DEB FLAG: " + amsg.setNum(bf_virtdeb )   + "\n";
	KPVEng += "  - Virtual DEB Path: " + user_path + VRT_DEB        + "\n";
	KPVEng += "  - Virtual DEB Org : " + vrt_deb_org                + "\n";
	KPVEng += "  - Virtual SLA FLAG: " + amsg.setNum(bf_virtslak)   + "\n";
	KPVEng += "  - Virtual SLA Path: " + user_path + VRT_SLA        + "\n";
	KPVEng += "  - Virtual SLA Org : " + vrt_sla_org                + "\n";
	
	cerr << KPVEng;
	TInfoWindow *kpveng = new TInfoWindow("KPV Engine Status", KPVEng, false, true);
	kpveng->exec(); DESTROY(kpveng);
}
//---------------------------------------------------------------------
void TKPackViewer::Beep() { BEEP }
//---------------------------------------------------------------------
void TKPackViewer::Warn(QString awarn, bool bep)
{
	WaitDone();	if (bep) BEEP; KMsgBox::message(this, TITLE, awarn); PrintMsg(MSG_DIV1);
}
//---------------------------------------------------------------------
void TKPackViewer::Confirm(QString aqst, bool &ret, bool bep)
{
	if (bep) BEEP; ret = (KMsgBox::yesNo(this, "Confirm...", aqst, 32+8) == 1);
}
//---------------------------------------------------------------------
void TKPackViewer::Fatal(QString aerr)
{
	WaitDone(); BEEP; QMessageBox::critical(this, DLG_DIV25, aerr);
	KPVApp->quit(); exit(1);
}
//---------------------------------------------------------------------
bool TKPackViewer::FTEST(FILE *&afle, QString flenme, QString amod)
{
	afle = fopen(flenme, amod); return (afle != NULL);
}
//---------------------------------------------------------------------
FILE* TKPackViewer::FOPEN(QString afle, QString amod)
{
	FILE *xfle = fopen(afle, amod); if (xfle != NULL) return xfle;
	
	(amod == "r") ? amsg = MSG_WARN3 : amod = MSG_WARN2; amsg += afle; Fatal(amsg);
}
//---------------------------------------------------------------------
int TKPackViewer::FileLines(QString FullPath) // Simple Text File routine
{
	f = FOPEN(FullPath, "r"); QString dummy(""); int numlnspack = 0;
 	do 
	{	IFGETS(f, dummy) { numlnspack++; } Working;
	} while (!feof(f)); fclose(f); return numlnspack;
}
//---------------------------------------------------------------------
bool TKPackViewer::FileExists(QString FullPath) // Simple Text File routine
{
	FILE *afle = fopen(FullPath, "r");
	if (afle != NULL) { fclose(afle); return true; } else return false;
}
//---------------------------------------------------------------------
void TKPackViewer::FileReset(QString FullPath) // Simple Text File routine
{
	FILE *afle = FOPEN(FullPath, "w"); fputs("", afle); fclose(afle);
}
//---------------------------------------------------------------------
void TKPackViewer::closeEvent( QCloseEvent *e )
{
	e = e; // __unused__
	PrintMsg(MSG_EXIT); dirlog.clear(); PrintMsg(MSG_EXIT);
	if (windowList.count() == 1)
	{	SetKPVConfig(); PrintMsg(MSG_EXIT); delete this;
		cerr << "Bye.\n\n"; KPVApp->quit();
	} else { PrintMsg(MSG_DIV31); delete this; }
}
//---------------------------------------------------------------------
void TKPackViewer::Quit()
{
	if (windowList.count() > 0) close(true);
};
//---------------------------------------------------------------------
void TKPackViewer::SetKPVConfig() 
{
	KConfig *conf = KPVApp->getConfig();
	
	conf->setGroup( "Options" );
	cfgbuf = conf->writeEntry( "CheckMem", CHK_MEM	 );
	cfgbuf = conf->writeEntry( "NiceTree", nice3	 );
	cfgbuf = conf->writeEntry( "inHTML"  , inHTML	 );
	cfgbuf = conf->writeEntry( "AltDir"  , ALT_DIR	 );
	cfgbuf = conf->writeEntry( "Style"   , APP_STYLE );
	conf->setGroup( "Window" );
	cfgbuf = conf->writeEntry( "WinXPos"  , x()		 );
	cfgbuf = conf->writeEntry( "WinYPos"  , y()		 );
	cfgbuf = conf->writeEntry( "WinWidth" , width()	 );
 	cfgbuf = conf->writeEntry( "WinHeight", height() );
	conf->sync();
}
//---------------------------------------------------------------------
void TKPackViewer::MenuMsg(int which)
{
	switch (which)
	{	case 101: PrintMsg(M_SLACK	); break;
		case 102: PrintMsg(M_RPM	); break;
		case 103: PrintMsg(M_DEB	); break;
		case 104: PrintMsg(M_ZIP	); break;
		case 105: PrintMsg(M_TGZ	); break;
		case 106: PrintMsg(M_TBZ	); break;
		case 107: PrintMsg(M_LHA	); break;
		case 108: PrintMsg(M_GZP	); break;
		case 109: PrintMsg(M_ALL	); break;
		case 110: PrintMsg(M_LOOK	); break;
		case 111: PrintMsg(M_QUIT	); break;
		case 112: PrintMsg(M_MNTSLK	); break;
		case 113: PrintMsg(M_MNTRPM ); break;
		case 114: PrintMsg(M_FRESH	); break;
		case 115: PrintMsg(M_MNTDEB ); break;
		case 116: PrintMsg(M_NKPV	); break;
		case 117: PrintMsg(M_ARJ	); break;
		case 118: PrintMsg(M_RAR	); break;
		case 201: PrintMsg(M_GUIWIN	); break;
		case 202: PrintMsg(M_GUIMOT	); break;
		case 203: PrintMsg(M_MCHK	); break;
		case 204: PrintMsg(M_AFIC	); break;
		case 205: PrintMsg(M_GUISYS	); break;
		case 206: PrintMsg(M_INHTML	); break;
		case 207: PrintMsg(M_NIC3	); break;
		case 301: PrintMsg(M_ABOUT	); break;
		case 302: PrintMsg(M_HELP	); break;
		default : PrintMsg(MSG_DIV1 );
	}		
}
//---------------------------------------------------------------------
void TKPackViewer::ToggleMemChk()
{
	CHK_MEM = !CHK_MEM; mnuopt->setItemChecked(203, CHK_MEM);
}
//---------------------------------------------------------------------
void TKPackViewer::ToggleNice3()
{
	nice3 = !nice3; mnuopt->setItemChecked(207, nice3);
}
//---------------------------------------------------------------------
void TKPackViewer::ToggleHTML()
{
	inHTML = !inHTML; mnuopt->setItemChecked(206, inHTML); SetInfoView();
}
//---------------------------------------------------------------------
void TKPackViewer::ChangeFolderIcon(int mnu_id)
{
	if (ALT_DIR == mnu_id) return; SetFolderIcon(mnu_id);
}
//---------------------------------------------------------------------
void TKPackViewer::SetFolderIcon(int icon_id, bool relod)
{
	mnufol->setItemChecked(ALT_DIR, false);
	ALT_DIR = icon_id;
	mnufol->setItemChecked(ALT_DIR, true);
	switch (ALT_DIR)
	{	case 2041: fico = alt    ; break;
		case 2042: fico = alt_blu; break;
		case 2043: fico = alt_red; break;
		case 2044: fico = alt_gre; break;
		case 2045: fico = alt_yel; break;
		case 2046: fico = alt_mag; break;
		case 2047: fico = alt_cya; break;
		case 2048: fico = alt_bf ; break;
		case 2049: fico = alt_rf ; break;
		case 2050: fico = alt_gf ; break;
		case 2051: fico = alt_of ; break;
		case 2052: fico = alt_mf ; break;
		case 2053: fico = alt_cf ; break;
		default:   fico = fol;
	} if (relod) ReloadPack();
}
//---------------------------------------------------------------------
bool TKPackViewer::MemAvail()
{/* The code expects to find the layout below...
        total:    used:    free:  shared: buffers:  cached:
Mem:  64737280 61042688  3694592 60186624  5324800 20656128
Swap: 123371520    65536 123305984
MemTotal:     63220 kB
MemFree:       3608 kB
MemShared:    58776 kB
Buffers:       5200 kB
Cached:       20172 kB
SwapTotal:   120480 kB
SwapFree:    120416 kB */

	if (!CHK_MEM) return true;

    FILE *mef = fopen(MEM_FLE, "r"); if ( !mef ) { Fatal(MSG_WARN9); return false; }
	
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef); memdum = membuf;
	MemTot = memdum.mid(memdum.find(":")+1, memdum.length());
	fgets(membuf, MEMLEN, mef); memdum = membuf;
	MemFree = memdum.mid(memdum.find(":")+1, memdum.length());
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef);
	fgets(membuf, MEMLEN, mef); memdum = membuf;		
	SwapTot = memdum.mid(memdum.find(":")+1, memdum.length());
	fgets(membuf, MEMLEN, mef); memdum = membuf;
	SwapFree = memdum.mid(memdum.find(":")+1, memdum.length());
	fclose(mef);

	// Strip unwanted chars...
	MemTot   = MemTot.stripWhiteSpace();
	SwapTot  = SwapTot.stripWhiteSpace();
	MemFree  = MemFree.stripWhiteSpace();
	SwapFree = SwapFree.stripWhiteSpace();
	MemTot   = MemTot.mid(0, MemTot.length()-3);
	SwapTot  = SwapTot.mid(0, SwapTot.length()-3);
	MemFree  = MemFree.mid(0, MemFree.length()-3);
	SwapFree = SwapFree.mid(0, SwapFree.length()-3);
		
	// Test against 10% of total available
	unsigned int avail = (MemTot.toUInt() - MemFree.toUInt() ) + (SwapTot.toUInt() - SwapFree.toUInt());
	if (avail > (unsigned int)(0.1)*(MemTot.toUInt() + SwapTot.toUInt())) return true;
	Warn(MSG_WARN8); return false;		
}
//---------------------------------------------------------------------
void TKPackViewer::TabSelected(int tab)
{
	switch (tab) 
	{ 	case  0: SetView(0); break;
		case  1: SetView(1); break;
		default: SetInfoView();
	} PrintMsg(MSG_DIV1);
}
//---------------------------------------------------------------------
void TKPackViewer::SetInfoView()
{
	if (tabbar->currentTab() != 2)	return; // Attention, order matters...
	if		( InGroupView() ) { (inHTML) ? SetView(3) : SetView(5); }
	else if	(  isGroupable  ) { (inHTML) ? SetView(3) : SetView(2); }
	else SetView(4);  // Apply to: Zip, BZip2, Lha, TGZ. Arj...
}
//---------------------------------------------------------------------
void TKPackViewer::SetView(int which)
{
	if (which != GetView()) ResetView(); else return;
	switch(which)
	{	case  1: results->show();	break;
		case  2: info->show();		break;
		case  3: finfo->show();		break;
		case  4: packview->show();	break;
		case  5: grpview->show();	break;
		default: packtree->show();
	}
}
//---------------------------------------------------------------------
int TKPackViewer::GetView()
{
	if		(packtree->isVisible() ) return 0;
	else if	(results->isVisible()  ) return 1;
	else if	(info->isVisible()     ) return 2;
	else if	(finfo->isVisible()    ) return 3;
	else if	(packview->isVisible() ) return 4;
	else if	(grpview->isVisible()  ) return 5;
	else return -1;
}
//---------------------------------------------------------------------
void TKPackViewer::ResetView(bool force)
{
	if ( !force )
	{	switch(GetView())
		{	case 0: packtree->hide();	break;
			case 1: results->hide();	break;
			case 2: info->hide();		break;
			case 3: finfo->hide();		break;
			case 4: packview->hide();	break;
			case 5: grpview->hide();	break;
		}
	} else { packtree->hide(); results->hide(); info->hide(); finfo->hide(); packview->hide(); grpview->hide(); }
}
//---------------------------------------------------------------------
void TKPackViewer::SearchFor(QString criteria, int Mode)
{
	switch (GetView())
	{	case  0: packtree->Search(criteria, Mode); break;
		case  1:  results->Search(criteria, Mode); break;
		default: packview->Search(criteria, Mode); break;
	}
}


//==<Code to manage Extraction and Convertion>=========================


bool TKPackViewer::TrivialErr()
{
	if (packages->Zerd()) return true; if (isBusy) return true;
	if (isRPMdb || isDEBdb || isSLAdb) { Beep(); Warn(MSG_WARN1); return true; }
	if (InGroupView()) { Warn(MSG_WARN6); return true; }
	return false;
}
//---------------------------------------------------------------------
void TKPackViewer::SetConvertPath()
{
	amsg = DLG_DIV23 + requested_pack; PrintMsg(amsg); amsg += DLG_DIV24;
	if (xtrak_opt.find(PAK_ALN_R, 0, false) == -1)
	{	if (DirExists(user_path + PAK_ALN, true)) amsg +=  user_path + "/Alien";
		else { Warn(MSG_WARN4); bf_dummy = DirExists("/"); amsg +=  "/"; }
	} else amsg += RPM_RPM;
}
//---------------------------------------------------------------------
void TKPackViewer::ConvertPack()
{
	if (TrivialErr()) return;
	if (pack_type != trpm && pack_type != tdeb && pack_type != tgz) { WARN(MSG_WARN5); }
	PrintMsg(MSG_DIV13);
	TKPVExtract *dlg = new TKPVExtract(requested_pack, true); int retval = dlg->exec();
	if (retval == QDialog::Rejected) { DESTROY(dlg); NoPanic; }
	xtrak_opt = dlg->GetOptions(); DESTROY(dlg); timer->restart(); SetConvertPath();
	ExternExec(xtrak_opt + requested_pack);
}
//---------------------------------------------------------------------
void TKPackViewer::ExtractTo()
{
	if 		( InGroupView() ) OpenNewKPV(GetKPVContext());
	else if (  TrivialErr() ) return;
	else if (    InFolder   ) ExtractVirtualPak();
	else if (    isDEBxt    ) DoExtractDeb(requested_pack);
	else                      DoExtractTo(requested_pack);
}
//---------------------------------------------------------------------
void TKPackViewer::ExtractVirtualPak()
{
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Virtual_Path" );
	vrt_sla_org = conf->readEntry("SLAK_PATH", ""); vrt_deb_org = conf->readEntry("DEB_PATH" , "");

	QString aux(path_to_packs + CurrPackLabel);

	if (path_to_packs == user_path + VRT_DEB)
	{	aux = GetPackOrigin(aux, vrt_deb_org);
		if (aux == "!") { WARN(MSG_WARN34 + aux); }
		if (aux ==  "") { WARN(MSG_WARN35 + aux); }
		if (FileExists(aux)) DoExtractDeb(aux); else { WARN(MSG_WARN7 + aux); }
	}
	else if (path_to_packs == user_path + VRT_RPM)
	{	aux = GetPackOrigin(aux, vrt_rpm_org);
		if (aux == "!") { WARN(MSG_WARN34 + aux); }
		if (aux ==  "") { WARN(MSG_WARN35 + aux); }
		if (FileExists(aux)) DoExtractTo(aux); else { WARN(MSG_WARN7 + aux); }
	}
	else if (path_to_packs == user_path + VRT_SLA)
	{	aux = GetPackOrigin(aux, vrt_sla_org);
		if (aux == "!") { WARN(MSG_WARN34 + aux); }
		if (aux ==  "") { WARN(MSG_WARN35 + aux); }
		if (FileExists(aux)) DoExtractTo(aux); else { WARN(MSG_WARN7 + aux); }
	} else { }
}
//---------------------------------------------------------------------
QString TKPackViewer::GetPackOrigin(QString pck, QString vrt_def)
{
	QString aux(""), pak(""), dummy("");
	f = FOPEN(GoodPath(pck), "r"); IFGETS(f, aux)
	{	if (aux.left(7) == "VIRTUAL")
		{	aux = aux.mid(aux.find(":")+1, aux.length()); pak = aux.stripWhiteSpace();
			IFGETS(f, dummy)
			{	if (dummy.left(16) == "ORIGINATED FROM:") dummy = dummy.mid(17, dummy.length()); else dummy = vrt_def;
				dummy = dummy.stripWhiteSpace(); ForceDir(dummy);
				if (vrt_def == vrt_sla_org)
				{	BGETS(f, aux); if (aux.left(17) == "PACKAGE LOCATION:")
					{	aux = aux.mid(aux.find("disk")+4, aux.length()); aux = aux.stripWhiteSpace();
						if (aux.find("Unknown") == 0) aux = "contrib/";
						else aux =  "slakware/" + aux + "/"; pak += ".tgz";
					} else { aux = ""; fclose(f); return aux; }
				} else aux = ""; aux = dummy + aux + pak;
			} else aux = "";
		} else aux = "";
	} else aux = "!"; fclose(f); return aux;
}
//---------------------------------------------------------------------
void TKPackViewer::DoExtractDeb(QString adeb)
{
	PrintMsg(MSG_DIV14); TKPVExtractDeb *chodeb = new TKPVExtractDeb();
	int retval = chodeb->exec(); TOption option = chodeb->GetOptions();
	DESTROY(chodeb); if (retval == QDialog::Rejected) return;
	if (option != Option_1)
	{	QString aux(PAK_DEB_INS); (option == Option_4) ? aux += "--force-conflicts " : aux += "--force-depends ";
		aux += adeb; amsg = MSG_DIV15 + adeb; PrintMsg(amsg); timer->restart(); ExternExec(aux); return;
	} 

	TKPVExtract *dlg = new TKPVExtract(adeb); retval = dlg->exec();
	if (retval == QDialog::Rejected) { DESTROY(dlg); }
	else { xtrak_opt = dlg->GetPath(); DESTROY(dlg); ForceDir(xtrak_opt); DoExtractPack(adeb); }
	PrintMsg(MSG_DIV1);
}
//---------------------------------------------------------------------
void TKPackViewer::DoExtractTo(QString apak)
{
	(isRPMxt) ? PrintMsg(MSG_DIV14) : PrintMsg(MSG_DIV17);
	int wSel = 0; QString thesel(""); QStrList selst; selst.setAutoDelete(true);
	switch (tabbar->currentTab())
	{	case 1: wSel = results->GetNumSelection() ; if (wSel) results->GetSelection(&selst) ; break;
		case 2: wSel = packview->GetNumSelection(); if (wSel) packview->GetSelection(&selst); break;
		default: break;
	}
	TKPVExtract *dlg = new TKPVExtract(apak, false, &selst, wSel); int retval = dlg->exec();
	if (retval == QDialog::Rejected) { DESTROY(dlg); selst.clear(); NoPanic; }
	(isRPMxt) ? xtrak_opt = dlg->GetOptions() : xtrak_opt = dlg->GetPath();
	DESTROY(dlg); Working; ForceDir(xtrak_opt); Working; DoExtractPack(apak);
}
//---------------------------------------------------------------------
void TKPackViewer::DoExtractPack(QString apak)
{
	TPack ptype; (pack_mode_all) ? ptype = GetPackType(CurrPackLabel) : ptype = GetPackType(apak);
	if (ptype != trpm) { if (!DirExists(xtrak_opt)) { WARN(MSG_WARN29 + xtrak_opt); }}

	QString AQry(""); amsg = DLG_DIV14; DQuoteStr(apak); timer->restart();
	switch (ptype)
	{	case trpm  : amsg += "RPM "  ; AQry = xtrak_opt   + apak; break;
		case tzip  : amsg += "ZIP "  ; AQry = PAK_ZIP_XTR + apak; break;
		case tlzh  : amsg += "LHA "  ; AQry = PAK_LHA_XTR + apak; break;
		case tz    : amsg += "GZIP " ; AQry = PAK_GZP_XTR + apak; break;
		case tarj  : amsg += "ARJ "  ; AQry = PAK_ARJ_XTR + apak; break;
		case trar  : amsg += "RAR "  ; AQry = PAK_RAR_XTR + apak; break;
		case tbz2  : amsg += "BZIP2 "; AQry = PAK_BZ2_XTR + apak + PAK_TAR_XTR; break;

		case tslack: if (GetPackExt(apak) != "tgz") return;
		case tgz   : amsg += "TGZ "  ; AQry = PAK_TGZ_XTR + apak; break;

		case tvdeb : if (GetPackExt(apak) != "deb") return;
		case tdeb  : amsg += "DEB "  ; AQry = PAK_DEB_XTR + apak + " " + xtrak_opt; break;		

		default    : return;
	}
	amsg += "package " + apak + "..."; PrintMsg(amsg); ExternExec(AQry); 
}
//---------------------------------------------------------------------
void TKPackViewer::ExternExec(QString AQry, bool block)
{
	exec_ok = true; shell_out = amsg + "\n"; DESTROY(Shell_Viewer);
	Shell_Viewer = new TInfoWindow(VIEWTIT, shell_out, false, false);
	Shell_Viewer->show(); Working; Working;

	KShellProcess *proc = new KShellProcess(); (*proc) << AQry;
	connect(proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(ExternOutput(KProcess*, char*, int)));
	connect(proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(ExternOutput(KProcess*, char*, int)));
	connect(proc, SIGNAL(processExited(KProcess*)), this, SLOT(ExternEnd(KProcess*))); Working; Working;
	proc->start((block)?KProcess::Block:KProcess::NotifyOnExit, KProcess::AllOutput);
}
//---------------------------------------------------------------------
void TKPackViewer::ExternOutput(KProcess*, char *buffer, int buflen)
{
	QString aux(""); aux = buffer; aux = aux.mid(0, buflen);
	shell_out += aux; Shell_Viewer->SetText(shell_out);
}
//---------------------------------------------------------------------
void TKPackViewer::ExternEnd(KProcess *proc)
{
	DESTROY(proc); shell_out += DLG_DIV22;
	Shell_Viewer->SetText(shell_out); cerr << shell_out << "\n";
	PrintElapsed(); bf_dummy = DirExists(path_to_packs);
}


//==<Code to View packages in Groups>==================================


void TKPackViewer::ShowGroups(TPack GrpType)
{
	DESTROY( oneshot ); shotwhat = ""; if (InRpmFolder) GrpType = tvrpm;
	// Sanity Check...	
	switch (GrpType)
	{	case tvdeb : if (! (InDebFolder) ) { WARN(MSG_WARN22); } break;
		case tvrpm : if (! (InRpmFolder) ) { WARN(MSG_WARN22); } break;
		case tslack: if (! (InSlaFolder) ) { WARN(MSG_WARN22); } break;		
		case trpm  : if (!isRPMdb && !ExistRPMs()) { WARN(MSG_WARN15); } break;
		default: return;
	} ClearPack();
	
	htmlinfo = HTML_HEADER; htmlinfo += GRUP_HEADER;
	FileReset(user_path + FLE_LST); grpview->Reset((int)tabbar->width() >> 1);
	SetLedOn(); if (PackCount > GRPMIN) { amsg = MSG_DIV9; SPACED(amsg); ProgInit(amsg, PackCount); }
	
	QListViewItem *curritm = FirstPack; int i = 0; timer->restart(); PrintMsg(DLG_DIV41);
	while( curritm )
	{	GetGroupInfo(GrpType, curritm->text(0)); i++;
		if (PackCount > GRPMIN) { ProgDlg->setProgress(i); if (ProgDlg->wasCancelled()) goto nomore; }
		curritm = curritm->itemBelow();
		Working;
	}
nomore: if (PackCount > GRPMIN) { ProgDlgDone; } PrintMsg(MSG_DIV3);

	switch (GrpType)
	{	case tslack: SortPackList(); requested_pack = ID_SLA_GRP; SetModeTo(tslack, bf_SLAdb); break;
		case tvdeb : SortPackList(); requested_pack = ID_DEB_GRP; SetModeTo(tvdeb , bf_DEBdb); break;
		case tvrpm : SortPackList(); requested_pack = ID_RPM_GRP; SetModeTo(tvrpm , bf_RPMdb); break;
		case trpm  : DoRPMGrpInfo(); requested_pack = ID_RPM_GRP; SetModeTo(trpm  , bf_RPMdb); break;
		default: break;
	}

	htmlinfo += "</TABLE></CENTER>"; htmlinfo += HTML_FOOTER; SetHTMLView(htmlinfo); grpview->Activate();
	Pack_Parse(); readable_pack = user_path + FLE_DIR; ReadPack(); SetInfoView();
}
//---------------------------------------------------------------------
void TKPackViewer::GetGroupInfo(TPack GrpType, QString anitm)
{
	switch (GrpType)
	{	case tvdeb : GetDebGroupInfo(anitm);   break;
		case tslack: GetSlackGroupInfo(anitm); break;
		case tvrpm : GetVRPMGroupInfo(anitm);  break;
		case trpm  : if (isRPMdb) GetRPMGroupInfo(anitm); else { if (GetPackType(anitm) == trpm) GetRPMGroupInfo(anitm); } break;
		default: break;
	} 
}
//---------------------------------------------------------------------
void TKPackViewer::GetDebGroupInfo(QString apck)
{
	f = FOPEN(GoodPath(path_to_packs + apck), "r"); nf = FOPEN(user_path + FLE_LST, "a");
	FNAME(apck); FNODOT(apck); QString aux(""), grp(""), dsc("");
	do 
	{	IFGETS(f, aux)
		{	if (!isDEBdb)
			{	if (aux.find("VIRTUAL DEBIAN PACKAGE:", 0, false) > -1)
				{	grp = aux.mid(aux.find(":")+1, aux.length()); grp = grp.stripWhiteSpace();
					FNODOT(grp); fputs(grp + "\n", nf); grp = grp.mid(0, grp.findRev("/"));
			}}
			else
			{	if (aux.find("Section:", 0, false) > -1)
				{	grp = aux.mid(aux.find(":")+1, aux.length()); grp = grp.stripWhiteSpace();
					ForceDir(grp); fputs(grp + apck + "\n", nf);
			}}
			
			if (aux.find("Description:", 0, false) > -1)
			{	dsc = aux.mid(aux.find(":")+1, aux.length()); dsc = dsc.stripWhiteSpace(); }

			if (aux.find("FILE LIST:", 0, false) > -1) goto bstis;
		} Working;
	} while (!feof(f));
bstis: fclose(f); fclose(nf);
	grpview->Insert(mntdeb, apck, grp, dsc);
	htmlinfo += "<TR><TD>" + apck + "</TD><TD>" + grp + "</TD><TD>" + dsc + "</TD></TR>";
}
//---------------------------------------------------------------------
void TKPackViewer::GetVRPMGroupInfo(QString apck)
{
	f = FOPEN(GoodPath(path_to_packs + apck), "r"); nf = FOPEN(user_path + FLE_LST, "a");
	FNAME(apck); QString aux(""), grp(""), dsc(""); int ppt = -1;
	do 
	{	IFGETS(f, aux)
		{	if (isRPMTopic(aux))
			{	ppt = aux.find(":")+1;
				if (aux.left(13) == "Group       :") { grp = aux.mid(ppt, 40-ppt); grp = grp.stripWhiteSpace(); ForceDir(grp); fputs(grp + apck + "\n", nf); }
				if (aux.left(13) == "Summary     :") { dsc = aux.mid(ppt, aux.length()); dsc = dsc.stripWhiteSpace(); }
				if (aux.left(11) == "Description"  ) goto bastis;
			}
		} Working;
	} while (!feof(f));
bastis: fclose(f); fclose(nf);
	grpview->Insert(mntRPM, apck, grp, dsc);
	htmlinfo += "<TR><TD>" + apck + "</TD><TD>" + grp + "</TD><TD>" + dsc + "</TD></TR>";
}
//---------------------------------------------------------------------
void TKPackViewer::GetSlackGroupInfo(QString apck)
{
	QString aux(""), grp(""), dsc("");
 	f = FOPEN(GoodPath(path_to_packs + apck), "r"); nf = FOPEN(user_path + FLE_LST, "a");
	do 
	{	IFGETS(f, aux)
		{	if (aux.find("PACKAGE LOCATION:", 0, false) > -1)
			{	grp = GetSlackAlias(aux); aux = grp + "/" + apck + "\n"; fputs(aux,nf);
				IFGETS(f, aux)
				{	if (aux.find("PACKAGE DESCRIPTION:", 0, false) > -1) { FGETS(f, aux); }
					if (isINF(aux, apck)) { dsc = aux.mid(aux.find(":")+1, aux.length()); dsc = dsc.stripWhiteSpace(); }
					htmlinfo += "<TR><TD>" + apck + "</TD><TD>" + grp + "</TD><TD>" + dsc + "</TD></TR>"; 
					grpview->Insert(mntSLACK, apck, grp, dsc);
				} goto noslak;
			}
		} Working;
	} while (!feof(f));
noslak: fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetRPMGroupInfo(QString arpm)
{
	QString AQry(""), Tgt(""), Src("");
	Src = user_path + FLE_LST; Tgt = GoodPath(path_to_packs + arpm);

	(isRPMdb) ? AQry = PAK_RPM_QF : AQry = PAK_RPM_QPF;
	AQry += " \"%{NAME}-%{VERSION}-%{RELEASE}^%{GROUP}^%{SUMMARY}^%{GROUP}/" + arpm + "\n\" " + Tgt + " >> " + Src;

	ProcessExec(AQry); if (!exec_ok) DumpMsg(MSG_WARN33 + AQry);
}
//---------------------------------------------------------------------
void TKPackViewer::DoRPMGrpInfo()
{
	FILE *fgrpm = FOPEN(user_path + FLE_LST, "r"), *forpm = FOPEN(user_path + FLE_PAK, "w");
	QString aux(""), fle(""), grp(""), dsc(""), i_grp("");
	do 
	{	IFGETS(fgrpm, aux)
		{ 	SplitRPMGroupInfo(aux, fle, grp, dsc, i_grp);
			if (i_grp.left(1) == "/") i_grp ="NoGroup" + i_grp; i_grp += "\n"; fputs(i_grp, forpm);
			htmlinfo += "<TR><TD><B>" + fle + "</B></TD><TD>" + grp + "</TD><TD>" + dsc + "</TD></TR>";
			grpview->Insert(rpm, fle, grp, dsc);
		} Working;
	} while (!feof(fgrpm)); fclose(fgrpm); fclose(forpm); SortPackList(FLE_PAK);
}
//---------------------------------------------------------------------
void TKPackViewer::SplitRPMGroupInfo(QString ainf, QString &fle, QString &grp, QString &dsc, QString &i_grp)
{
	QString aux(""); aux = ainf.copy();
	fle = aux.mid(0, aux.find("^")); aux = aux.mid(aux.find("^")+1, aux.length());
	grp = aux.mid(0, aux.find("^")); aux = aux.mid(aux.find("^")+1, aux.length());
	dsc = aux.mid(0, aux.find("^")); aux = aux.mid(aux.find("^")+1, aux.length());
	fle = fle.stripWhiteSpace(); grp = grp.stripWhiteSpace(); dsc = dsc.stripWhiteSpace();
	i_grp = aux.stripWhiteSpace(); if (grp.isEmpty()) grp = "NoGroup";
}
//---------------------------------------------------------------------
QString TKPackViewer::GetSlackAlias(QString analias)
{
	QString xgrp(""), abuf(analias.mid(analias.find(":")+1, analias.length()));	abuf = abuf.stripWhiteSpace();
	if		(abuf.find(QRegExp("diska[0-9]*"  , false, true)) > -1)	xgrp = "Base System";
	else if	(abuf.find(QRegExp("diskap[0-9]*" , false, true)) > -1)	xgrp = "Linux Applications";
	else if	(abuf.find(QRegExp("diskd[0-9]*"  , false, true)) > -1)	xgrp = "Program Development";
	else if	(abuf.find(QRegExp("diske[0-9]*"  , false, true)) > -1)	xgrp = "GNU EMacs";
	else if	(abuf.find(QRegExp("diskf[0-9]*"  , false, true)) > -1)	xgrp = "FAQs";
	else if	(abuf.find(QRegExp("diskk[0-9]*"  , false, true)) > -1)	xgrp = "Kernel Source";
	else if	(abuf.find(QRegExp("diskn[0-9]*"  , false, true)) > -1)	xgrp = "Networking";
	else if	(abuf.find(QRegExp("diskt[0-9]*"  , false, true)) > -1)	xgrp = "TeX Distribution";
	else if	(abuf.find(QRegExp("disktcl[0-9]*", false, true)) > -1)	xgrp = "TCL Script Language";
	else if	(abuf.find(QRegExp("diskx[0-9]*"  , false, true)) > -1)	xgrp = "X Window System";
	else if	(abuf.find(QRegExp("diskxap[0-9]*", false, true)) > -1)	xgrp = "X Applications";
	else if	(abuf.find(QRegExp("diskxd[0-9]*" , false, true)) > -1)	xgrp = "X Development Tools";
	else if	(abuf.find(QRegExp("diskxv[0-9]*" , false, true)) > -1)	xgrp = "XView, OpenLook";
	else if	(abuf.find(QRegExp("disky[0-9]*"  , false, true)) > -1)	xgrp = "Games";
	else xgrp = "Miscellaneous";
	return xgrp;
}
//---------------------------------------------------------------------
bool TKPackViewer::ValidSLAFolder(QString &apath, bool verify)
{
	if (isSLAFolder(apath)) return true;

	QString aux(""); aux = apath.copy();
	if (!IsDirectory(aux)) GetItemParent(aux);
	if (DirExists(aux))
	{	if (verify) { if (aux != SLA_PAK && aux != user_path + VRT_SLA) apath = SLA_PAK; }
		return true;
	} else { if (verify) { apath = SLA_PAK; return true; }}
	return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::ValidRPMFolder(QString &apath, bool verify)
{
	if (isRPMFolder(apath)) return true;

	QString aux(""); aux = apath.copy();
	if (!IsDirectory(aux)) GetItemParent(aux);
	if (DirExists(aux))
	{	if (verify) { if (aux != user_path + VRT_RPM) apath = user_path + VRT_RPM; }
		return true;
	} else { if (verify) { apath = user_path + VRT_RPM; return true; }}
	return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::ValidDEBFolder(QString &apath, bool verify)
{
	if (isDEBFolder(apath)) return true;

	QString aux(""); aux = apath.copy();
	if (!IsDirectory(aux)) GetItemParent(aux);
	if (DirExists(aux))
	{	if (verify) { if (aux != user_path + VRT_TMP && aux != user_path + VRT_DEB) apath = user_path + VRT_TMP; }
		return true;
	} else { if (verify) { apath = user_path + VRT_TMP; return true; }}
	return false;
}
//---------------------------------------------------------------------
bool TKPackViewer::ExistRPMs()
{
	QListViewItem *curritm = FirstPack;
	while( curritm )
	{	if (GetPackType(curritm->text(0)) == trpm) return true;
		curritm = curritm->itemBelow();
	} return false;
}

//---------------------------------------------------------------------
void TKPackViewer::RemovePAK(void)
{
	TKPVRemovePAK *dlg = new TKPVRemovePAK(bf_RPMdb); int retval = dlg->exec();	
	if (retval == QDialog::Rejected) { DESTROY(dlg); PrintMsg(MSG_DIV1); return; }
	xtrak_opt = dlg->GetOptions(); DESTROY(dlg); 
	amsg = "Executing Remove Command: \n" + xtrak_opt + requested_pack + "\n";
	ExternExec(xtrak_opt + requested_pack, true);
	if (xtrak_opt.find("--test") == -1 && xtrak_opt.find("--no-act") == -1) RefreshPacks();
	PrintMsg(MSG_DIV1);
}


//==<Code to View RPM installed packages database>=====================


void TKPackViewer::LogRPM()
{
	if (!UpdateRPMPackList()) return;

	BlockFrame(true, MSG_DIV21); 
		readable_pack = " "; path_to_packs = " "; SetModeTo(trpm, true); TTip(ID_RPM_STA);
		QString aux(""); aux = RPMPackList.first();
		do { packages->Insert(rpm, aux); Working; aux = RPMPackList.next(); } while ( aux );
	BlockFrame(false);
	
	if (packages->Zerd()) { packtree->clear(); Warn(MSG_WARN15); } else SetPack();
}
//---------------------------------------------------------------------
bool TKPackViewer::UpdateRPMPackList()
{
	// Sanity Check RPM packs database...
	if (!FileExists(RPM_PAK)) { amsg = MSG_WARN21; amsg += RPM_PAK; Warn(amsg, true); PrintMsg(MSG_DIV1); return false; }
	
	// Query all RPM installed packs...
	QString AQry(""); AQry = user_path + FLE_RPM; AQry = PAK_RPM_QA + AQry;
	PrintMsg(MSG_DIV32); SetLedOn(); ProcessExec(AQry);
	if (!exec_ok) { SetLedOff(); AQry = MSG_WARN31 + AQry; DumpMsg(AQry); Warn(AQry); return false; }
	
	// Read RPM installed packs into string list...
	RPMPackList.clear(); FILE *frpm = FOPEN(user_path + FLE_RPM, "r");
	do 
	{ IFGETS(frpm, AQry) RPMPackList.append(AQry); Working;
	} while (!feof(frpm)); fclose(frpm); BlockFrame(false);
	PrintMsg(MSG_DIV1); return ( !RPMPackList.isEmpty() );
}


//==<Code to View DEB installed packages database>=====================


void TKPackViewer::LogDEB()
{
	DESTROY( oneshot ); shotwhat = ""; QString deb_file(DEB_PAK);
	
	// Sanity Check...
	if (!FTEST(f, deb_file, "r")) { PANIC(MSG_WARN7 + deb_file); }
	if (!DirExists(user_path + VRT_TMP, true)) { fclose(f); PANIC(MSG_WARN11); }

	// Init operations...
	FILE *df = FOPEN(user_path + FLE_LST, "w"); packages->clear(); TTip(DLG_DIV41); 
	int count = 0; bool bf_SectionFnd; QString aux(""), unk(""), debpack(user_path + VRT_TMP);
	
	BlockFrame(true, MSG_DIV21);
	do
	{	if (aux.left(8) == "Package:")
		{	// capture pack name
			debpack = aux.mid(8, aux.length()); debpack = debpack.stripWhiteSpace();
			// write a KPV pack list to it and verify pack section while doing it
			nf = FOPEN(user_path + VRT_TMP + debpack, "w"); bf_SectionFnd = false; 
			do
			{	if ( GOODStr(aux) ) fputs(aux + "\n", nf);
				if (aux.left(8) == "Section:") 
				{	bf_SectionFnd = true; aux = aux.mid(8, aux.length()) + "/" + debpack;
					aux = aux.stripWhiteSpace()+ "\n"; fputs(aux, df);
				} FGETS(f, aux); Working;
			} while (aux.left(8) != "Package:" && !feof(f));
			if (!bf_SectionFnd) // Make shure we really have a section...
			{ 	fputs("Section: unknown\n", nf);
				unk = "unknown/" + debpack + " \n"; fputs(unk, df);
			} fclose(nf); AppendDEBData(debpack); // Append FILELIST to KPV standard list
			// Insert pack in ListBox
			packages->Insert(mntdeb, debpack);
			count++; if (count > PACKCN) PrintMsg(MSG_DIV21 + amsg.setNum(count));
		} else { FGETS(f, aux); } Working;
	} while (!feof(f)); fclose(f); fclose(df);
	BlockFrame(false);
}
//---------------------------------------------------------------------
void TKPackViewer::AppendDEBData(QString apck)
{
	FILE *fdbl; if (!FTEST(fdbl,  DEB_LST + apck + ".list" , "r")) return;
	FILE *fapp; if (!FTEST(fapp, user_path + VRT_TMP + apck, "a")) return;
	QString aux(""), strcurr(""), strprev(""); fputs("FILE LIST:\n", fapp);
	do
	{	IFGETS(fdbl, strcurr)
		{	if (GOODStr(strcurr))
			{	if (strcurr == "/.") fputs("./\n", fapp);
				else
				{	if (ValidStr(strprev) && strprev != "/.")
					{	(strprev.left(1) != "/") ? aux = strprev : aux = strprev.mid(1, strprev.length());
						(strcurr.find(strprev, 0, true) == -1) ? fputs(aux + "\n", fapp) : fputs(aux + "/\n", fapp);
		}}}} if(!feof(fdbl)) strprev = strcurr; Working;
	} while (!feof(fdbl));
	(strcurr.left(1) != "/") ? aux = strcurr : aux = strcurr.mid(1, strcurr.length());
	fputs(aux + "\n", fapp); fclose(fdbl); fclose(fapp);
}


//==<Code to make the RPM Virtual Package Directory>===================


void TKPackViewer::MountRPM()
{
	PrintMsg(MSG_DIV34); QString cd_path("/"); 
	cd_path = KDirDialog::getDirectory(cd_path, this); if (cd_path.isEmpty()) { NoPanic; }
	
	if (DirExists(user_path + VRT_RPM))
	{	bf_dummy = false; Confirm(MSG_CONF1, bf_dummy, true); if ( !bf_dummy ) { NoPanic; }
	} else { if (!DirExists(user_path + VRT_RPM, true)) { WARN(MSG_WARN32); } }
	
	bf_dummy = false; Confirm(MSG_CONF2 + cd_path + "\n", bf_dummy, true);
	if ( !bf_dummy) { NoPanic; }
	
	// Performs a query to get all packages...
	QString AQry(""), Tgt(""); path_to_packs = cd_path;	// Includes the terminating slash
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Virtual_Path" );
	cfgbuf = conf->writeEntry( "RPM_PATH", cd_path ); conf->sync(); Working;
	AQry = user_path + FLE_RPM;	Tgt = cd_path + "*.rpm"; SQuoteStr(Tgt);
	AQry = PAK_LIST + Tgt + " > " + AQry; SetLedOn(); ProcessExec(AQry);
	if (!exec_ok) { WARN(MSG_WARN31 + AQry); }
	TTip(DLG_DIV41); ShowWait(MSG_DIV26); MountRPMPacks(); WaitDone();
	SetModeTo(tvrpm, false); SetPathTo(user_path + VRT_RPM); SetPack();
}
//---------------------------------------------------------------------
void TKPackViewer::MountRPMPacks()
{
	f = FOPEN(user_path + FLE_RPM, "r"); PrintMsg(MSG_DIV25 + user_path + VRT_RPM + "..."); 
	QString aux(""), AQry(""), Tgt(""), Src(user_path + FLE_LST); int ppt = 0;
	do 
 	{	IFGETS(f, aux)
		{	if (GOODStr(aux))
			{	Tgt  = aux.copy(); FNAME(Tgt); FNODOT(Tgt);
				Tgt  = user_path + VRT_RPM + Tgt; nf = FOPEN(Tgt, "w");
				AQry = aux.copy(); ppt = AQry.findRev("/");
				AQry = AQry.mid(ppt+1, AQry.length()); WaitDlg->WaitMsg(MSG_DIV26 + AQry); Working;
				AQry = "VIRTUAL RPM PACKAGE: " + AQry + "\nORIGINATED FROM: " + path_to_packs + "\n"; fputs(AQry, nf); fclose(nf); Working;
				AQry = PAK_RPM_QPI + aux + " >> "  + Tgt; ProcessExec(AQry); Working; if (!exec_ok) DumpMsg(MSG_WARN31 + AQry);
				nf = FOPEN(Tgt, "a"); fputs("\nFILE LIST: \n", nf); fclose(nf); Working;
				AQry = PAK_RPM_QPL + aux + " >> "  + Tgt; ProcessExec(AQry); Working; if (!exec_ok) DumpMsg(MSG_WARN31 + AQry);
			}
		} Working;
	} while (!feof(f)); fclose(f);
}


//==<Code to make the Debian Virtual Package Directory>================


void TKPackViewer::MountDEB()
{
	PrintMsg(MSG_DIV33); QString cd_path("/"); 
	cd_path = KDirDialog::getDirectory(cd_path, this); if (cd_path.isEmpty()) { NoPanic; }
	
	QDir admin_dir(cd_path + "admin"), base_dir(cd_path + "base"), lib_dir(cd_path + "libs");
	if (!admin_dir.exists() || !base_dir.exists() || !lib_dir.exists()) { OPS(MSG_WARN18, cd_path); }

	if (DirExists(user_path + VRT_DEB))
	{	bf_dummy = false; Confirm(MSG_CONF1, bf_dummy, true); if ( !bf_dummy ) { NoPanic; }
	} else { if (!DirExists(user_path + VRT_DEB, true)) { WARN(MSG_WARN32); } }

	bf_dummy = false; Confirm(MSG_CONF2 + cd_path + "\n", bf_dummy, true);
	if ( !bf_dummy) { NoPanic; }
	
	// Performs a query to get all packages...
	QString AQry(""), Tgt(""); path_to_packs = cd_path;	// Includes the terminating slash
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Virtual_Path" );
	cfgbuf = conf->writeEntry( "DEB_PATH", cd_path ); conf->sync(); Working;
	AQry = user_path + FLE_DEB;	Tgt = cd_path + "*/*.deb"; SQuoteStr(Tgt);
	AQry = PAK_LIST + Tgt + " > " + AQry; SetLedOn(); ProcessExec(AQry);
	if (!exec_ok) { WARN(MSG_WARN31 + AQry); }
	TTip(DLG_DIV41); ShowWait(MSG_DIV26); MountDEBPacks(); WaitDone();
	SetModeTo(tvdeb, false); SetPathTo(user_path + VRT_DEB); SetPack();
}
//---------------------------------------------------------------------
void TKPackViewer::MountDEBPacks()
{
	f = FOPEN(user_path + FLE_DEB, "r"); PrintMsg(MSG_DIV25 + user_path + VRT_DEB + "..."); 
	QString aux(""), AQry(""), Tgt(""), Src(user_path + FLE_LST); int ppt = 0;
	do 
 	{	IFGETS(f, aux)
		{	if (GOODStr(aux))
			{	Tgt  = aux.copy(); FNAME(Tgt); FNODOT(Tgt);
				Tgt  = user_path + VRT_DEB + Tgt; nf = FOPEN(Tgt, "w");
				AQry = aux.copy(); ppt = AQry.findRev("/"); ppt = AQry.findRev("/", ppt-1);
				AQry = AQry.mid(ppt+1, AQry.length()); WaitDlg->WaitMsg(MSG_DIV26 + AQry); Working;
				AQry = "VIRTUAL DEBIAN PACKAGE: " + AQry + "\nORIGINATED FROM: " + path_to_packs + "\n"; fputs(AQry, nf); fclose(nf); Working;
				AQry = PAK_DEB_INF + aux + " >> "  + Tgt; ProcessExec(AQry); Working; if (!exec_ok) DumpMsg(MSG_WARN31 + AQry);
				nf = FOPEN(Tgt, "a"); fputs("\nFILE LIST: \n", nf); fclose(nf); Working;
				AQry = PAK_DEB_LST + aux + " >> "  + Tgt; ProcessExec(AQry); Working; if (!exec_ok) DumpMsg(MSG_WARN31 + AQry);
			}
		} Working;
	} while (!feof(f)); fclose(f);
}


//==<Code to make the Slackware Virtual Package Directory>==============


void TKPackViewer::MountSLA()
{
	PrintMsg(MSG_DIV23); QString cd_path("/");
	cd_path = KDirDialog::getDirectory(cd_path, this); if (cd_path.isEmpty()) { NoPanic; }
	
	QDir packs_dir(cd_path + "contents"), scripts_dir(cd_path + "contents/scripts"), slak_dir(cd_path + "slakware");
	if (!packs_dir.exists() || !scripts_dir.exists() || !slak_dir.exists()) { OPS(MSG_WARN18, cd_path); }

	if (DirExists(user_path + VRT_SLA)) { WARN(MSG_WARN16); }
	else { if (!DirExists(user_path + VRT_SLA, true)) { WARN(MSG_WARN17); } }
	
	bf_dummy = false; Confirm(MSG_CONF2 + cd_path + "\n", bf_dummy, true);
	if ( !bf_dummy) { NoPanic; }
	
	// Performs a query to get all packages...
	QString AQry(""), Tgt(""); path_to_packs = cd_path;	// Includes the terminating slash
	KConfig *conf = KPVApp->getConfig(); conf->setGroup( "Virtual_Path" );
	cfgbuf = conf->writeEntry( "SLAK_PATH", cd_path ); conf->sync(); Working;
	AQry = user_path + FLE_SLK;	Tgt = cd_path + "slakware/*/disk*"; SQuoteStr(Tgt);
	AQry = PAK_LIST + Tgt + " > " + AQry; SetLedOn(); ProcessExec(AQry);
	if (!exec_ok) { WARN(MSG_WARN31 + AQry); }
	TTip(DLG_DIV41); ShowWait(MSG_DIV26); MountSLAPacks(); WaitDone();
	SetModeTo(tslack, false); SetPathTo(user_path + VRT_SLA); SetPack();
}
//---------------------------------------------------------------------
void TKPackViewer::MountSLAPacks()
{
	GenAllDescs(); PrintMsg(MSG_DIV25 + user_path + VRT_SLA + "'..."); 
	struct dirent *dirent; DIR *dir = opendir(path_to_packs + "contents");
	if (dir != NULL)
	{	do 
		{	dirent = readdir(dir);
			if (dirent != NULL && strcmp(dirent->d_name,".")!= 0 && strcmp(dirent->d_name,"..")!= 0)
			{	amsg =  dirent->d_name;
				if (amsg.find("TRANS.TBL", 0, false) == -1 && amsg != "scripts" && amsg.left(2) != "00")
				{	// for_each "contents" join description with script and file list...
					WaitDlg->WaitMsg(MSG_DIV26 + amsg );
					GetVSlackDesc(amsg); GetVSlackScript(amsg);	GetVSlackList(amsg);
				}
			} Working;
		} while (dirent != NULL); closedir(dir);
	}
}
//---------------------------------------------------------------------
void TKPackViewer::GenAllDescs()	// Mount a dumb huge file with all descs
{									
	FILE *mf; QString aux(""), pack_loc(""); PrintMsg(MSG_DIV24);
	
 	f  = FOPEN(user_path + FLE_SLK, "r"); nf = FOPEN(user_path + FLE_DSC, "w");
	do 
	{	IFGETS(f,aux)
		{	pack_loc = aux; FNAME(pack_loc); pack_loc = "PACKAGE LOCATION: " + pack_loc + " \n";
			fputs(pack_loc, nf); mf = FOPEN(aux, "r");
			do 
			{	IFGETS(mf, aux) { aux += "\n"; if (aux.left(9) != "CONTENTS:") fputs(aux,nf); }
				Working;
			} while (!feof(mf)); fclose(mf);
		} Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackDesc(QString astr)
{
	QString aux(""), pack_loc("");
	
 	f  = FOPEN(user_path + FLE_DSC, "r"); nf = FOPEN(user_path + VRT_SLA + astr, "w");
	aux = "VIRTUAL SLACK PACKAGE: " + astr + " \nORIGINATED FROM: " + path_to_packs + "\n";
	fputs(aux, nf);
	do 
	{	IFGETS(f, aux)
		{	if (aux.left(18) != "PACKAGE LOCATION: ") 
			{	if (isINF(aux, astr)) // Found, do_only the necessary...
				{	fputs(pack_loc + "\n", nf); GetVSlackSize(pack_loc, astr); 
					fputs("PACKAGE DESCRIPTION:\n", nf);
					while ( (aux.left(astr.length()+1) == (astr+":")) && !feof(f) )
					{ fputs(aux + "\n", nf); Working; FGETS(f, aux); } goto stopit;
				}
			} else pack_loc = aux;
		} Working;
	} while (!feof(f)); fputs("PACKAGE LOCATION: diskUnknown \n",nf);
stopit:	fclose(f); fclose(nf);
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackSize(QString pck_loc, QString pck)
{
	QString aux(""), Aux("");

  	aux = pck_loc.mid(pck_loc.find("disk")+4, pck_loc.length()); aux = aux.stripWhiteSpace();
	if (aux.find("Unknown") == 0) aux = path_to_packs + "contrib/";
	else aux = path_to_packs + "slakware/" + aux + "/"; aux += pck + ".tgz";
	if (!FileExists(aux)) return;
	Aux = PAK_TGZ_INF + aux + " > " + user_path + FLE_LST; ProcessExec(Aux); 
	if (!exec_ok) { DumpMsg(MSG_WARN33 + Aux); return; }
	FILE *FSz = FOPEN(user_path + FLE_LST, "r"); EatFleLn(FSz);
	IBGETS(FSz, aux) 
	{	Aux = aux.mid( 0, 10); Aux = Aux.stripWhiteSpace();
		unsigned long kval = Aux.toULong(); kval = kval>>10; Aux = Aux.setNum(kval) + " K";
		Aux = "COMPRESSED PACKAGE SIZE:     "   + Aux + " \n"; fputs(Aux, nf);
		Aux = aux.mid(10, 10); Aux = Aux.stripWhiteSpace();
		kval = Aux.toULong(); kval = kval>>10; Aux = Aux.setNum(kval) + " K";
		Aux = "UNCOMPRESSED PACKAGE SIZE:     " + Aux + " \n"; fputs(Aux, nf);
	} fclose(FSz);
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackScript(QString astr)
{
	if (!DirExists(path_to_packs + "contents/scripts")) return; QFile slack_script(astr);
	if (slack_script.open( IO_ReadOnly ))
	{	nf= FOPEN(user_path + VRT_SLA + astr, "a");
		fputs("          \n",nf);
		fputs("---<Script>--------------------------\n",nf);
		fputs("          \n",nf);
		QTextStream tx( &slack_script ); QString aux("");
		while (!tx.eof()) { aux = tx.readLine() + "\n"; fputs( aux, nf ); }
		fputs("          \n",nf);
		fclose(nf); slack_script.close();
	}
	bf_dummy = DirExists(user_path + VRT_SLA);
}
//---------------------------------------------------------------------
void TKPackViewer::GetVSlackList(QString astr)
{
	nf = FOPEN(user_path + VRT_SLA + astr, "a"); fputs("FILE LIST:\n", nf); 
	f  = FOPEN(path_to_packs + "contents/" + astr, "r"); QString aux("");
	do
	{	IFGETS(f, aux) fputs(aux.mid(48, aux.length()) + "\n", nf); Working;
	} while (!feof(f)); fclose(f); fclose(nf);
}


//==<Class TInfoWindow>=================================================


TInfoWindow::TInfoWindow(QString title, QString wintxt, bool in_HTML, bool isModal, QWidget *parent, const char *name)
:QDialog(parent, name, isModal )
{
	QPixmap aico; if (ILoad(aico, "/kpv_mini.xpm")) setIcon(aico);

	setCaption(title); ahtml = 0; atxt = 0;
	
	if (in_HTML)
	{	ahtml = new KHTMLView(this);
		ahtml->begin("", 1, 1); ahtml->write(wintxt); ahtml->end(); ahtml->parse();
		resize( 600, 400 );
	} else { atxt = new TKMultiEd(this); atxt->setText(wintxt); }

	OK_Button = new QPushButton( this );
	OK_Button->setText( DLG_DIV27 ); OK_Button->setMaximumHeight( 25 );
	connect( OK_Button, SIGNAL( released() ), this, SLOT( accept() ) );

	WLayout = new QVBoxLayout( this, 5 ); 
	(in_HTML) ? WLayout->addWidget(ahtml) : WLayout->addWidget(atxt);
	WLayout->addWidget(OK_Button);
	WLayout->activate(); if (!in_HTML) Restore();
}
//----------------------------------------------------------------------
void TInfoWindow::Restore()
{
	KConfig *conf = KPVApp->getConfig();

	conf->setGroup( "ShellViewer" );
	WinX = conf->readNumEntry( "WinXPos"  ,   1 );
	WinY = conf->readNumEntry( "WinYPos"  ,   1 );
	WinW = conf->readNumEntry( "WinWidth" , 500 );
	WinH = conf->readNumEntry( "WinHeight", 500 );

	setGeometry(WinX,WinY,WinW,WinH);
}
//---------------------------------------------------------------------
void TInfoWindow::SaveConfig() 
{
	KConfig *conf = KPVApp->getConfig();
	
	conf->setGroup( "ShellViewer" );
	cfgbuf = conf->writeEntry( "WinXPos"  ,      x() );
	cfgbuf = conf->writeEntry( "WinYPos"  ,      y() );
	cfgbuf = conf->writeEntry( "WinWidth" ,  width() );
 	cfgbuf = conf->writeEntry( "WinHeight", height() );
	conf->sync();
}


//==<Class TKPVExtract>=================================================


TKPVExtract::TKPVExtract(QString the_pack, bool wAlien, QStrList *the_sel, int wSel, QWidget *parent, const char *name)
:QDialog(parent, name, true)
{
	isAlien = wAlien; hasSel = wSel;
	
	RadioButton_1 = 0; RadioButton_2 = 0; RadioButton_3 = 0;
	RadioButton_4 = 0; RadioButton_5 = 0; RadioButton_6 = 0;
	CheckBox_1 = 0; CheckBox_2 = 0; CheckBox_3 = 0; CheckBox_4 = 0;
	GroupBox_2 = 0; Browse_Button = 0; Combo_1 = 0; Combo_2 = 0; Label_1 = 0; Label_3 = 0;

		OK_Button = new QPushButton( this, "OK" ); OK_Button->setText( DLG_DIV8 );
	Cancel_Button = new QPushButton( this, "CANCEL" ); Cancel_Button->setText( DLG_DIV9 );
	Cancel_Button->setAutoDefault( true );

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setFrameStyle( 49 ); GroupBox_1->setAlignment( 1 );

	QString aux(""), aux2(""); UnQuoteStr(the_pack);
	aux  = the_pack.copy(); FNAME(aux);
	aux2 = the_pack.mid(0, the_pack.findRev("/")+1);
	ext  = aux.mid(aux.findRev("."), aux.length()); ext = ext.lower();
	if (isAlien) BuildAlien(); else { pak = aux; aux = "Extracting package:  " + pak; (ext == ".rpm") ? BuildRPM() : BuildGeneric( aux2 , the_sel); }
}
//----------------------------------------------------------------------
void TKPVExtract::BuildGeneric(QString pack_path, QStrList *the_sel)
{
		OK_Button->setGeometry( 420, 10, 80, 25 );
	Cancel_Button->setGeometry( 420, 40, 80, 25 );

	GroupBox_1->setGeometry( 10, 0, 400, 90 ); GroupBox_1->setTitle( " Extract " );

	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 23, 17, 380, 30 ); Label_1->setAlignment( 289 ); Label_1->setMargin( -1 );

	RadioButton_5 = new QRadioButton( GroupBox_1, "RadioButton_1" );
	RadioButton_6 = new QRadioButton( GroupBox_1, "RadioButton_2" );

	RadioButton_5->setGeometry( 10, 53, 70, 25 ); RadioButton_5->setText( "All Files" );
	RadioButton_6->setGeometry( 90, 53, 70, 25 ); RadioButton_6->setText( "Selected" );

	Combo_2 = new KCombo( false, this, "Combo_2" );
	Combo_2->setGeometry( 180, 53, 220, 25 );
	
	if (hasSel > 0 && the_sel)
	{	QString aux(""); aux = the_sel->first();
		while (!aux.isNull() && !the_sel->isEmpty())
		{	if (!aux.isEmpty()) Combo_2->insertItem(aux);
			aux = the_sel->next();
		} SelectSom();
	}	
	else { RadioButton_6->setEnabled(false); Combo_2->setEnabled(false); SelectAll(); }
	
	connect( RadioButton_5, SIGNAL( clicked() ), this, SLOT( SelectAll() ));
	connect( RadioButton_6, SIGNAL( clicked() ), this, SLOT( SelectSom() ));
	
	GroupBox_2 = new QGroupBox( this, "GroupBox_2" );
	GroupBox_2->setGeometry( 10, 95, 400, 60 ); GroupBox_2->setTitle( " Select Directory " );
	GroupBox_2->setFrameStyle( 49 ); GroupBox_2->setAlignment( 1 );

	Combo_1 = new THistCombo(KPVApp->getConfig(), "ExtractHistory", 10, this, "Combo_1" );
	Combo_1->setGeometry( 20, 118, 300, 25 ); Combo_1->AddToHistory(pack_path);
	connect( OK_Button, SIGNAL( released() ), Combo_1, SLOT( Remember() ));

	Browse_Button = new QPushButton( this, "Browse" );
	Browse_Button->setGeometry( 330, 118, 70, 25 ); Browse_Button->setText( "Browse" );
	connect( Browse_Button, SIGNAL( released() ), this, SLOT( ChooseDir() ));

	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setAlignment(AlignCenter); Label_3->setGeometry( 435, 90, 50, 50 );

	QPixmap aico;
	if (ext == ".deb")
	{	if (ILoad(aico, "/debian_logo.xpm")) setIcon(aico);
		if (ILoad(aico, "/debian_big.xpm")) Label_3->setPixmap(aico);
	} else if (ext == ".tgz")
	{	if (ILoad(aico, "/slack.xpm")) setIcon(aico);
		if (ILoad(aico, "/pinguim_big.xpm")) Label_3->setPixmap(aico);		
	} else if (ext == ".bz2")
	{	if (ILoad(aico, "/bz2.xpm")) setIcon(aico);
		if (ILoad(aico, "/bz2logobig.xpm")) Label_3->setPixmap(aico);		
	} else if (ext == ".zip")
	{	if (ILoad(aico, "/zip.xpm")) setIcon(aico);
		if (ILoad(aico, "/pklogobig.xpm")) Label_3->setPixmap(aico);		
	} else if (ext == ".arj" || ext == ".lha" || ext == ".lzh" || ext == ".rar")
	{	if (ILoad(aico, "/rar.xpm")) setIcon(aico);
		if (ILoad(aico, "/rarlogobig.xpm")) Label_3->setPixmap(aico);		
	} else
	{	if (ILoad(aico, "/gzp.xpm")) setIcon(aico);
		if (ILoad(aico, "/ziplogobig.xpm")) Label_3->setPixmap(aico);		
	}

	Fixed( 510, 165 , "Extract To");
}
//----------------------------------------------------------------------
void TKPVExtract::BuildAlien()
{
		OK_Button->setGeometry( 225, 15, 100, 25 );
	Cancel_Button->setGeometry( 225, 45, 100, 25 );

	GroupBox_1->setGeometry( 10,  5, 200, 145 ); GroupBox_1->setTitle( DLG_DIV7 );
	
	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setGeometry( 260, 95, 40, 50 ); Label_3->setAlignment(AlignCenter);		
	
	QPixmap aico; if (ILoad(aico, "/alienbig.xpm")) Label_3->setPixmap(aico);
	FixIco( 340, 163 , DLG_DIV12, aico, "/alien.xpm");

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	RadioButton_4 = new TDoubleClick_RB( GroupBox_1, "RadioButton_4" );

	RadioButton_1->setGeometry( 17,  20, 160, 30 ); RadioButton_1->setText( "To Debian" );
	RadioButton_2->setGeometry( 17,  50, 160, 30 ); RadioButton_2->setText( "To RPM" );
	RadioButton_3->setGeometry( 17,  80, 160, 30 ); RadioButton_3->setText( "To Slackware" );
	RadioButton_4->setGeometry( 17, 110, 160, 30 ); RadioButton_4->setText( "Unpack-Don't Convert" );

	RadioButton_1->setChecked( true );	

	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_4, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
}
//----------------------------------------------------------------------
void TKPVExtract::BuildRPM()
{
		OK_Button->setGeometry( 225, 15, 100, 25 );
	Cancel_Button->setGeometry( 225, 45, 100, 25 );

	GroupBox_1->setGeometry( 10,  5, 200, 145 ); GroupBox_1->setTitle( DLG_DIV7 );	

	Label_3 = new QLabel( this, "Label_3" );
	Label_3->setGeometry( 260, 95, 40, 50 ); Label_3->setAlignment(AlignCenter);

	QPixmap aico; if (ILoad(aico, "/rpmlogobig.xpm")) Label_3->setPixmap(aico);
	FixIco( 340, 163 , "Extract RPM pack", aico, "/rpmlogo.xpm");

	CheckBox_1 = new QCheckBox( this, "CheckBox_1" );
	CheckBox_2 = new QCheckBox( this, "CheckBox_2" );
	CheckBox_3 = new QCheckBox( this, "CheckBox_3" );
	CheckBox_4 = new QCheckBox( this, "CheckBox_4" );
	
	CheckBox_1->setGeometry( 27,  25, 160, 30 ); CheckBox_1->setText( "Verbose" );
	CheckBox_2->setGeometry( 27,  55, 160, 30 ); CheckBox_2->setText( "Upgrade" );
	CheckBox_3->setGeometry( 27,  85, 160, 30 ); CheckBox_3->setText( "Force Install" );
	CheckBox_4->setGeometry( 27, 115, 160, 30 ); CheckBox_4->setText( "No Dependancy Check" );

	CheckBox_1->setChecked( true );	
}


//==<Class TKPVExtractDeb>=============================================

TKPVExtractDeb::TKPVExtractDeb(QWidget* parent, const char* name)
:QDialog(parent, name, true)
{	
		OK_Button = new QPushButton( this, "OK" ); OK_Button->setText( DLG_DIV8 );
	Cancel_Button = new QPushButton( this, "CANCEL" ); Cancel_Button->setText( DLG_DIV9 );
	Cancel_Button->setAutoDefault( true );
	
		OK_Button->setGeometry( 225, 15, 100, 25 );
	Cancel_Button->setGeometry( 225, 45, 100, 25 );

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setGeometry( 10,  5, 200, 145 ); GroupBox_1->setTitle( DLG_DIV7 );
	GroupBox_1->setFrameStyle( 49 ); GroupBox_1->setAlignment( 1 );
	
	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 260, 95, 40, 50 ); Label_1->setAlignment(AlignCenter);
	
	QPixmap aico; if (ILoad(aico, "/debian_big.xpm")) Label_1->setPixmap(aico);
	FixIco( 340, 163 , "Extract Debian pack", aico, "/debian_logo.xpm");

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	RadioButton_4 = new TDoubleClick_RB( GroupBox_1, "RadioButton_4" );
	
	RadioButton_1->setGeometry( 17,  20, 160, 30 ); RadioButton_1->setText( "ExtractTo..." );
	RadioButton_2->setGeometry( 17,  50, 160, 30 ); RadioButton_2->setText( "Install-NoForce" );
	RadioButton_3->setGeometry( 17,  80, 160, 30 ); RadioButton_3->setText( "Install-ForceDepends" );
	RadioButton_4->setGeometry( 17, 110, 160, 30 ); RadioButton_4->setText( "Install-ForceConflicts" );

	RadioButton_1->setChecked( true );	

	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_4, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
}


//==<Class TKPVChoPakMod>==============================================

TKPVChoPakMod::TKPVChoPakMod(TPack pck, bool virt_pak, QWidget* parent, const char* name)
:QDialog(parent, name, true)
{	
		OK_Button = new QPushButton( this, "OK" ); OK_Button->setText( DLG_DIV8 );
	Cancel_Button = new QPushButton( this, "CANCEL" ); Cancel_Button->setText( DLG_DIV9 );
	Cancel_Button->setAutoDefault( true );

		OK_Button->setGeometry( 225, 15, 100, 25 ); 
	Cancel_Button->setGeometry( 225, 45, 100, 25 ); 

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QButtonGroup( this, "GroupBox_1" );
	GroupBox_1->setGeometry( 10,  5, 200, 145 ); GroupBox_1->setTitle( DLG_DIV7 );
	GroupBox_1->setFrameStyle( 49 ); GroupBox_1->setAlignment( 1 );

	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 260, 95, 40, 50 ); Label_1->setAlignment(AlignCenter);
	
	QPixmap aico; tpck = pck;
	switch (pck)
	{	case tslack:
			if (ILoad(aico, "/virtslabig.xpm")) Label_1->setPixmap(aico);
			FixIco( 340, 163 , DLG_DIV45, aico, "/slack.xpm");				break;
		case tdeb:
			if (ILoad(aico, "/virtdebbig.xpm")) Label_1->setPixmap(aico);
			FixIco( 340, 163 , DLG_DIV45, aico, "/debian_logo.xpm");		break;
		case trpm:
			if (ILoad(aico, "/virtrpmbig.xpm")) Label_1->setPixmap(aico);
			FixIco( 340, 163 , DLG_DIV45, aico, "/rpmlogo.xpm");			break;
		default: break;
	}

	RadioButton_1 = new TDoubleClick_RB( GroupBox_1, "RadioButton_1" );
	RadioButton_2 = new TDoubleClick_RB( GroupBox_1, "RadioButton_2" );
	RadioButton_3 = new TDoubleClick_RB( GroupBox_1, "RadioButton_3" );
	   CheckBox_1 = new QCheckBox(  this, "CheckBox_1" );

	RadioButton_1->setGeometry( 20,  18, 160, 30 ); 
	RadioButton_2->setGeometry( 20,  48, 160, 30 ); 
	RadioButton_3->setGeometry( 20,  78, 160, 30 ); RadioButton_3->setText( DLG_DIV11 );
	   CheckBox_1->setGeometry( 30, 113, 160, 30 ); CheckBox_1->setText( "Auto Load Directory" );

	switch (pck)
	{	case trpm:
			RadioButton_1->setText( "RPM Installed Packs" ); RadioButton_2->setText( "Virtual_RPM" );
			break;
		default:
			RadioButton_1->setText( (pck == tslack) ? SLA_PAK : DEB_DIR );
			RadioButton_2->setText( (pck == tslack) ? "Virtual_Slack" : "Virtual_Debian" );
	}

	QDir paksdir, virtual_paks;
	switch (pck)
	{	case trpm  : virtual_paks = user_path + VRT_RPM; paksdir = user_path; break;
		case tslack: virtual_paks = user_path + VRT_SLA; paksdir = SLA_PAK;   break;
		case tdeb  : virtual_paks = user_path + VRT_DEB; paksdir = DEB_DIR;   break;
		default: break;
	}

	RadioButton_1->setEnabled(paksdir.exists());
	RadioButton_2->setEnabled(virtual_paks.exists());
	   CheckBox_1->setEnabled(paksdir.exists() || virtual_paks.exists());
	   CheckBox_1->setChecked( true );

	(pck == trpm) ? toggleIMG(!RadioButton_2->isChecked()) : toggleIMG(RadioButton_2->isChecked());

	if		( paksdir.exists() &&  virtual_paks.exists()) { (virt_pak) ? RadioButton_2->setChecked(true) : RadioButton_1->setChecked(true); }
	else if	(!paksdir.exists() && !virtual_paks.exists()) { RadioButton_3->setChecked(true); }
	else {	(virtual_paks.exists()) ? RadioButton_2->setChecked(true) : RadioButton_1->setChecked(true); }

	connect( GroupBox_1   , SIGNAL( released(int)       ), this, SLOT( toggleIMG(int) ));
	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT(    accept()    ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT(    accept()    ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT(    accept()    ));
}
//---------------------------------------------------------------------
void TKPVChoPakMod::toggleIMG(int ButID)
{ 
	QPixmap aico; QString animg("/kpack_big.xpm");
	switch(tpck)
	{	case tslack: (ButID == 1) ? animg = "/virtslabig.xpm" : animg = "/pinguim_big.xpm"; break;
		case tdeb  : (ButID == 1) ? animg = "/virtdebbig.xpm" : animg = "/debian_big.xpm" ; break;
		case trpm  : (ButID == 1) ? animg = "/virtrpmbig.xpm" : animg = "/rpmlogobig.xpm" ; break;
		default: break;
	} if (ILoad(aico, animg)) Label_1->setPixmap(aico);
}


//==<Class TKPVGetInput>===============================================


TKPVGetInput::TKPVGetInput(bool wher, QWidget *parent, const char *name)
:QDialog(parent, name, true)
{
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	PushButton_2 = new QPushButton( this, "PushButton_2" );
	PushButton_1->setAutoDefault( true );

	PushButton_1->setGeometry( 325, 15, 100, 25 ); PushButton_1->setText( DLG_DIV31 );
	PushButton_2->setGeometry( 325, 45, 100, 25 ); PushButton_2->setText( DLG_DIV9  );

	connect(PushButton_1, SIGNAL( released() ), this, SLOT( CheckInput() ));
	connect(PushButton_2, SIGNAL( released() ), this, SLOT( reject() ));

	GroupBox_1 = new QGroupBox( this, "GroupBox_1" );
	GroupBox_1->setGeometry( 10, 05, 300, 95 ); GroupBox_1->setTitle( DLG_DIV7 );
	GroupBox_1->setFrameStyle( 49 ); GroupBox_1->setAlignment( 1 );

	Label_1 = new QLabel( this, "Label_1" ); Label_1->setText( DLG_DIV30 ); 
	Label_1->setGeometry( 25, 40, 80, 20 );  Label_1->setAlignment( 289 ); Label_1->setMargin( -1 );

	QPixmap aico;
	if (wher)	{ FixIco( 440, 110 , MNU_POP18, aico, "/where.xpm"); }
	else 		{ FixIco( 440, 110 , MNU_POP11, aico, "/lupa.xpm" ); }
	
	Combo_1 = new THistCombo(KPVApp->getConfig(), "SearchHistory", 10, this, "Combo_1" );
	ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
	RadioButton_1 = new QRadioButton(  ButtonGroup_1 , "RadioButton_1" );
	RadioButton_2 = new QRadioButton(  ButtonGroup_1 , "RadioButton_2" );
	   CheckBox_1 = new QCheckBox(  this, "CheckBox_1" );
	   CheckBox_2 = new QCheckBox(  this, "CheckBox_2" );
	
	ButtonGroup_1->setAlignment( 1 ); ButtonGroup_1->setFrameStyle( QFrame::NoFrame );
	ButtonGroup_1->setGeometry(  95, 20,  80, 40 ); ButtonGroup_1->setTitle("");
	RadioButton_1->setGeometry(  05, 03,  70, 15 ); RadioButton_1->setText( "Pattern" ); 
	RadioButton_2->setGeometry(  05, 22,  70, 15 ); RadioButton_2->setText( "RegExp" );
	   CheckBox_1->setGeometry( 180, 24, 110, 15 ); CheckBox_1->setText( DLG_DIV28 ); 
	   CheckBox_2->setGeometry( 180, 43, 110, 15 ); CheckBox_2->setText( DLG_DIV29 );
		  Combo_1->setGeometry(  20, 65, 275, 25 );

	isRegExp = false; RadioButton_1->setChecked( true );
	CheckBox_1->setChecked( false ); CheckBox_2->setChecked( false );

	connect( RadioButton_1, SIGNAL(     clicked()       ),   this , SLOT(     IsPattern()         ));
	connect( RadioButton_2, SIGNAL(     clicked()       ),   this , SLOT(     IsRegExp()          ));
	connect( PushButton_1 , SIGNAL(    released()       ), Combo_1, SLOT(      Remember()         ));
	connect(    this      , SIGNAL( Warn(QString, bool) ), parent , SLOT( EmitWarn(QString, bool) ));

	Combo_1->setFocus();
}


//==<Class TKPVStatus>==================================================


TKPVStatus::TKPVStatus(QString amsg, QWidget *parent, const char *name)
:QDialog(parent, name, false)
{
	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setAutoResize(true); Label_1->setAlignment(AlignCenter);
	Label_1->setLineWidth(1); Label_1->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	WaitMsg(amsg);
}
//---------------------------------------------------------------------
void TKPVStatus::Adjust()
{
	Label_1->setMinimumSize( Label_1->sizeHint() );
			
	int dlgW = (int) (1.2 * Label_1->sizeHint().width()),
		dlgH = (int) (1.8 * Label_1->sizeHint().height());
				
	QPixmap aico; FixIco( dlgW, dlgH , MSG_DIV5, aico, "/kpv_mini.xpm");
			
	QWidget *scr = QApplication::desktop();
	int scrW = scr->width(), scrH = scr->height();
	setGeometry( (int)(((scrW-dlgW)>>1)+1), (int)(((scrH-dlgH)>>1)+1) , dlgW , dlgH );
	Label_1->resize((int)(0.9 * dlgW) , (int)(0.5 * dlgH));
	Label_1->move( (int)(((dlgW-Label_1->width())>>1)+1), (int)(((dlgH-Label_1->height())>>1)+1));
	Label_1->show(); Label_1->update();
}
//---------------------------------------------------------------------
void TKPVStatus::WaitMsg(QString amsg, bool adj) 
{ 
	SPACED(amsg); Label_1->setText(amsg); if (adj) Adjust(); update(); Working;
}


//==<Class TKPVScriptWiz>==============================================


TKPVScriptWiz::TKPVScriptWiz(QStrList &flelst, QWidget *parent, const char *name)
:QDialog(parent, name, true)
{
	the_lst = &flelst;
	
	Frame_1 = new QFrame( this, "Frame_1" );
	Frame_2 = new QFrame( this, "Frame_2" );
	
	Label_1 = new QLabel( this, "Label_1" ); Label_2 = new QLabel( this, "Label_2" );
	Label_3 = new QLabel( this, "Label_3" ); Label_4 = new QLabel( this, "Label_4" );
	Label_5 = new QLabel( this, "Label_5" ); Label_6 = new QLabel( this, "Label_6" );
	Label_7 = new QLabel( this, "Label_7" ); Label_8 = new QLabel( this, "Label_8" );
	Label_9 = new QLabel(Frame_2, "Label_9" );
	
	LineEdit_1 = new QLineEdit( this, "LineEdit_1" );
	LineEdit_2 = new QLineEdit( this, "LineEdit_2" ); LineEdit_4 = new QLineEdit( this, "LineEdit_4" );
	LineEdit_3 = new QLineEdit( this, "LineEdit_3" ); LineEdit_5 = new QLineEdit( this, "LineEdit_5" );
	MultiLineEdit_1 = new QMultiLineEdit( this, "MultiLineEdit_1" );	

	ButtonGroup_1 = new QButtonGroup( Frame_2, "ButtonGroup_1" );
	RadioButton_1 = new QRadioButton( ButtonGroup_1, "RadioButton_1" );
	RadioButton_2 = new QRadioButton( ButtonGroup_1, "RadioButton_2" );
	RadioButton_3 = new QRadioButton( ButtonGroup_1, "RadioButton_3" );
	CheckBox_1    = new QCheckBox( Frame_2, "CheckBox_1" );
	LineEdit_6    = new QLineEdit( Frame_2, "LineEdit_6" );
	PushButton_3  = new QPushButton( Frame_2, "PushButton_3" );

	PushButton_2 = new QPushButton( this, "PushButton_2" );
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	
	Frame_1->setGeometry(   5,  10, 415, 280 ); Frame_1->setFrameStyle( 50 );
	Label_1->setGeometry(  10,  20, 150,  25 );	Label_1->setText( LBL_DIV9 );
	Label_2->setGeometry(  10,  80, 150,  25 );	Label_2->setText( LBL_DIV10);
	Label_3->setGeometry(  10, 135, 150,  25 );	Label_3->setText( LBL_DIV11);
	Label_4->setGeometry( 250,  55, 150,  25 );	Label_4->setText( LBL_DIV12);
	Label_5->setGeometry(  90,  55, 150,  25 );	Label_5->setText( LBL_DIV13);
	Label_6->setGeometry(  90, 110, 150,  25 );	Label_6->setText( LBL_DIV13);
	Label_7->setGeometry( 250, 110, 150,  25 );	Label_7->setText( LBL_DIV12);
	Label_8->setGeometry(  15, 167, 150,  25 );	Label_8->setText( LBL_DIV14);
	
	LineEdit_1->setGeometry(  90,  20, 150, 25 ); LineEdit_1->setMaxLength( 32767 ); LineEdit_1->setText( WIZ_SCP );
	LineEdit_2->setGeometry(  90,  80, 150, 25 ); LineEdit_2->setMaxLength( 32767 ); LineEdit_2->setText( "" );
	LineEdit_3->setGeometry(  90, 135, 150, 25 ); LineEdit_3->setMaxLength( 32767 ); LineEdit_3->setText( "" );
	LineEdit_4->setGeometry( 250,  80, 150, 25 ); LineEdit_4->setMaxLength( 32767 ); LineEdit_4->setText( "" ); 
	LineEdit_5->setGeometry( 250, 135, 150, 25 ); LineEdit_5->setMaxLength( 32767 ); LineEdit_5->setText( "" ); 

	QToolTip::add(LineEdit_2, LBL_DIV16); QToolTip::add(LineEdit_4, LBL_DIV16);
	QToolTip::add(LineEdit_3, LBL_DIV16); QToolTip::add(LineEdit_5, LBL_DIV16);
	
	PushButton_1->setGeometry( 250,  20, 150, 25 );	PushButton_1->setText( LBL_DIV15 );
	connect(PushButton_1, SIGNAL( released() ), this, SLOT( DoScript() ));

 	PushButton_2->setGeometry(   5, 395, 415, 25 ); PushButton_2->setText( DLG_DIV27 ); PushButton_2->setAutoDefault( true );
	connect(PushButton_2, SIGNAL( released() ), this, SLOT(  reject()  ));

	MultiLineEdit_1->setGeometry( 15, 192, 395, 90 ); MultiLineEdit_1->setReadOnly( TRUE );
	ScriptChg("");

	      Frame_2->setGeometry(   5, 300, 415, 85 );
	ButtonGroup_1->setGeometry(   5,   5,  95, 70 ); ButtonGroup_1->setTitle( "" ); ButtonGroup_1->setAlignment( 1 );
	RadioButton_1->setGeometry(   5,   5,  70, 15 ); RadioButton_1->setText( LBL_DIV17 ); RadioButton_1->setChecked( TRUE  );
	RadioButton_2->setGeometry(   5,  30,  70, 15 ); RadioButton_2->setText( LBL_DIV18 ); RadioButton_2->setChecked( FALSE );
	RadioButton_3->setGeometry(   5,  55,  70, 15 ); RadioButton_3->setText( LBL_DIV19 ); RadioButton_3->setChecked( FALSE );
	   CheckBox_1->setGeometry( 105,  34, 300, 15 ); CheckBox_1->setText( LBL_DIV20 ); CheckBox_1->setChecked( TRUE );
	   LineEdit_6->setGeometry( 105,  55, 225, 20 ); LineEdit_6->setText( "" ); LineEdit_6->setMaxLength( 32767 );
	 PushButton_3->setGeometry( 335,  53,  70, 25 ); PushButton_3->setText( "Browse" ); 
	     Label_9->setGeometry(  105,   7, 300, 22 ); Label_9->setText( LBL_DIV21 );

	Frame_2->setFrameStyle(50); ButtonGroup_1->setFrameStyle( QFrame::NoFrame );
	Label_9->setFrameStyle(50); Label_9->setAlignment( AlignCenter );
	LineEdit_6->setFrame( QLineEdit::Normal ); LineEdit_6->setFrame( TRUE );

	connect(PushButton_3, SIGNAL( released() ), this, SLOT( MoveToWhere() ));

	connect(LineEdit_1, SIGNAL( textChanged(const char*) ), this, SLOT( ScriptChg(const char*) ));
	connect(LineEdit_2, SIGNAL( textChanged(const char*) ), this, SLOT( ScriptChg(const char*) ));
	connect(LineEdit_3, SIGNAL( textChanged(const char*) ), this, SLOT( ScriptChg(const char*) ));
	connect(LineEdit_4, SIGNAL( textChanged(const char*) ), this, SLOT( ScriptChg(const char*) ));
	connect(LineEdit_5, SIGNAL( textChanged(const char*) ), this, SLOT( ScriptChg(const char*) ));
	
	QPixmap aico; FixIco( 425, 425 , "Script Wizard", aico, "/bulb.xpm");

	connect(this, SIGNAL(  PrintMsg(QString)   ), parent, SLOT(  PrintMsg(QString)   ));
	connect(this, SIGNAL( Warn(QString, bool)  ), parent, SLOT( Warn(QString, bool)  ));
	connect(this, SIGNAL( ShowWait(QString)    ), parent, SLOT( ShowWait(QString)    ));
	connect(this, SIGNAL(    WaitDone()        ), parent, SLOT(     WaitDone()       ));
	connect(this, SIGNAL(       Beep()         ), parent, SLOT(       Beep()         ));
	connect(this, SIGNAL(     SetLedOn()       ), parent, SLOT(      SetLedOn()      ));
	connect(this, SIGNAL(     SetLedOff()      ), parent, SLOT(      SetLedOff()     ));
	connect(this, SIGNAL(Confirm(QString, bool&, bool)), parent, SLOT(Confirm(QString, bool&, bool)));
}


//==<Class TKPVNewWin>=================================================


TKPVNewWin::TKPVNewWin(QString ctx, QWidget *parent, const char *name)
:QDialog(parent, name, true)
{
	PushButton_1 = new QPushButton( this, "PushButton_1" );
	PushButton_2 = new QPushButton( this, "PushButton_2" );

	PushButton_1->setGeometry( 160, 10, 85, 25 ); PushButton_1->setText( DLG_DIV8 );
	PushButton_2->setGeometry( 160, 40, 85, 25 ); PushButton_2->setText( DLG_DIV9 );

	connect(PushButton_1, SIGNAL( released() ), this, SLOT( accept() ));
	connect(PushButton_2, SIGNAL( released() ), this, SLOT( reject() ));

	ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
	RadioButton_1 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_1" );
	RadioButton_2 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_2" );
	RadioButton_3 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_3" );
	RadioButton_4 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_4" );
	RadioButton_5 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_5" );
	RadioButton_6 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_6" );
	RadioButton_7 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_7" );
	RadioButton_8 = new TDoubleClick_RB( ButtonGroup_1, "RadioButton_8" );
	   CheckBox_1 = new QCheckBox(  this, "CheckBox_1" );
	
	ButtonGroup_1->setGeometry(  10,  10, 140, 210 ); ButtonGroup_1->setFrameStyle( 49 ); ButtonGroup_1->setAlignment( 1 );
	RadioButton_1->setGeometry(  10,   5, 125,  25 ); RadioButton_1->setText( "Blank" );
	RadioButton_2->setGeometry(  10,  30, 125,  25 ); RadioButton_2->setText( "Slack Installed" );
	RadioButton_3->setGeometry(  10,  55, 125,  25 ); RadioButton_3->setText( "Virtual_Slack" );
	RadioButton_4->setGeometry(  10,  80, 125,  25 ); RadioButton_4->setText( "Debian Installed" );
	RadioButton_5->setGeometry(  10, 105, 125,  25 ); RadioButton_5->setText( "Virtual_Debian" );
	RadioButton_6->setGeometry(  10, 130, 125,  25 ); RadioButton_6->setText( "RPM Installed" );
	RadioButton_7->setGeometry(  10, 155, 125,  25 ); RadioButton_7->setText( "Virtual RPM" );
	RadioButton_8->setGeometry(  10, 180, 125,  25 ); RadioButton_8->setText( "Clone Current" );
	   CheckBox_1->setGeometry( 170,  80,  85,  25 ); 	 CheckBox_1->setText( "InGroup" ); 

	connect( ButtonGroup_1, SIGNAL( released(int) ), this, SLOT( toggleIMG(int) ));
	connect( RadioButton_1, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_2, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_3, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_4, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_5, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_6, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_7, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));
	connect( RadioButton_8, SIGNAL( SIG_DoubleClicked() ), this, SLOT( accept() ));

	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 175, 155, 50, 50 ); Label_1->setAlignment(AlignCenter);
	
	if		(ctx == ""                       ) { RadioButton_1->setChecked(true); toggleIMG(0); }
	else if	(ctx.find(SLA_PAK            )>-1) { RadioButton_2->setChecked(true); toggleIMG(1); }
	else if	(ctx.find(user_path + VRT_SLA)>-1) { RadioButton_3->setChecked(true); toggleIMG(2); }
	else if	(ctx.find(user_path + VRT_TMP)>-1) { RadioButton_4->setChecked(true); toggleIMG(3); }
	else if	(ctx.find(user_path + VRT_DEB)>-1) { RadioButton_5->setChecked(true); toggleIMG(4); }
	else if	(ctx.find(user_path + VRT_RPM)>-1) { RadioButton_7->setChecked(true); toggleIMG(6); }
	else if	(ctx.left(4)=="RPM:" || ctx.left(7)=="RPMGRP:") { RadioButton_6->setChecked(true);  toggleIMG(5); }
	else { RadioButton_7->setChecked(true); toggleIMG(7); }

	CheckBox_1->setChecked(ctx.left(7) == "SLAGRP:" || ctx.left(7) == "DEBGRP:" || ctx.left(7) == "RPMGRP:");

	Fixed( 255, 230 , "Clone Context...");
}
//---------------------------------------------------------------------
void TKPVNewWin::toggleIMG(int imgID)
{ 
	QPixmap aico;
	switch(imgID)
	{	case  1: if (ILoad(aico, "/pinguim_big.xpm")) Label_1->setPixmap(aico); break;
		case  2: if (ILoad(aico, "/virtslabig.xpm" )) Label_1->setPixmap(aico); break;
		case  3: if (ILoad(aico, "/debian_big.xpm" )) Label_1->setPixmap(aico); break;
		case  4: if (ILoad(aico, "/virtdebbig.xpm" )) Label_1->setPixmap(aico); break;
		case  5: if (ILoad(aico, "/rpmlogobig.xpm" )) Label_1->setPixmap(aico); break;
		case  6: if (ILoad(aico, "/virtrpmbig.xpm" )) Label_1->setPixmap(aico); break;
		default: if (ILoad(aico, "/kpack_big.xpm"  )) Label_1->setPixmap(aico); break;
	} 
}


//==<Class TKPVRemovePAK>==============================================


TKPVRemovePAK::TKPVRemovePAK(bool is_RPM, QWidget* parent, const char* name)
:QDialog(parent, name, true)
{	
		OK_Button = new QPushButton( this, "OK" ); OK_Button->setText( DLG_DIV8 );
	Cancel_Button = new QPushButton( this, "CANCEL" ); Cancel_Button->setText( DLG_DIV9 );
	Cancel_Button->setAutoDefault( true );

		OK_Button->setGeometry( 225, 15, 100, 25 );
	Cancel_Button->setGeometry( 225, 45, 100, 25 );

	connect( OK_Button,     SIGNAL( released()  ), this, SLOT( accept() ));
	connect( Cancel_Button, SIGNAL( released()  ), this, SLOT( reject() ));

	GroupBox_1 = new QGroupBox( this, "GroupBox_1" );
	GroupBox_1->setGeometry( 10,  5, 200, 145 ); GroupBox_1->setTitle( DLG_DIV7 );
	GroupBox_1->setFrameStyle( 49 ); GroupBox_1->setAlignment( 1 );

	Label_1 = new QLabel( this, "Label_1" );
	Label_1->setGeometry( 260, 95, 40, 50 ); Label_1->setAlignment(AlignCenter); 
	
	CheckBox_1 = new QCheckBox( this, "CheckBox_1" ); CheckBox_1->setText( "Verbose" );
	CheckBox_2 = new QCheckBox( this, "CheckBox_2" ); CheckBox_2->setText( "Test" );
	CheckBox_3 = new QCheckBox( this, "CheckBox_3" );
	CheckBox_4 = new QCheckBox( this, "CheckBox_4" );

	isRPM = is_RPM; QPixmap aico; 
	if (isRPM)
	{	CheckBox_3->setText( "No Scripts" );
		CheckBox_4->setText( "No Dependancy Check" );
		if (ILoad(aico, "/rpmlogobig.xpm")) Label_1->setPixmap(aico);
		FixIco( 340, 163 , "Remove RPM pack", aico, "/rpmlogo.xpm");

	}
	else
	{	CheckBox_3->setText( "No Force" );
		CheckBox_4->setText( "No ..." );
		if (ILoad(aico, "/debian_big.xpm")) Label_1->setPixmap(aico);
		FixIco( 340, 163 , "Remove DEB pack", aico, "/debian_logo.xpm");
	}
	
	CheckBox_1->setGeometry( 27,  25, 160, 30 ); 
	CheckBox_2->setGeometry( 27,  55, 160, 30 ); 
	CheckBox_3->setGeometry( 27,  85, 160, 30 ); 
	CheckBox_4->setGeometry( 27, 115, 160, 30 ); 

	CheckBox_1->setChecked( true );	CheckBox_2->setChecked( true );
}


//=====================================================================
//	END.
//=====================================================================











