// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <string.h>
#include <typhoon.h>
}

#include "users.h"
#include <iostream.h>

#define errlog cerr

UserData::UserData()
{

}

UserData::~UserData()
{

}

int UserData::checkId(unsigned long id)
{
  if( d_keyfind(USER_ID, &id) != S_OKAY )
    return S_NOTFOUND;
  else
    return S_OKAY;
}

int UserData::findId(User *rec, unsigned long id)
{
  if( d_keyfind(USER_ID, &id) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return S_OKAY;
}

int UserData::findName(User *rec, MyString name)
{
  int rcode = S_NOTFOUND;
  char kname[41];
  if( d_keyfrst(NAME) != S_OKAY )
    return S_NOTFOUND;
  do {
    d_keyread(kname);
    //if( name == ((MyString) kname).before((int) name.length()) )
    if( name == ((MyString) kname).substr(0, name.length()) )
      {
	rcode = S_OKAY;
	break;
      }
  } while( d_keynext(NAME) == S_OKAY );

  if( rcode == S_OKAY )
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return rcode;
}

int UserData::findNick(User *rec, MyString nick)
{
  int rcode = S_NOTFOUND;
  char knick[21];
  if( d_keyfrst(NICK) != S_OKAY )
    return S_NOTFOUND;
  do {
    d_keyread(knick);
    //if( nick == ((MyString) knick).before((int) nick.length()) )
    if( nick == ((MyString) knick).substr(0, nick.length()) )
      {
	rcode = S_OKAY;
	break;
      }
  } while( d_keynext(NICK) == S_OKAY );
  // rcode = d_keyfind(NICK, (const char *) nick);
  if( rcode == S_OKAY )
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return rcode;
}

int UserData::findEmail(User *rec, MyString email)
{
  int rcode = S_NOTFOUND;
  char kemail[81];
  if( d_keyfrst(EMAIL) != S_OKAY )
    return S_NOTFOUND;
  do {
    d_keyread(kemail);
    //if( email == ((MyString) kemail).before((int) email.length()) )
    if( email == ((MyString) kemail).substr(0, email.length()) )
      {
	rcode = S_OKAY;
	break;
      }
  } while( d_keynext(EMAIL) == S_OKAY );
  //rcode = d_keyfind(EMAIL, (const char *) email);
  if( rcode == S_OKAY )
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return rcode;
}

int UserData::findNext(User *rec, int key, MyString kvalue)
{
  char temp[101];
  if( d_keynext(key) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_keyread(temp);
      //if( kvalue != ((MyString) temp).before((int) kvalue.length()) )
      if( kvalue != ((MyString) temp).substr(0, kvalue.length()) )
	return S_NOTFOUND;
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return S_OKAY;
}

int UserData::add(User *rec)
{
  int rcode;
  unsigned long new_id;
  d_getsequence(UUSER_ID , &new_id);
  while( new_id < 100 )  // id = 0 is not allowed; id = 1-99 reserved for special services
    d_getsequence(UUSER_ID, &new_id);
  //if( new_id == 0 )
  //  d_getsequence(UUSER_ID, &new_id);
  record.user_id = new_id;
  rec->id = new_id;
  strcpy(record.name,    (const char *) rec->name.c_str());
  strcpy(record.vname,   (const char *) rec->vname.c_str());
  strcpy(record.nick,    (const char *) rec->nick.c_str());
  strcpy(record.date,    (const char *) rec->date.c_str());
  strcpy(record.email,   (const char *) rec->email.c_str());
  strcpy(record.passwd,  (const char *) rec->passwd.c_str());
  if( (rcode = d_fillnew(USERS, &record)) != S_OKAY )
    {
      errlog << "can't insert record: CODE = " << rcode << endl;
      return S_DUPLICATE;
    }
  return S_OKAY;
}

int UserData::remove(unsigned long id)
{
  if( checkId(id) == S_OKAY )
    {
      d_keyfind(USER_ID, &id);
      if( d_delete() != S_OKAY )
	return S_NOTFOUND;
      else
	return S_OKAY;
    }
  return S_NOTFOUND;
}

int UserData::changeRec(User *rec)
{
  int rcode;
  if( checkId(rec->id) == S_OKAY )
    {
      d_keyfind(USER_ID, &(rec->id));
      record.user_id = rec->id;
      strcpy(record.name,    (const char *) rec->name.c_str());
      strcpy(record.vname,   (const char *) rec->vname.c_str());
      strcpy(record.nick,    (const char *) rec->nick.c_str());
      strcpy(record.date,    (const char *) rec->date.c_str());
      strcpy(record.email,   (const char *) rec->email.c_str());
      strcpy(record.passwd,  (const char *) rec->passwd.c_str());
      if( (rcode = d_recwrite(&record)) != S_OKAY )
	{
	  errlog << "can't insert record: CODE = " << rcode << endl;
	  return S_DUPLICATE;
	}
      return S_OKAY;
    }
  return S_NOTFOUND;
}

int UserData::getFirst(User *rec)
{
  if( d_recfrst(USER_ID) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return S_OKAY;
}

int UserData::getNext(User *rec)
{
  if( d_recnext(USER_ID) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      rec->id = record.user_id;
      rec->name = record.name;
      rec->vname = record.vname;
      rec->nick = record.nick;
      rec->date = record.date;
      rec->email = record.email;
    }
  return S_OKAY;
}

int UserData::checkPasswd(unsigned long id, MyString passwd)
{
  if( d_keyfind(USER_ID, &id) != S_OKAY )
    return S_NOTFOUND;
  else
    {
      d_recread(&record);
      if( ((MyString) record.passwd) == passwd )
	return S_OKAY;
      else
	return S_NOTFOUND;
    }
}
