// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <typhoon.h>
}

//#include <String.h>
#include "mystring.h"
#include <iostream.h>
#include <fstream.h>
//ofstream errlog("/home/lrd/errorlog/LRDM.log", ios::out);
#define errlog cerr

#include "konserver.h"
#include "konline.h"

int debug;

int main(int argc, char **argv)
{
  debug = 0;
  //int export = 0;
  //int import = 0;
  char c;
  MyString config_file;
  while ( ( c = getopt (argc, argv, "hdvc:")) != -1)
    {
      switch (c)
        {
        case 'h':
          cout << "usage: konserver [-h] [-v] [-d] [-c configfile]" << endl;
          cout << "       -h this help" << endl;
          cout << "       -v prints version information" << endl;
          cout << "       -d sets debug mode" << endl;
          cout << "       -c configfile tells konserver where to look for the config file" << endl;
          exit(1);
        case 'd':
	  debug = 1;
          break;
        case 'v':
	  cout << "Konserver Version " << VERSION << " Copyright 1998 Christoph Neerfeld." << endl;
	  exit(0);
          break;
        case 'c':
	  config_file = (MyString) optarg;
          break;
	  /*
        case 'e':
	  export = 1;
          break;
        case 'i':
	  import = 1;
          break;
	  */
        case '?':
          break;
        default:
          exit (1);
        }
    }

  if( debug )
    {
      errlog << "##############################################" << endl;
      errlog << "              konserver started !" << endl;
      errlog << "##############################################" << endl;
    }

  pid_t pid;
  if( !debug )
    {
      pid = fork();
      if( pid > 0 )
	{ // this is the parent
	  exit(0);
	}
      else if( pid < 0 )
	{  // fork failed
	  errlog << "Unable to spawn subprocess. Giving up !" << endl;
	  exit(1);
	}
    }
  if( !config_file.length() )
    config_file = "/etc/konserver.conf";
  Konserver server(config_file);
  /*
  if( export )
    server.exportUserDatabase();
  else if( import )
    server.importUserDatabase();
  else
  */
  server.loop();
  //d_close();
}
