// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <unistd.h>
#include <signal.h>
};

#include <qapp.h>
#include <qdir.h>
#include <qfileinf.h>
#include <qstring.h>
#include <qfile.h>
#include <qtstream.h>
#include <qstrlist.h>
#include <qpixmap.h>

#include <kapp.h>
#include <drag.h>
#include <kiconloader.h>

#include "konline.h"
#include "server.h"

Server *serv;

QPixmap *online_pix;
QPixmap *offline_pix;

Konline *main_widget;

int main( int argc, char **argv )
{
  KApplication a( argc, argv, "konline" );

  KConfig *config = a.getConfig();
  config->setGroup("konline");

  serv = new Server;

  Konline konline;
  if( a.isRestored() )
    {
      if( KTopLevelWidget::canBeRestored(1) )
	{
          konline.restore(1);
	}
    }
  main_widget = &konline;
  a.setMainWidget( (QWidget *) &konline );
  a.setRootDropZone( new KDNDDropZone( (QWidget *) &konline, DndNotDnd ) );
  //konline.callUpdate();
  online_pix = new QPixmap(KApplication::getKApplication()->getIconLoader()->
			   loadIcon("online.xpm"));
  offline_pix = new QPixmap(KApplication::getKApplication()->getIconLoader()->
			    loadIcon("offline.xpm"));
  konline.resize(konline.size());
  konline.show();
  int x = config->readNumEntry("XPos", 0);
  int y = config->readNumEntry("YPos", 0);
  if( x > QApplication::desktop()->width()-konline.width() )
    x = QApplication::desktop()->width()-konline.width();
  if( y > QApplication::desktop()->height()-konline.height() )
    y = QApplication::desktop()->height()-konline.height();
  
  konline.move( x, y );
  return a.exec();
}





