#include "clientimap.h"
#include "knewmail.h"
#include "filterconfigdlg.h"

#include <iostream.h>

#include <qregexp.h>

ClientImap::ClientImap(QWidget* parent) : ClientBase(parent)
{
}

ClientImap::~ClientImap()
{
}

bool ClientImap::checkMail(QList<HeaderStruct>* headerList, ServerStruct *serverInfo)
{
  QString response, command;
  int match, len;

  if (!openConnection(serverInfo))
    return false;
      
  int numMsgs = 0;
  KConfig* config = kapp->getConfig();

  initProgressDialog(serverInfo->address);

 

  // ************************** GET WELCOME MSG FROM SERVER  ***************************

  if (!readLine(response))
    {
      return 0;
    }

  // ****************************** END WELCOME MESSGAE ********************************



  // *************************** SEND USERNAME AND PASSWORD ****************************

  // Send the login name
  command = "A01 LOGIN ";
  command += serverInfo->username;
  command += " ";
  if (serverInfo->save)
    command += serverInfo->password;
  else
    command += KNewMailApp::showPassDialog(serverInfo->address);
  command +="\r\n\0";
  
  writeLine(command);
  
 if ((!readLine(response)) || (!checkResponse(response, "A01")))
    {
      return 0;
    }

  //************************ END SEND USERNAME AND PASSWORD ****************************


  //***************************** SET THE FOLDER  *************************************

  command = "A02 SELECT ";
  command += serverInfo->folder;
  command += "\r\n\0";

  writeLine(command);

  readLine(response);
  while (response[0] == '*')
    {
       readLine(response);
    }
  if (!checkResponse(response, "A02"))
    return 0;

  //***************************** END SET THE FOLDER  **********************************


  //***************************** ASK FOR NUM MESSAGES **********************************
  command = "A03 STATUS ";
  command += serverInfo->folder;
  command += " (messages unseen)\r\n\0";
  
  writeLine(command);

  readLine(response);
  if (response[0] == '*')
    {
      // Taken from KBiff

      // I'm not sure which of the following should be used. 
      // I think I have the proper one working
      // check the number of messages
      //      QRegExp recent_re("UNSEEN [0-9]*");
      //if ((match = recent_re.match(response, 0, &len)) > -1)
      //	numMsgs = response.mid(match + 7, len - 7).toInt();
      
      // check the number of messages
      QRegExp messages_re("MESSAGES [0-9]*");
      if ((match = messages_re.match(response, 0, &len)) > -1)
	numMsgs = response.mid(match + 9, len - 9).toInt();

      readLine(response);
    }    

  //cout << "BEFORE CHECK: " << response << endl;  

  if (!checkResponse(response, "A03"))
    return 0;
  
  //***************************** END ASK FOR NUM MESSAGES **********************************
  
  //cout << "NUM MESSAGES: " << numMsgs << endl;


  //***************************** REQUEST THE HEADERS **********************************

   int i = 0;

   config->setGroup("NOTIFICATION");
   if ((fParent->isVisible()) && (config->readBoolEntry("ShowStatusDlg", TRUE)))
     {
       fProgress->setTotalSteps(numMsgs);
       for (i=0; i< numMsgs; i++) 
	 {
	   fProgress->setProgress( i );
	   if ( fProgress->wasCancelled() )
	     break;
	   
	   if (!retrieveHeaders(i, serverInfo, config, headerList))
	     {
	       fProgress->setProgress( numMsgs );
	       destroyProgrssDialog();
	       return false;
	     }
	   
	   fProgress->setProgress( numMsgs );
	 }
       
       destroyProgrssDialog();
     }
   
   else
     {
       
       // Same as code above, but with no progress bar support
       for (i = 0; i < numMsgs; i++)
	 {
	   if (!retrieveHeaders(i, serverInfo, config, headerList))
	     return false;
	 }
     }
   // ************************* END REQUEST HEADERS ****************************
    
   //************************* SEND QUIT *******************************
   
   command = "A04 LOGOUT\r\n";
   writeLine(command);
   readLine(response);
   while (response[0] == '*')
     readLine(response);
   
   // Wait for results from that command
   checkResponse(response, "A04");

   // ************************ END SEND QUIT ***************************

  destroyProgrssDialog();

  destroyConnection();
  
return true;
}

bool ClientImap::checkResponse(QString response, QString commandId)
{
  QString errorString;
  QString possibleResponse;

  // Every read will give us a result, either ok or err. We need
  // to get that value now.
  
  possibleResponse = commandId;
  possibleResponse += " OK";
  if (response.contains(possibleResponse))
    {
      return true;
    }
  
  possibleResponse = commandId;
  possibleResponse += " NO";
  if (response.contains(possibleResponse))
    {
      errorString = "Server returned an error. Error was: ";
      errorString += response;
      ERROR(errorString);
      
      return false;
    }

  possibleResponse = commandId;
  possibleResponse += " BAD";
  if (response.contains(possibleResponse))
    {
      errorString = "Server returned an error. Error was: ";
      errorString += response;
      ERROR(errorString);
      
      return false;
    }

 return false;
}

bool ClientImap::retrieveHeaders(int msgNum, ServerStruct* serverInfo, KConfig* config, QList<HeaderStruct>* headerList)
{
  HeaderStruct *headerInfo;
  QString command, response;
  char intToString[5];
  bool validReadLine = true;
  int loopCount = 0;

  headerInfo = new HeaderStruct;
  headerInfo->address = serverInfo->username + "@" + serverInfo->address;
  
  command = "A20 FETCH ";
  sprintf(intToString, "%d", msgNum+1);
  command += intToString;
  command += " RFC822.HEADER\r\n";
  
  writeLine(command);
  
  validReadLine = readLine(response);
  while ((validReadLine) && (!response.contains("A20 OK FETCH completed")) && (loopCount < 5000))
    {
      parseHeaderLine(response, headerInfo);
      validReadLine = readLine(response);
      loopCount++;
    }
    
  if (loopCount > 5000)
    ERROR("Attempted to read from the socket 5000 times. Breaking out of loop.");
  
  // Now run it through the filter
  config->setGroup("FILTER");
  if (config->readBoolEntry("UseFiltering", false))
    if (runThroughFilter(headerInfo))
      {
	switch (config->readNumEntry("Command", COMBO_ID_IGNORE))
	  {
	  case COMBO_ID_IGNORE:
	    //cout << "Header being ignored" << endl;
	    delete (headerInfo);
	    break;
	    
	  case COMBO_ID_DELETE:
	    command = "A21 STORE ";
	    sprintf(intToString, "%d", msgNum+1);
	    command += intToString;
	    command += " +FLAGS (\\DELETED)\r\n";
	    writeLine(command);
	    delete(headerInfo);
	    
	    readLine(response);
	    while (response[0] == '*')
		readLine(response);

	    // Wait for results from that command
	    if (!checkResponse(response, "A21"))
	      return 0;

	    // We need to expunge the box a well
	    command = "A22 EXPUNGE\r\n";
	    writeLine(command);
	    
	    
	    // Wait for results from that command
	    readLine(response);
	    while (response[0] == '*')
	      readLine(response);
	    
	    if (!checkResponse(response, "A22"))
	      return 0;
	    break;
	  }
      }
    else
      headerList->append(headerInfo);
  else
    headerList->append(headerInfo);

  return true;
}
