/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kstatsview.h"

KStatsView::KStatsView(QWidget *parent, KnetdumpDoc* doc, const char *name ) : QListView(parent,name) , pdoc(doc) {
  starttime = 0;
  spanbr=0;
  spanpkt=0;
  peakactivity=0;
  peakpps=0;

  setSorting(-1, TRUE);
  addColumn("eth0", -1);
  setColumnWidth(0,100);
  addColumn("Packets", -1);
  setColumnWidth(1,75);
  addColumn("Bytes");
  setColumnWidth(2,75);
  addColumn("Activity");
  setColumnWidth(3,100);
  addColumn("PeakActivity");
  setColumnWidth(4,120);
  
  // the sort order in QListView is first-in-last-viewed
  othersitem = new QListViewItem(this, "Others:", "0", "0", "", "");
  netbiositem = new QListViewItem(this, "NETBIOS:", "0", "0", "", "");
  appleitem = new QListViewItem(this, "Appletalk:", "0", "0", "", "");
  ipxitem = new QListViewItem(this, "IPX:", "0", "0", "");

  badipitem = new QListViewItem(this, "Bad-IP:", "0", "0", "", "");
  otheripitem = new QListViewItem(this, "OTHER-IP:", "0", "0", "", "");
  icmpitem = new QListViewItem(this, "ICMP:", "0", "0", "", "");
  udpitem = new QListViewItem(this, "UDP:", "0", "0", "", "");
  tcpitem = new QListViewItem(this, "TCP:", "0", "0", "", "");
  ipitem = new QListViewItem(this, "IP:", "0", "0", "", "");
  rarpitem = new QListViewItem(this, "RARP:", "0", "0", "", "");
  arpitem = new QListViewItem(this, "ARP:", "0", "0", "0", "0");
  packetitem = new QListViewItem(this, "Total:", "0", "0", "0", "0");

  triggerUpdate();
  setColumnWidthMode(1,QListView::Maximum);
  setAllColumnsShowFocus(1);
  setSorting(-1, TRUE);
  show();   

  gettimeofday(&tv, NULL);
  starttime  = tv.tv_sec;  
  activitytimer = new QTimer(this, "Stats Timer");
  connect( activitytimer, SIGNAL(timeout()), SLOT(timerDone()) );
  activitytimer->start( 1000, FALSE );                 // 2 seconds single-shot 
}

KStatsView::~KStatsView(){
  activitytimer->stop();
  delete(activitytimer);
}

void KStatsView::slotChangeInterface(QString name) {
   // only eth0 is valid, yet.
  if (pdoc->devIsPresent(name))
      interface=name;
  else
      cerr << "*** the interface=" << name.data() << " was not found " << endl;
  draw();
}


void KStatsView::startslot () {
    //
    // startslot
    //
    draw();

    spanbr+= pdoc->byterec();
    spanpkt++;

    // finished work on received packet, inform doc
    emit gotData();
}

void KStatsView::draw() {
    //
    // view each received packet as headers
    // 
    
    // set counters
  if (interface.isNull())
    return;
  struct stats stat=pdoc->getStatstruct(interface.data());;
    QString str;

    // set packet counter
    str.sprintf("%u", stat.pcounter.packet);  packetitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.arp);        arpitem->setText(1,str); 
    str.sprintf("%u", stat.pcounter.rarp);      rarpitem->setText(1,str); 
    str.sprintf("%u", stat.pcounter.ip);          ipitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.tcp);        tcpitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.udp);        udpitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.icmp);      icmpitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.otherip);otheripitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.badip);    badipitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.ipx);        ipxitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.apple);    appleitem->setText(1,str);
    str.sprintf("%u", stat.pcounter.netbios);netbiositem->setText(1,str);
    str.sprintf("%u", stat.pcounter.others);  othersitem->setText(1,str);

    // set byte counter
    str.sprintf("%u", stat.bcounter.packet);  packetitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.arp);        arpitem->setText(2,str); 
    str.sprintf("%u", stat.bcounter.rarp);      rarpitem->setText(2,str); 
    str.sprintf("%u", stat.bcounter.ip);          ipitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.tcp);        tcpitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.udp);        udpitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.icmp);      icmpitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.otherip);otheripitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.badip);    badipitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.ipx);        ipxitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.apple);    appleitem->setText(2,str);
    str.sprintf("%u", stat.bcounter.netbios);netbiositem->setText(2,str);
    str.sprintf("%u", stat.bcounter.others);  othersitem->setText(2,str);
}

void KStatsView::timerDone()
{
  float activity;
  float pps;
  unsigned long now;
  QString *timerstr = new QString();    
  gettimeofday(&tv, NULL);
  now = tv.tv_sec;

  if (now - starttime >= 1) {
    activity = (float) (spanbr / 1024) / (float) (now - starttime);
    timerstr->sprintf("%2.2f kbytes/sec",activity);
  
    packetitem->setText(3,timerstr->data());

    pps = (float) (spanpkt) / (float) (now - starttime);
    spanbr = 0;
    spanpkt = 0;
    starttime = now;

    timerstr->sprintf("%2.2f pkts/sec",pps);
    arpitem->setText(3,timerstr->data());

    if (activity > peakactivity) {
      peakactivity = activity;
      timerstr->sprintf("%2.2f kbytes/sec",peakactivity);
      packetitem->setText(4,timerstr->data());
    }
    
    if (pps > peakpps) {
      peakpps = pps;
      timerstr->sprintf("%2.2f pkts/sec",peakpps);
      arpitem->setText(4,timerstr->data());
    }
  }                       
}
