/***************************************************************************
                          usrmodem.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef USRMODEM_H
#define USRMODEM_H

#include <stdio.h>
#include <qstring.h>
#include <qlist.h>
#include "modemconnector.h"

struct USRMemHdr {
  unsigned char  mIndex;
  unsigned char  mType;
  unsigned char  mPages;
  char           Filler[5];
  char           mSender[20];
  unsigned char  mPrevPage;
  unsigned char  mPrevAddr1;
  unsigned char  mPrevAddr2;
  unsigned char  mNextPage;
  unsigned char  mNextAddr1;
  unsigned char  mNextAddr2;
}; /* 34 byte */

enum MessageType {unknown, Fax, Voice, Data};
enum MessageAttrib {Atunknown, UnreleasedUnchecked, UnreleasedChecked, ReleasedChecked};

struct ModemGeneralInfo {
	int memSize;
	int memUsed;
	int noVoiceMsg;
	int noVoiceUnreleased;
	int noFaxMsg;
	int noFaxUnreleased;
	bool outMsgPresent;
	bool fullMsgPresent;
};

struct ModemMsgInfoStruct {
	int msgIndex;
	enum MessageType msgType;
	int msgSize;
	enum MessageAttrib msgAttribute;
	int msgStatus;
	bool clockValid;
	int msgDay;
	int msgHour;
	int msgMinute;
	QString callerId;
	int msgStartPage;
	unsigned int msgAddress;
};

/** typedef of a list class that stores message inx */
typedef QList<ModemMsgInfoStruct> ModemMessageList;

/**	This class specialices the ModemConnector class for the
		USR Modem. It adds specific functionality.
  *	@author Torsten Uhlmann
*/
class USRModem : public ModemConnector
{
	Q_OBJECT

public:

	enum ModemType {unknownModem, MessageModem, ProfessionalModem};

	USRModem(const QString&, const QString&, const QString&);
	~USRModem();
	
	bool initModem();
	bool resetModem();
	
  bool getFax(int, const QString&);
  bool getMemory();
	// get pages of memory from start to stop
	bool getMemoryPage(int start, int stop);
  bool getMemoryInfo(ModemGeneralInfo& ,ModemMessageList&);
  bool clearMemory();

  QString getFaxFileName();
  QString getVoiceFileName();
  QString getMemoryFileName();
  QString getUserMemoryFileName();
  int  		getPagesWritten();

	/** functions for voice messages */
	bool getUserPageVoice(int , const QString&);
  bool getVoice(int, const QString&);
  bool playVoiceIntern(int);

	/** set / unset functions which control the modem */
	bool 		setStandaloneMode();
	bool 		unsetStandaloneMode();
	bool 		resetClock();
	bool 		getFaxReception();
	bool 		setFaxReception();
	bool 		unsetFaxReception();
	bool 		getVoiceReception();
	bool 		setVoiceReception();
	bool 		unsetVoiceReception();
	bool 		getControlMonitor();
	bool 		setControlMonitor();
	bool 		unsetControlMonitor();
	bool 		setSetupRings(int);
	int  		getSetupRings();
	bool		setVoiceDuration(int);
	int			getVoiceDuration();
 	QString getSetupFaxId();
 	bool 		setSetupFaxId(QString);
	bool 		commitSetup();
	QString rawCommand(const QString&);
	bool		setMessageInternal(bool start, bool outgoing);
	bool		uploadVoiceMessage(QString,bool);
	bool		dialVoiceNumber(const QString);
	bool		hangupPhone();
	bool		setSpeakerMikeVolume(int,int);
	bool		getSpeakerMikeVolume(int&, int&);

	bool		memoryInfoValid() {return _memoryInfoValid;};

private:
  bool ExtractMessage(int, MessageType);
  bool ExtractMessageUserSector(int);

  int  WritePage(FILE*, unsigned char);
  QString	faxFileName(int);
  QString voiceFileName();
  void 		deleteMemoryFile();
  void 		deleteUserMemoryFile();
  void 		deleteFaxFiles();
  void 		deleteVoiceFiles();
  /** detects the type of the modem (Message or Professional) */
  ModemType detectModemType();

  QString memoryFile;
  QString userMemoryFile;
  QString faxFile;
  QString voiceFile;
  bool		_memoryInfoValid;
  bool 		tempFile;
  bool 		tempVoiceFile;
  int  		pagesWritten;
  int  		WasDLE;

  /** type of modem we deal with */
  ModemType modemType;

  /** structures to store modem info internal */
  ModemGeneralInfo modemInfo;
};

#endif







