/*
    KMLOFax

    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef EXPORTDLG_H
#define EXPORTDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qdialog.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcombobox.h>




class ExportDlg : public QDialog
{
	Q_OBJECT
public:
	ExportDlg(QWidget *parent = 0, const char *name = 0);
	~ExportDlg();

	void addToolTips(bool on);

	void exportFax(const QString& name, const QString& alias);

private slots:
	void browseClicked();
	void okClicked();

private:
	bool gotToolTips;

	QLineEdit *file;
	QPushButton *browse;

	QSpinBox *from_page;
	QSpinBox *to_page;

	QComboBox *compression;
	
	QString fname, salias;
};


extern ExportDlg *exportdlg;

#endif // EXPORTDLG_H
