/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <qglobal.h>

#include <kapp.h>

#include "kmlocfg.h"
#include "global.h"



KMLOCfg * kmlocfg;



void print_version()
{
	fprintf(stderr, "kmlocfg %s\n", VERSION);
}


void print_help()
{
	fprintf(stderr, "Usage: kmlocfg [-help] [-version] [generic Qt or KDE arguments]\n");
}


int main( int argc, char *argv[] )
{
	int ret, i;

	for (i=1; i < argc; i++) {
		if (strcmp(argv[i], "-help") == 0) {
			print_help();
			exit(1);
		}
		else if (strcmp(argv[i], "-version") == 0) {
			print_version();
			exit(1);
		}
	}

	test_dir("/.kde/");
	test_dir("/.kde/share");
	test_dir("/.kde/share/apps");
	test_dir("/.kde/share/apps/kmlocfg");

	mykapp = new KApplication( argc, argv, "kmlocfg" );
	CHECK_PTR( mykapp );

	kmlocfg = new KMLOCfg( "kmlocfgtop" );
	CHECK_PTR( kmlocfg );

	mykapp->setMainWidget( kmlocfg );
	mykapp->setTopWidget( kmlocfg );

	ret = mykapp->exec();

	delete kmlocfg;
	delete mykapp;

	return ret;
}
