/*  memmap_ioctl.c
 *
 */

#ifndef __KERNEL__
#define __KERNEL__
#endif
#ifndef MODULE
#define MODULE
#endif
#ifndef EXPORT_SYMTAB
#define EXPORT_SYMTAB 1
#endif

#include "memmap.h"

#include <linux/proc_fs.h>
#include <linux/sched.h>
#include <asm/uaccess.h>


int memmap_ioctl (struct inode *inode, struct file *filp,
                 unsigned int cmd, unsigned long arg)
{
	int pages, f_pos ;
	char buf[1] ;
//	int err = 0, size = _IOC_SIZE(cmd); /* the size bitfield in cmd */

	#ifdef MEMMAP_DEBUG
	printk( "memmap_ioctl(), cmd=%d\n", cmd ) ;
	#endif

	/*
	 * extract the type and number bitfields, and don't decode
	 * wrong cmds: return EINVAL before verify_area()
	 */
	if (_IOC_TYPE(cmd) != MEMMAP_IOCTL_MAGIC) return -EINVAL;
	if (_IOC_NR(cmd) > MEMMAP_IOCTL_MAXNR) return -EINVAL;

	/*
	 * the direction is a bitmask, and VERIFY_WRITE catches R/W
	 * transfers. `Type' is user-oriented, while
	 * verify_area is kernel-oriented, so the concept of "read" and
	 * "write" is reversed
	 */
/*	if (_IOC_DIR(cmd) & _IOC_READ)
		err = access_ok(VERIFY_WRITE, (void *)arg, size));
	else if (_IOC_DIR(cmd) & _IOC_WRITE)
		err =  access_ok(VERIFY_READ, (void *)arg, size);
	if (err) return err;
*/

	switch(cmd) {

#ifdef MEMMAP_DEBUG
		case MEMMAP_IOCTL_RESET:
        		/*
        		 * reset the counter to 1, to allow unloading in case of problems.
        		 * Use 1, not 0, because the invoking file is still to be closed.
        		 */
//	        	mod_use_count_ = 1;
			break;
#endif
		case MEMMAP_IOCTL_GET_NR_OF_PAGES:
			pages = ( (MemmapDevice*)(filp->private_data) )->size ;
			put_user( pages, (int *)arg ) ;
			break ;
		case MEMMAP_IOCTL_GET_PAGE:
			get_user( pages, (int *)arg ) ;
			f_pos = filp->f_pos ;
			filp->f_pos = pages ;
			memmap_read( filp, buf, 1, 0 ) ; /* what's the last argument ?? */
			printk("ioctl : %d\n", *buf ) ;
			put_user( (int)(*buf), (int *)arg ) ;
			filp->f_pos = f_pos ;
			break ;
		default:  /* redundant, as cmd was checked against MAXNR */
		        return -EINVAL;
	}
	return 0;
}


