/***************************************************************************
                          setyear.cpp  -  description
                             -------------------
    begin                : Sat Nov 13 1999
    copyright            : (C) 1999 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#include "setyear.h"
#include "qpushbutton.h"
#include "qspinbox.h"
#include "knuminput.h"
#include "kdialog.h"
#include <qstring.h>
#include "qpainter.h"
#include "klocale.h"
#include "qnamespace.h"

setYear::setYear( QWidget *parent, const char *name, int initialize ) : KDialog( parent, name)
{
setFixedSize(120, 100);
show();
setCaption(i18n("Set year"));
set = new QPushButton( i18n("Set"), this, "set" );
set->setGeometry( 6, 65, 53, 27);
set->setDefault(TRUE);
set->show();
connect( set, SIGNAL(clicked()), SLOT(returnValue()) );
connect( set, SIGNAL(clicked()), SLOT(accept()) );
cancel = new QPushButton( i18n("Cancel"), this, "cancel" );
cancel->setGeometry( 59, 65, 53, 27 );
cancel->setAccel(Key_Escape);
cancel->show();
connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
//QSpinBox *spinbox = new QSpinBox( 1, 2999, 1, this, "spin" );
KIntSpinBox *spinbox = new KIntSpinBox( 1, 2999, 1, initialize, 10, this, "spin" );
spinbox->setGeometry( 30, 30, 60, 30 );
//spinbox->setValue( initialize );
spinbox->show();
connect( spinbox, SIGNAL(valueChanged(int)), SLOT(setValue(int)) );

}
setYear::~setYear()
{
 	emit valueChanged( value );
}

void setYear::paintEvent( QPaintEvent * )
{
QPainter s;
QPen pen( black, 1);
s.begin( this );
//char *message="Enter year:";
s.setFont(QFont("times", 18/*, QFont::Bold*/));
QString message(i18n("Enter year:"));
s.drawText( 0, 0, 120, 30, AlignCenter, message, -1);
s.end();
}

void setYear::setValue( int spinboxresult )
{
	value = spinboxresult;
//	emit valueChanged( value );
}

void setYear::returnValue( )
{
	emit valueChanged( value );
}
