/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qvalidator.h>

#include <kapp.h>

#include "update.h"


UpdateDialog::UpdateDialog(bool a, int i, QWidget *parent, const char *name) : QDialog(parent, name, true) , auto_update(a) , update_interval(i)
{
	active_w = new QCheckBox(i18n("&Enable auto update"), this);
	active_w->adjustSize();
	active_w->move(10,10);
	active_w->setChecked(auto_update);

	interval_w = new QLineEdit(this);
	interval_w->setMaxLength(5); 
	interval_w->setText("99999");
	interval_w->adjustSize();

	QLabel *l = new QLabel(interval_w, i18n("&Interval (3 - 99999 sec)"), this);
	l->adjustSize();
	l->move(10, 30 + active_w->height());

	interval_w->move(20 + l->width(), l->y());

	QIntValidator *validator = new QIntValidator(3, 99999, this);
	interval_w->setValidator(validator);

	connect(active_w, SIGNAL(clicked()), SLOT(activeClicked()));
	connect(interval_w, SIGNAL(returnPressed()), SLOT(accept()));
	connect(interval_w, SIGNAL(textChanged(const char *)), SLOT(textChanged(const char *)));

	ok = new QPushButton(i18n("Ok"), this);
	ok->adjustSize();
	connect(ok, SIGNAL(clicked()), SLOT(accept()));

	cancel = new QPushButton(i18n("Cancel"), this);
	cancel->adjustSize();
	connect(cancel, SIGNAL(clicked()), SLOT(reject()));

	ok->move(40, interval_w->y() + interval_w->height() + 20);
	int x;
	x = interval_w->x() + interval_w->width() + 10;
	if (320 > x)
		x = 320;
	cancel->move(x - 140, ok->y());

	setFixedSize(x, ok->y() + ok->height() + 10);

	active_w->setChecked(auto_update);
	activeClicked();
	interval_w->setText(QString().setNum(update_interval));
	textChanged(interval_w->text());

	setCaption(i18n("Auto update"));

	changed = false;
}


void UpdateDialog::activeClicked()
{
	auto_update = active_w->isChecked();
	if (!auto_update)
		interval_w->setText(QString().setNum(update_interval));
	interval_w->setEnabled(auto_update);
}


void UpdateDialog::textChanged(const char *t)
{
	int i = 0;
	QString s(t);
	bool valid = interval_w->validator()->validate(s, i) == QValidator::Acceptable;
	ok->setEnabled(valid);
	ok->setDefault(valid);
	if (valid)
		update_interval = QString(t).toInt();
}


#include "update.moc"
