/* -------------------------------------------------------------

   htmlimager.cpp (part of K HTML Imager)

   (C)  by Andreas Heck

 ------------------------------------------------------------- */

#include "htmlimager.h"
#include <iostream.h>

HTMLImager::HTMLImager()
{
 directory = new QDir;
}

HTMLImager::~HTMLImager()
{

}

int HTMLImager::createHTML(const char *dirname, const char *filename, bool recursively)
{
 int counter = 0;
 QString fullFileName;
 const QFileInfoList *list = filterDir(dirname, recursively);
 QFileInfoListIterator it(*list);
 QFileInfo *fi;

 if (!it)
   return -1;

 fullFileName.sprintf("%s%s",dirname,filename);

 QFile file(fullFileName);
 if ( !file.open( IO_WriteOnly ) )
    return -1;

 QTextStream textstream(&file);

 textstream << "<HTML>\n<HEAD>\n<TITLE>Images</TITLE>\n</HEAD>\n<BODY>\n <H1>This file was generated by K HTML Imager";

 while ( (fi=it.current()) )
  {
   textstream << "\n <P><IMG SRC=\"" << fi->fileName() << "\" alt=\"" << fi->fileName() << "\"></P>";
   ++it;
   counter++;
  }
 textstream << "\n</BODY>\n</HTML>";
 return counter;
}

const QFileInfoList * HTMLImager::filterDir(const char *dirname, bool recursively) const
{
 directory->setPath(dirname);
 directory->setNameFilter("*.jpg");
 return (directory->entryInfoList());
}
