/*
 * heisedlg.cpp
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qstring.h>

#include <kapp.h>
#include "klocale.h"

#include "heisedlg.h"
#include "heisedlg.moc"

#define SEPARATOR 6
#define ELEM_HEIGHT 24
#define ELEM_WIDTH  70


/************************************************************************
* Constructor
*/
HeiseDlg::HeiseDlg(QWidget *parent,const char* name)
                                  : QWidget(parent,name) 
{
  // default values
  heisereg_path = new QString("./heisereg");
  heisereg_proggy = new QString(heisereg_path->copy());
  heisereg_proggy->append("/heise");
  heisereg_frm = new QString(heisereg_path->copy());
  heisereg_frm->append("/inhalt.frm");


  mainLayout = new QVBoxLayout(this,SEPARATOR); CHECK_PTR(mainLayout);

 // pattern Group
  patternGroup = new QGroupBox(klocale->translate("Searchpatterns"),this); 
  CHECK_PTR(patternGroup);

  patternEdit = new KStrListEdit(patternGroup); CHECK_PTR(patternEdit);
  patternEdit->move(2*SEPARATOR,4*SEPARATOR);

  searchGroup = new QButtonGroup(klocale->translate("Search"),patternGroup);
  CHECK_PTR(searchGroup);
  searchGroup->setFixedSize(ELEM_WIDTH+2*SEPARATOR,4*ELEM_HEIGHT+5*SEPARATOR);
  startBtn = new QPushButton(klocale->translate("&Start"),searchGroup);
  CHECK_PTR(startBtn);
  startBtn->setGeometry(SEPARATOR,3*SEPARATOR
                        ,searchGroup->width()-2*SEPARATOR
                        ,(searchGroup->height()-5*SEPARATOR)/2 );
  connect(startBtn,SIGNAL(clicked()),this,SIGNAL(startSearch()) );

  stopBtn = new QPushButton(klocale->translate("S&top"),searchGroup);
  CHECK_PTR(stopBtn);
  //  stopBtn->setFixedSize(ELEM_WIDTH,ELEM_HEIGHT);
  stopBtn->setGeometry(SEPARATOR,startBtn->y()+startBtn->height()+SEPARATOR
                        ,startBtn->width()
                        ,startBtn->height() );
  stopBtn->setEnabled(FALSE);
  searchGroup->insert(startBtn);
  connect(stopBtn,SIGNAL(clicked()),this,SIGNAL(stopSearch()) );

  patternGroup->setFixedHeight(patternEdit->height()+6*SEPARATOR);
  mainLayout->addWidget(patternGroup,15);

 // param Group 
  paramGroup = new QGroupBox(klocale->translate("Settings"),this);
  CHECK_PTR(paramGroup);
 
 // 2 onOffGroups are initalized (and/or, phon)
  for (int i=0;i<2;i++) { 
    onOffGroup[i] = new QButtonGroup(paramGroup); CHECK_PTR(onOffGroup[i]);
    on_OnOffRadio[i] = new QRadioButton(klocale->translate("on"),onOffGroup[i]);
    off_OnOffRadio[i] = new QRadioButton(klocale->translate("off"),onOffGroup[i]);
    CHECK_PTR(on_OnOffRadio[i]);
    CHECK_PTR(off_OnOffRadio[i]);
    onOffGroup[i]->setFixedSize(2*ELEM_WIDTH+3*SEPARATOR
                               ,1*ELEM_HEIGHT+4*SEPARATOR );
    onOffGroup[i]->insert(on_OnOffRadio[i],1);
    onOffGroup[i]->insert(off_OnOffRadio[i],2);
  }
  onOffGroup[0]->setTitle(  klocale->translate("Conjunction Mode") );
    on_OnOffRadio[0]->setText(klocale->translate("and") );
    off_OnOffRadio[0]->setText(klocale->translate("or") );
    connect(onOffGroup[0],SIGNAL(clicked(int)),this,SLOT(conjModeSlot(int)) );
  onOffGroup[1]->setTitle(  klocale->translate("phonetic search") );
    connect(onOffGroup[1],SIGNAL(clicked(int)),this,SLOT(phonSearchSlot(int)) );
  
  // 3 ModeGroups are initalized (ign,reg,iso)
  for (int i=0;i<3;i++) { 
    modeGroup[i] = new QButtonGroup(paramGroup); CHECK_PTR(modeGroup[i]);
    on_ModeRadio[i] = new QRadioButton(klocale->translate("on"),modeGroup[i]);
    off_ModeRadio[i] = new QRadioButton(klocale->translate("off"),modeGroup[i]);
    auto_ModeRadio[i] = new QRadioButton(klocale->translate("auto"),modeGroup[i]);
    CHECK_PTR(on_ModeRadio[i]);
    CHECK_PTR(off_ModeRadio[i]);
    CHECK_PTR(auto_ModeRadio[i]);
    modeGroup[i]->setFixedSize(3*ELEM_WIDTH+4*SEPARATOR
                               ,1*ELEM_HEIGHT+4*SEPARATOR );
    modeGroup[i]->setAlignment(AlignRight);
    modeGroup[i]->insert(on_ModeRadio[i],1);
    modeGroup[i]->insert(off_ModeRadio[i],2);
    modeGroup[i]->insert(auto_ModeRadio[i],3);
  }
  modeGroup[0]->setTitle(  klocale->translate("Ignore case") );
    connect(modeGroup[0],SIGNAL(clicked(int)),this,SLOT(ignoreCaseSlot(int)) );
  modeGroup[1]->setTitle(  klocale->translate("regExpressions (*,?) ") );
  //connect(modeGroup[1],SIGNAL(clicked(int)),this,SLOT(regExprSlot(int)) );
  modeGroup[2]->setTitle(  klocale->translate("convert umlaut to ISO") );
  //    connect(modeGroup[2],SIGNAL(clicked(int)),this,SLOT(umlautConvSlot(int)) );

  paramGroup->setFixedHeight(3*modeGroup[0]->height()+7*SEPARATOR);
  mainLayout->addWidget(paramGroup,25);

 // heiseWrapper Group
  hwGroup = new QGroupBox(klocale->translate("found articles"),this);
  CHECK_PTR(hwGroup);
  hwGroup->move(0,0);
  hw = new HeiseWrapper(hwGroup); CHECK_PTR(hw);
  hw->move(2*SEPARATOR,4*SEPARATOR);
  mainLayout->addWidget(hwGroup,60);
  connect(hw,SIGNAL(searchDone()),this,SIGNAL(searchDone()) );
  mainLayout->activate();

 // default RadioButton-Activation
 // overrides (resets) the defaults from HeiseWrapper!!
  on_OnOffRadio[0]->setChecked(TRUE);
  off_OnOffRadio[1]->setChecked(TRUE);

  auto_ModeRadio[0]->setChecked(TRUE);
  auto_ModeRadio[1]->setChecked(TRUE);
  auto_ModeRadio[2]->setChecked(TRUE);


  // no direct slot-invocation
  //  connect(this,SIGNAL(startSearch()),this,SLOT(startSearchSlot()) );
  //connect(this,SIGNAL(stopSearch()), this,SLOT(stopSearchSlot()) );
  
  connect(this,SIGNAL(searchDone()), this,SLOT(searchDoneSlot()) );
  
  adjustSize(); // get minimum space required for all widgets in Dlg
  show();

}

/************************************************************************
  * resizeEvent
  **/
void HeiseDlg::resizeEvent(QResizeEvent *) {
  //debug("HeiseDlg::resizeEvent: %dx%d",width(),height()); 

  // patternEdit+start/stop-Button
 
  patternEdit->resize(patternGroup->width()-5*SEPARATOR-searchGroup->width()
                      ,50);
  searchGroup->move(patternEdit->x()+patternEdit->width()+SEPARATOR,
                    patternEdit->y() -2*SEPARATOR );
                 
  // 2 OnOff Groups
  for (int i=0;i<2;i++) {
    onOffGroup[i]->move(2*SEPARATOR
                       ,3*SEPARATOR+ i*(modeGroup[i]->height()+1*SEPARATOR) );
    on_OnOffRadio[i]->setGeometry(1*SEPARATOR
                            ,3*SEPARATOR
                            ,ELEM_WIDTH,ELEM_HEIGHT);
    off_OnOffRadio[i]->setGeometry(on_OnOffRadio[i]->x()
                                 +on_OnOffRadio[i]->width()+1*SEPARATOR
                             ,on_OnOffRadio[i]->y(),ELEM_WIDTH,ELEM_HEIGHT);
  }
 
  // 3 Mode Groups
  for (int i=0;i<3;i++) {
    modeGroup[i]->move(paramGroup->width()-2*SEPARATOR-modeGroup[i]->width()
                       ,3*SEPARATOR+ i*(modeGroup[i]->height()+1*SEPARATOR) );
    on_ModeRadio[i]->setGeometry(1*SEPARATOR
                            ,3*SEPARATOR
                            ,ELEM_WIDTH,ELEM_HEIGHT);
    off_ModeRadio[i]->setGeometry(on_ModeRadio[i]->x()
                                 +on_ModeRadio[i]->width()+1*SEPARATOR
                             ,on_ModeRadio[i]->y(),ELEM_WIDTH,ELEM_HEIGHT);
    auto_ModeRadio[i]->setGeometry(off_ModeRadio[i]->x()
                                 +off_ModeRadio[i]->width()+1*SEPARATOR
                             ,off_ModeRadio[i]->y(),ELEM_WIDTH,ELEM_HEIGHT);
  }
  
    hw->resize(hwGroup->width()-hw->x()-2*SEPARATOR
             ,hwGroup->height()-hw->y()-2*SEPARATOR );
};

/************************************************************************
  * updateDBSlot
**/
void HeiseDlg::updateDBSlot(QString file) {
  //debug("HeiseDlg::updateDBSlot");
  if (file.isEmpty()) return;
  startBtn->setEnabled(FALSE);
  stopBtn->setEnabled(FALSE);
  hw->updateDB( file );
}

/************************************************************************
  * startSearchSlot
**/
void HeiseDlg::startSearchSlot() {
  //debug("HeiseDlg::startSearchSlot");
  if ( !patternEdit->isEmpty() ) {
    startBtn->setEnabled(FALSE);
    stopBtn->setEnabled(TRUE);
    hw->startSearch( patternEdit->data() );
  } else {
    emit searchDone();
    kapp->beep();
  }
}

/************************************************************************
  * stopSearchSlot
**/
void HeiseDlg::stopSearchSlot() {
  //debug("HeiseDlg::stopSearchSlot");
  startBtn->setEnabled(TRUE);
  stopBtn->setEnabled(FALSE);
  hw->stopSearch();
}

/************************************************************************
  * searchDoneSlot
**/
void HeiseDlg::searchDoneSlot() {
  //debug("HeiseDlg::searchDoneSlot");
  startBtn->setEnabled(TRUE);
  stopBtn->setEnabled(FALSE);
}

/************************************************************************
  * adjustSize
**/
QSize HeiseDlg::sizeHint() {
  //debug("HeiseDlg::adjustSize");
  QSize siz;
  siz.setWidth(480);
  siz.setHeight(540);
  return siz;
}
     
