/**
* @short Search dialog class.
*
* KGrepSearchDlg provides all the code for the dialog where the user
* enters the search pattern information and the location to search.
* This dialog is modeless so that it will remember the search pattern
* between searches and for general convenience to the user.
*
* @author Keith Brown <kbrown@logikos.com>, Jeff Cody <jcody@logikos.com>
* @version 0.0.1
**/

////////////////////////////////////////////////////////////////////////
//
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class Name  : KGrepSearchDlg
//
//  File Name   : kgrepsearchdlg.h
//
//  Originated  : 6-Sept-99  Keith Brown (kbrown@logikos.com),
//                           Jeff Cody   (jcody@logikos.com)
//
//  Abstract    : Search dialog.  See notes above.
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////
#ifndef KGREPSEARCHDLG_H
#define KGREPSEARCHDLG_H

// Compiler includes
#include <kapp.h>
#include <qbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qtabdialog.h>
#include <kprocess.h>

// Project includes

// Types and constants

// Forward declarations



class KGrepSearchDlg : public QTabDialog
{
    // Meta-object compiler thingy
    Q_OBJECT

    // Attributes
    protected:
        QString    m_argStr;                    // User selected arguments
        QCheckBox* m_binDataChkBox;             // Read binary data search option
        QCheckBox* m_caseSenChkBox;             // Case Sensitive search option
        QButton*   m_dirBtn;                    // Directory "Browse..." button
        QLineEdit* m_dirEdit;                   // Directory edit field
        QButton*   m_fileBtn;                   // File "Browse..." button
        QLineEdit* m_fileEdit;                  // File edit field
        QCheckBox* m_linesWOMatchChkBox;        // Lines without match search option
        QLineEdit* m_patEdit;                   // Pattern edit field
        QButton*   m_patFileBtn;                // Pattern file "Browse..." button
        QLineEdit* m_patFileEdit;               // Pattern file edit field
        QCheckBox* m_recurseDirChkBox;          // Recurse sub-directory search option
        QCheckBox* m_reqWholeWordChkBox;        // Require whole word to match search option
        QCheckBox* m_reqWholeLineChkBox;        // Require whole line to match search option


    // Methods
    public:
        /** Constructor. */
        KGrepSearchDlg(QWidget* parent=0, const char* name=0, bool modal=false);

        /** Destructor. */
        ~KGrepSearchDlg();

    signals:
        /** Signal when OK button has been selected. */
        void okSelected(QString argStr);

    public slots:
        /** Slot to set state before dialog is shown. */
        void slotAboutToShow();

        /** Slot (event-handler) for dialog cancel. */
        void slotCancel();

        /** slot for directory browse button click. */
        void slotDirBrowse();

        /** Slot for directory edit text changing. */
        void slotDirEntry(const char*);

        /** Slot for file browse button click. */
        void slotFileBrowse();

        /** Slot for file edit text changing. */
        void slotFileEntry(const char*);

        /** Slot for pattern edit text changing. */
        void slotPatternEntry(const char*);

        /** Slot for pattern file browse button click. */
        void slotPatternFileBrowse();

        /** Slot for pattern file edit text changing. */
        void slotPatternFileEntry(const char*);

        /** Slot (event-handler) for dialog OK. */
        void slotOK();

    private:
        void createTabPattern(QWidget* parent);
        void createTabLocation(QWidget* parent);

};  // end class KGrepSearchDlg


// Inline function definitions


#endif // KGREPSEARCHDLG_H

// end file kgrepsearchdlg.h
