#include <kgps.h>
#include <kgps.moc>

#include <kconfig.h>

KConfig* config;

KGPS::KGPS(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
	config = new KConfig(QString(kapp->kde_configdir() + "/kgpsrc"));
	setGeometry(0,0,800,600);
	
	QPopupMenu *file_menu = new QPopupMenu();
	file_menu->insertItem(i18n("E&xit"), kapp, SLOT(quit()));

	QPopupMenu *help_menu = new QPopupMenu();
	help_menu->insertItem(i18n("&Help"), this, SLOT(invokeHelp()));

	menuBar = new KMenuBar(this, "menubar");
	menuBar->insertItem(i18n("&File"), file_menu);
	menuBar->insertItem(i18n("&Help"), help_menu);

	setMenu(menuBar);

	statusBar = new KStatusBar(this);
	setStatusBar(statusBar);

	view = new KGPSWidget(this);
	setView(view);
}

KGPS::~KGPS()
{
	config->sync();
	view->close();
	delete statusBar;
	delete menuBar;
}

void KGPS::invokeHelp()
{
	kapp->invokeHTMLHelp("kgps/kgps.html", "");
}

