#ifndef __LISTVIEW_H_
#define __LISTVIEW_H_

#include <qlistview.h>
#include <qwidget.h>
#include <qpoint.h>
#include <qevent.h>

/**
 * This is the class definition of CListView. An inheritation of QListView.
 *
 * This class enables a ListView with dynamic width of the last column.
 */
class CListView : public QListView
{
  Q_OBJECT

public:
  /**
   * This is the constructor of class CListView.
   * It creates a ListView where the last column is resized together
   * with the parent.
   */
  CListView( QWidget* parent, const char* name = 0 );
  /**
   * This is the destructor of class CListView.
   */
  ~CListView();
    
  /**
   * Saves the size of the columns and other config type stuff to the
   * config file.
   */
  void saveOptions(); 
  
  /**
   * Sets the size of this list and resizes the last column appropriately.
   */
  void updateColumnSize();


protected:
  /**
   * This resizeEvent does the necessary stuff to update the columns.
   */
  void resizeEvent ( QResizeEvent * e );

};

#endif







