/***********************************************************************
**
**   wp.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef WP_STRUCT
#define WP_STRUCT

#include <qstring.h>

/**
  * This struct contains one point. The struct is used to represent the
  * Cartesian-coordinates. The resolution used in KFLog is 1/10,000th of a
  * minute (approx. 0.1852m on a great circle).
  * <P>
  * We decided to use minutes
  * instead of seconds as base unit, because our GPS-Logger used
  * them likewise ;-)
  * </P>
  * <P>
  * <TABLE>
  * <TR><TD>Therefore:</TD>
  *     <TD>1 second</TD><TD>=</TD><TD ALIGN="right"><TT>~167</TT></TD></TR>
  * <TR><TD></TD>
  *     <TD>1 minute</TD><TD>=</TD><TD ALIGN="right"><TT>10,000</TT></TD></TR>
  * <TR><TD></TD>
  *     <TD>1 degree</TD><TD>=</TD><TD ALIGN="right"><TT>600,000</TT></TD></TR>
  * </TABLE>
  * </P>
  * <P>
  * The Earth's circumference (1 degree * 360) is 216,000,000, so
  * we can use 32 bit integer vars to represent these values!
  * Positive values mean North or East and negative values South
  * or West.
  * </P>
  */
struct point
{
  /** The latitude ;-) */
  long latitude;
  /** The longitude ;-) */
  long longitude;
};

/**
  * This struct contains one flightpoint.
  */
struct flightPoint
{
  /** The latitude, registered by the logger. */
  long latitude;
  /** The longitude, registered by the logger. */
  long longitude;
  /** The barometrical height, registered by the logger. */
  int height;
  /** The gps-height, registered by the logger. */
  int gpsHeight;
  /** The time, the point was registered by the logger. */
  int time;
  /** The speed, calculated by KFLog. */
  float speed;
  /** The vario, calculated by KFLog. */
  float vario;
  /** <TT>true</TT>, if the flightpoint is near to one waypoint. */
  bool nearWP;
};

/**
  * This struct contains the data of one waypoint given to the logger.
  */
struct wayPoint
{
  /** The name of the waypoint. */
  QString name;
  /** The latitude ;-) */
  long latitude;
  /** The longitude ;-) */
  long longitude;
  /** <TT>true</TT>, if the waypoint was reached. */
  bool reached;
  /** The time, the waypoint was reached. */
  int time;
};

#endif
