/***********************************************************************
**
**   runway.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef RUNWAY_H
#define RUNWAY_H

/**
  * This struct is used for defining a runway. It is used for the
  * international airports. All other airports use the struct
  * "runway", because they don't need the coordinates of the runway.
  *
  * @author Heiner Lamprecht
  * @version 0.1
  */
struct intrunway
{
  /**
    * The length of the runway, given in meters.
    */
  unsigned int length;
  /**
    * The direction of the runway, given in steps of 10 degree.
    * NOTE: Only the first two digits are given. Thus "25" meens "250".
    */
  unsigned int direction;
  /**
    * The surface of the runway.
    *
    * @see Airport#Surface
    */
  unsigned int surface;
  /**
    * The coordinates of the two edged of the runway.
    */
  long latitudeA;
  /**
    * The coordinates of the two edged of the runway.
    */
  long longitudeA;
  /**
    * The coordinates of the two edged of the runway.
    */
  long latitudeB;
  /**
    * The coordinates of the two edged of the runway.
    */
  long longitudeB;
};

/**
  * This struct is used for defining a runway. It is used for all "small"
  * airports, not for the international airports, they use the struct
  * "intrunway", because they need two points per runway.
  *
  * @author Heiner Lamprecht
  * @version 0.1
  */
struct runway
{
  /**
    * The length of the runway, given in meters.
    */
  unsigned int length;
  /**
    * The direction of the runway, given in steps of 10 degree.
    * NOTE: Only the first two digits are given. Thus "25" meens "250".
    */
  unsigned int direction;
  /**
    * The surface of the runway.
    *
    * @see Airport#Surface
    */
  unsigned int surface;
};

#endif
