/***********************************************************************
**
**   flight.h
**
**   This file is part of KFLog
**
************************************************************************
**
**
**   Copyright (c):  1999 by Jan Max Walter Krueger
**                                 ( jkrueger@physics.otago.ac.nz )
**                           Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Tue Sep 28 1999
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef FLIGHT_H
#define FLIGHT_H

#include <mapcontents.h>
#include <lineelement.h>
#include <wp.h>

#include <qfile.h>
#include <qlist.h>
#include <qstring.h>

/**
  * Contains the logged flight-data.
  * @author Jan Max Walter Krueger ( jkrueger@physics.otago.ac.nz )
  * @author Heiner Lamprecht ( heiner@kijumfo.de )
  */
class Flight : public LineElement
{
 public:
	/**
	  * Creates a new flight-object and read the data from the given file.
	  */
	Flight(MapContents* mContents, QFile* flightDataFile);
	/**
	  * Destroys the flight-object.
	  */
	~Flight();
	/**
	  * Returns the name of the pilot.
	  */
	QString getPilot();
	/**
	  * Returns the type of the glider.
	  */
	QString getType();
	/**
	  * Returns the id of the glider.
	  */
	QString getID();
	/**
	  * Returns the starttime.
	  */
	QString getStartTime();
	/**
	  * Returns the start-site.
	  */
  QString getStartSite();
  /**
    * Returns the landing time.
    */
  QString getLandTime();
  /**
    * Returns the site, where the glider has landed.
    */
  QString getLandSite();
  /**
    *
    */
  QString getDate();
	/**
	  * Sets the values of the header.
	  */
	void setFlightHeader(QString pilot, QString gliderType,
	        QString gliderID, QString date);
  /** */
  void setRoute(struct flightPoint* flightRoute,
          unsigned int routeLength);
  /**
    * Appends a new waypoint to the list.
    */
  void appendWaypoint(QString name, long latitude, long longitude);
  /** */
	void checkWaypoints();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /** */
  QList<struct wayPoint>* getWPList();
	
private:
  /**
    * The name of the pilot.
    */
  QString pilotName;
  /**
    * The glider.
    */
  QString gliderType;
  /**
    * The id of the glider.
    */
  QString gliderID;
  /**
    * The start-time, detected by the logger.
    */
  QString startTime;
  /**
    * The site where the glider launched.
    */
  QString startSite;
  /**
    * The time of the landing.
    */
  QString landTime;
  /**
    * The site where the glider has landed.
    */
  QString landSite;
  /**
    * The difference between two timestamps.
    */
  int dtime;
  /**
    * The date ...
    */
  QString date;
  /** */
  MapContents* mapContents;
  /** */
  unsigned int routeLength;
  /** */
  struct flightPoint* flightRoute;
  /** */
  QList<struct wayPoint> wpList;
};

#endif
