/***********************************************************************
**
**   elevpoint.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "elevpoint.h"

#include <mapcalc.h>

#include <kapp.h>
#include <kiconloader.h>
#include <qdatastream.h>
#include <qfile.h>
#include <qtextstream.h>

bool ElevPoint::writeElementBin(const char* fileName)
{
  QFile outputFile(fileName);
  if(!outputFile.open(IO_WriteOnly | IO_Append)) {
    return false;
  }
  QDataStream out(&outputFile);

  out << (Q_UINT8) typeID;
  if((typeID != BaseMapElement::Obstacle) &&
     (typeID != BaseMapElement::LightObstacle) &&
     (typeID != BaseMapElement::ObstacleGroup) &&
     (typeID != BaseMapElement::LightObstacleGroup)) {
    out << (const char*) name;
  }
  out << (Q_INT32) latitude;
  out << (Q_INT32) longitude;
  out << (Q_UINT8) isWaypoint;
  out << (Q_UINT16) elevation;

  outputFile.close();

  return true;
}

bool ElevPoint::writeElementAscii(const char* fileName)
{
  QFile mapFile(fileName);
  if(!mapFile.open(IO_ReadWrite)) {
    return false;
  }
  mapFile.at(mapFile.size());
  QTextStream mapOut(&mapFile);

  mapOut << "[NEW]\n"
         << "TYPE=" << typeID << endl
         << "NAME=" << name << endl
         << "AT=" << latitude << " " << longitude << endl
         << "ELEVATION=" << elevation << endl
         << "WAYPOINT=" << (unsigned int) isWaypoint << endl
         << "[END]\n";
  mapFile.close();

  return true;
}

void ElevPoint::drawMapElement(QPainter* targetPainter,
          double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern double _currentScale;
  double lat, lon, projX, projY, drawX, drawY;

  lat = numToRad(latitude);
  lon = numToRad(longitude - mapCenterLon);

  projX = calc_X_Lambert(lat,lon);
  projY = calc_Y_Lambert(lat,lon);

  drawX = projX * RADIUS / _currentScale + dX;
  drawY = projY * RADIUS / _currentScale + dY;

  targetPainter->setPen(QPen(QColor(0,0,0), 2));
  char* kflog_dir = "/kflog/map";
  // Nochmal genau berprfen ...
  if(_currentScale > _scale[3]) {
    kflog_dir = "/kflog/map/small";
  }

  QString tempText;
  switch (typeID) {
    case Outlanding:
      break;
    case Obstacle:
      break;
    case LightObstacle:
      break;
    case ObstacleGroup:
      break;
    case LightObstacleGroup:
      break;
  }
}

ElevPoint::ElevPoint(QString n, unsigned int t, long latPos = 0,
            long lonPos = 0, unsigned int elev = 0)
    : SinglePoint(n, t, latPos, lonPos)
{
  elevation = elev;
}

ElevPoint::~ElevPoint()
{

}
