/***************************************************************************
                          mapobject.cpp  -  class for creating mapobjects
                             -------------------
    begin                : Sun Jun 27 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>

#include <mapcalc.h>
#include <mapobject.h>

#include <qfile.h>
#include <qtextstream.h>

/*
 * First the class Location will be implemented. This class is used to
 * store a single position in the internal format.
 */

void Location::setLat(long lat)
{
  latitude = lat;
}

void Location::setLon(long lon)
{
  longitude = lon;
}

long Location::getLat()
{
  return latitude;
}

long Location::getLon()
{
  return longitude;
}

Location::Location()
{
}

Location::Location(long lat, long lon)
{
  latitude = lat;
  longitude = lon;
}

Location::~Location()
{

}

/*
 * The class MapObject is used to create the several objects displayed
 * in the map. Each object MUST have at least a type, a number of
 * coordinates (0 is allowed) an a name.
 */
void MapObject::setAlias(QString new_alias = 0)
{
  alias = new_alias;
}

void MapObject::setAt(long at_lat = 0, long at_lon = 0)
{
  at.setLat(at_lat);
  at.setLon(at_lon);
}

void MapObject::setElev(QString elev = 0, int elevType = 0)
{
  elevation = elev;
}

void MapObject::setFrequency(QString freq_string = 0, bool vdf = false)
{
  frequency = freq_string;
}

void MapObject::setLocList(long* lat, long* lon)
{
  latitude = lat;
  longitude = lon;
}

const long MapObject::getAtLat()
{
  return at.getLat();
}

const long MapObject::getAtLon()
{
  return at.getLon();
}

const long* MapObject::getLatList()
{
  return latitude;
}

const long* MapObject::getLonList()
{
  return longitude;
}

const int MapObject::getLocLength()
{
  return locLength;
}

const QString MapObject::getName()
{
  return name;
}

const QString MapObject::getType()
{
  return type;
}

void MapObject::setLocLength(int coordNum = 0)
{
  locLength = coordNum;
  latitude = new long[coordNum];
  longitude = new long[coordNum];
}

MapObject::MapObject(const char* t = 0, const QString n, int coordNum = 0)
{
  type = t;
  name = n;
  if(coordNum) {
    locLength = coordNum;
    latitude = new long[coordNum];
    longitude = new long[coordNum];
  }
}

MapObject::~MapObject() {

}

/*
 * The class MapObjectList is used to store all the MapObjects.
 */
void MapObjectList::addObject(MapObject* newObject)
{
  objectList.append(newObject);
}

unsigned int MapObjectList::getListLength()
{
  return objectList.count();
}

MapObject* MapObjectList::getObject(unsigned int index)
{
  return objectList.at(index);
}

unsigned int MapObjectList::createList(QString* fileName)
{
  objectList.~QList();
  QFile file(mapFile);
  QTextStream stream(&file);
  QString line;

  if(!file.open(IO_ReadOnly)) {
    /////////////////////////////////////////////////////////
    //
    // Fehler-Handling bislang nicht ausreichend ...
    return 0;
    //
    /////////////////////////////////////////////////////////
  }

  // creating the mapobject-list
  objectList.~QList();

  // inititialation of the object entries
  bool isObject = false;
  bool freqType = false;

  int l = 0;
  int* runwayDir = 0;
  int* runwayLength = 0;
  int* runwayType = 0;

  long at_lat = 0, at_lon = 0;
  long latitude = 0, longitude = 0;

  QString alias = 0;
  QString elev = 0;
  QString frequency = 0;
  QString name = 0;
  QString type = 0;

  QString* runwayInf = 0;

  QList<Location> locList;
  locList.setAutoDelete(true);

  QList<QString> runwayList;
  runwayList.setAutoDelete(true);

  // reading the file:
  while (!stream.eof())
    {
      line = stream.readLine();

      // if it is a comment, ignore it!
      if(line.mid(0,1) == "#") continue;

      if(line.mid(0,11) == "[NEW ENTRY]") {
        // a new object starts here
        isObject = true;
        // resetting of the object entries
        l = 0;
        name = 0;
        type = 0;
        frequency = 0;
        alias = 0;
        elev = 0;
        at_lat = 0;
        at_lon = 0;
        locList.~QList();         /* removes all listitems but  */
        runwayList.~QList();      /* doesn't destroy the list. */
        runwayInf = new QString[15];
      } else if(isObject) {
        // an object is opened!
        if(line.mid(0,4) == "TYPE") {
                                // setting the object-type
          type = line.mid(5,100);
        } else if(line.mid(0,5) == "ALIAS") {
                                // setting the alias
          alias = line.mid(5,100);
        } else if(line.mid(0,2) == "AT") {
                                // setting "at"
          unsigned int loop;
          // search for space (hopefully, there will only be one!)
          for(loop = 3; loop < strlen(line); loop++) {
            if(line.mid(loop, 1) == " ") {
              break;
            }
          }
          at_lat = degreeToNum(line.mid(3,(loop - 3)));
          at_lon = degreeToNum(line.mid((loop + 1),100));
        } else if(line.mid(0,4) == "ELEV") {
                                // setting the elevation
          elev = line.mid(4,100);
        } else if(line.mid(0,9) == "FREQUENCY") {
                                // setting the frequency
          QString temp = line.mid(10,100);
          unsigned int loop;
          for(loop = 0; loop < strlen(temp); loop++) {
            if(line.mid(loop, 1) == "/") {
              break;
            }
          }
          frequency = temp.left(loop);
          freqType = temp.mid((loop + 1),1);
        } else if(line.mid(0,4) == "NAME") {
                                // setting the name
          name = line.mid(5,1000);
        } else if(line.mid(0,7) == "RUNWAYS") {
                                // setting the coords for the runways

          ////////////////////////////////////////////////
          // noch implementieren !!!
          ////////////////////////////////////////////////
        } else if(line.mid(0,6) == "RUNWAY") {
                                // setting the information about the runway
          runwayList.append(new QString(line.mid(7,100)));
          runwayInf[l] = line.mid(7,100);
          ++l;
        } else if((line.mid(0,1) >= "0") && (line.mid(0,1) <= "9")) {
          // calculating the position and putting into the temp-lists
          unsigned int loop;
          // search for space (hopefully, there will only be one!)
          for(loop = 0; loop < strlen(line); loop++) {
            if(line.mid(loop, 1) == " ") {
              break;
            }
          }
          latitude = degreeToNum(line.left(loop));
          longitude = degreeToNum(line.mid((loop + 1),100));
          locList.append(new Location(latitude,longitude));
        } else if(line.mid(0,5) == "[END]")     {
          // now the object is complete!
          // first: creating the arrays for the coordinates
          long* latList = new long[locList.count()];
          long* lonList = new long[locList.count()];
          Location* _pos;
          for(_pos = locList.first(); _pos != 0; _pos = locList.next())
            {
              latList[locList.at()] = _pos->getLat();
              lonList[locList.at()] = _pos->getLon();
            }

          // second: creating the arrays for the runway-information
          runwayDir = new int[l - 1];
          runwayLength = new int[l - 1];
          runwayType = new int[l-1];

          for(int i = 0; i < l; i++)
            {
              const char* text = runwayInf[i];
              runwayDir[i] = ( 100 * (text[0] - '0') ) +
                (  10 * (text[1] - '0') ) +
                (text[2] - '0');

              runwayLength[i] = ( 100 * (text[4] - '0') ) +
                (  10 * (text[5] - '0') ) +
                (text[6] - '0');
              if(((text[7] - '0') >= 0) && ((text[7] - '0') <= 9)) {
                // the runway is more than 999m long!
                // (hopefully under 10000m)
                runwayLength[i] = 10 * runwayLength[i] + (text[7] - '0');
                runwayInf[i] = runwayInf[i].mid(9,1);
              } else {
                runwayInf[i] = runwayInf[i].mid(8,1);
              }
              // default: grass-runway
              if(runwayInf[i] == "a") {
                // asphalt-runway
                runwayType[i] = 0;
              } else if(runwayInf[i] == "c") {
                // concrete-runway
                runwayType[i] = 1;
              }
            }

          // now we can create the mapobject!
          objectList.append(new MapObject(type, name, locList.count()));

          MapObject* current = objectList.current();
          current->setAlias(alias);
          current->setAt(at_lat, at_lon);
          current->setElev(elev);
          current->setFrequency(frequency);
          current->setLocList(latList, lonList);

          isObject = false;
        }
      }
    }

  // after all: closing the file
  file.close();
  // erzeugen noch implementieren ...
  return objectList.count();
}

MapObjectList::MapObjectList()
{

}

MapObjectList::MapObjectList(QString fileName)
{
  mapFile = fileName;
  createList();
}

MapObjectList::~MapObjectList()
{
  objectList.~QList();    // deletes all items in the list, but does
                          // not destroy the list itself.
}













