/***************************************************************************
                          KFLogview.h  -  description
                             -------------------
    begin                : Sun Jun  6 11:42:22 CEST 1999

    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KFLOGVIEW_H
#define KFLOGVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <mapobject.h>

#include <kapp.h>

#include <kcombo.h>
#include <kintegerline.h>
#include <krestrictedline.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qwidget.h>

/**
  * This class provides an the base for KFLog-view.
  * @author Heiner Lamprecht
  */

class KFLogView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  KFLogView(QWidget* parent);
  /** Destructor for the main view */
  ~KFLogView();
  /** shows the widget of the map */
  void showMapFrame();
  /** shows the widget for digitising */
  void showTabFrame();
  /** */
  void setMOList(MapObjectList* newList);

  QFrame* getMapView();
  QFrame* getTabView();
  QFrame* getMapFrame();

 public slots:
  void selectMapObject(QListViewItem* item);
  void startInput();

 private:
  QFrame* mapFrame;
  QFrame* mapView;
  QFrame* tabView;
  QLabel* typLabel;
  bool pointList;
  long* latitude;
  long* longitude;
  char* type;
  QWidget* parent;
  // the widgets for entering the map-object-data:
  QLineEdit* nameE;
  KRestrictedLine* abkE;
  QPushButton* addB;
  QPushButton* delB;
  KIntegerLine* dirE;
  KIntegerLine* elevE;
  KCombo* elevT;
  KRestrictedLine* freqE;
  KCombo* gliderT;
  KCombo* heliT;
  QCheckBox* lightE;
  KRestrictedLine* pointE1;
  KRestrictedLine* pointE2;
  KIntegerLine* runwE;
  QComboBox* runwtE;
  KIntegerLine* uppE;
  QCheckBox* vdfE;
  MapObjectList* mapObjectList;
};

#endif // KFLOGVIEW_H



