/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "kdconfigwidget.h"

KDConfigWidget::~KDConfigWidget(){
}

KDConfigWidget::KDConfigWidget(QWidget * parent, const char *name, KDConfig *cfg):KDialog (parent, name){
	config=cfg;

	gb_icons=new QGroupBox(this);
	gb_pathes=new QGroupBox(this);
	gb_update=new QGroupBox(this);
	gb_color=new QGroupBox(this);

	gb_icons->setTitle(klocale->translate("Icons"));
	gb_pathes->setTitle(klocale->translate("Dock-Pathes"));
	gb_update->setTitle(klocale->translate("Update Frequency (s)"));
	gb_color->setTitle(klocale->translate("Colors"));

	label_color_free=new QLabel(klocale->translate("Free"),gb_color);
	label_color_full=new QLabel(klocale->translate("Full"),gb_color);
	label_color_unmounted=new QLabel(klocale->translate("Unmounted"),gb_color);

	color_free=new KColorButton(config->color_disk_free,gb_color);
	color_full=new KColorButton(config->color_disk_full,gb_color);
	color_unmounted=new KColorButton(config->color_disk_umounted,gb_color);

	iconLabelMinix=new QLabel(klocale->translate("Minix"),gb_icons);
	iconLabelExt2=new QLabel(klocale->translate("Extended 2"),gb_icons);
	iconLabelVFatFD=new QLabel(klocale->translate("VFat 32 Floppy"),gb_icons);
	iconLabelFVatHD=new QLabel(klocale->translate("VFat 32 HD"),gb_icons);
	iconLabelNFS=new QLabel(klocale->translate("NFS"),gb_icons);
	iconLabelSMBFS=new QLabel(klocale->translate("Samba FS"),gb_icons);
	iconLabelISO9660=new QLabel(klocale->translate("ISO 9660"),gb_icons);
	iconLabelMSDos=new QLabel(klocale->translate("MSDos"),gb_icons);
	iconLabelHFS=new QLabel(klocale->translate("HFS"),gb_icons);
	iconLabelUnknown=new QLabel(klocale->translate("Unknown FS"),gb_icons);
	iconLabelUnmounted=new QLabel(klocale->translate("Unmounted"),gb_icons);

	for (int i=0;i<4;i++){
		dock_pathes[i]=new KLined(gb_pathes);
		dock_pathes[i]->setText(config->dock_mp[i]);
	} 

	button_okay=new QPushButton(this);
	button_cancel=new QPushButton(this);
	button_okay->setText(klocale->translate("Ok"));
	button_cancel->setText(klocale->translate("Cancel"));

	update_freq=new KNumericSpinBox(gb_update);
	update_freq->setStep(10);
	update_freq->setRange(0,1000);
	update_freq->setValue(config->update_freq);

	iconButtonMinix		=new KIconLoaderButton(gb_icons);
	iconButtonExt2		=new KIconLoaderButton(gb_icons);
	iconButtonVFatFD	=new KIconLoaderButton(gb_icons);
	iconButtonVFatHD	=new KIconLoaderButton(gb_icons);
	iconButtonNFS		=new KIconLoaderButton(gb_icons);
	iconButtonSMBFS		=new KIconLoaderButton(gb_icons);
	iconButtonISO9660	=new KIconLoaderButton(gb_icons);
	iconButtonMSDos		=new KIconLoaderButton(gb_icons);
	iconButtonHFS		=new KIconLoaderButton(gb_icons);
	iconButtonUnknown	=new KIconLoaderButton(gb_icons);
	iconButtonUnmounted	=new KIconLoaderButton(gb_icons);

	iconButtonMinix		->setIcon(config->icon_minix);
	iconButtonExt2		->setIcon(config->icon_ext2);
	iconButtonVFatFD	->setIcon(config->icon_vfat_fd);
	iconButtonVFatHD	->setIcon(config->icon_vfat_hd);
	iconButtonNFS		->setIcon(config->icon_nfs);
	iconButtonSMBFS		->setIcon(config->icon_smbfs);
	iconButtonISO9660	->setIcon(config->icon_iso9660);
	iconButtonMSDos		->setIcon(config->icon_msdos);
	iconButtonHFS		->setIcon(config->icon_hfs);
	iconButtonUnknown	->setIcon(config->icon_unknown);
	iconButtonUnmounted	->setIcon(config->icon_unmounted);

	resize(600,510);

	setMinimumSize(width(),height());
	setMaximumSize(width(),height());

	connect(button_okay,SIGNAL(clicked()),SLOT(slot_button_okay()));
	connect(button_cancel,SIGNAL(clicked()),SLOT(slot_button_cancel()));
}

void KDConfigWidget::resizeEvent(QResizeEvent *){
	gb_icons->setGeometry(10,10,400,320);
	iconButtonMinix		->setGeometry( 10, 20,40,40);
	iconButtonExt2		->setGeometry( 10, 70,40,40);
	iconButtonVFatFD	->setGeometry( 10,120,40,40);
	iconButtonVFatHD	->setGeometry( 10,170,40,40);
	iconButtonNFS		->setGeometry( 10,220,40,40);
	iconButtonHFS		->setGeometry( 10,270,40,40);
	iconButtonSMBFS		->setGeometry(230, 20,40,40);
	iconButtonISO9660	->setGeometry(230, 70,40,40);
	iconButtonMSDos		->setGeometry(230,120,40,40);
	iconButtonUnknown	->setGeometry(230,170,40,40);
	iconButtonUnmounted	->setGeometry(230,220,40,40);

	iconLabelMinix->setGeometry    ( 60, 20,110,40);
	iconLabelExt2->setGeometry     ( 60, 70,110,40);
	iconLabelVFatFD->setGeometry   ( 60,120,110,40);
	iconLabelFVatHD->setGeometry   ( 60,170,110,40);
	iconLabelNFS->setGeometry      ( 60,220,110,40);
	iconLabelHFS->setGeometry      ( 60,270,110,40);
	iconLabelSMBFS->setGeometry    (280, 20,110,40);
	iconLabelISO9660->setGeometry  (280, 70,110,40);
	iconLabelMSDos->setGeometry    (280,120,110,40);
	iconLabelUnknown->setGeometry  (280,170,110,40);
	iconLabelUnmounted->setGeometry(280,220,110,40);

	gb_color->setGeometry(430,10,160,140);
	color_free->setGeometry(10,20,30,30);
	color_full->setGeometry(10,60,30,30);
	color_unmounted->setGeometry(10,100,30,30);
	label_color_free->setGeometry(50,20,100,30);
	label_color_full->setGeometry(50,60,100,30);
	label_color_unmounted->setGeometry(50,100,100,30);

	gb_update->setGeometry(430,170,160,55);
	update_freq->setGeometry(10,20,140,25);

	button_okay->setGeometry(430,380,160,30);
	button_cancel->setGeometry(430,420,160,30);

	gb_pathes->setGeometry(10,350,400,150);
	for (int i=0;i<4;i++) dock_pathes[i]->setGeometry(10,20+i*30,380,25);
}

void KDConfigWidget::slot_button_okay(){
	config->icon_minix	=iconButtonMinix->icon();
	config->icon_ext2	=iconButtonExt2->icon();
	config->icon_vfat_fd	=iconButtonVFatFD->icon();
	config->icon_vfat_hd	=iconButtonVFatHD->icon();
	config->icon_nfs	=iconButtonNFS->icon();
	config->icon_smbfs	=iconButtonSMBFS->icon();
	config->icon_iso9660	=iconButtonISO9660->icon();
	config->icon_msdos	=iconButtonMSDos->icon();
	config->icon_hfs	=iconButtonHFS->icon();
	config->icon_unknown	=iconButtonUnknown->icon();
	config->icon_unmounted	=iconButtonUnmounted->icon();

	config->color_disk_free=color_free->color();
	config->color_disk_full=color_full->color();
	config->color_disk_umounted=color_unmounted->color();
	
	for (int i=0;i<4;i++) config->dock_mp[i]=dock_pathes[i]->text();
	config->update_freq=update_freq->getValue();
	emit(newConfig());

	config->save();

	close();
}

void KDConfigWidget::slot_button_cancel(){
	close();
}
