/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <iostream.h>

#include <kapp.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "config.h"
#include "kdiffDiffOptionsDialog.h"

#define DEBUGME
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/
//
// Name: void kDiffOptTD::kDiffOptTD()
//
// Comment: Slot for Menu 'options'->diff options
//
// Paramter: void
//
// Return Value: void
//
kDiffOptTD::kDiffOptTD( QWidget * parent , const char * name )
    : QTabDialog( parent, name, TRUE )
{
    	int widthSize = 0;

	this->setOkButton(i18n("OK"));
	// Because there is no help button, I use this ridiculous work-around
	this->setDefaultButton(i18n("Help"));
	this->setCancelButton(i18n("Cancel"));

	// First page: Ignoring info	
	QWidget *w1 = new QWidget( this );
	this->addTab( w1,i18n( "&Ignoring") );

	QVBoxLayout VLayout( w1 , 3 );
	
	VLayout.addSpacing( 5 );

	QFont ft = font();
	ft.setWeight( QFont::Bold );
	QLabel * ql = new QLabel( i18n("When analysing differences:") , w1 );
	ql->setFont( ft );
	ql->setMinimumSize( ql->sizeHint() );
	VLayout.addWidget( ql, 1 );
	widthSize = QMAX( ql->sizeHint().width() , widthSize );

	QCBignoreCase = new QCheckBox(i18n("Ignore case"), w1 );
	QCBignoreCase->setMinimumSize(QCBignoreCase->sizeHint());
	VLayout.addWidget(QCBignoreCase, 1 );
	QCBignoreCase->setChecked(kdiffCfg.ignoreCase);
	widthSize = QMAX( QCBignoreCase->sizeHint().width() , widthSize );

	QCBignoreBlankLines = new QCheckBox(i18n("Ignore blank lines"), w1);
	QCBignoreBlankLines->setChecked(kdiffCfg.ignoreBlankLines);
	QCBignoreBlankLines->setMinimumSize(
					QCBignoreBlankLines->sizeHint());
	VLayout.addWidget(QCBignoreBlankLines, 1 );
	widthSize = QMAX( QCBignoreBlankLines->sizeHint().width() , widthSize );

	QCBignoreSpaces = new QCheckBox(i18n("Ignore spaces"), w1);
	QCBignoreSpaces->setChecked(kdiffCfg.ignoreSpaces);
	QCBignoreSpaces->setMinimumSize(QCBignoreSpaces->sizeHint());
	VLayout.addWidget(QCBignoreSpaces, 1 );
	widthSize = QMAX( QCBignoreSpaces->sizeHint().width() , widthSize );


	QCBignoreAllSpaces = new QCheckBox(i18n("Ignore all types of spaces"), w1);
	QCBignoreAllSpaces->setChecked(kdiffCfg.ignoreAllSpaces);
	QCBignoreAllSpaces->setMinimumSize(
					 QCBignoreAllSpaces->sizeHint());
	VLayout.addWidget(QCBignoreAllSpaces, 1 );
	widthSize = QMAX( QCBignoreAllSpaces->sizeHint().width() , widthSize );


	QCBignoreRegExp = new QCheckBox(i18n("Ignore lines matching regular expression:"), w1);
	QCBignoreRegExp->setChecked(kdiffCfg.ignoreRegExpLines);
	QCBignoreRegExp->setMinimumSize(QCBignoreRegExp->sizeHint());
	connect(QCBignoreRegExp, SIGNAL(clicked()), SLOT(enableRegExp()));
	widthSize = QMAX( QCBignoreRegExp->sizeHint().width() , widthSize );

	QLEregExp = new QLineEdit(w1);
	QLEregExp->setEnabled(QCBignoreRegExp->isChecked());
	QLEregExp->setText(kdiffCfg.RegExp);
	QLEregExp->setFixedSize( widthSize, QLEregExp->sizeHint().height() );

	VLayout.addWidget( QCBignoreRegExp , 1 );
	VLayout.addWidget( QLEregExp , 0 , AlignLeft | AlignTop );
	
	VLayout.addStretch( 5 );

	VLayout.activate();

	// Second page : performance
	QWidget * w2 = new QWidget( this );
	QVBoxLayout  * qvb2 = new QVBoxLayout( w2 , 5 );
	this->addTab( w2,  i18n("&Performance") );

	qvb2->addSpacing( 5 );

	QLabel * ql2 = new QLabel( i18n("Algorithm:") , w2);
	ql2->setFont( ft );
	ql2->setMinimumSize( ql2->sizeHint() );
	qvb2->addWidget( ql2 );
	widthSize = QMAX( ql2->sizeHint().width() , widthSize );

	qrb1 = new QRadioButton(i18n("standard"), w2 );
	qrb1->setMinimumSize( qrb1->sizeHint() );
	qvb2->addWidget( qrb1 );
	widthSize = QMAX( qrb1->sizeHint().width() , widthSize );
	
	qrb2 = new QRadioButton(i18n("smallest set of differences (slower)"), w2 );
	qrb2->setMinimumSize( qrb2->sizeHint() );
	qvb2->addWidget( qrb2 );
	widthSize = QMAX( qrb2->sizeHint().width() , widthSize );
	
	qrb3 = new QRadioButton(i18n("large files with small differences"), w2 );
	qrb3->setMinimumSize( qrb3->sizeHint() );
	qvb2->addWidget( qrb3 );
	widthSize = QMAX( qrb3->sizeHint().width() , widthSize );

	// Make the button exclusive
	QButtonGroup * qbg = new QButtonGroup();
	qbg->insert(qrb1);
	qbg->insert(qrb2);
	qbg->insert(qrb3);
	
	if ( kdiffCfg.minimalDifferences )
		qrb2->setChecked( true );
	else if ( kdiffCfg.largeFiles )
		qrb3->setChecked( true );
	else
		qrb1->setChecked( true );

	qvb2->addStretch( 5 );
	qvb2->activate();

	connect( this, SIGNAL( applyButtonPressed() ), SLOT( ok() ) ); 
	connect( this, SIGNAL( defaultButtonPressed() ), SLOT( help() ) ); 
	connect( this, SIGNAL( cancelButtonPressed() ), SLOT( cancel() ) ); 

	setMinimumSize( widthSize, 300);	
	resize( widthSize, 320);

	setCaption(i18n("Diff options"));
}

void kDiffOptTD::enableRegExp()
{
	QLEregExp->setEnabled(QCBignoreRegExp->isChecked());
}

void kDiffOptTD::ok()
{
	kdiffCfg.ignoreCase = QCBignoreCase->isChecked();
	kdiffCfg.ignoreBlankLines = QCBignoreBlankLines->isChecked();
	kdiffCfg.ignoreAllSpaces = QCBignoreAllSpaces->isChecked();
	kdiffCfg.ignoreSpaces = QCBignoreSpaces->isChecked();
	kdiffCfg.ignoreRegExpLines = QCBignoreRegExp->isChecked();
	kdiffCfg.RegExp = QLEregExp->text();
	
	kdiffCfg.minimalDifferences = qrb2->isChecked();
	kdiffCfg.largeFiles = qrb3->isChecked();
}

void kDiffOptTD::cancel()
{
}

void kDiffOptTD::help()
{
	// XXX fill in with the correct help page when available
	QString filename(APPNAME "/kdiff-5.html");

	// kapp is defined in kapp.h as #define kapp KApplication::getKApplication()
	kapp->invokeHTMLHelp(filename, "ss5.1");
}

kDiffOptTD::~kDiffOptTD()
{
}




