/*

    $Id: setupDlg.cpp,v 1.1 1998/05/29 12:28:41 root Exp root $

*/

#include "setupDlg.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <kapp.h>

#include "../../config.h"

extern KApplication* TemplateApplication; 	/* defined in main.cpp */

setupDlg::setupDlg(QWidget *parent) : QDialog(parent, "setupDlg kcyradm", TRUE) {
  

  KConfig *kc = TemplateApplication->getConfig();
  kc->setGroup("Configuration");
  
  setupDlg::setActiveWindow();
  
  resize(300, 300);
  setFixedSize(size());
  setCaption("Setup");
  
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 276, 290);
  GBox->setTitle(i18n("Imap Server Configuration"));
 
  
  imapserverLabel = new QLabel(this);
  imapserverLabel->setGeometry(20, 30, 20, 28);
  imapserverLabel->setText("Imapserver IP");
  imapserverLabel->setAutoResize(true);
  imapserver = new QLineEdit(this);
  imapserver->setGeometry(20, 50, 200, 28);
  imapserver->setText(kc->readEntry("Host"));
  imapserver->setFocus();
  

  portLabel = new QLabel(this);
  portLabel->setGeometry(20, 80, 20, 28);
  portLabel->setText("Imapserver Port");
  portLabel->setAutoResize(true);
  port = new QLineEdit(this);
  port->setGeometry(20, 100, 200, 28);
  port->setText(kc->readEntry("Port"));
   
  usernameLabel = new QLabel(this);
  usernameLabel->setGeometry(20, 130, 20, 28);
  usernameLabel->setText("Loginname");
  usernameLabel->setAutoResize(true);
  username  = new QLineEdit(this);
  username->setGeometry(20, 150, 200, 28);
  username->setText(kc->readEntry("Username"));
   
   
  passwordLabel = new QLabel(this);
  passwordLabel->setGeometry(20, 180, 20, 28);
  passwordLabel->setText("Password");
  passwordLabel->setAutoResize(true);
  password = new QLineEdit(this);
  password->setGeometry(20, 200, 200, 28);
  password->setText(kc->readEntry("Password"));
  password->setEchoMode(QLineEdit::Password);
  connect(password, SIGNAL(returnPressed()), SLOT(Store()));    
  
    
  QPushButton *OkButton = new QPushButton("Ok", this);
  OkButton->setGeometry(width()/2-40,  240, 80, 32);
  OkButton->setDefault(TRUE);
  OkButton->setAutoDefault(TRUE);
  connect(OkButton, SIGNAL(released()),
	  this, SLOT(Store()));
}
void
setupDlg::Store()
{
  ImapServer = imapserver->text();
  Port	     = port->text();
  Username   = username->text();
  Password   = password->text();
  
  KConfig *kc = TemplateApplication->getConfig();
  kc->setGroup("Configuration");
  kc->writeEntry("Host", imapserver->text());			
  kc->writeEntry("Port", port->text());			
  kc->writeEntry("Username", username->text());			
  kc->writeEntry("Password", password->text());			
  kc->sync();
  
  accept();
}

setupDlg::~setupDlg()
{
  delete GBox;
  delete imapserverLabel;
  delete imapserver;
  delete portLabel;
  delete port;
  delete usernameLabel;
  delete username;
  delete passwordLabel;
  delete password;
  //delete OkButton;
}
#include "setupDlg.moc"
