#ifndef Editor_EditorSettings_h
#define Editor_EditorSettings_h

#include <kapp.h>
#include <kconfig.h>


	// for internal use only:
#define FLAG_AUTOINDENT  		0x0001
#define FLAG_TABSVISIBLE		0x0002
#define FLAG_TABSASSPACES		0x0004
#define FLAG_USECOLORS			0x0008
#define FLAG_OVERWRITESELECTION	0x0010
#define FLAG_AUTOCLIPBOARDING	0x0020



class EditorSettings
{
public:
	EditorSettings(const QString& configSection)
	{ 
		ConfigSection = configSection;
		KConfig* kconfig = kapp->getConfig();
		QString old = kconfig->group();
		kconfig->setGroup(ConfigSection);
		
		Flags = kconfig->readNumEntry("Flags", 0);
		TabSize = kconfig->readNumEntry("TabSize", 4);
		Font = QFont(kconfig->readEntry("FontFamily", "Courier"), 
					 kconfig->readNumEntry("FontSize", 17), 
				 	 QFont::Normal);		

		kconfig->setGroup(old);
	}
	
	~EditorSettings()
	{ 
		KConfig* kconfig = kapp->getConfig();
		QString old = kconfig->group();
		kconfig->setGroup(ConfigSection);

		kconfig->writeEntry("Flags", Flags);
		kconfig->writeEntry("TabSize", TabSize);
		kconfig->writeEntry("FontFamily", Font.family());
		kconfig->writeEntry("FontSize", Font.pointSize());

		kconfig->setGroup(old);
		warning("~EditorSettings!\n");
	}

	
	bool autoIndent() const			{ return (Flags & FLAG_AUTOINDENT) != 0; }
	bool tabsVisible() const		{ return (Flags & FLAG_TABSVISIBLE) != 0; }
	bool tabsAsSpaces() const		{ return (Flags & FLAG_TABSASSPACES) != 0; }
	bool useColors() const			{ return (Flags & FLAG_USECOLORS) != 0; }
	bool autoClipboarding() const	{ return (Flags & FLAG_AUTOCLIPBOARDING) != 0; }
	bool overwriteSelection() const	{ return (Flags & FLAG_OVERWRITESELECTION) != 0; }

	void setAutoIndent(bool f)			{ setFlag(FLAG_AUTOINDENT, f); }
	void setTabsVisible(bool f)			{ setFlag(FLAG_TABSVISIBLE, f); }
	void setTabsAsSpaces(bool f)		{ setFlag(FLAG_TABSASSPACES, f); }
	void setUseColors(bool f)			{ setFlag(FLAG_USECOLORS, f); }
	void setAutoClipboarding(bool f)	{ setFlag(FLAG_AUTOCLIPBOARDING, f); }
	void setOverwriteSelection(bool f)	{ setFlag(FLAG_OVERWRITESELECTION, f); }

	void setFlag(unsigned int flag, bool set)
	{ Flags = (Flags & ~flag) | (set ? flag : 0); }


	int   tabSize() const 			{ return TabSize; }
	QFont font() const 				{ return Font; }

	void setTabSize(int s)				{ TabSize = s; }
	void setFont(const QFont& f)		{ Font = f; }


protected:
	QString 	 ConfigSection;
	unsigned int Flags;
	int   		 TabSize;
	QFont 		 Font;
};


#endif // Editor_EditorSettings_h
