/*
 * pgpconfigtab.h
 *
 * Copyright (c) 1997 Christian Stueble stueble@ls6.cs.informatik.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __KPGPCONFIGTAB_H__
#define __KPGPCONFIGTAB_H__

#include <qframe.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qradiobt.h> 
#include <qpixmap.h>
#include <qgrpbox.h> 
#include <qpainter.h>
#include <qbttngrp.h>
#include <qlcdnum.h>

#include <qchkbox.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlayout.h>
#include <qdict.h>

#include <kcontrol.h>
#include <ksimpleconfig.h>

#include "pgpconfig.h"

class KPGPConfig : public KConfigWidget
{
  Q_OBJECT;
  
public:
  
  KPGPConfig( QWidget *parent=0, const char* name=0 );
  ~KPGPConfig( );
  
  void  resizeEvent(QResizeEvent *e);
  
  void  loadSettings();
  void  applySettings();
  void  defaultSettings();
 
  
signals:

  /// signal, if config file has changed
  void signalPubringChanged();

private slots:
  
  void slotChoosePubring();
  void slotChooseSecring();
  void slotChooseSeedFile();
  
private:
  
  QWidget*      fileSettings(QPushButton* &btn, QString name, QLineEdit * &ledit);
  QWidget*      getCheckSettings();
  QWidget*      getNameSettings();
  QWidget*      getTrustSettings();
  QWidget*      getCommentSettings();
 
  PgpConfig     *pgp_config;

  int           VERBOSE;
 
  QLineEdit     *completeEdit;
  QLineEdit     *marginalEdit;
  QLineEdit     *depthEdit;

  QLineEdit     *mynameEdit;
  QLineEdit     *commentEdit;
  
  QLineEdit     *pubringEdit;
  QPushButton   *pubringSelect;
  
  QLineEdit     *secringEdit;
  QPushButton   *secringSelect;
  
  QLineEdit     *seed_fileEdit;
  QPushButton   *seed_fileSelect;
  
  QCheckBox     *checkINTERACTIVE;
  QCheckBox     *checkCOMPRESS;
  QCheckBox     *checkKEEPBINARY;
  QCheckBox     *checkARMOR;
  QCheckBox     *checkTEXTMODE;
  QCheckBox     *checkSHOWPASS;
  QCheckBox     *checkCLEARSIG;
  QCheckBox     *checkENCRYPTTOSELF;
};

#endif
