/*
 * KBatMon - Copyright 1999 Russ Steffen <rsteffen@ia.net>
 *
 * Released under the terms of the GNU General Public License
 *
 *
 * $Id: kbatmonconfigdlg.cc,v 1.5 1999/01/15 06:08:48 russ Exp $
 *
 * $Log: kbatmonconfigdlg.cc,v $
 * Revision 1.5  1999/01/15 06:08:48  russ
 * Added file headers.
 *
 *
 */
 
#include <qtabbar.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qlayout.h>
#include <kapp.h>
#include <ktabctl.h>
#include <kseparator.h>
#include <kkeydialog.h>

#include "kbatmonconfigdlg.h"

#include <iostream.h>

//
// GeneralSettingsPage Members
//

TabPage::TabPage( KTabCtl *parent, KBatMonConfig &pConfig ) : QWidget(parent), config(pConfig)
{};

TabPage::~TabPage()
{};

GeneralSettingsPage::GeneralSettingsPage( KTabCtl *parent, KBatMonConfig &pConfig ) :  TabPage(parent, pConfig)
{
   // Setup controls
   dockInPanel = new QCheckBox( "Dock In Panel", this );
   useSessionManagement = new QCheckBox( "Use Session Management", this );
   
   // Layout
   QBoxLayout *vert1 = new QVBoxLayout( this, 5, 5 );

   dockInPanel->setMinimumSize( dockInPanel->sizeHint() );
   vert1->addWidget( dockInPanel );
   
   useSessionManagement->setMinimumSize( useSessionManagement->sizeHint() );
   vert1->addWidget( useSessionManagement );

   vert1->addStretch( 1 );
   
   adjustSize();
   
}

GeneralSettingsPage::~GeneralSettingsPage()
{}

void GeneralSettingsPage::prepare(void)
{
   dockInPanel->setChecked( config.getDockInPanel() );
   useSessionManagement->setChecked( config.getUseSessionManagement() );
}

void GeneralSettingsPage::apply(void)
{
   config.setDockInPanel( dockInPanel->isChecked() );
   config.setUseSessionManagement( useSessionManagement->isChecked() );
}

//
// Warnings Page
//

WarningSettingsPage::WarningSettingsPage( KTabCtl *parent, KBatMonConfig &pConfig ) : TabPage( parent, pConfig )
{
   lowBatWarning = new QCheckBox( i18n("Low Battery Warning"), this );
   
   // Layout
   QBoxLayout *vert1 = new QVBoxLayout( this, 5, 5 );
   
   lowBatWarning->setMinimumSize( lowBatWarning->sizeHint() );
   vert1->addWidget( lowBatWarning );

   vert1->addStretch( 1 );
}

WarningSettingsPage::~WarningSettingsPage()
{}

void WarningSettingsPage::prepare(void)
{
   lowBatWarning->setChecked( config.getLowBatWarning() );
}

void WarningSettingsPage::apply(void)
{
   config.setLowBatWarning( lowBatWarning->isChecked() );
}

// Key Config Page

KeyConfigPage::KeyConfigPage( KTabCtl *parent, KBatMonConfig &pConfig ) : TabPage( parent, pConfig )
{
   KBatMonApp *app = (KBatMonApp *)kapp;
   
   keyDict = app->getGlobalAccel().keyDict();
   
   keyChooser = new KKeyChooser( &keyDict, this );
   
   // Layout
   
   QBoxLayout *vert = new QVBoxLayout( this, 5, 5 );
   
   keyChooser->setMinimumSize( keyChooser->sizeHint() );
   vert->addWidget( keyChooser );

   adjustSize();
}

KeyConfigPage::~KeyConfigPage()
{
}

void KeyConfigPage::prepare(void)
{
   KBatMonApp *app = (KBatMonApp *)kapp;
   
   keyDict = app->getGlobalAccel().keyDict();
}

void KeyConfigPage::apply(void)
{
   KBatMonApp *app = (KBatMonApp *)kapp;
   
   app->getGlobalAccel().setKeyDict( keyDict );
}


//
// Config Dialog Members
//

KBatMonConfigDialog::KBatMonConfigDialog( KBatMonConfig &pConfig )
: QDialog(0,0,true), config(pConfig) 
{
   // Create controls   
   tabBar = new KTabCtl( this );
   connect( tabBar, SIGNAL(tabSelected(int)), this, SLOT(showTab(int)) );
      
   generalSettings = new GeneralSettingsPage( tabBar, config );
   tabBar->addTab( generalSettings, i18n("General") );
   
   warningSettings = new WarningSettingsPage( tabBar, config );
   tabBar->addTab( warningSettings, i18n("Warnings") );

   keySettings = new KeyConfigPage( tabBar, config );
   tabBar->addTab( keySettings, i18n("Key Bindings") );
   
   okBtn = new QPushButton( i18n("Ok"), this );
   okBtn->setDefault(true);
   applyBtn = new QPushButton( i18n("Apply"), this );
   cancelBtn = new QPushButton( i18n("Cancel"), this );
   
   // Signal/Slot Connections
   
   connect(okBtn, SIGNAL(clicked()), this, SLOT(okPressed()) );
   connect(applyBtn, SIGNAL(clicked()), this, SLOT(applyPressed()) );
   connect(cancelBtn, SIGNAL(clicked()), this, SLOT(cancelPressed()) );
	   
   // Layout widget
   QBoxLayout *vert1 = new QVBoxLayout( this, 5, 5 );

   tabBar->setMinimumSize( 350, 350 );
   vert1->addWidget( tabBar, 1 );

   QBoxLayout *btnRow = new QHBoxLayout;
   
   vert1->addLayout(btnRow);
   
   btnRow->addStretch(1);

   okBtn->setFixedSize( okBtn->sizeHint() );
   btnRow->addWidget( okBtn );
   
   applyBtn->setFixedSize( applyBtn->sizeHint() );
   btnRow->addWidget( applyBtn );

   cancelBtn->setFixedSize( cancelBtn->sizeHint() );
   btnRow->addWidget( cancelBtn );
   
   adjustSize();
}

KBatMonConfigDialog::~KBatMonConfigDialog()
{
}

void KBatMonConfigDialog::showTab( int newTab )
{
   switch( newTab ) {
    case 0 :
      generalSettings->prepare();
      break;
    case 1:
      warningSettings->prepare();
      break;
    case 2:
      keySettings->prepare();
      break;
    default:
      break;
   }
   
}

void KBatMonConfigDialog::okPressed()
{
   generalSettings->apply();
   warningSettings->apply();
   keySettings->apply();
   accept();
}
   
void KBatMonConfigDialog::applyPressed()
{
   generalSettings->apply();
   warningSettings->apply();
   keySettings->apply();
}

void KBatMonConfigDialog::cancelPressed()
{
   reject();
}

