/* -*- C++ -*-
 * This file declares some macros that have similar names as the ones
 * used by the NANA debugging library. With it, the code does not have to be 
 * linked against Nana.
 *
 * the KDE Addressbook, Version II
 * copyright:  (C) Mirko Sucker, 1998 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#ifndef KAB2_DEBUG_H
#define	KAB2_DEBUG_H

extern "C" {
#include <assert.h> // WORK_TO_DO: remove after adding AssertDialog
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <ctype.h>
}

#include <qstring.h>

#ifdef assert
#undef assert
#endif
#ifdef CHECK
#undef CHECK
#endif
#ifdef REQUIRE
#undef REQUIRE
#endif
#ifdef ENSURE
#undef ENSURE
#endif

// ##############################################################################
#if defined NDEBUG /* ! defined KAB_DEBUG */
// ------------------------------------------------------------------------------
// ----- no debugging wanted, remove everything:
inline void L(...) {}
inline void LG(...) {}
#define assert(x)
#define CHECK(x)
#define REQUIRE(x)
#define ENSURE(x)
// ------------------------------------------------------------------------------
#else 
// ------------------------------------------------------------------------------
// ----- compile with debugging statements:
inline void L(const char *format, ... ) 
{
  va_list ap;
  // -----
  va_start(ap, format);
  vprintf(format, ap);
  va_end(ap);
}

inline void LG(bool condition, const char *format, ...) 
{
  va_list ap;
  // -----
  va_start(ap, format);
  if(condition)
    {
      vprintf(format, ap);
    }
  va_end(ap);
}

// kab's (libkab's) own assertions, overriding some Nana keywords:
#define assert(x) evaluate_assertion(x, __FILE__, __LINE__, #x)
#define CHECK(x) assert(x) 
#define REQUIRE(x) assert(x)
#define ENSURE(x) assert(x)

inline void evaluate_assertion(bool cond, const char* f, int l, const char* c)
{
  if(cond!=true)
    {
      printf("Assertion failed: file %s, %i: %s.\n---->Remove this function.\n",
	     f, l, c);
      abort();
    }
}
// ------------------------------------------------------------------------------
#endif // ! defined KAB_DEBUG

// ##############################################################################
// a static string that contains the authors email address, must be defined by 
// the application:
extern QString AuthorEmailAddress;

// ##############################################################################
// the function that pops up a dialog when an assertion failes (in libkab):
void evaluate_assertion(bool cond, const char* file, int line, const char* text);

// ##############################################################################

#endif // KAB2_DEBUG_H









